# coding: utf-8

"""
    Koverse Data Platform (KDP) API

    The KDP API is a REST API that can be used to create, access, and update data in KDP Workspaces. Please note that the Python client library follows Python's naming convention of snake casing for fields, even though they may appear in camel case in the API specification. <p><b>By default this api documentation targets the koverse production server at 'api.app.koverse.com' You can provide the hostname of your koverse instance to this documentation page via the 'host' query param.</p> <p><b>For example providing host - https://koverse-docs.saic.com/api?host=api.myHost.com, will update requests to target the provided host.</b></p> <p><b>Authentication request example with provided host - https://api.myHost.com/authentication</b></p>

    The version of the OpenAPI document: 4.127.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from kdp_api.models.application_create_request_required_dataset_access_inner import ApplicationCreateRequestRequiredDatasetAccessInner
from typing import Optional, Set
from typing_extensions import Self

class ApplicationPatchRequest(BaseModel):
    """
    ApplicationPatchRequest
    """ # noqa: E501
    name: Optional[StrictStr] = None
    url: Optional[StrictStr] = None
    redirect_url: Optional[StrictStr] = Field(default=None, alias="redirectUrl")
    workspace_id: Optional[StrictStr] = Field(default=None, alias="workspaceId")
    client_id: Optional[StrictStr] = Field(default=None, alias="clientId")
    client_secret: Optional[StrictStr] = Field(default=None, alias="clientSecret")
    visible: Optional[StrictBool] = None
    description: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    allowed_users: Optional[List[StrictStr]] = Field(default=None, alias="allowedUsers")
    required_dataset_access: Optional[List[ApplicationCreateRequestRequiredDatasetAccessInner]] = Field(default=None, alias="requiredDatasetAccess")
    reset_secret: Optional[StrictBool] = Field(default=None, description="If set to true, a new clientSecret will be generated for the application", alias="resetSecret")
    __properties: ClassVar[List[str]] = ["name", "url", "redirectUrl", "workspaceId", "clientId", "clientSecret", "visible", "description", "type", "allowedUsers", "requiredDatasetAccess", "resetSecret"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['mls', 'sls']):
            raise ValueError("must be one of enum values ('mls', 'sls')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApplicationPatchRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in required_dataset_access (list)
        _items = []
        if self.required_dataset_access:
            for _item in self.required_dataset_access:
                if _item:
                    _items.append(_item.to_dict())
            _dict['requiredDatasetAccess'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApplicationPatchRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "url": obj.get("url"),
            "redirectUrl": obj.get("redirectUrl"),
            "workspaceId": obj.get("workspaceId"),
            "clientId": obj.get("clientId"),
            "clientSecret": obj.get("clientSecret"),
            "visible": obj.get("visible"),
            "description": obj.get("description"),
            "type": obj.get("type"),
            "allowedUsers": obj.get("allowedUsers"),
            "requiredDatasetAccess": [ApplicationCreateRequestRequiredDatasetAccessInner.from_dict(_item) for _item in obj["requiredDatasetAccess"]] if obj.get("requiredDatasetAccess") is not None else None,
            "resetSecret": obj.get("resetSecret")
        })
        return _obj


