# coding: utf-8

"""
    Koverse Data Platform (KDP) API

    The KDP API is a REST API that can be used to create, access, and update data in KDP Workspaces. Please note that the Python client library follows Python's naming convention of snake casing for fields, even though they may appear in camel case in the API specification. <p><b>By default this api documentation targets the koverse production server at 'api.app.koverse.com' You can provide the hostname of your koverse instance to this documentation page via the 'host' query param.</p> <p><b>For example providing host - https://koverse-docs.saic.com/api?host=api.myHost.com, will update requests to target the provided host.</b></p> <p><b>Authentication request example with provided host - https://api.myHost.com/authentication</b></p>

    The version of the OpenAPI document: 4.127.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DatasetSync(BaseModel):
    """
    DatasetSync
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="dataset sync ID")
    dataset_id: Optional[StrictStr] = Field(default=None, description="dataset ID", alias="datasetId")
    status: Optional[StrictStr] = Field(default=None, description="Status of the dataset sync.<br>Pending, active, or canceled.")
    type: Optional[StrictStr] = Field(default=None, description="Type of the Dataset Sync<br><br>read - the paired replica dataset can only read records from the origin dataset <br><br>write - the paired replica dataset can only write records to the origin dataset <br><br>manage - the paired replica dataset can read records from the origin dataset, <br>write records to the origin dataset, and delete records from the origin dataset")
    key: Optional[StrictStr] = Field(default=None, description="Security key used for the dataset sync")
    created_by_user_id: Optional[StrictStr] = Field(default=None, description="ID of User that created the dataset sync", alias="createdByUserId")
    is_origin_workspace: Optional[StrictBool] = Field(default=None, description="Indicates if dataset for sync originates in this workspace", alias="isOriginWorkspace")
    host: Optional[StrictStr] = Field(default=None, description="Our Host name")
    workspace_id: Optional[StrictStr] = Field(default=None, description="Our workspace ID", alias="workspaceId")
    workspace_unique_id: Optional[StrictStr] = Field(default=None, description="Our workspace uniqueId", alias="workspaceUniqueId")
    sync_id: Optional[StrictStr] = Field(default=None, description="The ID of the dataset-sync in paired Sync Workspace  *For a paired replica, this is the Origin Dataset Sync ID*  *For the origin sync, this is the Paired Replica Dataset Sync ID* ", alias="syncId")
    sync_host: Optional[StrictStr] = Field(default=None, description="The Host Name of the paired Sync Workspace", alias="syncHost")
    sync_dataset_id: Optional[StrictStr] = Field(default=None, description="The ID of the dataset in paired Sync Workspace", alias="syncDatasetId")
    sync_workspace_id: Optional[Any] = Field(default=None, description="The ID of the paired Sync Workspace", alias="syncWorkspaceId")
    sync_workspace_unique_id: Optional[StrictStr] = Field(default=None, description="UniqueId of the paired Sync Workspace", alias="syncWorkspaceUniqueId")
    last_sync_at: Optional[datetime] = Field(default=None, description="Last Sync At - Time of last successful Sync", alias="lastSyncAt")
    __properties: ClassVar[List[str]] = ["id", "datasetId", "status", "type", "key", "createdByUserId", "isOriginWorkspace", "host", "workspaceId", "workspaceUniqueId", "syncId", "syncHost", "syncDatasetId", "syncWorkspaceId", "syncWorkspaceUniqueId", "lastSyncAt"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['pending', 'active', 'canceled']):
            raise ValueError("must be one of enum values ('pending', 'active', 'canceled')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write', 'manage']):
            raise ValueError("must be one of enum values ('read', 'write', 'manage')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DatasetSync from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if sync_workspace_id (nullable) is None
        # and model_fields_set contains the field
        if self.sync_workspace_id is None and "sync_workspace_id" in self.model_fields_set:
            _dict['syncWorkspaceId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DatasetSync from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "datasetId": obj.get("datasetId"),
            "status": obj.get("status"),
            "type": obj.get("type"),
            "key": obj.get("key"),
            "createdByUserId": obj.get("createdByUserId"),
            "isOriginWorkspace": obj.get("isOriginWorkspace"),
            "host": obj.get("host"),
            "workspaceId": obj.get("workspaceId"),
            "workspaceUniqueId": obj.get("workspaceUniqueId"),
            "syncId": obj.get("syncId"),
            "syncHost": obj.get("syncHost"),
            "syncDatasetId": obj.get("syncDatasetId"),
            "syncWorkspaceId": obj.get("syncWorkspaceId"),
            "syncWorkspaceUniqueId": obj.get("syncWorkspaceUniqueId"),
            "lastSyncAt": obj.get("lastSyncAt")
        })
        return _obj


