# coding: utf-8

"""
    Koverse Data Platform (KDP) API

    The KDP API is a REST API that can be used to create, access, and update data in KDP Workspaces. Please note that the Python client library follows Python's naming convention of snake casing for fields, even though they may appear in camel case in the API specification. <p><b>By default this api documentation targets the koverse production server at 'api.app.koverse.com' You can provide the hostname of your koverse instance to this documentation page via the 'host' query param.</p> <p><b>For example providing host - https://koverse-docs.saic.com/api?host=api.myHost.com, will update requests to target the provided host.</b></p> <p><b>Authentication request example with provided host - https://api.myHost.com/authentication</b></p>

    The version of the OpenAPI document: 4.130.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class SyncSetupOrigin(BaseModel):
    """
    SyncSetupOrigin
    """ # noqa: E501
    id: StrictStr = Field(description="synchronization ID")
    dataset_id: StrictStr = Field(description="ID dataset to be synchronized", alias="datasetId")
    status: StrictStr = Field(description="synchronization status")
    type: StrictStr = Field(description="synchronization type")
    workspace_id: StrictStr = Field(description="Workspace ID", alias="workspaceId")
    workspace_unique_id: StrictStr = Field(description="Workspace uniqueId", alias="workspaceUniqueId")
    sync_workspace_id: StrictStr = Field(description="Sync Workspace ID", alias="syncWorkspaceId")
    sync_workspace_unique_id: StrictStr = Field(description="Sync Workspace uniqueId", alias="syncWorkspaceUniqueId")
    host: StrictStr = Field(description="Host")
    sync_host: StrictStr = Field(description="Sync Host", alias="syncHost")
    __properties: ClassVar[List[str]] = ["id", "datasetId", "status", "type", "workspaceId", "workspaceUniqueId", "syncWorkspaceId", "syncWorkspaceUniqueId", "host", "syncHost"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['pending', 'active', 'canceled']):
            raise ValueError("must be one of enum values ('pending', 'active', 'canceled')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['read', 'write', 'manage']):
            raise ValueError("must be one of enum values ('read', 'write', 'manage')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SyncSetupOrigin from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SyncSetupOrigin from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "datasetId": obj.get("datasetId"),
            "status": obj.get("status"),
            "type": obj.get("type"),
            "workspaceId": obj.get("workspaceId"),
            "workspaceUniqueId": obj.get("workspaceUniqueId"),
            "syncWorkspaceId": obj.get("syncWorkspaceId"),
            "syncWorkspaceUniqueId": obj.get("syncWorkspaceUniqueId"),
            "host": obj.get("host"),
            "syncHost": obj.get("syncHost")
        })
        return _obj


