# kdp-api-python-client
The KDP API is a REST API that can be used to create, access, and update data in KDP Workspaces. Please note that the Python client library follows Python's naming convention of snake casing for fields, even though they may appear in camel case in the API specification. <p><b>By default this api documentation targets the koverse production server at 'api.app.koverse.com' You can provide the hostname of your koverse instance to this documentation page via the 'host' query param.</p> <p><b>For example providing host - https://koverse-docs.saic.com/api?host=api.myHost.com, will update requests to target the provided host.</b></p> <p><b>Authentication request example with provided host - https://api.myHost.com/authentication</b></p>

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 4.141.0
- Package version: 4.141.0
- Generator version: 7.4.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import kdp_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import kdp_api
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import kdp_api
from kdp_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.app.koverse.com
# See configuration.py for a list of all supported configuration parameters.
configuration = kdp_api.Configuration(
    host = "https://api.app.koverse.com"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): Bearer
configuration = kdp_api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with kdp_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = kdp_api.ApplicationsApi(api_client)
    id = 'id_example' # str | ID of application to remove

    try:
        # Removes Application with the given ID
        api_response = api_instance.delete_applications_id(id)
        print("The response of ApplicationsApi->delete_applications_id:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ApplicationsApi->delete_applications_id: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.app.koverse.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApplicationsApi* | [**delete_applications_id**](docs/ApplicationsApi.md#delete_applications_id) | **DELETE** /applications/{id} | Removes Application with the given ID
*ApplicationsApi* | [**get_applications**](docs/ApplicationsApi.md#get_applications) | **GET** /applications | Retrieves a list of Applications
*ApplicationsApi* | [**get_applications_id**](docs/ApplicationsApi.md#get_applications_id) | **GET** /applications/{id} | Retrieves Application with the given ID
*ApplicationsApi* | [**patch_applications_id**](docs/ApplicationsApi.md#patch_applications_id) | **PATCH** /applications/{id} | Updates provided fields of Application with the given ID
*ApplicationsApi* | [**post_applications**](docs/ApplicationsApi.md#post_applications) | **POST** /applications | Create a new Application
*ApplicationsApi* | [**put_applications_id**](docs/ApplicationsApi.md#put_applications_id) | **PUT** /applications/{id} | Updates Application with the given ID
*AttributeBasedAccessControlApi* | [**delete_attribute_assignments_id**](docs/AttributeBasedAccessControlApi.md#delete_attribute_assignments_id) | **DELETE** /attribute-assignments/{id} | Attribute-Assignments - Remove Attribute Assignment with given ID
*AttributeBasedAccessControlApi* | [**delete_attributes_id**](docs/AttributeBasedAccessControlApi.md#delete_attributes_id) | **DELETE** /attributes/{id} | Attributes - Remove Attribute with the given ID
*AttributeBasedAccessControlApi* | [**get_attribute_assignments**](docs/AttributeBasedAccessControlApi.md#get_attribute_assignments) | **GET** /attribute-assignments | Attributes - Retrieve a list of Attribute Assignments
*AttributeBasedAccessControlApi* | [**get_attribute_assignments_id**](docs/AttributeBasedAccessControlApi.md#get_attribute_assignments_id) | **GET** /attribute-assignments/{id} | Attribute-Assignments - Retrieve Attribute Assignment with the given ID
*AttributeBasedAccessControlApi* | [**get_attributes**](docs/AttributeBasedAccessControlApi.md#get_attributes) | **GET** /attributes | Attributes - Retrieves a list of Attributes
*AttributeBasedAccessControlApi* | [**get_attributes_id**](docs/AttributeBasedAccessControlApi.md#get_attributes_id) | **GET** /attributes/{id} | Attributes - Retrieve Attribute with the given ID
*AttributeBasedAccessControlApi* | [**patch_attribute_assignments_id**](docs/AttributeBasedAccessControlApi.md#patch_attribute_assignments_id) | **PATCH** /attribute-assignments/{id} | Attribute-Assignments - Update provided fields of Attribute Assignment by given ID
*AttributeBasedAccessControlApi* | [**patch_attributes_id**](docs/AttributeBasedAccessControlApi.md#patch_attributes_id) | **PATCH** /attributes/{id} | Attributes - Update provided fields of Attribute with the given ID
*AttributeBasedAccessControlApi* | [**patch_column_security**](docs/AttributeBasedAccessControlApi.md#patch_column_security) | **PATCH** /write/schema/{datasetId} | Schema - Modify schema by adding new column security configuration
*AttributeBasedAccessControlApi* | [**post_attribute_assignments**](docs/AttributeBasedAccessControlApi.md#post_attribute_assignments) | **POST** /attribute-assignments | Attribute-Assignments - Create a new Attribute Assignment
*AttributeBasedAccessControlApi* | [**post_attributes**](docs/AttributeBasedAccessControlApi.md#post_attributes) | **POST** /attributes | Attributes - Creates a new Attribute
*AttributeBasedAccessControlApi* | [**put_attribute_assignments_id**](docs/AttributeBasedAccessControlApi.md#put_attribute_assignments_id) | **PUT** /attribute-assignments/{id} | Attribute-Assignments - Update an Attribute Assignment by given ID
*AttributeBasedAccessControlApi* | [**put_attributes_id**](docs/AttributeBasedAccessControlApi.md#put_attributes_id) | **PUT** /attributes/{id} | Attributes - Update Attribute with the given ID
*AuthenticateApi* | [**delete_authentication_id**](docs/AuthenticateApi.md#delete_authentication_id) | **DELETE** /authentication/{id} | Remove authentication with accessToken
*AuthenticateApi* | [**post_authentication**](docs/AuthenticateApi.md#post_authentication) | **POST** /authentication | Creates a new Koverse Authentication Token
*AuthenticateApi* | [**post_authentication_sso**](docs/AuthenticateApi.md#post_authentication_sso) | **POST** /authentication?workspaceId&#x3D;{workspaceId} | Creates a new Koverse Authentication Token for Single Sign-On (SSO) users
*DatasetPairingApi* | [**get_dataset_syncs**](docs/DatasetPairingApi.md#get_dataset_syncs) | **GET** /dataset-syncs | Retrieve a list of Dataset Syncs
*DatasetPairingApi* | [**get_dataset_syncs_id**](docs/DatasetPairingApi.md#get_dataset_syncs_id) | **GET** /dataset-syncs/{id} | Retrieve a Dataset Sync with the given ID
*DatasetPairingApi* | [**patch_dataset_syncs_id**](docs/DatasetPairingApi.md#patch_dataset_syncs_id) | **PATCH** /dataset-syncs/{id} | Update provided fields of Dataset Sync with given ID
*DatasetPairingApi* | [**post_dataset_syncs_management_terminate_connection**](docs/DatasetPairingApi.md#post_dataset_syncs_management_terminate_connection) | **POST** /dataset-sync-management | Terminate a Dataset-Sync Connection
*DatasetPairingApi* | [**post_dataset_syncs_origin**](docs/DatasetPairingApi.md#post_dataset_syncs_origin) | **POST** /dataset-syncs | Create Sync Key (Create Origin Dataset Sync)
*DatasetPairingApi* | [**post_dataset_syncs_replica**](docs/DatasetPairingApi.md#post_dataset_syncs_replica) | **POST** /dataset-syncs?postType&#x3D;replica | Create and activate a Dataset Sync from key (Create Replica Dataset Sync)
*DatasetPairingApi* | [**put_dataset_syncs_id**](docs/DatasetPairingApi.md#put_dataset_syncs_id) | **PUT** /dataset-syncs/{id} | Update Dataset Sync with the given ID
*DatasetPermissionsApi* | [**delete_dataset_permissions_id**](docs/DatasetPermissionsApi.md#delete_dataset_permissions_id) | **DELETE** /dataset-permissions/{id} | Remove Dataset Permission with given ID
*DatasetPermissionsApi* | [**get_dataset_permissions**](docs/DatasetPermissionsApi.md#get_dataset_permissions) | **GET** /dataset-permissions | Retrieve list of dataset permissions
*DatasetPermissionsApi* | [**get_dataset_permissions_id**](docs/DatasetPermissionsApi.md#get_dataset_permissions_id) | **GET** /dataset-permissions/{id} | Retrieve a Dataset Permission with the given ID
*DatasetPermissionsApi* | [**patch_dataset_permissions_id**](docs/DatasetPermissionsApi.md#patch_dataset_permissions_id) | **PATCH** /dataset-permissions/{id} | Update provided fields of Dataset Permission with given ID
*DatasetPermissionsApi* | [**post_dataset_permissions**](docs/DatasetPermissionsApi.md#post_dataset_permissions) | **POST** /dataset-permissions | Create a new Dataset Permission
*DatasetPermissionsApi* | [**put_dataset_permissions_id**](docs/DatasetPermissionsApi.md#put_dataset_permissions_id) | **PUT** /dataset-permissions/{id} | Update Dataset Permission with the given ID
*DatasetsApi* | [**delete_datasets_id**](docs/DatasetsApi.md#delete_datasets_id) | **DELETE** /datasets/{id} | Datasets - Remove Dataset with given ID
*DatasetsApi* | [**get_datasets**](docs/DatasetsApi.md#get_datasets) | **GET** /datasets | Datasets - Retrieve a list of datasets
*DatasetsApi* | [**get_datasets_id**](docs/DatasetsApi.md#get_datasets_id) | **GET** /datasets/{id} | Datasets - Retrieve a Dataset with the given ID
*DatasetsApi* | [**get_jobs**](docs/DatasetsApi.md#get_jobs) | **GET** /jobs | Jobs - Retrieves list of Jobs
*DatasetsApi* | [**get_jobs_id**](docs/DatasetsApi.md#get_jobs_id) | **GET** /jobs/{id} | Jobs - Retrieve Job with the given ID
*DatasetsApi* | [**get_schema**](docs/DatasetsApi.md#get_schema) | **GET** /query/schema/{datasetId} | Schema - Get the schema for the given dataset id
*DatasetsApi* | [**get_segments**](docs/DatasetsApi.md#get_segments) | **GET** /segments | Segments - Retrieves a list of Segments
*DatasetsApi* | [**get_segments_id**](docs/DatasetsApi.md#get_segments_id) | **GET** /segments/{id} | Segments - Retrieves Segment with the given ID
*DatasetsApi* | [**patch_datasets_id**](docs/DatasetsApi.md#patch_datasets_id) | **PATCH** /datasets/{id} | Datasets - Updates the provided fields of Dataset with given ID
*DatasetsApi* | [**patch_jobs_id**](docs/DatasetsApi.md#patch_jobs_id) | **PATCH** /jobs/{id} | Jobs - Updates fields provided for Jobs with the ID given
*DatasetsApi* | [**post_datasets**](docs/DatasetsApi.md#post_datasets) | **POST** /datasets | Datasets - Create a new Dataset
*DatasetsApi* | [**post_jobs**](docs/DatasetsApi.md#post_jobs) | **POST** /jobs | Jobs - Creates a new Job
*DatasetsApi* | [**put_datasets_id**](docs/DatasetsApi.md#put_datasets_id) | **PUT** /datasets/{id} | Datasets - Updates Dataset with given ID
*DatasetsApi* | [**put_jobs_id**](docs/DatasetsApi.md#put_jobs_id) | **PUT** /jobs/{id} | Jobs - Updates Job with the ID given
*IndexingApi* | [**delete_indexes_id**](docs/IndexingApi.md#delete_indexes_id) | **DELETE** /indexes/{id} | Indexes - Removes Index with the given ID
*IndexingApi* | [**get_indexes**](docs/IndexingApi.md#get_indexes) | **GET** /indexes | Indexes - Retrieve list of Indexes
*IndexingApi* | [**get_indexes_id**](docs/IndexingApi.md#get_indexes_id) | **GET** /indexes/{id} | Indexes - Retrieve Index with given ID
*IndexingApi* | [**patch_indexes_id**](docs/IndexingApi.md#patch_indexes_id) | **PATCH** /indexes/{id} | Indexes - Updates fields provided for Index with the ID given
*IndexingApi* | [**post_indexes**](docs/IndexingApi.md#post_indexes) | **POST** /indexes | Indexes - Create a new Index
*IndexingApi* | [**put_indexes_id**](docs/IndexingApi.md#put_indexes_id) | **PUT** /indexes/{id} | Indexes - Updates Index with given ID
*ManageRecordsApi* | [**delete_dataset_document_query**](docs/ManageRecordsApi.md#delete_dataset_document_query) | **POST** /storage/datasets/{datasetId}/deleteDocuments/query | Delete Documents - Deletes documents from a dataset based on a given query
*ManageRecordsApi* | [**delete_dataset_record_id**](docs/ManageRecordsApi.md#delete_dataset_record_id) | **POST** /storage/datasets/{datasetId}/deleteRecords | Delete Records - Deletes records from a dataset based on the given ids
*ManageRecordsApi* | [**delete_dataset_record_query**](docs/ManageRecordsApi.md#delete_dataset_record_query) | **POST** /storage/datasets/{datasetId}/deleteRecords/query | Delete Records - Deletes records from a dataset based on a given query
*ManageRecordsApi* | [**post_clear_dataset**](docs/ManageRecordsApi.md#post_clear_dataset) | **POST** /storage/datasets/{datasetId}/clear | Delete - Clear a dataset
*ReadAndQueryApi* | [**get_serve_media**](docs/ReadAndQueryApi.md#get_serve_media) | **GET** /serve-media/{datasetId}?documentId&#x3D;documentId | Serve-Media - Performs authentication and authorization checks for users before providing a media url
*ReadAndQueryApi* | [**get_splits_id**](docs/ReadAndQueryApi.md#get_splits_id) | **GET** /splits/{datasetId} | Get record ranges of partitions
*ReadAndQueryApi* | [**post_lucene_query**](docs/ReadAndQueryApi.md#post_lucene_query) | **POST** /query/lucene | Query a dataset using the lucene query syntax
*ReadAndQueryApi* | [**post_lucene_query_document**](docs/ReadAndQueryApi.md#post_lucene_query_document) | **POST** /query/document/lucene | Query document for a dataset using the lucene query syntax
*ReadAndQueryApi* | [**post_query**](docs/ReadAndQueryApi.md#post_query) | **POST** /query | Query a dataset
*ReadAndQueryApi* | [**post_query_summary**](docs/ReadAndQueryApi.md#post_query_summary) | **POST** /query/datasets/summary | Query all datasets
*ReadAndQueryApi* | [**post_read**](docs/ReadAndQueryApi.md#post_read) | **POST** /read | Read records
*ReadAndQueryApi* | [**post_read_in_sequence**](docs/ReadAndQueryApi.md#post_read_in_sequence) | **POST** /readInSequence | Read records from dataset in sequence
*UsersAndGroupsApi* | [**delete_group_memberships_id**](docs/UsersAndGroupsApi.md#delete_group_memberships_id) | **DELETE** /groups-memberships/{id} | Group-Memberships - Deletes the group membership with the given ID
*UsersAndGroupsApi* | [**delete_groups_id**](docs/UsersAndGroupsApi.md#delete_groups_id) | **DELETE** /groups/{id} | Groups - Removes the group with the given id
*UsersAndGroupsApi* | [**delete_users_id**](docs/UsersAndGroupsApi.md#delete_users_id) | **DELETE** /users/{id} | Users - Removes the user by given id
*UsersAndGroupsApi* | [**get_group_memberships**](docs/UsersAndGroupsApi.md#get_group_memberships) | **GET** /group-memberships | Group-Memberships - Retrieves a list of group memberships
*UsersAndGroupsApi* | [**get_group_memberships_id**](docs/UsersAndGroupsApi.md#get_group_memberships_id) | **GET** /groups-memberships/{id} | Group-Memberships - Retrieves a group membership with the given id
*UsersAndGroupsApi* | [**get_groups**](docs/UsersAndGroupsApi.md#get_groups) | **GET** /groups | Groups - Retrieves a list of groups from the groups service
*UsersAndGroupsApi* | [**get_groups_id**](docs/UsersAndGroupsApi.md#get_groups_id) | **GET** /groups/{id} | Groups - Retrieves a group with the given id from the service
*UsersAndGroupsApi* | [**get_users**](docs/UsersAndGroupsApi.md#get_users) | **GET** /users | Users - Retrieves a list of users
*UsersAndGroupsApi* | [**get_users_id**](docs/UsersAndGroupsApi.md#get_users_id) | **GET** /users/{id} | Users - Retrieves a user with the given id from the users service.
*UsersAndGroupsApi* | [**patch_group_memberships_id**](docs/UsersAndGroupsApi.md#patch_group_memberships_id) | **PATCH** /groups-memberships/{id} | Group-Memberships - Updates the provided properties of group membership with the given ID
*UsersAndGroupsApi* | [**patch_groups_id**](docs/UsersAndGroupsApi.md#patch_groups_id) | **PATCH** /groups/{id} | Groups - Updates the resource with the given id
*UsersAndGroupsApi* | [**patch_users_id**](docs/UsersAndGroupsApi.md#patch_users_id) | **PATCH** /users/{id} | Users - Updates the resource by id for the fields provided
*UsersAndGroupsApi* | [**post_group_memberships**](docs/UsersAndGroupsApi.md#post_group_memberships) | **POST** /group-memberships | Group-Memberships - Create a new group membership
*UsersAndGroupsApi* | [**post_groups**](docs/UsersAndGroupsApi.md#post_groups) | **POST** /groups | Groups - Create a new group
*UsersAndGroupsApi* | [**post_user**](docs/UsersAndGroupsApi.md#post_user) | **POST** /users | Users - Create a user
*UsersAndGroupsApi* | [**put_group_memberships_id**](docs/UsersAndGroupsApi.md#put_group_memberships_id) | **PUT** /groups-memberships/{id} | Group-Memberships - Updates the group membership with the given ID
*UsersAndGroupsApi* | [**put_groups_id**](docs/UsersAndGroupsApi.md#put_groups_id) | **PUT** /groups/{id} | Groups - Updates the group with given id
*UsersAndGroupsApi* | [**put_users_id**](docs/UsersAndGroupsApi.md#put_users_id) | **PUT** /users/{id} | Users - Updates a user with given id
*WorkspacesApi* | [**get_all_auditlog_configurations**](docs/WorkspacesApi.md#get_all_auditlog_configurations) | **GET** /audit-log-configs/ | Audit-Logs - Get audit log configuration
*WorkspacesApi* | [**get_workspaces**](docs/WorkspacesApi.md#get_workspaces) | **GET** /workspaces | Workspaces - Retrieves a list of workspaces
*WorkspacesApi* | [**get_workspaces_id**](docs/WorkspacesApi.md#get_workspaces_id) | **GET** /workspaces/{id} | Workspaces - Retrieves Workspace with given ID
*WorkspacesApi* | [**patch_auditlog_configuration**](docs/WorkspacesApi.md#patch_auditlog_configuration) | **PATCH** /audit-log-configs/{auditLogConfigsId} | Audit-Logs - Patch audit log configuration of a workspace
*WorkspacesApi* | [**patch_workspaces_id**](docs/WorkspacesApi.md#patch_workspaces_id) | **PATCH** /workspaces/{id} | Workspaces - Updates provided fields of Workspace with the ID given
*WorkspacesApi* | [**post_audit_log_query**](docs/WorkspacesApi.md#post_audit_log_query) | **POST** /audit-log/query | Audit-Logs - Queries audit log datasets
*WorkspacesApi* | [**post_workspaces**](docs/WorkspacesApi.md#post_workspaces) | **POST** /workspaces | Workspaces - Creates a new Workspace
*WorkspacesApi* | [**put_workspaces_id**](docs/WorkspacesApi.md#put_workspaces_id) | **PUT** /workspaces/{id} | Workspaces - Updates Workspace with the ID given
*WriteApi* | [**get_abac_label_parsers**](docs/WriteApi.md#get_abac_label_parsers) | **GET** /abac-label-parsers | Retrieves a list of Abac Label Parsers
*WriteApi* | [**get_abac_label_parsers_id**](docs/WriteApi.md#get_abac_label_parsers_id) | **GET** /abac-label-parsers/{id} | Retrieves Abac Label Parser with the given ID.
*WriteApi* | [**post_ingest**](docs/WriteApi.md#post_ingest) | **POST** /ingest | Create an Ingest Job
*WriteApi* | [**post_uploads**](docs/WriteApi.md#post_uploads) | **POST** /uploads | Upload data from files
*WriteApi* | [**post_v2_write_id**](docs/WriteApi.md#post_v2_write_id) | **POST** /v2/write/{datasetId} | Write records (v2)
*WriteApi* | [**post_write_id**](docs/WriteApi.md#post_write_id) | **POST** /write/{datasetId} | Write records


## Documentation For Models

 - [AbacLabelParserPaginator](docs/AbacLabelParserPaginator.md)
 - [AbacLabelParsers](docs/AbacLabelParsers.md)
 - [AccessControlLabel](docs/AccessControlLabel.md)
 - [ApiError](docs/ApiError.md)
 - [Application](docs/Application.md)
 - [ApplicationCreateRequest](docs/ApplicationCreateRequest.md)
 - [ApplicationCreateRequestRequiredDatasetAccessInner](docs/ApplicationCreateRequestRequiredDatasetAccessInner.md)
 - [ApplicationPaginator](docs/ApplicationPaginator.md)
 - [ApplicationPatchRequest](docs/ApplicationPatchRequest.md)
 - [ApplicationRequiredDatasetAccessInner](docs/ApplicationRequiredDatasetAccessInner.md)
 - [ApplicationUpdateRequest](docs/ApplicationUpdateRequest.md)
 - [Attribute](docs/Attribute.md)
 - [AttributeAssignment](docs/AttributeAssignment.md)
 - [AttributeAssignmentCreateRequest](docs/AttributeAssignmentCreateRequest.md)
 - [AttributeAssignmentPaginator](docs/AttributeAssignmentPaginator.md)
 - [AttributeAssignmentPatchRequest](docs/AttributeAssignmentPatchRequest.md)
 - [AttributeAssignmentUpdateRequest](docs/AttributeAssignmentUpdateRequest.md)
 - [AttributeCreateRequest](docs/AttributeCreateRequest.md)
 - [AttributePaginator](docs/AttributePaginator.md)
 - [AttributePatchRequest](docs/AttributePatchRequest.md)
 - [AttributeUpdateRequest](docs/AttributeUpdateRequest.md)
 - [AuditLogConfiguration](docs/AuditLogConfiguration.md)
 - [AuditLogConfigurationPaginator](docs/AuditLogConfigurationPaginator.md)
 - [AuditLogEvent](docs/AuditLogEvent.md)
 - [AuditLogPaginator](docs/AuditLogPaginator.md)
 - [Authentication](docs/Authentication.md)
 - [AuthenticationDetails](docs/AuthenticationDetails.md)
 - [AuthenticationDetailsAuthentication](docs/AuthenticationDetailsAuthentication.md)
 - [AuthenticationDetailsAuthenticationPayload](docs/AuthenticationDetailsAuthenticationPayload.md)
 - [AuthenticationDetailsUser](docs/AuthenticationDetailsUser.md)
 - [AuthenticationSSO](docs/AuthenticationSSO.md)
 - [BatchWriteRequest](docs/BatchWriteRequest.md)
 - [ConnectionInfo](docs/ConnectionInfo.md)
 - [CustomIdentityProvider](docs/CustomIdentityProvider.md)
 - [DataSourceParams](docs/DataSourceParams.md)
 - [Dataset](docs/Dataset.md)
 - [DatasetCreateRequest](docs/DatasetCreateRequest.md)
 - [DatasetCurrentUserPermissions](docs/DatasetCurrentUserPermissions.md)
 - [DatasetPaginator](docs/DatasetPaginator.md)
 - [DatasetPatchRequest](docs/DatasetPatchRequest.md)
 - [DatasetPermission](docs/DatasetPermission.md)
 - [DatasetPermissionCreateRequest](docs/DatasetPermissionCreateRequest.md)
 - [DatasetPermissionPaginator](docs/DatasetPermissionPaginator.md)
 - [DatasetPermissionPatchRequest](docs/DatasetPermissionPatchRequest.md)
 - [DatasetPermissionUpdateRequest](docs/DatasetPermissionUpdateRequest.md)
 - [DatasetSync](docs/DatasetSync.md)
 - [DatasetSyncManagementTerminateConnectionRequest](docs/DatasetSyncManagementTerminateConnectionRequest.md)
 - [DatasetSyncPaginator](docs/DatasetSyncPaginator.md)
 - [DatasetSyncPatchRequest](docs/DatasetSyncPatchRequest.md)
 - [DatasetSyncUpdateRequest](docs/DatasetSyncUpdateRequest.md)
 - [DatasetUpdateRequest](docs/DatasetUpdateRequest.md)
 - [DeleteDocumentByQueryRequest](docs/DeleteDocumentByQueryRequest.md)
 - [DeleteRecordByIdRequest](docs/DeleteRecordByIdRequest.md)
 - [DeleteRecordByQueryRequest](docs/DeleteRecordByQueryRequest.md)
 - [ErrorCode](docs/ErrorCode.md)
 - [GetServeMedia200Response](docs/GetServeMedia200Response.md)
 - [Group](docs/Group.md)
 - [GroupCreateRequest](docs/GroupCreateRequest.md)
 - [GroupMembership](docs/GroupMembership.md)
 - [GroupMembershipCreateRequest](docs/GroupMembershipCreateRequest.md)
 - [GroupMembershipPaginator](docs/GroupMembershipPaginator.md)
 - [GroupMembershipPatchRequest](docs/GroupMembershipPatchRequest.md)
 - [GroupMembershipUpdateRequest](docs/GroupMembershipUpdateRequest.md)
 - [GroupPaginator](docs/GroupPaginator.md)
 - [GroupPatchRequest](docs/GroupPatchRequest.md)
 - [GroupUpdateRequest](docs/GroupUpdateRequest.md)
 - [Index](docs/Index.md)
 - [IndexPaginator](docs/IndexPaginator.md)
 - [IngestCreateRequest](docs/IngestCreateRequest.md)
 - [Job](docs/Job.md)
 - [JobPaginator](docs/JobPaginator.md)
 - [KeycloakProviderConfiguration](docs/KeycloakProviderConfiguration.md)
 - [KoverseDocumentMetadata](docs/KoverseDocumentMetadata.md)
 - [LuceneQueryRequest](docs/LuceneQueryRequest.md)
 - [OriginDatasetSyncCreateRequest](docs/OriginDatasetSyncCreateRequest.md)
 - [Query](docs/Query.md)
 - [QueryDatasetsSummary](docs/QueryDatasetsSummary.md)
 - [QueryDatasetsSummaryDatasetsInner](docs/QueryDatasetsSummaryDatasetsInner.md)
 - [QueryDatasetsSummaryRequest](docs/QueryDatasetsSummaryRequest.md)
 - [QueryDocumentLuceneRequest](docs/QueryDocumentLuceneRequest.md)
 - [QueryDocumentLuceneResponse](docs/QueryDocumentLuceneResponse.md)
 - [QueryDocumentLuceneResponseRecordsInner](docs/QueryDocumentLuceneResponseRecordsInner.md)
 - [ReadRangeRequest](docs/ReadRangeRequest.md)
 - [RecordBatch](docs/RecordBatch.md)
 - [ReindexRequest](docs/ReindexRequest.md)
 - [ReplicaDatasetSyncCreateRequest](docs/ReplicaDatasetSyncCreateRequest.md)
 - [SchemaField](docs/SchemaField.md)
 - [SchemaFieldSecurityLabel](docs/SchemaFieldSecurityLabel.md)
 - [SecurityLabelInfoParams](docs/SecurityLabelInfoParams.md)
 - [Segment](docs/Segment.md)
 - [SegmentPaginator](docs/SegmentPaginator.md)
 - [SequenceReadRequest](docs/SequenceReadRequest.md)
 - [SourceTypes](docs/SourceTypes.md)
 - [SplitPoints](docs/SplitPoints.md)
 - [StripeLatestCharge](docs/StripeLatestCharge.md)
 - [StripeLatestCharge1](docs/StripeLatestCharge1.md)
 - [SyncKafkaConsumerGroupId](docs/SyncKafkaConsumerGroupId.md)
 - [SyncSetupOrigin](docs/SyncSetupOrigin.md)
 - [SyncSetupReplica](docs/SyncSetupReplica.md)
 - [TerminateConnectionResponse](docs/TerminateConnectionResponse.md)
 - [TransferResourceRequest](docs/TransferResourceRequest.md)
 - [UploadAccessControlLabel](docs/UploadAccessControlLabel.md)
 - [UploadResponse](docs/UploadResponse.md)
 - [User](docs/User.md)
 - [UserCreateRequest](docs/UserCreateRequest.md)
 - [UserPaginator](docs/UserPaginator.md)
 - [UserPatchRequest](docs/UserPatchRequest.md)
 - [UserUpdateRequest](docs/UserUpdateRequest.md)
 - [Workspace](docs/Workspace.md)
 - [WorkspaceCreateRequest](docs/WorkspaceCreateRequest.md)
 - [WorkspaceCreateRequestSubscription](docs/WorkspaceCreateRequestSubscription.md)
 - [WorkspaceCreateRequestSubscriptionSubscriptionItemIds](docs/WorkspaceCreateRequestSubscriptionSubscriptionItemIds.md)
 - [WorkspacePaginator](docs/WorkspacePaginator.md)
 - [WorkspacePatchRequest](docs/WorkspacePatchRequest.md)
 - [WorkspaceSubscription](docs/WorkspaceSubscription.md)
 - [WorkspaceSubscriptionSubscriptionItemIds](docs/WorkspaceSubscriptionSubscriptionItemIds.md)
 - [WorkspaceUpdateRequest](docs/WorkspaceUpdateRequest.md)
 - [WriteBatchResponse](docs/WriteBatchResponse.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="Bearer"></a>
### Bearer

- **Type**: Bearer authentication (JWT)


## Author




