# coding: utf-8

"""
    Koverse Data Platform (KDP) API

    The KDP API is a REST API that can be used to create, access, and update data in KDP Workspaces. Please note that the Python client library follows Python's naming convention of snake casing for fields, even though they may appear in camel case in the API specification. <p><b>By default this api documentation targets the koverse production server at 'api.app.koverse.com' You can provide the hostname of your koverse instance to this documentation page via the 'host' query param.</p> <p><b>For example providing host - https://koverse-docs.saic.com/api?host=api.myHost.com, will update requests to target the provided host.</b></p> <p><b>Authentication request example with provided host - https://api.myHost.com/authentication</b></p>

    The version of the OpenAPI document: 4.143.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from kdp_api.models.index import Index
from typing import Optional, Set
from typing_extensions import Self

class ReindexRequest(BaseModel):
    """
    ReindexRequest
    """ # noqa: E501
    dataset_id: StrictStr = Field(description="ID of the dataset (uuid)", alias="datasetId")
    created: Optional[List[Index]] = None
    deleted: Optional[List[Index]] = None
    search_any_field_changed: Optional[StrictBool] = Field(default=None, alias="searchAnyFieldChanged")
    __properties: ClassVar[List[str]] = ["datasetId", "created", "deleted", "searchAnyFieldChanged"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReindexRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in created (list)
        _items = []
        if self.created:
            for _item in self.created:
                if _item:
                    _items.append(_item.to_dict())
            _dict['created'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in deleted (list)
        _items = []
        if self.deleted:
            for _item in self.deleted:
                if _item:
                    _items.append(_item.to_dict())
            _dict['deleted'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReindexRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "datasetId": obj.get("datasetId"),
            "created": [Index.from_dict(_item) for _item in obj["created"]] if obj.get("created") is not None else None,
            "deleted": [Index.from_dict(_item) for _item in obj["deleted"]] if obj.get("deleted") is not None else None,
            "searchAnyFieldChanged": obj.get("searchAnyFieldChanged")
        })
        return _obj


