# coding: utf-8

"""
    Koverse Data Platform (KDP) API

    The KDP API is a REST API that can be used to create, access, and update data in KDP Workspaces. Please note that the Python client library follows Python's naming convention of snake casing for fields, even though they may appear in camel case in the API specification. <p><b>By default this api documentation targets the koverse production server at 'api.app.koverse.com' You can provide the hostname of your koverse instance to this documentation page via the 'host' query param.</p> <p><b>For example providing host - https://koverse-docs.saic.com/api?host=api.myHost.com, will update requests to target the provided host.</b></p> <p><b>Authentication request example with provided host - https://api.myHost.com/authentication</b></p>

    The version of the OpenAPI document: 4.145.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kdp_api.models.schema_field_security_label import SchemaFieldSecurityLabel
from kdp_api.models.security_label_info_params import SecurityLabelInfoParams
from typing import Optional, Set
from typing_extensions import Self

class BatchWriteRequest(BaseModel):
    """
    BatchWriteRequest
    """ # noqa: E501
    records: Optional[List[Dict[str, Any]]] = Field(default=None, description="Array of json documents to write into KDP.")
    security_label_info: Optional[SecurityLabelInfoParams] = Field(default=None, alias="securityLabelInfo")
    column_security_label_info: Optional[Dict[str, SchemaFieldSecurityLabel]] = Field(default=None, description="The schema of the records returned in a record batch", alias="columnSecurityLabelInfo")
    __properties: ClassVar[List[str]] = ["records", "securityLabelInfo", "columnSecurityLabelInfo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BatchWriteRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of security_label_info
        if self.security_label_info:
            _dict['securityLabelInfo'] = self.security_label_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in column_security_label_info (dict)
        _field_dict = {}
        if self.column_security_label_info:
            for _key in self.column_security_label_info:
                if self.column_security_label_info[_key]:
                    _field_dict[_key] = self.column_security_label_info[_key].to_dict()
            _dict['columnSecurityLabelInfo'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BatchWriteRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "records": obj.get("records"),
            "securityLabelInfo": SecurityLabelInfoParams.from_dict(obj["securityLabelInfo"]) if obj.get("securityLabelInfo") is not None else None,
            "columnSecurityLabelInfo": dict(
                (_k, SchemaFieldSecurityLabel.from_dict(_v))
                for _k, _v in obj["columnSecurityLabelInfo"].items()
            )
            if obj.get("columnSecurityLabelInfo") is not None
            else None
        })
        return _obj


