# coding: utf-8

"""
    Koverse Data Platform (KDP) API

    The KDP API is a REST API that can be used to create, access, and update data in KDP Workspaces. Please note that the Python client library follows Python's naming convention of snake casing for fields, even though they may appear in camel case in the API specification. <p><b>By default this api documentation targets the koverse production server at 'api.app.koverse.com' You can provide the hostname of your koverse instance to this documentation page via the 'host' query param.</p> <p><b>For example providing host - https://koverse-docs.saic.com/api?host=api.myHost.com, will update requests to target the provided host.</b></p> <p><b>Authentication request example with provided host - https://api.myHost.com/authentication</b></p>

    The version of the OpenAPI document: 4.145.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class APIKeyResponse(BaseModel):
    """
    APIKeyResponse
    """ # noqa: E501
    id: StrictStr = Field(description="API Key ID")
    name: Optional[StrictStr] = Field(default=None, description="API Key name")
    key: Optional[StrictStr] = Field(default=None, description="API Key")
    workspace_id: StrictStr = Field(description="Workspace ID", alias="workspaceId")
    description: Optional[StrictStr] = Field(default=None, description="API Key description")
    revoked: Optional[StrictBool] = Field(default=None, description="API Key Revoked")
    created_by: Optional[StrictStr] = Field(default=None, description="API Key Created By", alias="createdBy")
    expiration_at: Optional[datetime] = Field(default=None, description="API Key Expiration Time", alias="expirationAt")
    key_id: Optional[StrictStr] = Field(default=None, description="API Key ID - first six characters of API Key", alias="keyId")
    user_id: Optional[StrictStr] = Field(default=None, description="User ID", alias="userId")
    updated_at: Optional[datetime] = Field(default=None, description="API Key Updated At", alias="updatedAt")
    created_at: Optional[datetime] = Field(default=None, description="API Key Created At", alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, description="API Key Deleted At", alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "name", "key", "workspaceId", "description", "revoked", "createdBy", "expirationAt", "keyId", "userId", "updatedAt", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of APIKeyResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of APIKeyResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "key": obj.get("key"),
            "workspaceId": obj.get("workspaceId"),
            "description": obj.get("description"),
            "revoked": obj.get("revoked"),
            "createdBy": obj.get("createdBy"),
            "expirationAt": obj.get("expirationAt"),
            "keyId": obj.get("keyId"),
            "userId": obj.get("userId"),
            "updatedAt": obj.get("updatedAt"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


