# coding: utf-8

"""
    Koverse Data Platform (KDP) API

    The KDP API is a REST API that can be used to create, access, and update data in KDP Workspaces. Please note that the Python client library follows Python's naming convention of snake casing for fields, even though they may appear in camel case in the API specification. <p><b>By default this api documentation targets the koverse production server at 'api.app.koverse.com' You can provide the hostname of your koverse instance to this documentation page via the 'host' query param.</p> <p><b>For example providing host - https://koverse-docs.saic.com/api?host=api.myHost.com, will update requests to target the provided host.</b></p> <p><b>Authentication request example with provided host - https://api.myHost.com/authentication</b></p>

    The version of the OpenAPI document: 4.145.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class AuthenticationDetailsUser(BaseModel):
    """
    AuthenticationDetailsUser
    """ # noqa: E501
    avatar: Optional[StrictStr] = None
    change_email_token_expiration: Optional[StrictStr] = Field(default=None, alias="changeEmailTokenExpiration")
    created_at: Optional[StrictStr] = Field(default=None, alias="createdAt")
    deleted_at: Optional[StrictStr] = Field(default=None, alias="deletedAt")
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    email: Optional[StrictStr] = None
    first_name: Optional[StrictStr] = Field(default=None, alias="firstName")
    github_id: Optional[StrictStr] = Field(default=None, alias="githubId")
    google_id: Optional[StrictStr] = Field(default=None, alias="googleId")
    id: Optional[StrictStr] = None
    last_name: Optional[StrictStr] = Field(default=None, alias="lastName")
    linked_accounts: Optional[List[StrictStr]] = Field(default=None, alias="linkedAccounts")
    microsoft_id: Optional[StrictStr] = Field(default=None, alias="microsoftId")
    okta_id: Optional[StrictStr] = Field(default=None, alias="oktaId")
    stripe_customer_id: Optional[StrictStr] = Field(default=None, alias="stripeCustomerId")
    updated_at: Optional[StrictStr] = Field(default=None, alias="updatedAt")
    verified: Optional[StrictBool] = None
    workspace_count: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="workspaceCount")
    __properties: ClassVar[List[str]] = ["avatar", "changeEmailTokenExpiration", "createdAt", "deletedAt", "displayName", "email", "firstName", "githubId", "googleId", "id", "lastName", "linkedAccounts", "microsoftId", "oktaId", "stripeCustomerId", "updatedAt", "verified", "workspaceCount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AuthenticationDetailsUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AuthenticationDetailsUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "avatar": obj.get("avatar"),
            "changeEmailTokenExpiration": obj.get("changeEmailTokenExpiration"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt"),
            "displayName": obj.get("displayName"),
            "email": obj.get("email"),
            "firstName": obj.get("firstName"),
            "githubId": obj.get("githubId"),
            "googleId": obj.get("googleId"),
            "id": obj.get("id"),
            "lastName": obj.get("lastName"),
            "linkedAccounts": obj.get("linkedAccounts"),
            "microsoftId": obj.get("microsoftId"),
            "oktaId": obj.get("oktaId"),
            "stripeCustomerId": obj.get("stripeCustomerId"),
            "updatedAt": obj.get("updatedAt"),
            "verified": obj.get("verified"),
            "workspaceCount": obj.get("workspaceCount")
        })
        return _obj


