# coding: utf-8

"""
    Koverse Data Platform (KDP) API

    The KDP API is a REST API that can be used to create, access, and update data in KDP Workspaces. Please note that the Python client library follows Python's naming convention of snake casing for fields, even though they may appear in camel case in the API specification. <p><b>By default this api documentation targets the koverse production server at 'api.app.koverse.com' You can provide the hostname of your koverse instance to this documentation page via the 'host' query param.</p> <p><b>For example providing host - https://koverse-docs.saic.com/api?host=api.myHost.com, will update requests to target the provided host.</b></p> <p><b>Authentication request example with provided host - https://api.myHost.com/authentication</b></p>

    The version of the OpenAPI document: 4.146.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from kdp_api.models.query_document_lucene_response_records_inner import QueryDocumentLuceneResponseRecordsInner
from kdp_api.models.schema_field import SchemaField
from typing import Optional, Set
from typing_extensions import Self

class QueryDocumentLuceneResponse(BaseModel):
    """
    A batch of records returned from the query
    """ # noqa: E501
    records: Optional[List[QueryDocumentLuceneResponseRecordsInner]] = None
    var_schema: Optional[Dict[str, SchemaField]] = Field(default=None, description="The schema of the records returned in a batch", alias="schema")
    total: Optional[StrictInt] = Field(default=None, description="The total count of all records the query can return, includes records even if they are not in the current batch result")
    __properties: ClassVar[List[str]] = ["records", "schema", "total"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of QueryDocumentLuceneResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in records (list)
        _items = []
        if self.records:
            for _item in self.records:
                if _item:
                    _items.append(_item.to_dict())
            _dict['records'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in var_schema (dict)
        _field_dict = {}
        if self.var_schema:
            for _key in self.var_schema:
                if self.var_schema[_key]:
                    _field_dict[_key] = self.var_schema[_key].to_dict()
            _dict['schema'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of QueryDocumentLuceneResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "records": [QueryDocumentLuceneResponseRecordsInner.from_dict(_item) for _item in obj["records"]] if obj.get("records") is not None else None,
            "schema": dict(
                (_k, SchemaField.from_dict(_v))
                for _k, _v in obj["schema"].items()
            )
            if obj.get("schema") is not None
            else None,
            "total": obj.get("total")
        })
        return _obj


