# coding: utf-8

"""
    Koverse Data Platform (KDP) API

    The KDP API is a REST API that can be used to create, access, and update data in KDP Workspaces. Please note that the Python client library follows Python's naming convention of snake casing for fields, even though they may appear in camel case in the API specification. <p><b>By default this api documentation targets the koverse production server at 'api.app.koverse.com' You can provide the hostname of your koverse instance to this documentation page via the 'host' query param.</p> <p><b>For example providing host - https://koverse-docs.saic.com/api?host=api.myHost.com, will update requests to target the provided host.</b></p> <p><b>Authentication request example with provided host - https://api.myHost.com/authentication</b></p>

    The version of the OpenAPI document: 4.148.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from kdp_api.models.application_required_dataset_access_inner import ApplicationRequiredDatasetAccessInner
from typing import Optional, Set
from typing_extensions import Self

class Application(BaseModel):
    """
    Application
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="ID of the Application")
    name: StrictStr = Field(description="name of the Application")
    url: StrictStr
    redirect_url: StrictStr = Field(description="url for redirect", alias="redirectUrl")
    workspace_id: StrictStr = Field(description="ID of the KDP workspace", alias="workspaceId")
    client_id: Optional[StrictStr] = Field(default=None, description="ID of the client", alias="clientId")
    client_secret: Optional[StrictStr] = Field(default=None, description="secret of the Client", alias="clientSecret")
    visible: Optional[StrictBool] = Field(default=None, description="visible flag")
    description: Optional[StrictStr] = Field(default=None, description="application description")
    type: Optional[StrictStr] = Field(default=None, description="type of application")
    allowed_users: Optional[List[StrictStr]] = Field(default=None, description="array of ID's of allowed users of the application", alias="allowedUsers")
    required_dataset_access: Optional[List[ApplicationRequiredDatasetAccessInner]] = Field(default=None, description="required dataset access", alias="requiredDatasetAccess")
    __properties: ClassVar[List[str]] = ["id", "name", "url", "redirectUrl", "workspaceId", "clientId", "clientSecret", "visible", "description", "type", "allowedUsers", "requiredDatasetAccess"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['mls', 'sls']):
            raise ValueError("must be one of enum values ('mls', 'sls')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Application from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in required_dataset_access (list)
        _items = []
        if self.required_dataset_access:
            for _item in self.required_dataset_access:
                if _item:
                    _items.append(_item.to_dict())
            _dict['requiredDatasetAccess'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Application from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "url": obj.get("url"),
            "redirectUrl": obj.get("redirectUrl"),
            "workspaceId": obj.get("workspaceId"),
            "clientId": obj.get("clientId"),
            "clientSecret": obj.get("clientSecret"),
            "visible": obj.get("visible"),
            "description": obj.get("description"),
            "type": obj.get("type"),
            "allowedUsers": obj.get("allowedUsers"),
            "requiredDatasetAccess": [ApplicationRequiredDatasetAccessInner.from_dict(_item) for _item in obj["requiredDatasetAccess"]] if obj.get("requiredDatasetAccess") is not None else None
        })
        return _obj


