# coding: utf-8

"""
    Koverse Data Platform (KDP) API

    The KDP API is a REST API that can be used to create, access, and update data in KDP Workspaces. Please note that the Python client library follows Python's naming convention of snake casing for fields, even though they may appear in camel case in the API specification. <p><b>By default this api documentation targets the koverse production server at 'api.app.koverse.com' You can provide the hostname of your koverse instance to this documentation page via the 'host' query param.</p> <p><b>For example providing host - https://koverse-docs.saic.com/api?host=api.myHost.com, will update requests to target the provided host.</b></p> <p><b>Authentication request example with provided host - https://api.myHost.com/authentication</b></p>

    The version of the OpenAPI document: 4.151.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from kdp_api.models.query_datasets_summary_datasets_inner import QueryDatasetsSummaryDatasetsInner
from typing import Optional, Set
from typing_extensions import Self

class QueryDatasetsSummary(BaseModel):
    """
    A summary of datasets that contain matching records
    """ # noqa: E501
    datasets: Optional[List[QueryDatasetsSummaryDatasetsInner]] = Field(default=None, description="A list of datasets that contain matching records, sorted by the number of matches.")
    total_records: Optional[StrictInt] = Field(default=None, description="The number of records across all datasets that match the search term.", alias="totalRecords")
    total_datasets: Optional[StrictInt] = Field(default=None, description="The total count of all datasets that contain matching records, includes datasets even if they are not in the current result", alias="totalDatasets")
    search_id: Optional[StrictStr] = Field(default=None, description="The uuid asscoiated with this search request, used for paging through results.", alias="searchId")
    __properties: ClassVar[List[str]] = ["datasets", "totalRecords", "totalDatasets", "searchId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of QueryDatasetsSummary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in datasets (list)
        _items = []
        if self.datasets:
            for _item in self.datasets:
                if _item:
                    _items.append(_item.to_dict())
            _dict['datasets'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of QueryDatasetsSummary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "datasets": [QueryDatasetsSummaryDatasetsInner.from_dict(_item) for _item in obj["datasets"]] if obj.get("datasets") is not None else None,
            "totalRecords": obj.get("totalRecords"),
            "totalDatasets": obj.get("totalDatasets"),
            "searchId": obj.get("searchId")
        })
        return _obj


