# coding: utf-8

# flake8: noqa

"""
    Koverse Data Platform (KDP) API

    The KDP API is a REST API that can be used to create, access, and update data in KDP Workspaces. Please note that the Python client library follows Python's naming convention of snake casing for fields, even though they may appear in camel case in the API specification. <p><b>By default this api documentation targets the koverse production server at 'api.app.koverse.com' You can provide the hostname of your koverse instance to this documentation page via the 'host' query param.</p> <p><b>For example providing host - https://koverse-docs.saic.com/api?host=api.myHost.com, will update requests to target the provided host.</b></p> <p><b>Authentication request example with provided host - https://api.myHost.com/authentication</b></p>

    The version of the OpenAPI document: 4.158.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


__version__ = "4.158.0"

# import apis into sdk package
from kdp_api.api.applications_api import ApplicationsApi
from kdp_api.api.attribute_based_access_control_api import AttributeBasedAccessControlApi
from kdp_api.api.authenticate_api import AuthenticateApi
from kdp_api.api.dataset_pairing_api import DatasetPairingApi
from kdp_api.api.dataset_permissions_api import DatasetPermissionsApi
from kdp_api.api.datasets_api import DatasetsApi
from kdp_api.api.indexing_api import IndexingApi
from kdp_api.api.manage_records_api import ManageRecordsApi
from kdp_api.api.read_and_query_api import ReadAndQueryApi
from kdp_api.api.users_and_groups_api import UsersAndGroupsApi
from kdp_api.api.workspaces_api import WorkspacesApi
from kdp_api.api.write_api import WriteApi

# import ApiClient
from kdp_api.api_response import ApiResponse
from kdp_api.api_client import ApiClient
from kdp_api.configuration import Configuration
from kdp_api.exceptions import OpenApiException
from kdp_api.exceptions import ApiTypeError
from kdp_api.exceptions import ApiValueError
from kdp_api.exceptions import ApiKeyError
from kdp_api.exceptions import ApiAttributeError
from kdp_api.exceptions import ApiException

# import models into sdk package
from kdp_api.models.api_key import APIKey
from kdp_api.models.api_key_paginator import APIKeyPaginator
from kdp_api.models.api_key_patch_request import APIKeyPatchRequest
from kdp_api.models.api_key_response import APIKeyResponse
from kdp_api.models.api_key_update_request import APIKeyUpdateRequest
from kdp_api.models.abac_label_parser_paginator import AbacLabelParserPaginator
from kdp_api.models.abac_label_parsers import AbacLabelParsers
from kdp_api.models.access_control_label import AccessControlLabel
from kdp_api.models.api_error import ApiError
from kdp_api.models.api_key_create_request import ApiKeyCreateRequest
from kdp_api.models.application import Application
from kdp_api.models.application_create_request import ApplicationCreateRequest
from kdp_api.models.application_create_request_required_dataset_access_inner import ApplicationCreateRequestRequiredDatasetAccessInner
from kdp_api.models.application_paginator import ApplicationPaginator
from kdp_api.models.application_patch_request import ApplicationPatchRequest
from kdp_api.models.application_required_dataset_access_inner import ApplicationRequiredDatasetAccessInner
from kdp_api.models.application_update_request import ApplicationUpdateRequest
from kdp_api.models.attribute import Attribute
from kdp_api.models.attribute_assignment import AttributeAssignment
from kdp_api.models.attribute_assignment_create_request import AttributeAssignmentCreateRequest
from kdp_api.models.attribute_assignment_paginator import AttributeAssignmentPaginator
from kdp_api.models.attribute_assignment_patch_request import AttributeAssignmentPatchRequest
from kdp_api.models.attribute_assignment_update_request import AttributeAssignmentUpdateRequest
from kdp_api.models.attribute_create_request import AttributeCreateRequest
from kdp_api.models.attribute_paginator import AttributePaginator
from kdp_api.models.attribute_patch_request import AttributePatchRequest
from kdp_api.models.attribute_update_request import AttributeUpdateRequest
from kdp_api.models.audit_log_configuration import AuditLogConfiguration
from kdp_api.models.audit_log_configuration_paginator import AuditLogConfigurationPaginator
from kdp_api.models.audit_log_event import AuditLogEvent
from kdp_api.models.audit_log_paginator import AuditLogPaginator
from kdp_api.models.authentication import Authentication
from kdp_api.models.authentication_api_key import AuthenticationAPIKey
from kdp_api.models.authentication_details import AuthenticationDetails
from kdp_api.models.authentication_details_authentication import AuthenticationDetailsAuthentication
from kdp_api.models.authentication_details_authentication_payload import AuthenticationDetailsAuthenticationPayload
from kdp_api.models.authentication_details_user import AuthenticationDetailsUser
from kdp_api.models.authentication_sso import AuthenticationSSO
from kdp_api.models.batch_write_request import BatchWriteRequest
from kdp_api.models.connection_info import ConnectionInfo
from kdp_api.models.custom_identity_provider import CustomIdentityProvider
from kdp_api.models.data_source_params import DataSourceParams
from kdp_api.models.dataset import Dataset
from kdp_api.models.dataset_create_request import DatasetCreateRequest
from kdp_api.models.dataset_current_user_permissions import DatasetCurrentUserPermissions
from kdp_api.models.dataset_paginator import DatasetPaginator
from kdp_api.models.dataset_patch_request import DatasetPatchRequest
from kdp_api.models.dataset_permission import DatasetPermission
from kdp_api.models.dataset_permission_create_request import DatasetPermissionCreateRequest
from kdp_api.models.dataset_permission_paginator import DatasetPermissionPaginator
from kdp_api.models.dataset_permission_patch_request import DatasetPermissionPatchRequest
from kdp_api.models.dataset_permission_update_request import DatasetPermissionUpdateRequest
from kdp_api.models.dataset_sync import DatasetSync
from kdp_api.models.dataset_sync_management_terminate_connection_request import DatasetSyncManagementTerminateConnectionRequest
from kdp_api.models.dataset_sync_paginator import DatasetSyncPaginator
from kdp_api.models.dataset_sync_patch_request import DatasetSyncPatchRequest
from kdp_api.models.dataset_sync_update_request import DatasetSyncUpdateRequest
from kdp_api.models.dataset_update_request import DatasetUpdateRequest
from kdp_api.models.delete_document_by_query_request import DeleteDocumentByQueryRequest
from kdp_api.models.delete_record_by_id_request import DeleteRecordByIdRequest
from kdp_api.models.delete_record_by_query_request import DeleteRecordByQueryRequest
from kdp_api.models.error_code import ErrorCode
from kdp_api.models.get_serve_media200_response import GetServeMedia200Response
from kdp_api.models.group import Group
from kdp_api.models.group_create_request import GroupCreateRequest
from kdp_api.models.group_membership import GroupMembership
from kdp_api.models.group_membership_create_request import GroupMembershipCreateRequest
from kdp_api.models.group_membership_paginator import GroupMembershipPaginator
from kdp_api.models.group_membership_patch_request import GroupMembershipPatchRequest
from kdp_api.models.group_membership_update_request import GroupMembershipUpdateRequest
from kdp_api.models.group_paginator import GroupPaginator
from kdp_api.models.group_patch_request import GroupPatchRequest
from kdp_api.models.group_update_request import GroupUpdateRequest
from kdp_api.models.index import Index
from kdp_api.models.index_paginator import IndexPaginator
from kdp_api.models.ingest_create_request import IngestCreateRequest
from kdp_api.models.job import Job
from kdp_api.models.job_paginator import JobPaginator
from kdp_api.models.keycloak_provider_configuration import KeycloakProviderConfiguration
from kdp_api.models.koverse_document_metadata import KoverseDocumentMetadata
from kdp_api.models.lucene_query_request import LuceneQueryRequest
from kdp_api.models.origin_dataset_sync_create_request import OriginDatasetSyncCreateRequest
from kdp_api.models.query import Query
from kdp_api.models.query_datasets_summary import QueryDatasetsSummary
from kdp_api.models.query_datasets_summary_datasets_inner import QueryDatasetsSummaryDatasetsInner
from kdp_api.models.query_datasets_summary_request import QueryDatasetsSummaryRequest
from kdp_api.models.query_document_lucene_request import QueryDocumentLuceneRequest
from kdp_api.models.query_document_lucene_response import QueryDocumentLuceneResponse
from kdp_api.models.query_document_lucene_response_records_inner import QueryDocumentLuceneResponseRecordsInner
from kdp_api.models.read_range_request import ReadRangeRequest
from kdp_api.models.record_batch import RecordBatch
from kdp_api.models.reindex_request import ReindexRequest
from kdp_api.models.replica_dataset_sync_create_request import ReplicaDatasetSyncCreateRequest
from kdp_api.models.schema_field import SchemaField
from kdp_api.models.schema_field_security_label import SchemaFieldSecurityLabel
from kdp_api.models.security_label_info_params import SecurityLabelInfoParams
from kdp_api.models.segment import Segment
from kdp_api.models.segment_paginator import SegmentPaginator
from kdp_api.models.sequence_read_request import SequenceReadRequest
from kdp_api.models.source_types import SourceTypes
from kdp_api.models.split_points import SplitPoints
from kdp_api.models.stripe_latest_charge import StripeLatestCharge
from kdp_api.models.stripe_latest_charge1 import StripeLatestCharge1
from kdp_api.models.sync_kafka_consumer_group_id import SyncKafkaConsumerGroupId
from kdp_api.models.sync_setup_origin import SyncSetupOrigin
from kdp_api.models.sync_setup_replica import SyncSetupReplica
from kdp_api.models.terminate_connection_response import TerminateConnectionResponse
from kdp_api.models.transfer_resource_request import TransferResourceRequest
from kdp_api.models.upload_access_control_label import UploadAccessControlLabel
from kdp_api.models.upload_response import UploadResponse
from kdp_api.models.user import User
from kdp_api.models.user_create_request import UserCreateRequest
from kdp_api.models.user_paginator import UserPaginator
from kdp_api.models.user_patch_request import UserPatchRequest
from kdp_api.models.user_update_request import UserUpdateRequest
from kdp_api.models.workspace import Workspace
from kdp_api.models.workspace_create_request import WorkspaceCreateRequest
from kdp_api.models.workspace_create_request_subscription import WorkspaceCreateRequestSubscription
from kdp_api.models.workspace_create_request_subscription_subscription_item_ids import WorkspaceCreateRequestSubscriptionSubscriptionItemIds
from kdp_api.models.workspace_paginator import WorkspacePaginator
from kdp_api.models.workspace_patch_request import WorkspacePatchRequest
from kdp_api.models.workspace_subscription import WorkspaceSubscription
from kdp_api.models.workspace_subscription_subscription_item_ids import WorkspaceSubscriptionSubscriptionItemIds
from kdp_api.models.workspace_update_request import WorkspaceUpdateRequest
from kdp_api.models.write_batch_response import WriteBatchResponse
