# coding: utf-8

"""
    Koverse Data Platform (KDP) API

    The KDP API is a REST API that can be used to create, access, and update data in KDP Workspaces. Please note that the Python client library follows Python's naming convention of snake casing for fields, even though they may appear in camel case in the API specification. <p><b>By default this api documentation targets the koverse production server at 'api.app.koverse.com' You can provide the hostname of your koverse instance to this documentation page via the 'host' query param.</p> <p><b>For example providing host - https://koverse-docs.saic.com/api?host=api.myHost.com, will update requests to target the provided host.</b></p> <p><b>Authentication request example with provided host - https://api.myHost.com/authentication</b></p>

    The version of the OpenAPI document: 4.166.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SecurityLabelInfoParams(BaseModel):
    """
    Contains the configuration parameters for the security label parser
    """ # noqa: E501
    fields: Optional[List[StrictStr]] = Field(default=None, description="array of label fields")
    label: Optional[StrictStr] = Field(default=None, description="the label to apply to all records")
    label_handling_policy: Optional[StrictStr] = Field(default='replace', description="how to handle label if value is missing.", alias="labelHandlingPolicy")
    parser_class_name: StrictStr = Field(description="Parser name. Please note 'simple-parser' has been deprecated. Use 'identity-parser' instead.", alias="parserClassName")
    replacement_string: Optional[StrictStr] = Field(default=None, description="the replacement string to use.", alias="replacementString")
    __properties: ClassVar[List[str]] = ["fields", "label", "labelHandlingPolicy", "parserClassName", "replacementString"]

    @field_validator('label_handling_policy')
    def label_handling_policy_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ignore', 'replace', 'drop']):
            raise ValueError("must be one of enum values ('ignore', 'replace', 'drop')")
        return value

    @field_validator('parser_class_name')
    def parser_class_name_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['simple-parser', 'identity-parser', 'capco-parser', 'apply-label-to-all-records-parser']):
            raise ValueError("must be one of enum values ('simple-parser', 'identity-parser', 'capco-parser', 'apply-label-to-all-records-parser')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SecurityLabelInfoParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SecurityLabelInfoParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fields": obj.get("fields"),
            "label": obj.get("label"),
            "labelHandlingPolicy": obj.get("labelHandlingPolicy") if obj.get("labelHandlingPolicy") is not None else 'replace',
            "parserClassName": obj.get("parserClassName"),
            "replacementString": obj.get("replacementString")
        })
        return _obj


