# coding: utf-8

"""
    Koverse Data Platform (KDP) API

    The KDP API is a REST API that can be used to create, access, and update data in KDP Workspaces. Please note that the Python client library follows Python's naming convention of snake casing for fields, even though they may appear in camel case in the API specification. <p><b>By default this api documentation targets the koverse production server at 'api.app.koverse.com' You can provide the hostname of your koverse instance to this documentation page via the 'host' query param.</p> <p><b>For example providing host - https://koverse-docs.saic.com/api?host=api.myHost.com, will update requests to target the provided host.</b></p> <p><b>Authentication request example with provided host - https://api.myHost.com/authentication</b></p>

    The version of the OpenAPI document: 4.175.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class ErrorCode(str, Enum):
    """
    Enum of error code responses
    """

    """
    allowed enum values
    """
    ACCUMULOERROR = 'AccumuloError'
    AUTHERROR = 'AuthError'
    BADREQUESTERROR = 'BadRequestError'
    DATASOURCEERROR = 'DatasourceError'
    FILEPARSEERROR = 'FileParseError'
    FORBIDDENERROR = 'ForbiddenError'
    HTTPCLIENTERROR = 'HttpClientError'
    INTERNALSERVERERROR = 'InternalServerError'
    LUCENEPARSEERROR = 'LuceneParseError'
    MISSINGINDEXERROR = 'MissingIndexError'
    NOTFOUNDERROR = 'NotFoundError'
    NOTIMPLEMENTEDERROR = 'NotImplementedError'
    RESTCLIENTERROR = 'RestClientError'
    SECURITYERROR = 'SecurityError'
    SQLPARSEERROR = 'SqlParseError'
    TABLENOTFOUNDERROR = 'TableNotFoundError'
    QUERYERROR = 'QueryError'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of ErrorCode from a JSON string"""
        return cls(json.loads(json_str))


