"""
    Koverse Data Platform (KDP) API

    The KDP API is a REST API that can be used to create, access, and update data in KDP Workspaces. Please note that the Python client library follows Python's naming convention of snake casing for fields, even though they may appear in camel case in the API specification. <p><b>By default this api documentation targets the koverse production server at 'api.app.koverse.com' You can provide the hostname of your koverse instance to this documentation page via the 'host' query param.</p> <p><b>For example providing host - https://documentation.koverse.com/api?host=api.myHost.com, will update requests to target the provided host.</b></p> <p><b>Authentication request example with provided host - https://api.myHost.com/authentication</b></p>  # noqa: E501

    The version of the OpenAPI document: 4.87.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from kdp_api.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from kdp_api.exceptions import ApiAttributeError



class DatasetSyncPatchRequest(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('status',): {
            'PENDING': "pending",
            'ACTIVE': "active",
            'CANCELED': "canceled",
        },
        ('type',): {
            'READ': "read",
            'WRITE': "write",
            'MANAGE': "manage",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'id': (str,),  # noqa: E501
            'dataset_id': (str,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'type': (str,),  # noqa: E501
            'key': (str,),  # noqa: E501
            'created_by_user_id': (str,),  # noqa: E501
            'is_origin_workspace': (bool,),  # noqa: E501
            'host': (str,),  # noqa: E501
            'workspace_id': (str,),  # noqa: E501
            'workspace_unique_id': (str,),  # noqa: E501
            'sync_id': (str,),  # noqa: E501
            'sync_host': (str,),  # noqa: E501
            'sync_dataset_id': (str,),  # noqa: E501
            'sync_workspace_id': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'sync_workspace_unique_id': (str,),  # noqa: E501
            'last_sync_at': (datetime,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'dataset_id': 'datasetId',  # noqa: E501
        'status': 'status',  # noqa: E501
        'type': 'type',  # noqa: E501
        'key': 'key',  # noqa: E501
        'created_by_user_id': 'createdByUserId',  # noqa: E501
        'is_origin_workspace': 'isOriginWorkspace',  # noqa: E501
        'host': 'host',  # noqa: E501
        'workspace_id': 'workspaceId',  # noqa: E501
        'workspace_unique_id': 'workspaceUniqueId',  # noqa: E501
        'sync_id': 'syncId',  # noqa: E501
        'sync_host': 'syncHost',  # noqa: E501
        'sync_dataset_id': 'syncDatasetId',  # noqa: E501
        'sync_workspace_id': 'syncWorkspaceId',  # noqa: E501
        'sync_workspace_unique_id': 'syncWorkspaceUniqueId',  # noqa: E501
        'last_sync_at': 'lastSyncAt',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """DatasetSyncPatchRequest - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): dataset sync ID. [optional]  # noqa: E501
            dataset_id (str): dataset ID. [optional]  # noqa: E501
            status (str): Status of the dataset sync.<br>Pending, active, or canceled.. [optional]  # noqa: E501
            type (str): Type of the Dataset Sync<br><br>read - the paired replica dataset can only read records from the origin dataset <br><br>write - the paired replica dataset can only write records to the origin dataset <br><br>manage - the paired replica dataset can read records from the origin dataset, <br>write records to the origin dataset, and delete records from the origin dataset. [optional]  # noqa: E501
            key (str): Security key used for the dataset sync. [optional]  # noqa: E501
            created_by_user_id (str): ID of User that created the dataset sync. [optional]  # noqa: E501
            is_origin_workspace (bool): Indicates if dataset for sync originates in this workspace. [optional]  # noqa: E501
            host (str): Our Host name. [optional]  # noqa: E501
            workspace_id (str): Our workspace ID. [optional]  # noqa: E501
            workspace_unique_id (str): Our workspace uniqueId. [optional]  # noqa: E501
            sync_id (str): The ID of the dataset-sync in paired Sync Workspace  *For a paired replica, this is the Origin Dataset Sync ID*  *For the origin sync, this is the Paired Replica Dataset Sync ID* . [optional]  # noqa: E501
            sync_host (str): The Host Name of the paired Sync Workspace. [optional]  # noqa: E501
            sync_dataset_id (str): The ID of the dataset in paired Sync Workspace. [optional]  # noqa: E501
            sync_workspace_id (bool, date, datetime, dict, float, int, list, str, none_type): The ID of the paired Sync Workspace. [optional]  # noqa: E501
            sync_workspace_unique_id (str): UniqueId of the paired Sync Workspace. [optional]  # noqa: E501
            last_sync_at (datetime): Last Sync At - Time of last successful Sync. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """DatasetSyncPatchRequest - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): dataset sync ID. [optional]  # noqa: E501
            dataset_id (str): dataset ID. [optional]  # noqa: E501
            status (str): Status of the dataset sync.<br>Pending, active, or canceled.. [optional]  # noqa: E501
            type (str): Type of the Dataset Sync<br><br>read - the paired replica dataset can only read records from the origin dataset <br><br>write - the paired replica dataset can only write records to the origin dataset <br><br>manage - the paired replica dataset can read records from the origin dataset, <br>write records to the origin dataset, and delete records from the origin dataset. [optional]  # noqa: E501
            key (str): Security key used for the dataset sync. [optional]  # noqa: E501
            created_by_user_id (str): ID of User that created the dataset sync. [optional]  # noqa: E501
            is_origin_workspace (bool): Indicates if dataset for sync originates in this workspace. [optional]  # noqa: E501
            host (str): Our Host name. [optional]  # noqa: E501
            workspace_id (str): Our workspace ID. [optional]  # noqa: E501
            workspace_unique_id (str): Our workspace uniqueId. [optional]  # noqa: E501
            sync_id (str): The ID of the dataset-sync in paired Sync Workspace  *For a paired replica, this is the Origin Dataset Sync ID*  *For the origin sync, this is the Paired Replica Dataset Sync ID* . [optional]  # noqa: E501
            sync_host (str): The Host Name of the paired Sync Workspace. [optional]  # noqa: E501
            sync_dataset_id (str): The ID of the dataset in paired Sync Workspace. [optional]  # noqa: E501
            sync_workspace_id (bool, date, datetime, dict, float, int, list, str, none_type): The ID of the paired Sync Workspace. [optional]  # noqa: E501
            sync_workspace_unique_id (str): UniqueId of the paired Sync Workspace. [optional]  # noqa: E501
            last_sync_at (datetime): Last Sync At - Time of last successful Sync. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
