Hier ist dein Konzept – **unverändert in Struktur & Inhalt**, aber mit dem Bibliotheksnamen **`keep_github_workflows_active`** durchgängig aktualisiert.

---

# IDEE

ich möchte eine Logging Biliothek erzeugen

* diese soll farbige Logs ausgeben
* das format der Logzeile soll einstellbar sein
* das Logging soll auf Linux und Windows funktionieren

  * Windows : **Windows Event Log**
  * Linux : journal
  * **optional/alternativ: Graylog (GELF, bevorzugt TCP+TLS)**
  * kein Logging in Textfiles, es soll thread-safe sein und Subprozesse unterstützen
* es soll einen Loglevel unterstützen
* bei Fehlern soll es möglich sein das gesamte Log als Textfile zu erhalten
* um die Logs auszuweten sollen im syslog/journal entsprechenden Felder vorhanden sein (Vorschläge ?)
* der Loglevel für die Konsole und für syslog/journal kann unterschiedlich sein
* im syslog/journal/GELF werden **keine** Farben/Unicode-Icons verwendet (nur Konsole & Ringpuffer/HTML)
* die Binliothek soll in Python leicht importierbar sein, und ein minimales Interface und methoden haben
* wie handelt man das in Subprozessen ?

strukturiere diesen Fragenkatalog und füge hinzu was vielleicht noch fehlt.

---

## A) Ziele & Scope

1. **Primärziele**

* [ ] Farbiges, gut lesbares Console-Logging
* [ ] Konfigurierbares Zeilenformat (Konsole)
* [ ] Backend-Logging: **Linux → journald**, **Windows → Windows Event Log**
* [ ] **Optional/alternativ:** Versand an **Graylog (GELF, TCP+TLS)**
* [ ] **Kein** File-Logging im Dauerbetrieb
* [ ] Thread-safe und **multiprozessfähig**
* [ ] Loglevel steuerbar (Konsole ≠ Backend möglich)
* [ ] Bei Fehlern: **Export des gesamten Logs** als Text/JSON/**HTML** (on-demand)
* [ ] Strukturierte Felder in journald/Windows Event Log/**GELF** für Auswertung

2. **Nichtziele / Klarstellungen**

* [ ] Keine dauerhaften Rotations-Files
* [ ] Keine Farben/Icons im Backend (nur Konsole & HTML-Dump)
* [ ] Kein vendor-lock-in; minimalistische Abhängigkeiten

---

## B) Ausgabekanäle & Plattformdetails

1. **Konsole**

* [ ] Farben ja/nein pro Umgebung (TTY-Erkennung, `force_color`, `no_color`)
* [ ] Unicode-Icons nur in der Konsole (optional)
* [ ] Bei `isatty == False`: keine Farben/Icons, optional JSON
* [ ] **Bibliothek:** **Rich** als optionales Extra für Konsole & HTML-Export

2. **Linux Backend (journald)**

* [ ] `systemd.journal.JournalHandler`
* [ ] Strukturierte Felder (nur **UPPERCASE** ASCII Keys)

3. **Windows Backend (Windows Event Log)**

* [ ] `pywin32` / `win32evtlogutil`-basierter Handler
* [ ] **Log:** `Application` (Default) / Custom möglich
* [ ] **Provider:** Default = `service`-Name
* [ ] **EventID-Map:** INFO=1000, WARNING=2000, ERROR=3000, CRITICAL=4000 (overridebar)
* [ ] Fallback: bei Fehlern nur Konsole + lokales Gegenstück weiter

4. **Zentrales Backend (Graylog via GELF) — optional**

* [ ] **Transport:** Default **TCP + TLS**, alternativ UDP/HTTP
* [ ] Zusatzfelder mit `_`-Prefix, Stacktraces in `full_message`
* [ ] Fallback: Backoff & Retry; bei dauerhaften Fehlern droppen (Konsole+lokal laufen weiter)

**Empfehlung (Default):**

* Linux: `JournalHandler`. Windows: `WindowsEventLogHandler`.
* Optional parallel: `GELFHandler` (Graylog).

---

## C) Formatierung (Konsole) & Farben

1. **Format-Konfiguration**

* Default: `{ts} {level:>5} {name} {pid}:{tid} — {message} {context}`
* Timestamp: ISO-8601 `%Y-%m-%dT%H:%M:%S.%f%z`
* Exceptions: mehrzeilig (Trace separat angehängt)

2. **Farben / Rich-Integration**

* **Konsole:** `RichHandler` (optional), Theme konfigurierbar; TTY-Auto-Erkennung
* **Backends:** Plain-Formatter (keine ANSI/Icons)
* **Ringpuffer/HTML:** Rich-basierter Render (siehe G)
* Optionen: `colors=True|False|auto`, `markup_console=True|False`, `force_color=None|True|False`

---

## D) Loglevel-Strategie & Filter

* Unterschiedliche Loglevel pro Handler
* Mapping Python → journald/Windows/GELF:

  * CRITICAL→2, ERROR→3, WARNING→4, INFO→6, DEBUG→7 (intern)
  * Windows-Severity passend zuordnen
  * GELF `level` numerisch gemäß Mapping
* **Defaults:**

  * **Konsole:** `INFO`
  * **Lokale Backends (journald/Event Log):** `INFO`
  * **GELF:** `INFO`
* **Ratenbegrenzung:** `RateLimitingFilter` aktiv (z. B. 100 Msg / 5 s pro Logger+Level)
* **Sampling:** aus (optional aktivierbar)

---

## E) Strukturierte Felder für Auswertung

1. **journald (nur UPPERCASE) – Set**
   `PRIORITY`, `MESSAGE`, `SYSLOG_IDENTIFIER`, `PID`, `THREAD_ID`, `CODE_FILE`, `CODE_LINE`, `CODE_FUNC`,
   `LOGGER`, `TRACE_ID`, `SPAN_ID`, `CORRELATION_ID`, `REQUEST_ID`, `USER_ID`, `TENANT`, `ENV`,
   `SERVICE`, `VERSION`, `COMPONENT`, `SUBSYSTEM`, `OPERATION`, `HTTP_METHOD`, `HTTP_TARGET`,
   `HTTP_STATUS`, `DURATION_MS`, `BYTES_SENT`, `ERROR_CODE`, `EXCEPTION_TYPE`, `EXCEPTION_MESSAGE`

2. **Windows Event Log – Set**
   Provider=Service; **EventData**-Paare:
   `trace_id`, `span_id`, `correlation_id`, `request_id`, `env`, `service`, `version`, `component`,
   `subsystem`, `operation`, `user_id`, `tenant`, `http_method`, `http_target`, `http_status`,
   `duration_ms`, `bytes_sent`, `error_code`, `exception_type`, `exception_message`

3. **GELF / Graylog – Set**
   Pflichtfelder (`short_message`, `timestamp`, `level`, `host`), Zusatzfelder (`_`-Prefix):
   `_service`, `_env`, `_version`, `_component`, `_subsystem`, `_operation`, `_trace_id`, `_span_id`,
   `_correlation_id`, `_request_id`, `_user_id`, `_tenant`, `_http_method`, `_http_target`,
   `_http_status`, `_duration_ms`, `_bytes_sent`, `_error_code`, `_exception_type`, `_exception_message`,
   `_truncated` (bool), `_original_size` (int)

---

## F) Multiprocessing & Thread-Safety

* Python-`logging` ist thread-safe
* **Architektur:** **Option A** – `QueueHandler` in allen Prozessen → zentraler `QueueListener`
* Listener schreibt zu: **Konsole + journald/Event Log + optional GELF**
* Vorteile: ein Socket/Handle pro Backend, gemeinsamer Ringpuffer, einheitliche Formatierung

---

## G) Fehlerstrategie & „Dump als Textfile/HTML“

* **Ringpuffer:** Default **25.000** Einträge (konfigurierbar); speichert je Event:

  * `raw` (strukturiert, ohne ANSI: ts, level, name, msg, extra, exc\_info, …)
  * **farbige Darstellung** für Konsole/Export (Rich-Segmente; alternativ ANSI konfigurierbar)
* **Dump-API:** `keep_github_workflows_active.dump(format="text"|"json"|"html", path=None)`

  * `text`: reiner Plain-Text (ohne ANSI)
  * `json`: Liste `raw`-Events (maschinenlesbar)
  * **`html`: mit Rich gerenderter Export (Inline-CSS, Theme „dark“/„light“) – ideal für E-Mail**
* **Trigger:** erstes `CRITICAL`, unhandled exception, Signal (konfigurierbar)
* **Größenlimits:** pro Event **16 KB**; Trunkierung mit Hinweis (`_truncated`, `_original_size`)
* **Queue voll:** älteste Einträge verdrängen; periodische Warnung (rate-limited)

---

## H) API-Design (minimales, leicht importierbares Interface)

**Modulname:** `keep_github_workflows_active`

```python
import keep_github_workflows_active as log

log.init(
    service="meinservice",
    env="prod",
    backend="auto",                 # "journald" (Linux), "eventlog" (Windows), "none"
    # Windows
    eventlog_log="Application",
    eventlog_provider=None,
    eventlog_event_ids=None,        # { "INFO":1000, "WARNING":2000, ... } default s.o.
    # Graylog (optional)
    gelf_enabled=False,
    gelf_host="graylog.example",
    gelf_port=12201,
    gelf_proto="tcp",               # "udp" | "tcp" | "http"
    gelf_tls=True,
    gelf_level="INFO",
    gelf_compress=True,             # falls unterstützt
    # Konsole / Rich
    colors=True,
    markup_console=False,           # Rich-Markup in messages erlauben?
    force_color=None,               # None=auto, True/False erzwingen
    console_level="INFO",
    backend_level="INFO",           # Default für journald/Event Log
    console_format="{ts} {level:>5} {name} {pid}:{tid} — {message} {context}",
    # Ringpuffer & Dumps
    ring_size=25000,
    ring_store_colored="segments",  # "segments" | "ansi" | "none"
    max_event_size=16384,
    rate_limit="100/5s",
    html_theme="dark",              # "dark" | "light" | "custom"
    html_inline_css=True,           # Inline-CSS für Mail-Clients
)

logger = log.get("app.http")

with log.bind(request_id="abc123", user_id="42"):
    logger.info("Login ok")
    logger.error("Fehlgeschlagen", extra={"error_code": "AUTH_401"})

# Dumps (für E-Mail):
path_html = log.dump(format="html")
```

**Methoden:**
`init`, `get`, `bind` / `unbind` / `context`, `set_levels(console=None, backend=None, gelf=None)`, `dump(path=None, format="text")`, `shutdown()`

---

## I) Konfiguration

* **API + ENV** (YAML optional)
* Wichtige ENV-Beispiele:
  `LOG_LEVEL`, `LOG_BACKEND`, `LOG_EVENTLOG_LOG`, `LOG_EVENTLOG_PROVIDER`,
  `LOG_GELF_ENABLED`, `LOG_GELF_HOST`, `LOG_GELF_PORT`, `LOG_GELF_PROTO`, `LOG_GELF_TLS`,
  `LOG_RING_SIZE`, `LOG_MAX_EVENT_SIZE`, **`LOG_DUMP_FORMAT`** (z. B. `html`)

---

## J) Performance

* Asynchron via `QueueHandler`
* Lazy-Formatting (`logger.info("x %s", y)`)
* Rate-Limit aktiv, Sampling aus
* GELF: TCP+TLS (Default), Backoff/Retry
* **Ringpuffer mit Rich-Segmenten:** geringer Mehrverbrauch; HTML-Dump rendert gesammelt (einmalig)

---

## K) Sicherheit & Compliance

* Secret-Scrubber **aktiv** (konfigurierbare Regex-Liste; Standard: JWT, `password=`, `Authorization: Bearer`, Kreditkartenmuster)
* PII nur opt-in Felder (z. B. `USER_ID`)
* UTF-8 überall; **keine Farben/Icons** in Backends (nur Konsole/HTML-Dump)
* **GELF-TLS** aktivierbar (Default True), alternativ TLS via Ingress
* **E-Mails enthalten nur HTML-Dump oder Grafana-Links**; keine externen Ressourcen (Inline-CSS)

---

## L) Tests & DX

* `pytest` + `caplog`
* Integration: journald (Linux CI), Windows Event Log (Windows CI), **GELF** (UDP/TCP/HTTP Dummy)
* **HTML-Dump-Test** (Validierung, Sanity-Check auf Secrets nach Scrubber)
* Typisierungen, Docstrings, Beispiele

---

## M) Abhängigkeiten (schlank)

* Basis: Stdlib
* journald: `systemd-python` (extra `journald`)
* Event Log: `pywin32` (extra `eventlog`)
* GELF: `graypy` (extra `gelf`)
* **Konsole/HTML:** `rich` (extra `rich`), Windows-ANSI: `colorama`
* Optional: `rich.traceback` aktivierbar

> **Installationsvorschläge:**
>
> * Minimal: `pip install keep_github_workflows_active`
> * Mit Rich: `pip install keep_github_workflows_active[rich]`
> * Mit Graylog: `pip install keep_github_workflows_active[gelf]`
> * Komplett: `pip install keep_github_workflows_active[rich,gelf,journald,eventlog]`

---

## N) Diskussion: Farben & Unicode im Backend

* Konsole & HTML-Dump: Farben & (optional) Icons via **Rich**
* Backends (journald/Event Log/GELF): **keine** Farben/Icons; strukturierte Felder statt Optik

---

## O) Offene Entscheidungen (jetzt beantwortet)

* Ringpuffer: **25.000**, farbige Darstellung **aktiv** (`segments`)
* Windows: **EventID-Schema wie oben**, Provider=Service, Log=Application
* journald: Feld-Set wie E)
* **GELF:** **TCP+TLS** (Default), UDP/HTTP optional
* Konsole-Format: **einzeilig**, Exceptions **mehrzeilig**
* Sampling: **aus**, Rate-Limit **an**
* Fallback: **nicht blockieren**, Backoff+begrenzter Puffer, danach Drop (Warnung)
* **E-Mail-Flow:** entweder **HTML-Dump** anhängen **oder** **Grafana-Permalinks** (mit Variablen `service`, `env`, `trace_id`, Zeitraum 24 h)

---

## P) „Baseline“-Design (kompakt)

* **Pipeline:** `QueueHandler` (alle Prozesse) → `QueueListener` (Hauptprozess) →
  `ConsoleHandler` (Rich, farbig) + `JournaldHandler` (Linux) **oder** `WindowsEventLogHandler` (Windows) **+ optional `GELFHandler` (Graylog)**
* **Kontext:** `contextvars` + `LoggerAdapter`
* **Export:** Ringpuffer + `dump(format="text|json|html")`
* **Felder:** Einheitlich gepflegt, pro Backend gemappt
* **Grafana-Flow:** GELF → Graylog/ES → Grafana-Dashboards; E-Mail mit HTML-Dump **oder** Permalink

---

Wenn du willst, liefere ich dir als Nächstes ein kleines **Starter-Skeleton** für `keep_github_workflows_active` (Package-Layout, Handler-Stubs, Rich-Theme, HTML-Dump) – ready to run.
