# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2024-04-08T09:50:50+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import Field

from kelvin.api.client.data_model import DataModelBase


class Error(DataModelBase):
    """
    Error object.

    Parameters
    ----------
    name: Optional[str]
    title: Optional[str]
    description: Optional[str]
    solution: Optional[str]
    payload: Optional[List[Dict[str, Any]]]

    """

    name: Optional[str] = Field(None, description="ID of the error.", max_length=64, min_length=1)
    title: Optional[str] = Field(None, description="Title of the error.", max_length=64, min_length=1)
    description: Optional[str] = Field(None, description="A description of what the problem may be.")
    solution: Optional[str] = Field(None, description="A possible solution to the problem.")
    payload: Optional[List[Dict[str, Any]]] = Field(
        None,
        description="Optional additional information. For example an array of objects listing all the errors that triggered the 4XX response.",
    )


class Type(Enum):
    system = "system"


class ErrorLegacy(DataModelBase):
    """
    ErrorLegacy object.

    Parameters
    ----------
    description: Optional[str]
    name: Optional[str]
    payload: Optional[List[Dict[str, Any]]]
    solution: Optional[str]
    title: Optional[str]
    type: Optional[Type]

    """

    description: Optional[str] = Field(None, description="Description of what the error is about.")
    name: Optional[str] = Field(None, description="Unique identifier name of the error.", max_length=64, min_length=1)
    payload: Optional[List[Dict[str, Any]]] = Field(
        None,
        description="A dictionary of all the individual error names, error titles, descriptions and solutions within the submitted information.",
    )
    solution: Optional[str] = Field(None, description="Possible solutions to resolve the error.")
    title: Optional[str] = Field(
        None, description="The Display name (title) of the error.", max_length=64, min_length=1
    )
    type: Optional[Type] = Field(None, description="The type of error that has occured, e.g. `system`.")
