# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2024-11-08T15:36:33+00:00

from __future__ import annotations

from typing import Optional

from pydantic import Field, StrictInt, StrictStr

from kelvin.api.client.data_model import DataModelBase


class PaginationCursor(DataModelBase):
    """
    PaginationCursor object.

    Parameters
    ----------
    next_page: Optional[StrictStr]
    previous_page: Optional[StrictStr]

    """

    next_page: Optional[StrictStr] = Field(
        None,
        description="Bookmark location for `starting_after` parameter in future API requests.",
        example="W3siS2V5IjoicmVzb3VyY2UiLCJWYWx1ZSI6ImtybjphZDpkZW1vLWNlbnRyaWZ1Z2FsLXB1bXAtMS9odW1pZGl0eSJ9XQ==",
    )
    previous_page: Optional[StrictStr] = Field(
        None,
        description="Bookmark location for `ending_before` parameter in future API requests.",
        example="W3siS2V5IjoicmVzb3VyY2UiLCJWYWx1ZSI6ImtybjphZDpkZW1vLWNlbnRyaWZ1Z2FsLXB1bXAtMS9odW1pZGl0eSJ9XQ==",
    )


class PaginationLimits(DataModelBase):
    """
    PaginationLimits object.

    Parameters
    ----------
    page_size: Optional[StrictInt]
    page: Optional[StrictInt]
    total_pages: Optional[StrictInt]
    total_items: Optional[StrictInt]

    """

    page_size: Optional[StrictInt] = Field(None, description="Number of objects returned in current page.", example=20)
    page: Optional[StrictInt] = Field(None, description="Current page number of returned objects.", example=8)
    total_pages: Optional[StrictInt] = Field(
        None, description="Total pages available based on current request parameters.", example=39
    )
    total_items: Optional[StrictInt] = Field(
        None, description="Total number of objects based on current request parameters.", example=628
    )
