# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2024-06-20T10:18:51+00:00

from __future__ import annotations

from typing import Optional

from pydantic import Field

from kelvin.api.client.data_model import DataModelBase


class PaginationCursor(DataModelBase):
    """
    PaginationCursor object.

    Parameters
    ----------
    next_page: Optional[str]
    previous_page: Optional[str]

    """

    next_page: Optional[str] = Field(
        None,
        description="Bookmark location for `starting_after` parameter in future API requests.",
        example="W3siS2V5IjoicmVzb3VyY2UiLCJWYWx1ZSI6ImtybjphZDpkZW1vLWNlbnRyaWZ1Z2FsLXB1bXAtMS9odW1pZGl0eSJ9XQ==",
    )
    previous_page: Optional[str] = Field(
        None,
        description="Bookmark location for `ending_before` parameter in future API requests.",
        example="W3siS2V5IjoicmVzb3VyY2UiLCJWYWx1ZSI6ImtybjphZDpkZW1vLWNlbnRyaWZ1Z2FsLXB1bXAtMS9odW1pZGl0eSJ9XQ==",
    )


class PaginationLimits(DataModelBase):
    """
    PaginationLimits object.

    Parameters
    ----------
    page_size: Optional[int]
    page: Optional[int]
    total_pages: Optional[int]
    total_items: Optional[int]

    """

    page_size: Optional[int] = Field(None, description="Number of objects returned in current page.", example=20)
    page: Optional[int] = Field(None, description="Current page number of returned objects.", example=8)
    total_pages: Optional[int] = Field(
        None, description="Total pages available based on current request parameters.", example=39
    )
    total_items: Optional[int] = Field(
        None, description="Total number of objects based on current request parameters.", example=628
    )
