# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from ..core.serialization import FieldMetadata
from .invite_response_data import InviteResponseData
from .invite_response_kind import InviteResponseKind
from .invite_response_status import InviteResponseStatus


class InviteResponse(UniversalBaseModel):
    id: str
    kind: InviteResponseKind
    status: InviteResponseStatus
    data: typing.Optional[InviteResponseData] = None
    created_at: typing_extensions.Annotated[str, FieldMetadata(alias="createdAt")]
    updated_at: typing_extensions.Annotated[str, FieldMetadata(alias="updatedAt")]
    invite_id: typing_extensions.Annotated[str, FieldMetadata(alias="inviteId")]
    participant_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="participantId")] = None
    invite: typing.Optional["Invite"] = None
    participant: typing.Optional["Participant"] = None
    calls: typing.Optional[typing.List["Call"]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .call import Call  # noqa: E402, F401, I001
from .call_event import CallEvent  # noqa: E402, F401, I001
from .chat_message import ChatMessage  # noqa: E402, F401, I001
from .chat_session import ChatSession  # noqa: E402, F401, I001
from .conversation_message import ConversationMessage  # noqa: E402, F401, I001
from .conversation_message_topic import ConversationMessageTopic  # noqa: E402, F401, I001
from .file import File  # noqa: E402, F401, I001
from .invite import Invite  # noqa: E402, F401, I001
from .moderator import Moderator  # noqa: E402, F401, I001
from .org import Org  # noqa: E402, F401, I001
from .participant import Participant  # noqa: E402, F401, I001
from .participant_invite import ParticipantInvite  # noqa: E402, F401, I001
from .project import Project  # noqa: E402, F401, I001
from .project_file import ProjectFile  # noqa: E402, F401, I001
from .thread import Thread  # noqa: E402, F401, I001
from .thread_file import ThreadFile  # noqa: E402, F401, I001
from .user import User  # noqa: E402, F401, I001

update_forward_refs(InviteResponse)
