# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class ProjectParticipantMakeup(UniversalBaseModel):
    age_minimum: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="ageMinimum")] = (
        pydantic.Field(default=None)
    )
    """
    The minimum age of the participant
    """

    age_maximum: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="ageMaximum")] = (
        pydantic.Field(default=None)
    )
    """
    The maximum age of the participant
    """

    income_minimum: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="incomeMinimum")] = (
        pydantic.Field(default=None)
    )
    """
    The minimum income of the participant
    """

    income_maximum: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="incomeMaximum")] = (
        pydantic.Field(default=None)
    )
    """
    The maximum income of the participant
    """

    education_level: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="educationLevel")] = (
        pydantic.Field(default=None)
    )
    """
    The education level of the participant
    """

    gender: typing.Optional[str] = pydantic.Field(default=None)
    """
    The gender of the participant
    """

    country: typing.Optional[str] = pydantic.Field(default=None)
    """
    The country of the participant
    """

    region: typing.Optional[str] = pydantic.Field(default=None)
    """
    The region of the participant
    """

    occupation: typing.Optional[str] = pydantic.Field(default=None)
    """
    The occupation of the participant
    """

    ethnicity: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ethnicity of the participant
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
