# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import httpx
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .core.request_options import RequestOptions
from .environment import KeplarApiEnvironment
from .raw_client import AsyncRawKeplarApi, RawKeplarApi
from .types.call import Call
from .types.call_metadata import CallMetadata
from .types.code_invite import CodeInvite
from .types.code_invite_response import CodeInviteResponse
from .types.conversation_message import ConversationMessage
from .types.create_chat_session_response import CreateChatSessionResponse
from .types.delete_chat_session_response import DeleteChatSessionResponse
from .types.file import File
from .types.get_api_chats_response_item import GetApiChatsResponseItem
from .types.get_api_invites_id_responses_response import GetApiInvitesIdResponsesResponse
from .types.get_api_projects_project_id_files_response import GetApiProjectsProjectIdFilesResponse
from .types.get_api_projects_response import GetApiProjectsResponse
from .types.get_api_threads_response import GetApiThreadsResponse
from .types.get_api_threads_thread_id_files_response import GetApiThreadsThreadIdFilesResponse
from .types.get_chat_session_response import GetChatSessionResponse
from .types.get_participant_invites_response import GetParticipantInvitesResponse
from .types.get_project_responses_response import GetProjectResponsesResponse
from .types.inbound_call_response import InboundCallResponse
from .types.invite import Invite
from .types.invite_config import InviteConfig
from .types.invite_response import InviteResponse
from .types.invite_response_data import InviteResponseData
from .types.invite_response_kind import InviteResponseKind
from .types.invite_response_status import InviteResponseStatus
from .types.invite_status import InviteStatus
from .types.participant_invite import ParticipantInvite
from .types.phone_call_start_response import PhoneCallStartResponse
from .types.post_api_call_messages_search_response_item import PostApiCallMessagesSearchResponseItem
from .types.post_api_files_file_id_signed_url_request_action import PostApiFilesFileIdSignedUrlRequestAction
from .types.post_api_files_file_id_signed_url_response import PostApiFilesFileIdSignedUrlResponse
from .types.post_api_files_response import PostApiFilesResponse
from .types.post_api_invite_code_code_responses_request_data import PostApiInviteCodeCodeResponsesRequestData
from .types.post_api_invites_id_participant_invites_request_participant import (
    PostApiInvitesIdParticipantInvitesRequestParticipant,
)
from .types.post_api_projects_request_thread_assets_item import PostApiProjectsRequestThreadAssetsItem
from .types.project_config import ProjectConfig
from .types.project_conversation_config import ProjectConversationConfig
from .types.project_file import ProjectFile
from .types.project_file_metadata import ProjectFileMetadata
from .types.project_status import ProjectStatus
from .types.project_test_call_response import ProjectTestCallResponse
from .types.project_with_analytics import ProjectWithAnalytics
from .types.put_api_chats_session_id_response import PutApiChatsSessionIdResponse
from .types.put_api_invite_code_code_responses_response_id_request_data import (
    PutApiInviteCodeCodeResponsesResponseIdRequestData,
)
from .types.put_api_invite_code_code_responses_response_id_update_call_request_call import (
    PutApiInviteCodeCodeResponsesResponseIdUpdateCallRequestCall,
)
from .types.remaining_responses_response import RemainingResponsesResponse
from .types.search_project_transcripts_response import SearchProjectTranscriptsResponse
from .types.send_chat_message_response import SendChatMessageResponse
from .types.thread import Thread
from .types.thread_kind import ThreadKind
from .types.user import User

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class KeplarApi:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : KeplarApiEnvironment
        The environment to use for requests from the client. from .environment import KeplarApiEnvironment



        Defaults to KeplarApiEnvironment.DEFAULT



    token : typing.Union[str, typing.Callable[[], str]]
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from keplar import KeplarApi

    client = KeplarApi(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: KeplarApiEnvironment = KeplarApiEnvironment.DEFAULT,
        token: typing.Union[str, typing.Callable[[], str]],
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._raw_client = RawKeplarApi(client_wrapper=self._client_wrapper)

    @property
    def with_raw_response(self) -> RawKeplarApi:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawKeplarApi
        """
        return self._raw_client

    def get_api_auth_google_redirect(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_api_auth_google_redirect()
        """
        _response = self._raw_client.get_api_auth_google_redirect(request_options=request_options)
        return _response.data

    def get_api_auth_google(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_api_auth_google()
        """
        _response = self._raw_client.get_api_auth_google(request_options=request_options)
        return _response.data

    def get_invite_by_code(
        self,
        code: str,
        *,
        participant_code: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CodeInvite:
        """
        Get an invite using invite code

        Parameters
        ----------
        code : str

        participant_code : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CodeInvite
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_invite_by_code(
            code="code",
        )
        """
        _response = self._raw_client.get_invite_by_code(
            code, participant_code=participant_code, request_options=request_options
        )
        return _response.data

    def get_participant_invite_by_code_and_participant_code(
        self, code: str, participant_code: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ParticipantInvite:
        """
        Get a participant invite using invite code and participant code

        Parameters
        ----------
        code : str

        participant_code : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ParticipantInvite
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_participant_invite_by_code_and_participant_code(
            code="code",
            participant_code="participantCode",
        )
        """
        _response = self._raw_client.get_participant_invite_by_code_and_participant_code(
            code, participant_code, request_options=request_options
        )
        return _response.data

    def get_remaining_responses_count_by_invite_code(
        self, code: str, *, participant_code: str, request_options: typing.Optional[RequestOptions] = None
    ) -> RemainingResponsesResponse:
        """
        Get the number of remaining responses for an invite using invite code

        Parameters
        ----------
        code : str

        participant_code : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RemainingResponsesResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_remaining_responses_count_by_invite_code(
            code="code",
            participant_code="participantCode",
        )
        """
        _response = self._raw_client.get_remaining_responses_count_by_invite_code(
            code, participant_code=participant_code, request_options=request_options
        )
        return _response.data

    def get_invite_response_by_invite_code_and_participant_code(
        self, code: str, *, participant_code: str, request_options: typing.Optional[RequestOptions] = None
    ) -> CodeInviteResponse:
        """
        Get the invite response for an invite using invite code and participant code

        Parameters
        ----------
        code : str

        participant_code : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CodeInviteResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_invite_response_by_invite_code_and_participant_code(
            code="code",
            participant_code="participantCode",
        )
        """
        _response = self._raw_client.get_invite_response_by_invite_code_and_participant_code(
            code, participant_code=participant_code, request_options=request_options
        )
        return _response.data

    def create_invite_response_by_invite_code(
        self,
        code: str,
        *,
        participant_code: typing.Optional[str] = None,
        kind: typing.Optional[InviteResponseKind] = OMIT,
        data: typing.Optional[PostApiInviteCodeCodeResponsesRequestData] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CodeInviteResponse:
        """
        Create a response for an invite using invite code

        Parameters
        ----------
        code : str

        participant_code : typing.Optional[str]

        kind : typing.Optional[InviteResponseKind]

        data : typing.Optional[PostApiInviteCodeCodeResponsesRequestData]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CodeInviteResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.create_invite_response_by_invite_code(
            code="code",
        )
        """
        _response = self._raw_client.create_invite_response_by_invite_code(
            code, participant_code=participant_code, kind=kind, data=data, request_options=request_options
        )
        return _response.data

    def get_invite_response_by_invite_code(
        self, code: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CodeInviteResponse:
        """
        Get a response of an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CodeInviteResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_invite_response_by_invite_code(
            code="code",
            response_id="responseId",
        )
        """
        _response = self._raw_client.get_invite_response_by_invite_code(
            code, response_id, request_options=request_options
        )
        return _response.data

    def update_invite_response_by_invite_code(
        self,
        code: str,
        response_id: str,
        *,
        status: InviteResponseStatus,
        data: typing.Optional[PutApiInviteCodeCodeResponsesResponseIdRequestData] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CodeInviteResponse:
        """
        Update a response of an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        status : InviteResponseStatus

        data : typing.Optional[PutApiInviteCodeCodeResponsesResponseIdRequestData]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CodeInviteResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.update_invite_response_by_invite_code(
            code="code",
            response_id="responseId",
            status="PENDING",
        )
        """
        _response = self._raw_client.update_invite_response_by_invite_code(
            code, response_id, status=status, data=data, request_options=request_options
        )
        return _response.data

    def start_call_by_invite_code(
        self, code: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> InboundCallResponse:
        """
        Start a call for an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InboundCallResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.start_call_by_invite_code(
            code="code",
            response_id="responseId",
        )
        """
        _response = self._raw_client.start_call_by_invite_code(code, response_id, request_options=request_options)
        return _response.data

    def update_call_by_invite_code(
        self,
        code: str,
        response_id: str,
        *,
        call_id: str,
        call: PutApiInviteCodeCodeResponsesResponseIdUpdateCallRequestCall,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Update a call for an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        call_id : str

        call : PutApiInviteCodeCodeResponsesResponseIdUpdateCallRequestCall

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Default Response

        Examples
        --------
        from keplar import (
            KeplarApi,
            PutApiInviteCodeCodeResponsesResponseIdUpdateCallRequestCall,
        )

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.update_call_by_invite_code(
            code="code",
            response_id="responseId",
            call_id="callId",
            call=PutApiInviteCodeCodeResponsesResponseIdUpdateCallRequestCall(
                vendor_call_id="vendorCallId",
                status="REQUESTED",
            ),
        )
        """
        _response = self._raw_client.update_call_by_invite_code(
            code, response_id, call_id=call_id, call=call, request_options=request_options
        )
        return _response.data

    def start_phone_call_by_invite_code(
        self, code: str, response_id: str, *, phone_number: str, request_options: typing.Optional[RequestOptions] = None
    ) -> PhoneCallStartResponse:
        """
        Start a phone call for an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        phone_number : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PhoneCallStartResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.start_phone_call_by_invite_code(
            code="code",
            response_id="responseId",
            phone_number="phoneNumber",
        )
        """
        _response = self._raw_client.start_phone_call_by_invite_code(
            code, response_id, phone_number=phone_number, request_options=request_options
        )
        return _response.data

    def get_call_metadata_by_invite_code(
        self, code: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CallMetadata:
        """
        Get a call metadata of an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CallMetadata
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_call_metadata_by_invite_code(
            code="code",
            response_id="responseId",
        )
        """
        _response = self._raw_client.get_call_metadata_by_invite_code(
            code, response_id, request_options=request_options
        )
        return _response.data

    def create_call_metadata_transcript_insight_by_invite_code(
        self, code: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CallMetadata:
        """
        Create a call metadata transcript insight for an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CallMetadata
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.create_call_metadata_transcript_insight_by_invite_code(
            code="code",
            response_id="responseId",
        )
        """
        _response = self._raw_client.create_call_metadata_transcript_insight_by_invite_code(
            code, response_id, request_options=request_options
        )
        return _response.data

    def post_api_vapi_webhook(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.post_api_vapi_webhook()
        """
        _response = self._raw_client.post_api_vapi_webhook(request_options=request_options)
        return _response.data

    def post_api_vapi_tools_show_visual_asset(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.post_api_vapi_tools_show_visual_asset()
        """
        _response = self._raw_client.post_api_vapi_tools_show_visual_asset(request_options=request_options)
        return _response.data

    def create_demo_invite(
        self,
        *,
        name: str,
        company: str,
        email: str,
        invite_code: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        name : str

        company : str

        email : str

        invite_code : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.create_demo_invite(
            name="name",
            company="company",
            email="email",
            invite_code="inviteCode",
        )
        """
        _response = self._raw_client.create_demo_invite(
            name=name, company=company, email=email, invite_code=invite_code, request_options=request_options
        )
        return _response.data

    def get_user(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> User:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_user(
            id="id",
        )
        """
        _response = self._raw_client.get_user(id, request_options=request_options)
        return _response.data

    def get_projects(
        self,
        *,
        search: typing.Optional[str] = None,
        page: typing.Optional[float] = None,
        limit: typing.Optional[float] = None,
        statuses: typing.Optional[typing.Union[ProjectStatus, typing.Sequence[ProjectStatus]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetApiProjectsResponse:
        """
        Parameters
        ----------
        search : typing.Optional[str]

        page : typing.Optional[float]

        limit : typing.Optional[float]

        statuses : typing.Optional[typing.Union[ProjectStatus, typing.Sequence[ProjectStatus]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetApiProjectsResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_projects()
        """
        _response = self._raw_client.get_projects(
            search=search, page=page, limit=limit, statuses=statuses, request_options=request_options
        )
        return _response.data

    def create_project(
        self,
        *,
        name: str,
        config: ProjectConfig,
        conversation_config: ProjectConversationConfig,
        description: typing.Optional[str] = OMIT,
        status: typing.Optional[ProjectStatus] = OMIT,
        thread_assets: typing.Optional[typing.Sequence[PostApiProjectsRequestThreadAssetsItem]] = OMIT,
        thread_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectWithAnalytics:
        """
        Parameters
        ----------
        name : str

        config : ProjectConfig

        conversation_config : ProjectConversationConfig

        description : typing.Optional[str]

        status : typing.Optional[ProjectStatus]

        thread_assets : typing.Optional[typing.Sequence[PostApiProjectsRequestThreadAssetsItem]]

        thread_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectWithAnalytics
            Default Response

        Examples
        --------
        from keplar import (
            KeplarApi,
            ProjectConfig,
            ProjectConversationConfig,
            VapiVoiceVapiProvider,
        )

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.create_project(
            name="name",
            config=ProjectConfig(
                kind="attitude_usage",
                prompt_variables={"key": "value"},
                learning_plan="learningPlan",
            ),
            conversation_config=ProjectConversationConfig(
                first_message="firstMessage",
                end_call_message="endCallMessage",
                max_duration_seconds=1.1,
                voice=VapiVoiceVapiProvider(
                    voice_id="Elliot",
                ),
            ),
        )
        """
        _response = self._raw_client.create_project(
            name=name,
            config=config,
            conversation_config=conversation_config,
            description=description,
            status=status,
            thread_assets=thread_assets,
            thread_id=thread_id,
            request_options=request_options,
        )
        return _response.data

    def get_project(
        self, project_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProjectWithAnalytics:
        """
        Parameters
        ----------
        project_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectWithAnalytics
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_project(
            project_id="projectId",
        )
        """
        _response = self._raw_client.get_project(project_id, request_options=request_options)
        return _response.data

    def update_project(
        self,
        project_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        status: typing.Optional[ProjectStatus] = OMIT,
        config: typing.Optional[ProjectConfig] = OMIT,
        conversation_config: typing.Optional[ProjectConversationConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectWithAnalytics:
        """
        Parameters
        ----------
        project_id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        status : typing.Optional[ProjectStatus]

        config : typing.Optional[ProjectConfig]

        conversation_config : typing.Optional[ProjectConversationConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectWithAnalytics
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.update_project(
            project_id="projectId",
        )
        """
        _response = self._raw_client.update_project(
            project_id,
            name=name,
            description=description,
            status=status,
            config=config,
            conversation_config=conversation_config,
            request_options=request_options,
        )
        return _response.data

    def create_project_test_call(
        self, project_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProjectTestCallResponse:
        """
        Parameters
        ----------
        project_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectTestCallResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.create_project_test_call(
            project_id="projectId",
        )
        """
        _response = self._raw_client.create_project_test_call(project_id, request_options=request_options)
        return _response.data

    def get_project_responses(
        self,
        project_id: str,
        *,
        page: typing.Optional[float] = None,
        limit: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetProjectResponsesResponse:
        """
        Parameters
        ----------
        project_id : str

        page : typing.Optional[float]

        limit : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetProjectResponsesResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_project_responses(
            project_id="projectId",
        )
        """
        _response = self._raw_client.get_project_responses(
            project_id, page=page, limit=limit, request_options=request_options
        )
        return _response.data

    def search_project_transcripts(
        self,
        project_id: str,
        *,
        page: typing.Optional[float] = OMIT,
        limit: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SearchProjectTranscriptsResponse:
        """
        Parameters
        ----------
        project_id : str

        page : typing.Optional[float]

        limit : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchProjectTranscriptsResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.search_project_transcripts(
            project_id="projectId",
        )
        """
        _response = self._raw_client.search_project_transcripts(
            project_id, page=page, limit=limit, request_options=request_options
        )
        return _response.data

    def create_project_analysis(
        self, project_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        project_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.create_project_analysis(
            project_id="projectId",
        )
        """
        _response = self._raw_client.create_project_analysis(project_id, request_options=request_options)
        return _response.data

    def get_call(self, call_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Call:
        """
        Get detailed information about a specific call including participant and project data

        Parameters
        ----------
        call_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Call
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_call(
            call_id="callId",
        )
        """
        _response = self._raw_client.get_call(call_id, request_options=request_options)
        return _response.data

    def get_conversation_message(
        self, call_id: str, index: float, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ConversationMessage:
        """
        Parameters
        ----------
        call_id : str

        index : float

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConversationMessage
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_conversation_message(
            call_id="callId",
            index=1.1,
        )
        """
        _response = self._raw_client.get_conversation_message(call_id, index, request_options=request_options)
        return _response.data

    def search_conversation_messages(
        self,
        *,
        request: typing.Dict[str, typing.Sequence[float]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[PostApiCallMessagesSearchResponseItem]:
        """
        Parameters
        ----------
        request : typing.Dict[str, typing.Sequence[float]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[PostApiCallMessagesSearchResponseItem]
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.search_conversation_messages(
            request={"key": [1.1]},
        )
        """
        _response = self._raw_client.search_conversation_messages(request=request, request_options=request_options)
        return _response.data

    def get_invite(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Invite:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Invite
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_invite(
            id="id",
        )
        """
        _response = self._raw_client.get_invite(id, request_options=request_options)
        return _response.data

    def update_invite(
        self,
        id: str,
        *,
        config: InviteConfig,
        status: InviteStatus,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        live_at: typing.Optional[dt.datetime] = OMIT,
        expires_at: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Invite:
        """
        Parameters
        ----------
        id : str

        config : InviteConfig

        status : InviteStatus

        name : typing.Optional[str]

        description : typing.Optional[str]

        live_at : typing.Optional[dt.datetime]

        expires_at : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Invite
            Default Response

        Examples
        --------
        from keplar import InviteConfig, KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.update_invite(
            id="id",
            config=InviteConfig(
                allowed_origins=["allowedOrigins"],
                allow_anonymous_responses=True,
            ),
            status="ACTIVE",
        )
        """
        _response = self._raw_client.update_invite(
            id,
            config=config,
            status=status,
            name=name,
            description=description,
            live_at=live_at,
            expires_at=expires_at,
            request_options=request_options,
        )
        return _response.data

    def create_invite(
        self,
        *,
        name: str,
        config: InviteConfig,
        project_id: str,
        description: typing.Optional[str] = OMIT,
        expires_at: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Invite:
        """
        Parameters
        ----------
        name : str

        config : InviteConfig

        project_id : str

        description : typing.Optional[str]

        expires_at : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Invite
            Default Response

        Examples
        --------
        from keplar import InviteConfig, KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.create_invite(
            name="name",
            config=InviteConfig(
                allowed_origins=["allowedOrigins"],
                allow_anonymous_responses=True,
            ),
            project_id="projectId",
        )
        """
        _response = self._raw_client.create_invite(
            name=name,
            config=config,
            project_id=project_id,
            description=description,
            expires_at=expires_at,
            request_options=request_options,
        )
        return _response.data

    def get_invite_responses(
        self,
        id: str,
        *,
        page: typing.Optional[float] = None,
        limit: typing.Optional[float] = None,
        statuses: typing.Optional[typing.Union[InviteResponseStatus, typing.Sequence[InviteResponseStatus]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetApiInvitesIdResponsesResponse:
        """
        Get all invite responses for an invite using invite ID

        Parameters
        ----------
        id : str

        page : typing.Optional[float]

        limit : typing.Optional[float]

        statuses : typing.Optional[typing.Union[InviteResponseStatus, typing.Sequence[InviteResponseStatus]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetApiInvitesIdResponsesResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_invite_responses(
            id="id",
        )
        """
        _response = self._raw_client.get_invite_responses(
            id, page=page, limit=limit, statuses=statuses, request_options=request_options
        )
        return _response.data

    def create_invite_response(
        self,
        id: str,
        *,
        kind: typing.Optional[InviteResponseKind] = OMIT,
        participant_invite_code: typing.Optional[str] = OMIT,
        data: typing.Optional[InviteResponseData] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> InviteResponse:
        """
        Create an invite response using invite ID

        Parameters
        ----------
        id : str

        kind : typing.Optional[InviteResponseKind]

        participant_invite_code : typing.Optional[str]

        data : typing.Optional[InviteResponseData]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InviteResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.create_invite_response(
            id="id",
        )
        """
        _response = self._raw_client.create_invite_response(
            id, kind=kind, participant_invite_code=participant_invite_code, data=data, request_options=request_options
        )
        return _response.data

    def get_invite_response(
        self, id: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> InviteResponse:
        """
        Get an invite response using invite ID and response ID

        Parameters
        ----------
        id : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InviteResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_invite_response(
            id="id",
            response_id="responseId",
        )
        """
        _response = self._raw_client.get_invite_response(id, response_id, request_options=request_options)
        return _response.data

    def update_invite_response(
        self,
        id: str,
        response_id: str,
        *,
        status: InviteResponseStatus,
        data: typing.Optional[typing.Optional[typing.Any]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> InviteResponse:
        """
        Update an invite response using invite ID and response ID

        Parameters
        ----------
        id : str

        response_id : str

        status : InviteResponseStatus

        data : typing.Optional[typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InviteResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.update_invite_response(
            id="id",
            response_id="responseId",
            status="PENDING",
        )
        """
        _response = self._raw_client.update_invite_response(
            id, response_id, status=status, data=data, request_options=request_options
        )
        return _response.data

    def get_call_metadata_by_invite_id_and_response_id(
        self, id: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CallMetadata:
        """
        Parameters
        ----------
        id : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CallMetadata
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_call_metadata_by_invite_id_and_response_id(
            id="id",
            response_id="responseId",
        )
        """
        _response = self._raw_client.get_call_metadata_by_invite_id_and_response_id(
            id, response_id, request_options=request_options
        )
        return _response.data

    def get_participant_invites(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetParticipantInvitesResponse:
        """
        Get all participant invites for an invite using invite ID

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetParticipantInvitesResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_participant_invites(
            id="id",
        )
        """
        _response = self._raw_client.get_participant_invites(id, request_options=request_options)
        return _response.data

    def create_participant_invite(
        self,
        id: str,
        *,
        participant: PostApiInvitesIdParticipantInvitesRequestParticipant,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ParticipantInvite:
        """
        Create a participant invite using invite ID

        Parameters
        ----------
        id : str

        participant : PostApiInvitesIdParticipantInvitesRequestParticipant

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ParticipantInvite
            Default Response

        Examples
        --------
        from keplar import (
            KeplarApi,
            PostApiInvitesIdParticipantInvitesRequestParticipant,
        )

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.create_participant_invite(
            id="id",
            participant=PostApiInvitesIdParticipantInvitesRequestParticipant(),
        )
        """
        _response = self._raw_client.create_participant_invite(
            id, participant=participant, request_options=request_options
        )
        return _response.data

    def get_participant_invite(
        self, id: str, participant_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ParticipantInvite:
        """
        Get a participant invite using invite ID and participant ID

        Parameters
        ----------
        id : str

        participant_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ParticipantInvite
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_participant_invite(
            id="id",
            participant_id="participantId",
        )
        """
        _response = self._raw_client.get_participant_invite(id, participant_id, request_options=request_options)
        return _response.data

    def update_participant_invite(
        self,
        id: str,
        participant_id: str,
        *,
        code: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ParticipantInvite:
        """
        Update a participant invite using invite ID and participant ID

        Parameters
        ----------
        id : str

        participant_id : str

        code : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ParticipantInvite
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.update_participant_invite(
            id="id",
            participant_id="participantId",
        )
        """
        _response = self._raw_client.update_participant_invite(
            id, participant_id, code=code, request_options=request_options
        )
        return _response.data

    def get_call_metadata_by_invite_id_and_participant_id(
        self, id: str, participant_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CallMetadata:
        """
        Parameters
        ----------
        id : str

        participant_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CallMetadata
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_call_metadata_by_invite_id_and_participant_id(
            id="id",
            participant_id="participantId",
        )
        """
        _response = self._raw_client.get_call_metadata_by_invite_id_and_participant_id(
            id, participant_id, request_options=request_options
        )
        return _response.data

    def get_chat_sessions_for_user(
        self, *, project_id: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[GetApiChatsResponseItem]:
        """
        Get all chat sessions for authenticated user

        Parameters
        ----------
        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[GetApiChatsResponseItem]
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_chat_sessions_for_user()
        """
        _response = self._raw_client.get_chat_sessions_for_user(project_id=project_id, request_options=request_options)
        return _response.data

    def create_a_new_chat_session(
        self,
        *,
        message: typing.Optional[str] = OMIT,
        project_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateChatSessionResponse:
        """
        Create a new chat session, optionally with an initial message

        Parameters
        ----------
        message : typing.Optional[str]

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateChatSessionResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.create_a_new_chat_session()
        """
        _response = self._raw_client.create_a_new_chat_session(
            message=message, project_id=project_id, request_options=request_options
        )
        return _response.data

    def get_chat_history_for_a_specific_session(
        self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetChatSessionResponse:
        """
        Get chat message history and citations for a specific chat session

        Parameters
        ----------
        session_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetChatSessionResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_chat_history_for_a_specific_session(
            session_id="sessionId",
        )
        """
        _response = self._raw_client.get_chat_history_for_a_specific_session(
            session_id, request_options=request_options
        )
        return _response.data

    def update_a_chat_session(
        self,
        session_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PutApiChatsSessionIdResponse:
        """
        Update the name and description of a chat session

        Parameters
        ----------
        session_id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PutApiChatsSessionIdResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.update_a_chat_session(
            session_id="sessionId",
        )
        """
        _response = self._raw_client.update_a_chat_session(
            session_id, name=name, description=description, request_options=request_options
        )
        return _response.data

    def delete_a_chat_session(
        self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteChatSessionResponse:
        """
        Delete a chat session and all its messages

        Parameters
        ----------
        session_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteChatSessionResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.delete_a_chat_session(
            session_id="sessionId",
        )
        """
        _response = self._raw_client.delete_a_chat_session(session_id, request_options=request_options)
        return _response.data

    def create_chat_message(
        self,
        session_id: str,
        *,
        message: str,
        project_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SendChatMessageResponse:
        """
        Send a message to analyze transcripts and get AI response

        Parameters
        ----------
        session_id : str

        message : str

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SendChatMessageResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.create_chat_message(
            session_id="sessionId",
            message="message",
        )
        """
        _response = self._raw_client.create_chat_message(
            session_id, message=message, project_id=project_id, request_options=request_options
        )
        return _response.data

    def post_api_copilotkit(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.post_api_copilotkit()
        """
        _response = self._raw_client.post_api_copilotkit(request_options=request_options)
        return _response.data

    def upload_a_file(self, *, request_options: typing.Optional[RequestOptions] = None) -> PostApiFilesResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostApiFilesResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.upload_a_file()
        """
        _response = self._raw_client.upload_a_file(request_options=request_options)
        return _response.data

    def get_file_metadata(self, file_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> File:
        """
        Parameters
        ----------
        file_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        File
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_file_metadata(
            file_id="fileId",
        )
        """
        _response = self._raw_client.get_file_metadata(file_id, request_options=request_options)
        return _response.data

    def delete_a_file(self, file_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        file_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.delete_a_file(
            file_id="fileId",
        )
        """
        _response = self._raw_client.delete_a_file(file_id, request_options=request_options)
        return _response.data

    def get_a_signed_url_for_file_access(
        self,
        file_id: str,
        *,
        action: typing.Optional[PostApiFilesFileIdSignedUrlRequestAction] = OMIT,
        expires_in: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PostApiFilesFileIdSignedUrlResponse:
        """
        Parameters
        ----------
        file_id : str

        action : typing.Optional[PostApiFilesFileIdSignedUrlRequestAction]

        expires_in : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostApiFilesFileIdSignedUrlResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_a_signed_url_for_file_access(
            file_id="fileId",
        )
        """
        _response = self._raw_client.get_a_signed_url_for_file_access(
            file_id, action=action, expires_in=expires_in, request_options=request_options
        )
        return _response.data

    def get_files_for_a_project(
        self,
        project_id: str,
        *,
        category: typing.Optional[str] = None,
        page: typing.Optional[float] = None,
        limit: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetApiProjectsProjectIdFilesResponse:
        """
        Parameters
        ----------
        project_id : str

        category : typing.Optional[str]

        page : typing.Optional[float]

        limit : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetApiProjectsProjectIdFilesResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_files_for_a_project(
            project_id="projectId",
        )
        """
        _response = self._raw_client.get_files_for_a_project(
            project_id, category=category, page=page, limit=limit, request_options=request_options
        )
        return _response.data

    def add_an_existing_file_to_a_project(
        self,
        project_id: str,
        *,
        file_id: str,
        category: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        metadata: typing.Optional[ProjectFileMetadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectFile:
        """
        Parameters
        ----------
        project_id : str

        file_id : str

        category : typing.Optional[str]

        description : typing.Optional[str]

        metadata : typing.Optional[ProjectFileMetadata]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectFile
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.add_an_existing_file_to_a_project(
            project_id="projectId",
            file_id="fileId",
        )
        """
        _response = self._raw_client.add_an_existing_file_to_a_project(
            project_id,
            file_id=file_id,
            category=category,
            description=description,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    def update_project_file_metadata(
        self,
        project_id: str,
        file_id: str,
        *,
        description: typing.Optional[str] = OMIT,
        metadata: typing.Optional[ProjectFileMetadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectFile:
        """
        Parameters
        ----------
        project_id : str

        file_id : str

        description : typing.Optional[str]

        metadata : typing.Optional[ProjectFileMetadata]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectFile
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.update_project_file_metadata(
            project_id="projectId",
            file_id="fileId",
        )
        """
        _response = self._raw_client.update_project_file_metadata(
            project_id, file_id, description=description, metadata=metadata, request_options=request_options
        )
        return _response.data

    def remove_a_file_from_a_project(
        self, project_id: str, file_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        project_id : str

        file_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.remove_a_file_from_a_project(
            project_id="projectId",
            file_id="fileId",
        )
        """
        _response = self._raw_client.remove_a_file_from_a_project(project_id, file_id, request_options=request_options)
        return _response.data

    def get_threads(
        self,
        *,
        project_id: typing.Optional[str] = None,
        kind: typing.Optional[ThreadKind] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetApiThreadsResponse:
        """
        Parameters
        ----------
        project_id : typing.Optional[str]

        kind : typing.Optional[ThreadKind]

        limit : typing.Optional[int]

        offset : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetApiThreadsResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_threads()
        """
        _response = self._raw_client.get_threads(
            project_id=project_id, kind=kind, limit=limit, offset=offset, request_options=request_options
        )
        return _response.data

    def upsert_thread(
        self,
        thread_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        kind: typing.Optional[ThreadKind] = OMIT,
        project_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Thread:
        """
        Parameters
        ----------
        thread_id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        kind : typing.Optional[ThreadKind]

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Thread
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.upsert_thread(
            thread_id="threadId",
        )
        """
        _response = self._raw_client.upsert_thread(
            thread_id,
            name=name,
            description=description,
            metadata=metadata,
            kind=kind,
            project_id=project_id,
            request_options=request_options,
        )
        return _response.data

    def get_thread_files(
        self,
        thread_id: str,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        file_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetApiThreadsThreadIdFilesResponse:
        """
        Parameters
        ----------
        thread_id : str

        limit : typing.Optional[int]

        offset : typing.Optional[int]

        file_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetApiThreadsThreadIdFilesResponse
            Default Response

        Examples
        --------
        from keplar import KeplarApi

        client = KeplarApi(
            token="YOUR_TOKEN",
        )
        client.get_thread_files(
            thread_id="threadId",
        )
        """
        _response = self._raw_client.get_thread_files(
            thread_id, limit=limit, offset=offset, file_names=file_names, request_options=request_options
        )
        return _response.data


class AsyncKeplarApi:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : KeplarApiEnvironment
        The environment to use for requests from the client. from .environment import KeplarApiEnvironment



        Defaults to KeplarApiEnvironment.DEFAULT



    token : typing.Union[str, typing.Callable[[], str]]
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from keplar import AsyncKeplarApi

    client = AsyncKeplarApi(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: KeplarApiEnvironment = KeplarApiEnvironment.DEFAULT,
        token: typing.Union[str, typing.Callable[[], str]],
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._raw_client = AsyncRawKeplarApi(client_wrapper=self._client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawKeplarApi:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawKeplarApi
        """
        return self._raw_client

    async def get_api_auth_google_redirect(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_api_auth_google_redirect()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_api_auth_google_redirect(request_options=request_options)
        return _response.data

    async def get_api_auth_google(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_api_auth_google()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_api_auth_google(request_options=request_options)
        return _response.data

    async def get_invite_by_code(
        self,
        code: str,
        *,
        participant_code: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CodeInvite:
        """
        Get an invite using invite code

        Parameters
        ----------
        code : str

        participant_code : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CodeInvite
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_invite_by_code(
                code="code",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_invite_by_code(
            code, participant_code=participant_code, request_options=request_options
        )
        return _response.data

    async def get_participant_invite_by_code_and_participant_code(
        self, code: str, participant_code: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ParticipantInvite:
        """
        Get a participant invite using invite code and participant code

        Parameters
        ----------
        code : str

        participant_code : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ParticipantInvite
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_participant_invite_by_code_and_participant_code(
                code="code",
                participant_code="participantCode",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_participant_invite_by_code_and_participant_code(
            code, participant_code, request_options=request_options
        )
        return _response.data

    async def get_remaining_responses_count_by_invite_code(
        self, code: str, *, participant_code: str, request_options: typing.Optional[RequestOptions] = None
    ) -> RemainingResponsesResponse:
        """
        Get the number of remaining responses for an invite using invite code

        Parameters
        ----------
        code : str

        participant_code : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RemainingResponsesResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_remaining_responses_count_by_invite_code(
                code="code",
                participant_code="participantCode",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_remaining_responses_count_by_invite_code(
            code, participant_code=participant_code, request_options=request_options
        )
        return _response.data

    async def get_invite_response_by_invite_code_and_participant_code(
        self, code: str, *, participant_code: str, request_options: typing.Optional[RequestOptions] = None
    ) -> CodeInviteResponse:
        """
        Get the invite response for an invite using invite code and participant code

        Parameters
        ----------
        code : str

        participant_code : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CodeInviteResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_invite_response_by_invite_code_and_participant_code(
                code="code",
                participant_code="participantCode",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_invite_response_by_invite_code_and_participant_code(
            code, participant_code=participant_code, request_options=request_options
        )
        return _response.data

    async def create_invite_response_by_invite_code(
        self,
        code: str,
        *,
        participant_code: typing.Optional[str] = None,
        kind: typing.Optional[InviteResponseKind] = OMIT,
        data: typing.Optional[PostApiInviteCodeCodeResponsesRequestData] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CodeInviteResponse:
        """
        Create a response for an invite using invite code

        Parameters
        ----------
        code : str

        participant_code : typing.Optional[str]

        kind : typing.Optional[InviteResponseKind]

        data : typing.Optional[PostApiInviteCodeCodeResponsesRequestData]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CodeInviteResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.create_invite_response_by_invite_code(
                code="code",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_invite_response_by_invite_code(
            code, participant_code=participant_code, kind=kind, data=data, request_options=request_options
        )
        return _response.data

    async def get_invite_response_by_invite_code(
        self, code: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CodeInviteResponse:
        """
        Get a response of an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CodeInviteResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_invite_response_by_invite_code(
                code="code",
                response_id="responseId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_invite_response_by_invite_code(
            code, response_id, request_options=request_options
        )
        return _response.data

    async def update_invite_response_by_invite_code(
        self,
        code: str,
        response_id: str,
        *,
        status: InviteResponseStatus,
        data: typing.Optional[PutApiInviteCodeCodeResponsesResponseIdRequestData] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CodeInviteResponse:
        """
        Update a response of an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        status : InviteResponseStatus

        data : typing.Optional[PutApiInviteCodeCodeResponsesResponseIdRequestData]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CodeInviteResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.update_invite_response_by_invite_code(
                code="code",
                response_id="responseId",
                status="PENDING",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_invite_response_by_invite_code(
            code, response_id, status=status, data=data, request_options=request_options
        )
        return _response.data

    async def start_call_by_invite_code(
        self, code: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> InboundCallResponse:
        """
        Start a call for an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InboundCallResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.start_call_by_invite_code(
                code="code",
                response_id="responseId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.start_call_by_invite_code(code, response_id, request_options=request_options)
        return _response.data

    async def update_call_by_invite_code(
        self,
        code: str,
        response_id: str,
        *,
        call_id: str,
        call: PutApiInviteCodeCodeResponsesResponseIdUpdateCallRequestCall,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Update a call for an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        call_id : str

        call : PutApiInviteCodeCodeResponsesResponseIdUpdateCallRequestCall

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Default Response

        Examples
        --------
        import asyncio

        from keplar import (
            AsyncKeplarApi,
            PutApiInviteCodeCodeResponsesResponseIdUpdateCallRequestCall,
        )

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.update_call_by_invite_code(
                code="code",
                response_id="responseId",
                call_id="callId",
                call=PutApiInviteCodeCodeResponsesResponseIdUpdateCallRequestCall(
                    vendor_call_id="vendorCallId",
                    status="REQUESTED",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_call_by_invite_code(
            code, response_id, call_id=call_id, call=call, request_options=request_options
        )
        return _response.data

    async def start_phone_call_by_invite_code(
        self, code: str, response_id: str, *, phone_number: str, request_options: typing.Optional[RequestOptions] = None
    ) -> PhoneCallStartResponse:
        """
        Start a phone call for an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        phone_number : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PhoneCallStartResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.start_phone_call_by_invite_code(
                code="code",
                response_id="responseId",
                phone_number="phoneNumber",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.start_phone_call_by_invite_code(
            code, response_id, phone_number=phone_number, request_options=request_options
        )
        return _response.data

    async def get_call_metadata_by_invite_code(
        self, code: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CallMetadata:
        """
        Get a call metadata of an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CallMetadata
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_call_metadata_by_invite_code(
                code="code",
                response_id="responseId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_call_metadata_by_invite_code(
            code, response_id, request_options=request_options
        )
        return _response.data

    async def create_call_metadata_transcript_insight_by_invite_code(
        self, code: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CallMetadata:
        """
        Create a call metadata transcript insight for an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CallMetadata
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.create_call_metadata_transcript_insight_by_invite_code(
                code="code",
                response_id="responseId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_call_metadata_transcript_insight_by_invite_code(
            code, response_id, request_options=request_options
        )
        return _response.data

    async def post_api_vapi_webhook(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.post_api_vapi_webhook()


        asyncio.run(main())
        """
        _response = await self._raw_client.post_api_vapi_webhook(request_options=request_options)
        return _response.data

    async def post_api_vapi_tools_show_visual_asset(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.post_api_vapi_tools_show_visual_asset()


        asyncio.run(main())
        """
        _response = await self._raw_client.post_api_vapi_tools_show_visual_asset(request_options=request_options)
        return _response.data

    async def create_demo_invite(
        self,
        *,
        name: str,
        company: str,
        email: str,
        invite_code: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        name : str

        company : str

        email : str

        invite_code : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.create_demo_invite(
                name="name",
                company="company",
                email="email",
                invite_code="inviteCode",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_demo_invite(
            name=name, company=company, email=email, invite_code=invite_code, request_options=request_options
        )
        return _response.data

    async def get_user(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> User:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_user(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_user(id, request_options=request_options)
        return _response.data

    async def get_projects(
        self,
        *,
        search: typing.Optional[str] = None,
        page: typing.Optional[float] = None,
        limit: typing.Optional[float] = None,
        statuses: typing.Optional[typing.Union[ProjectStatus, typing.Sequence[ProjectStatus]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetApiProjectsResponse:
        """
        Parameters
        ----------
        search : typing.Optional[str]

        page : typing.Optional[float]

        limit : typing.Optional[float]

        statuses : typing.Optional[typing.Union[ProjectStatus, typing.Sequence[ProjectStatus]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetApiProjectsResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_projects()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_projects(
            search=search, page=page, limit=limit, statuses=statuses, request_options=request_options
        )
        return _response.data

    async def create_project(
        self,
        *,
        name: str,
        config: ProjectConfig,
        conversation_config: ProjectConversationConfig,
        description: typing.Optional[str] = OMIT,
        status: typing.Optional[ProjectStatus] = OMIT,
        thread_assets: typing.Optional[typing.Sequence[PostApiProjectsRequestThreadAssetsItem]] = OMIT,
        thread_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectWithAnalytics:
        """
        Parameters
        ----------
        name : str

        config : ProjectConfig

        conversation_config : ProjectConversationConfig

        description : typing.Optional[str]

        status : typing.Optional[ProjectStatus]

        thread_assets : typing.Optional[typing.Sequence[PostApiProjectsRequestThreadAssetsItem]]

        thread_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectWithAnalytics
            Default Response

        Examples
        --------
        import asyncio

        from keplar import (
            AsyncKeplarApi,
            ProjectConfig,
            ProjectConversationConfig,
            VapiVoiceVapiProvider,
        )

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.create_project(
                name="name",
                config=ProjectConfig(
                    kind="attitude_usage",
                    prompt_variables={"key": "value"},
                    learning_plan="learningPlan",
                ),
                conversation_config=ProjectConversationConfig(
                    first_message="firstMessage",
                    end_call_message="endCallMessage",
                    max_duration_seconds=1.1,
                    voice=VapiVoiceVapiProvider(
                        voice_id="Elliot",
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_project(
            name=name,
            config=config,
            conversation_config=conversation_config,
            description=description,
            status=status,
            thread_assets=thread_assets,
            thread_id=thread_id,
            request_options=request_options,
        )
        return _response.data

    async def get_project(
        self, project_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProjectWithAnalytics:
        """
        Parameters
        ----------
        project_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectWithAnalytics
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_project(
                project_id="projectId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_project(project_id, request_options=request_options)
        return _response.data

    async def update_project(
        self,
        project_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        status: typing.Optional[ProjectStatus] = OMIT,
        config: typing.Optional[ProjectConfig] = OMIT,
        conversation_config: typing.Optional[ProjectConversationConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectWithAnalytics:
        """
        Parameters
        ----------
        project_id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        status : typing.Optional[ProjectStatus]

        config : typing.Optional[ProjectConfig]

        conversation_config : typing.Optional[ProjectConversationConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectWithAnalytics
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.update_project(
                project_id="projectId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_project(
            project_id,
            name=name,
            description=description,
            status=status,
            config=config,
            conversation_config=conversation_config,
            request_options=request_options,
        )
        return _response.data

    async def create_project_test_call(
        self, project_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProjectTestCallResponse:
        """
        Parameters
        ----------
        project_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectTestCallResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.create_project_test_call(
                project_id="projectId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_project_test_call(project_id, request_options=request_options)
        return _response.data

    async def get_project_responses(
        self,
        project_id: str,
        *,
        page: typing.Optional[float] = None,
        limit: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetProjectResponsesResponse:
        """
        Parameters
        ----------
        project_id : str

        page : typing.Optional[float]

        limit : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetProjectResponsesResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_project_responses(
                project_id="projectId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_project_responses(
            project_id, page=page, limit=limit, request_options=request_options
        )
        return _response.data

    async def search_project_transcripts(
        self,
        project_id: str,
        *,
        page: typing.Optional[float] = OMIT,
        limit: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SearchProjectTranscriptsResponse:
        """
        Parameters
        ----------
        project_id : str

        page : typing.Optional[float]

        limit : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchProjectTranscriptsResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.search_project_transcripts(
                project_id="projectId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.search_project_transcripts(
            project_id, page=page, limit=limit, request_options=request_options
        )
        return _response.data

    async def create_project_analysis(
        self, project_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        project_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.create_project_analysis(
                project_id="projectId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_project_analysis(project_id, request_options=request_options)
        return _response.data

    async def get_call(self, call_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Call:
        """
        Get detailed information about a specific call including participant and project data

        Parameters
        ----------
        call_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Call
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_call(
                call_id="callId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_call(call_id, request_options=request_options)
        return _response.data

    async def get_conversation_message(
        self, call_id: str, index: float, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ConversationMessage:
        """
        Parameters
        ----------
        call_id : str

        index : float

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConversationMessage
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_conversation_message(
                call_id="callId",
                index=1.1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_conversation_message(call_id, index, request_options=request_options)
        return _response.data

    async def search_conversation_messages(
        self,
        *,
        request: typing.Dict[str, typing.Sequence[float]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[PostApiCallMessagesSearchResponseItem]:
        """
        Parameters
        ----------
        request : typing.Dict[str, typing.Sequence[float]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[PostApiCallMessagesSearchResponseItem]
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.search_conversation_messages(
                request={"key": [1.1]},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.search_conversation_messages(
            request=request, request_options=request_options
        )
        return _response.data

    async def get_invite(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Invite:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Invite
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_invite(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_invite(id, request_options=request_options)
        return _response.data

    async def update_invite(
        self,
        id: str,
        *,
        config: InviteConfig,
        status: InviteStatus,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        live_at: typing.Optional[dt.datetime] = OMIT,
        expires_at: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Invite:
        """
        Parameters
        ----------
        id : str

        config : InviteConfig

        status : InviteStatus

        name : typing.Optional[str]

        description : typing.Optional[str]

        live_at : typing.Optional[dt.datetime]

        expires_at : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Invite
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi, InviteConfig

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.update_invite(
                id="id",
                config=InviteConfig(
                    allowed_origins=["allowedOrigins"],
                    allow_anonymous_responses=True,
                ),
                status="ACTIVE",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_invite(
            id,
            config=config,
            status=status,
            name=name,
            description=description,
            live_at=live_at,
            expires_at=expires_at,
            request_options=request_options,
        )
        return _response.data

    async def create_invite(
        self,
        *,
        name: str,
        config: InviteConfig,
        project_id: str,
        description: typing.Optional[str] = OMIT,
        expires_at: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Invite:
        """
        Parameters
        ----------
        name : str

        config : InviteConfig

        project_id : str

        description : typing.Optional[str]

        expires_at : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Invite
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi, InviteConfig

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.create_invite(
                name="name",
                config=InviteConfig(
                    allowed_origins=["allowedOrigins"],
                    allow_anonymous_responses=True,
                ),
                project_id="projectId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_invite(
            name=name,
            config=config,
            project_id=project_id,
            description=description,
            expires_at=expires_at,
            request_options=request_options,
        )
        return _response.data

    async def get_invite_responses(
        self,
        id: str,
        *,
        page: typing.Optional[float] = None,
        limit: typing.Optional[float] = None,
        statuses: typing.Optional[typing.Union[InviteResponseStatus, typing.Sequence[InviteResponseStatus]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetApiInvitesIdResponsesResponse:
        """
        Get all invite responses for an invite using invite ID

        Parameters
        ----------
        id : str

        page : typing.Optional[float]

        limit : typing.Optional[float]

        statuses : typing.Optional[typing.Union[InviteResponseStatus, typing.Sequence[InviteResponseStatus]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetApiInvitesIdResponsesResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_invite_responses(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_invite_responses(
            id, page=page, limit=limit, statuses=statuses, request_options=request_options
        )
        return _response.data

    async def create_invite_response(
        self,
        id: str,
        *,
        kind: typing.Optional[InviteResponseKind] = OMIT,
        participant_invite_code: typing.Optional[str] = OMIT,
        data: typing.Optional[InviteResponseData] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> InviteResponse:
        """
        Create an invite response using invite ID

        Parameters
        ----------
        id : str

        kind : typing.Optional[InviteResponseKind]

        participant_invite_code : typing.Optional[str]

        data : typing.Optional[InviteResponseData]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InviteResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.create_invite_response(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_invite_response(
            id, kind=kind, participant_invite_code=participant_invite_code, data=data, request_options=request_options
        )
        return _response.data

    async def get_invite_response(
        self, id: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> InviteResponse:
        """
        Get an invite response using invite ID and response ID

        Parameters
        ----------
        id : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InviteResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_invite_response(
                id="id",
                response_id="responseId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_invite_response(id, response_id, request_options=request_options)
        return _response.data

    async def update_invite_response(
        self,
        id: str,
        response_id: str,
        *,
        status: InviteResponseStatus,
        data: typing.Optional[typing.Optional[typing.Any]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> InviteResponse:
        """
        Update an invite response using invite ID and response ID

        Parameters
        ----------
        id : str

        response_id : str

        status : InviteResponseStatus

        data : typing.Optional[typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InviteResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.update_invite_response(
                id="id",
                response_id="responseId",
                status="PENDING",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_invite_response(
            id, response_id, status=status, data=data, request_options=request_options
        )
        return _response.data

    async def get_call_metadata_by_invite_id_and_response_id(
        self, id: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CallMetadata:
        """
        Parameters
        ----------
        id : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CallMetadata
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_call_metadata_by_invite_id_and_response_id(
                id="id",
                response_id="responseId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_call_metadata_by_invite_id_and_response_id(
            id, response_id, request_options=request_options
        )
        return _response.data

    async def get_participant_invites(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetParticipantInvitesResponse:
        """
        Get all participant invites for an invite using invite ID

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetParticipantInvitesResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_participant_invites(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_participant_invites(id, request_options=request_options)
        return _response.data

    async def create_participant_invite(
        self,
        id: str,
        *,
        participant: PostApiInvitesIdParticipantInvitesRequestParticipant,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ParticipantInvite:
        """
        Create a participant invite using invite ID

        Parameters
        ----------
        id : str

        participant : PostApiInvitesIdParticipantInvitesRequestParticipant

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ParticipantInvite
            Default Response

        Examples
        --------
        import asyncio

        from keplar import (
            AsyncKeplarApi,
            PostApiInvitesIdParticipantInvitesRequestParticipant,
        )

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.create_participant_invite(
                id="id",
                participant=PostApiInvitesIdParticipantInvitesRequestParticipant(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_participant_invite(
            id, participant=participant, request_options=request_options
        )
        return _response.data

    async def get_participant_invite(
        self, id: str, participant_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ParticipantInvite:
        """
        Get a participant invite using invite ID and participant ID

        Parameters
        ----------
        id : str

        participant_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ParticipantInvite
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_participant_invite(
                id="id",
                participant_id="participantId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_participant_invite(id, participant_id, request_options=request_options)
        return _response.data

    async def update_participant_invite(
        self,
        id: str,
        participant_id: str,
        *,
        code: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ParticipantInvite:
        """
        Update a participant invite using invite ID and participant ID

        Parameters
        ----------
        id : str

        participant_id : str

        code : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ParticipantInvite
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.update_participant_invite(
                id="id",
                participant_id="participantId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_participant_invite(
            id, participant_id, code=code, request_options=request_options
        )
        return _response.data

    async def get_call_metadata_by_invite_id_and_participant_id(
        self, id: str, participant_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CallMetadata:
        """
        Parameters
        ----------
        id : str

        participant_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CallMetadata
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_call_metadata_by_invite_id_and_participant_id(
                id="id",
                participant_id="participantId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_call_metadata_by_invite_id_and_participant_id(
            id, participant_id, request_options=request_options
        )
        return _response.data

    async def get_chat_sessions_for_user(
        self, *, project_id: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[GetApiChatsResponseItem]:
        """
        Get all chat sessions for authenticated user

        Parameters
        ----------
        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[GetApiChatsResponseItem]
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_chat_sessions_for_user()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_chat_sessions_for_user(
            project_id=project_id, request_options=request_options
        )
        return _response.data

    async def create_a_new_chat_session(
        self,
        *,
        message: typing.Optional[str] = OMIT,
        project_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateChatSessionResponse:
        """
        Create a new chat session, optionally with an initial message

        Parameters
        ----------
        message : typing.Optional[str]

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateChatSessionResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.create_a_new_chat_session()


        asyncio.run(main())
        """
        _response = await self._raw_client.create_a_new_chat_session(
            message=message, project_id=project_id, request_options=request_options
        )
        return _response.data

    async def get_chat_history_for_a_specific_session(
        self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetChatSessionResponse:
        """
        Get chat message history and citations for a specific chat session

        Parameters
        ----------
        session_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetChatSessionResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_chat_history_for_a_specific_session(
                session_id="sessionId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_chat_history_for_a_specific_session(
            session_id, request_options=request_options
        )
        return _response.data

    async def update_a_chat_session(
        self,
        session_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PutApiChatsSessionIdResponse:
        """
        Update the name and description of a chat session

        Parameters
        ----------
        session_id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PutApiChatsSessionIdResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.update_a_chat_session(
                session_id="sessionId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_a_chat_session(
            session_id, name=name, description=description, request_options=request_options
        )
        return _response.data

    async def delete_a_chat_session(
        self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteChatSessionResponse:
        """
        Delete a chat session and all its messages

        Parameters
        ----------
        session_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteChatSessionResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.delete_a_chat_session(
                session_id="sessionId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_a_chat_session(session_id, request_options=request_options)
        return _response.data

    async def create_chat_message(
        self,
        session_id: str,
        *,
        message: str,
        project_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SendChatMessageResponse:
        """
        Send a message to analyze transcripts and get AI response

        Parameters
        ----------
        session_id : str

        message : str

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SendChatMessageResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.create_chat_message(
                session_id="sessionId",
                message="message",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_chat_message(
            session_id, message=message, project_id=project_id, request_options=request_options
        )
        return _response.data

    async def post_api_copilotkit(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.post_api_copilotkit()


        asyncio.run(main())
        """
        _response = await self._raw_client.post_api_copilotkit(request_options=request_options)
        return _response.data

    async def upload_a_file(self, *, request_options: typing.Optional[RequestOptions] = None) -> PostApiFilesResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostApiFilesResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.upload_a_file()


        asyncio.run(main())
        """
        _response = await self._raw_client.upload_a_file(request_options=request_options)
        return _response.data

    async def get_file_metadata(self, file_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> File:
        """
        Parameters
        ----------
        file_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        File
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_file_metadata(
                file_id="fileId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_file_metadata(file_id, request_options=request_options)
        return _response.data

    async def delete_a_file(self, file_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        file_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.delete_a_file(
                file_id="fileId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_a_file(file_id, request_options=request_options)
        return _response.data

    async def get_a_signed_url_for_file_access(
        self,
        file_id: str,
        *,
        action: typing.Optional[PostApiFilesFileIdSignedUrlRequestAction] = OMIT,
        expires_in: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PostApiFilesFileIdSignedUrlResponse:
        """
        Parameters
        ----------
        file_id : str

        action : typing.Optional[PostApiFilesFileIdSignedUrlRequestAction]

        expires_in : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostApiFilesFileIdSignedUrlResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_a_signed_url_for_file_access(
                file_id="fileId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_a_signed_url_for_file_access(
            file_id, action=action, expires_in=expires_in, request_options=request_options
        )
        return _response.data

    async def get_files_for_a_project(
        self,
        project_id: str,
        *,
        category: typing.Optional[str] = None,
        page: typing.Optional[float] = None,
        limit: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetApiProjectsProjectIdFilesResponse:
        """
        Parameters
        ----------
        project_id : str

        category : typing.Optional[str]

        page : typing.Optional[float]

        limit : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetApiProjectsProjectIdFilesResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_files_for_a_project(
                project_id="projectId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_files_for_a_project(
            project_id, category=category, page=page, limit=limit, request_options=request_options
        )
        return _response.data

    async def add_an_existing_file_to_a_project(
        self,
        project_id: str,
        *,
        file_id: str,
        category: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        metadata: typing.Optional[ProjectFileMetadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectFile:
        """
        Parameters
        ----------
        project_id : str

        file_id : str

        category : typing.Optional[str]

        description : typing.Optional[str]

        metadata : typing.Optional[ProjectFileMetadata]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectFile
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.add_an_existing_file_to_a_project(
                project_id="projectId",
                file_id="fileId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.add_an_existing_file_to_a_project(
            project_id,
            file_id=file_id,
            category=category,
            description=description,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    async def update_project_file_metadata(
        self,
        project_id: str,
        file_id: str,
        *,
        description: typing.Optional[str] = OMIT,
        metadata: typing.Optional[ProjectFileMetadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectFile:
        """
        Parameters
        ----------
        project_id : str

        file_id : str

        description : typing.Optional[str]

        metadata : typing.Optional[ProjectFileMetadata]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectFile
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.update_project_file_metadata(
                project_id="projectId",
                file_id="fileId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_project_file_metadata(
            project_id, file_id, description=description, metadata=metadata, request_options=request_options
        )
        return _response.data

    async def remove_a_file_from_a_project(
        self, project_id: str, file_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        project_id : str

        file_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.remove_a_file_from_a_project(
                project_id="projectId",
                file_id="fileId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.remove_a_file_from_a_project(
            project_id, file_id, request_options=request_options
        )
        return _response.data

    async def get_threads(
        self,
        *,
        project_id: typing.Optional[str] = None,
        kind: typing.Optional[ThreadKind] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetApiThreadsResponse:
        """
        Parameters
        ----------
        project_id : typing.Optional[str]

        kind : typing.Optional[ThreadKind]

        limit : typing.Optional[int]

        offset : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetApiThreadsResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_threads()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_threads(
            project_id=project_id, kind=kind, limit=limit, offset=offset, request_options=request_options
        )
        return _response.data

    async def upsert_thread(
        self,
        thread_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        kind: typing.Optional[ThreadKind] = OMIT,
        project_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Thread:
        """
        Parameters
        ----------
        thread_id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        kind : typing.Optional[ThreadKind]

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Thread
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.upsert_thread(
                thread_id="threadId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.upsert_thread(
            thread_id,
            name=name,
            description=description,
            metadata=metadata,
            kind=kind,
            project_id=project_id,
            request_options=request_options,
        )
        return _response.data

    async def get_thread_files(
        self,
        thread_id: str,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        file_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetApiThreadsThreadIdFilesResponse:
        """
        Parameters
        ----------
        thread_id : str

        limit : typing.Optional[int]

        offset : typing.Optional[int]

        file_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetApiThreadsThreadIdFilesResponse
            Default Response

        Examples
        --------
        import asyncio

        from keplar import AsyncKeplarApi

        client = AsyncKeplarApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_thread_files(
                thread_id="threadId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_thread_files(
            thread_id, limit=limit, offset=offset, file_names=file_names, request_options=request_options
        )
        return _response.data


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: KeplarApiEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
