# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .open_ai_model_config import OpenAiModelConfig
from .vapi_voice_vapi_provider import VapiVoiceVapiProvider


class VapiAssistantConfig(UniversalBaseModel):
    system_prompt: typing_extensions.Annotated[str, FieldMetadata(alias="systemPrompt")]
    model: OpenAiModelConfig
    first_message: typing_extensions.Annotated[str, FieldMetadata(alias="firstMessage")]
    end_call_message: typing_extensions.Annotated[str, FieldMetadata(alias="endCallMessage")]
    max_duration_seconds: typing_extensions.Annotated[float, FieldMetadata(alias="maxDurationSeconds")]
    voice: VapiVoiceVapiProvider

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
