# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from .core.api_error import ApiError
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .core.http_response import AsyncHttpResponse, HttpResponse
from .core.jsonable_encoder import jsonable_encoder
from .core.pydantic_utilities import parse_obj_as
from .core.request_options import RequestOptions
from .core.serialization import convert_and_respect_annotation_metadata
from .errors.bad_request_error import BadRequestError
from .errors.not_found_error import NotFoundError
from .types.call import Call
from .types.call_metadata import CallMetadata
from .types.code_invite import CodeInvite
from .types.code_invite_response import CodeInviteResponse
from .types.conversation_message import ConversationMessage
from .types.create_chat_session_response import CreateChatSessionResponse
from .types.delete_chat_session_response import DeleteChatSessionResponse
from .types.file import File
from .types.get_api_chats_response_item import GetApiChatsResponseItem
from .types.get_api_invites_id_responses_response import GetApiInvitesIdResponsesResponse
from .types.get_api_projects_project_id_files_response import GetApiProjectsProjectIdFilesResponse
from .types.get_api_projects_response import GetApiProjectsResponse
from .types.get_api_threads_response import GetApiThreadsResponse
from .types.get_api_threads_thread_id_files_response import GetApiThreadsThreadIdFilesResponse
from .types.get_chat_session_response import GetChatSessionResponse
from .types.get_participant_invites_response import GetParticipantInvitesResponse
from .types.get_project_responses_response import GetProjectResponsesResponse
from .types.inbound_call_response import InboundCallResponse
from .types.invite import Invite
from .types.invite_config import InviteConfig
from .types.invite_response import InviteResponse
from .types.invite_response_data import InviteResponseData
from .types.invite_response_kind import InviteResponseKind
from .types.invite_response_status import InviteResponseStatus
from .types.invite_status import InviteStatus
from .types.participant_invite import ParticipantInvite
from .types.phone_call_start_response import PhoneCallStartResponse
from .types.post_api_call_messages_search_response_item import PostApiCallMessagesSearchResponseItem
from .types.post_api_files_file_id_signed_url_request_action import PostApiFilesFileIdSignedUrlRequestAction
from .types.post_api_files_file_id_signed_url_response import PostApiFilesFileIdSignedUrlResponse
from .types.post_api_files_response import PostApiFilesResponse
from .types.post_api_invite_code_code_responses_request_data import PostApiInviteCodeCodeResponsesRequestData
from .types.post_api_invites_id_participant_invites_request_participant import (
    PostApiInvitesIdParticipantInvitesRequestParticipant,
)
from .types.post_api_projects_request_thread_assets_item import PostApiProjectsRequestThreadAssetsItem
from .types.project_config import ProjectConfig
from .types.project_conversation_config import ProjectConversationConfig
from .types.project_file_metadata import ProjectFileMetadata
from .types.project_file_with_url import ProjectFileWithUrl
from .types.project_status import ProjectStatus
from .types.project_test_call_response import ProjectTestCallResponse
from .types.project_with_analytics import ProjectWithAnalytics
from .types.put_api_chats_session_id_response import PutApiChatsSessionIdResponse
from .types.put_api_invite_code_code_responses_response_id_request_data import (
    PutApiInviteCodeCodeResponsesResponseIdRequestData,
)
from .types.put_api_invite_code_code_responses_response_id_update_call_request_call import (
    PutApiInviteCodeCodeResponsesResponseIdUpdateCallRequestCall,
)
from .types.remaining_responses_response import RemainingResponsesResponse
from .types.search_project_transcripts_response import SearchProjectTranscriptsResponse
from .types.send_chat_message_response import SendChatMessageResponse
from .types.thread import Thread
from .types.thread_kind import ThreadKind
from .types.user import User

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawKeplarApi:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_api_auth_google_redirect(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/auth/google/redirect",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_api_auth_google(self, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[None]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/auth/google",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_invite_by_code(
        self,
        code: str,
        *,
        participant_code: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CodeInvite]:
        """
        Get an invite using invite code

        Parameters
        ----------
        code : str

        participant_code : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CodeInvite]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/",
            method="GET",
            params={
                "participantCode": participant_code,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CodeInvite,
                    parse_obj_as(
                        type_=CodeInvite,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_participant_invite_by_code_and_participant_code(
        self, code: str, participant_code: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ParticipantInvite]:
        """
        Get a participant invite using invite code and participant code

        Parameters
        ----------
        code : str

        participant_code : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ParticipantInvite]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/participantCode/{jsonable_encoder(participant_code)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ParticipantInvite,
                    parse_obj_as(
                        type_=ParticipantInvite,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_remaining_responses_count_by_invite_code(
        self, code: str, *, participant_code: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[RemainingResponsesResponse]:
        """
        Get the number of remaining responses for an invite using invite code

        Parameters
        ----------
        code : str

        participant_code : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[RemainingResponsesResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/remainingResponses",
            method="GET",
            params={
                "participantCode": participant_code,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    RemainingResponsesResponse,
                    parse_obj_as(
                        type_=RemainingResponsesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_invite_response_by_invite_code_and_participant_code(
        self, code: str, *, participant_code: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[CodeInviteResponse]:
        """
        Get the invite response for an invite using invite code and participant code

        Parameters
        ----------
        code : str

        participant_code : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CodeInviteResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/participantResponse",
            method="GET",
            params={
                "participantCode": participant_code,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CodeInviteResponse,
                    parse_obj_as(
                        type_=CodeInviteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_invite_response_by_invite_code(
        self,
        code: str,
        *,
        participant_code: typing.Optional[str] = None,
        kind: typing.Optional[InviteResponseKind] = OMIT,
        data: typing.Optional[PostApiInviteCodeCodeResponsesRequestData] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CodeInviteResponse]:
        """
        Create a response for an invite using invite code

        Parameters
        ----------
        code : str

        participant_code : typing.Optional[str]

        kind : typing.Optional[InviteResponseKind]

        data : typing.Optional[PostApiInviteCodeCodeResponsesRequestData]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CodeInviteResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/responses",
            method="POST",
            params={
                "participantCode": participant_code,
            },
            json={
                "kind": kind,
                "data": convert_and_respect_annotation_metadata(
                    object_=data, annotation=PostApiInviteCodeCodeResponsesRequestData, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CodeInviteResponse,
                    parse_obj_as(
                        type_=CodeInviteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_invite_response_by_invite_code(
        self, code: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[CodeInviteResponse]:
        """
        Get a response of an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CodeInviteResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/responses/{jsonable_encoder(response_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CodeInviteResponse,
                    parse_obj_as(
                        type_=CodeInviteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_invite_response_by_invite_code(
        self,
        code: str,
        response_id: str,
        *,
        status: InviteResponseStatus,
        data: typing.Optional[PutApiInviteCodeCodeResponsesResponseIdRequestData] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CodeInviteResponse]:
        """
        Update a response of an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        status : InviteResponseStatus

        data : typing.Optional[PutApiInviteCodeCodeResponsesResponseIdRequestData]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CodeInviteResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/responses/{jsonable_encoder(response_id)}",
            method="PUT",
            json={
                "status": status,
                "data": convert_and_respect_annotation_metadata(
                    object_=data, annotation=PutApiInviteCodeCodeResponsesResponseIdRequestData, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CodeInviteResponse,
                    parse_obj_as(
                        type_=CodeInviteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def start_call_by_invite_code(
        self, code: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[InboundCallResponse]:
        """
        Start a call for an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[InboundCallResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/responses/{jsonable_encoder(response_id)}/startCall",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InboundCallResponse,
                    parse_obj_as(
                        type_=InboundCallResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_call_by_invite_code(
        self,
        code: str,
        response_id: str,
        *,
        call_id: str,
        call: PutApiInviteCodeCodeResponsesResponseIdUpdateCallRequestCall,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.Optional[typing.Any]]:
        """
        Update a call for an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        call_id : str

        call : PutApiInviteCodeCodeResponsesResponseIdUpdateCallRequestCall

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[typing.Any]]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/responses/{jsonable_encoder(response_id)}/updateCall",
            method="PUT",
            json={
                "callId": call_id,
                "call": convert_and_respect_annotation_metadata(
                    object_=call,
                    annotation=PutApiInviteCodeCodeResponsesResponseIdUpdateCallRequestCall,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if _response is None or not _response.text.strip():
                return HttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def start_phone_call_by_invite_code(
        self, code: str, response_id: str, *, phone_number: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PhoneCallStartResponse]:
        """
        Start a phone call for an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        phone_number : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PhoneCallStartResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/responses/{jsonable_encoder(response_id)}/startPhoneCall",
            method="POST",
            json={
                "phoneNumber": phone_number,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PhoneCallStartResponse,
                    parse_obj_as(
                        type_=PhoneCallStartResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_call_metadata_by_invite_code(
        self, code: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[CallMetadata]:
        """
        Get a call metadata of an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CallMetadata]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/responses/{jsonable_encoder(response_id)}/callMetadata",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CallMetadata,
                    parse_obj_as(
                        type_=CallMetadata,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_call_metadata_transcript_insight_by_invite_code(
        self, code: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[CallMetadata]:
        """
        Create a call metadata transcript insight for an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CallMetadata]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/responses/{jsonable_encoder(response_id)}/transcriptInsight",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CallMetadata,
                    parse_obj_as(
                        type_=CallMetadata,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def post_api_vapi_webhook(self, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[None]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/vapi/webhook",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_demo_invite(
        self,
        *,
        name: str,
        company: str,
        email: str,
        invite_code: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[None]:
        """
        Parameters
        ----------
        name : str

        company : str

        email : str

        invite_code : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/demos/createDemoInvite",
            method="POST",
            json={
                "name": name,
                "company": company,
                "email": email,
                "inviteCode": invite_code,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_user(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[User]:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[User]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/users/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    User,
                    parse_obj_as(
                        type_=User,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_projects(
        self,
        *,
        search: typing.Optional[str] = None,
        page: typing.Optional[float] = None,
        limit: typing.Optional[float] = None,
        statuses: typing.Optional[typing.Union[ProjectStatus, typing.Sequence[ProjectStatus]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetApiProjectsResponse]:
        """
        Parameters
        ----------
        search : typing.Optional[str]

        page : typing.Optional[float]

        limit : typing.Optional[float]

        statuses : typing.Optional[typing.Union[ProjectStatus, typing.Sequence[ProjectStatus]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetApiProjectsResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/projects/",
            method="GET",
            params={
                "search": search,
                "page": page,
                "limit": limit,
                "statuses": statuses,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetApiProjectsResponse,
                    parse_obj_as(
                        type_=GetApiProjectsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_project(
        self,
        *,
        name: str,
        config: ProjectConfig,
        conversation_config: ProjectConversationConfig,
        description: typing.Optional[str] = OMIT,
        status: typing.Optional[ProjectStatus] = OMIT,
        thread_assets: typing.Optional[typing.Sequence[PostApiProjectsRequestThreadAssetsItem]] = OMIT,
        thread_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ProjectWithAnalytics]:
        """
        Parameters
        ----------
        name : str

        config : ProjectConfig

        conversation_config : ProjectConversationConfig

        description : typing.Optional[str]

        status : typing.Optional[ProjectStatus]

        thread_assets : typing.Optional[typing.Sequence[PostApiProjectsRequestThreadAssetsItem]]

        thread_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProjectWithAnalytics]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/projects/",
            method="POST",
            json={
                "name": name,
                "description": description,
                "status": status,
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=ProjectConfig, direction="write"
                ),
                "conversationConfig": convert_and_respect_annotation_metadata(
                    object_=conversation_config, annotation=ProjectConversationConfig, direction="write"
                ),
                "threadAssets": convert_and_respect_annotation_metadata(
                    object_=thread_assets,
                    annotation=typing.Sequence[PostApiProjectsRequestThreadAssetsItem],
                    direction="write",
                ),
                "threadId": thread_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProjectWithAnalytics,
                    parse_obj_as(
                        type_=ProjectWithAnalytics,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_project(
        self, project_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ProjectWithAnalytics]:
        """
        Parameters
        ----------
        project_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProjectWithAnalytics]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/projects/{jsonable_encoder(project_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProjectWithAnalytics,
                    parse_obj_as(
                        type_=ProjectWithAnalytics,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_project(
        self,
        project_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        status: typing.Optional[ProjectStatus] = OMIT,
        config: typing.Optional[ProjectConfig] = OMIT,
        conversation_config: typing.Optional[ProjectConversationConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ProjectWithAnalytics]:
        """
        Parameters
        ----------
        project_id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        status : typing.Optional[ProjectStatus]

        config : typing.Optional[ProjectConfig]

        conversation_config : typing.Optional[ProjectConversationConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProjectWithAnalytics]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/projects/{jsonable_encoder(project_id)}",
            method="PUT",
            json={
                "name": name,
                "description": description,
                "status": status,
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=ProjectConfig, direction="write"
                ),
                "conversationConfig": convert_and_respect_annotation_metadata(
                    object_=conversation_config, annotation=ProjectConversationConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProjectWithAnalytics,
                    parse_obj_as(
                        type_=ProjectWithAnalytics,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_project_test_call(
        self, project_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ProjectTestCallResponse]:
        """
        Parameters
        ----------
        project_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProjectTestCallResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/projects/{jsonable_encoder(project_id)}/test-call",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProjectTestCallResponse,
                    parse_obj_as(
                        type_=ProjectTestCallResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_project_responses(
        self,
        project_id: str,
        *,
        page: typing.Optional[float] = None,
        limit: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetProjectResponsesResponse]:
        """
        Parameters
        ----------
        project_id : str

        page : typing.Optional[float]

        limit : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetProjectResponsesResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/projects/{jsonable_encoder(project_id)}/responses",
            method="GET",
            params={
                "page": page,
                "limit": limit,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetProjectResponsesResponse,
                    parse_obj_as(
                        type_=GetProjectResponsesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def search_project_transcripts(
        self,
        project_id: str,
        *,
        page: typing.Optional[float] = OMIT,
        limit: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SearchProjectTranscriptsResponse]:
        """
        Parameters
        ----------
        project_id : str

        page : typing.Optional[float]

        limit : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SearchProjectTranscriptsResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/projects/{jsonable_encoder(project_id)}/searchTranscripts",
            method="POST",
            json={
                "page": page,
                "limit": limit,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SearchProjectTranscriptsResponse,
                    parse_obj_as(
                        type_=SearchProjectTranscriptsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_project_analysis(
        self, project_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        project_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[typing.Any]]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/projects/{jsonable_encoder(project_id)}/analysis",
            method="POST",
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return HttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_project_file_metadata(
        self,
        project_id: str,
        file_id: str,
        *,
        description: typing.Optional[str] = OMIT,
        metadata: typing.Optional[ProjectFileMetadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ProjectFileWithUrl]:
        """
        Parameters
        ----------
        project_id : str

        file_id : str

        description : typing.Optional[str]

        metadata : typing.Optional[ProjectFileMetadata]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProjectFileWithUrl]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/projects/{jsonable_encoder(project_id)}/files/{jsonable_encoder(file_id)}",
            method="PUT",
            json={
                "description": description,
                "metadata": convert_and_respect_annotation_metadata(
                    object_=metadata, annotation=ProjectFileMetadata, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProjectFileWithUrl,
                    parse_obj_as(
                        type_=ProjectFileWithUrl,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def remove_a_file_from_a_project(
        self, project_id: str, file_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Parameters
        ----------
        project_id : str

        file_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/projects/{jsonable_encoder(project_id)}/files/{jsonable_encoder(file_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_files_for_a_project(
        self,
        project_id: str,
        *,
        category: typing.Optional[str] = None,
        page: typing.Optional[float] = None,
        limit: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetApiProjectsProjectIdFilesResponse]:
        """
        Parameters
        ----------
        project_id : str

        category : typing.Optional[str]

        page : typing.Optional[float]

        limit : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetApiProjectsProjectIdFilesResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/projects/{jsonable_encoder(project_id)}/files",
            method="GET",
            params={
                "category": category,
                "page": page,
                "limit": limit,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetApiProjectsProjectIdFilesResponse,
                    parse_obj_as(
                        type_=GetApiProjectsProjectIdFilesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def add_an_existing_file_to_a_project(
        self,
        project_id: str,
        *,
        file_id: str,
        category: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        metadata: typing.Optional[ProjectFileMetadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ProjectFileWithUrl]:
        """
        Parameters
        ----------
        project_id : str

        file_id : str

        category : typing.Optional[str]

        description : typing.Optional[str]

        metadata : typing.Optional[ProjectFileMetadata]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProjectFileWithUrl]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/projects/{jsonable_encoder(project_id)}/files",
            method="POST",
            json={
                "fileId": file_id,
                "category": category,
                "description": description,
                "metadata": convert_and_respect_annotation_metadata(
                    object_=metadata, annotation=ProjectFileMetadata, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProjectFileWithUrl,
                    parse_obj_as(
                        type_=ProjectFileWithUrl,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_call(self, call_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[Call]:
        """
        Get detailed information about a specific call including participant and project data

        Parameters
        ----------
        call_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Call]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/calls/{jsonable_encoder(call_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Call,
                    parse_obj_as(
                        type_=Call,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_conversation_message(
        self, call_id: str, index: float, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ConversationMessage]:
        """
        Parameters
        ----------
        call_id : str

        index : float

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ConversationMessage]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/calls/{jsonable_encoder(call_id)}/messages/{jsonable_encoder(index)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ConversationMessage,
                    parse_obj_as(
                        type_=ConversationMessage,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def search_conversation_messages(
        self,
        *,
        request: typing.Dict[str, typing.Sequence[float]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[PostApiCallMessagesSearchResponseItem]]:
        """
        Parameters
        ----------
        request : typing.Dict[str, typing.Sequence[float]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[PostApiCallMessagesSearchResponseItem]]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/callMessages/search",
            method="POST",
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[PostApiCallMessagesSearchResponseItem],
                    parse_obj_as(
                        type_=typing.List[PostApiCallMessagesSearchResponseItem],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_invite(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[Invite]:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Invite]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Invite,
                    parse_obj_as(
                        type_=Invite,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_invite(
        self,
        id: str,
        *,
        config: InviteConfig,
        status: InviteStatus,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        live_at: typing.Optional[dt.datetime] = OMIT,
        expires_at: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Invite]:
        """
        Parameters
        ----------
        id : str

        config : InviteConfig

        status : InviteStatus

        name : typing.Optional[str]

        description : typing.Optional[str]

        live_at : typing.Optional[dt.datetime]

        expires_at : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Invite]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/",
            method="PUT",
            json={
                "name": name,
                "description": description,
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=InviteConfig, direction="write"
                ),
                "liveAt": live_at,
                "expiresAt": expires_at,
                "status": status,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Invite,
                    parse_obj_as(
                        type_=Invite,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_invite(
        self,
        *,
        name: str,
        config: InviteConfig,
        project_id: str,
        description: typing.Optional[str] = OMIT,
        expires_at: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Invite]:
        """
        Parameters
        ----------
        name : str

        config : InviteConfig

        project_id : str

        description : typing.Optional[str]

        expires_at : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Invite]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/invites/",
            method="POST",
            json={
                "name": name,
                "description": description,
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=InviteConfig, direction="write"
                ),
                "projectId": project_id,
                "expiresAt": expires_at,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Invite,
                    parse_obj_as(
                        type_=Invite,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_invite_responses(
        self,
        id: str,
        *,
        page: typing.Optional[float] = None,
        limit: typing.Optional[float] = None,
        statuses: typing.Optional[typing.Union[InviteResponseStatus, typing.Sequence[InviteResponseStatus]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetApiInvitesIdResponsesResponse]:
        """
        Get all invite responses for an invite using invite ID

        Parameters
        ----------
        id : str

        page : typing.Optional[float]

        limit : typing.Optional[float]

        statuses : typing.Optional[typing.Union[InviteResponseStatus, typing.Sequence[InviteResponseStatus]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetApiInvitesIdResponsesResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/responses",
            method="GET",
            params={
                "page": page,
                "limit": limit,
                "statuses": statuses,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetApiInvitesIdResponsesResponse,
                    parse_obj_as(
                        type_=GetApiInvitesIdResponsesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_invite_response(
        self,
        id: str,
        *,
        kind: typing.Optional[InviteResponseKind] = OMIT,
        participant_invite_code: typing.Optional[str] = OMIT,
        data: typing.Optional[InviteResponseData] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[InviteResponse]:
        """
        Create an invite response using invite ID

        Parameters
        ----------
        id : str

        kind : typing.Optional[InviteResponseKind]

        participant_invite_code : typing.Optional[str]

        data : typing.Optional[InviteResponseData]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[InviteResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/responses",
            method="POST",
            json={
                "kind": kind,
                "participantInviteCode": participant_invite_code,
                "data": convert_and_respect_annotation_metadata(
                    object_=data, annotation=InviteResponseData, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InviteResponse,
                    parse_obj_as(
                        type_=InviteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_invite_response(
        self, id: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[InviteResponse]:
        """
        Get an invite response using invite ID and response ID

        Parameters
        ----------
        id : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[InviteResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/responses/{jsonable_encoder(response_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InviteResponse,
                    parse_obj_as(
                        type_=InviteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_invite_response(
        self,
        id: str,
        response_id: str,
        *,
        status: InviteResponseStatus,
        data: typing.Optional[typing.Optional[typing.Any]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[InviteResponse]:
        """
        Update an invite response using invite ID and response ID

        Parameters
        ----------
        id : str

        response_id : str

        status : InviteResponseStatus

        data : typing.Optional[typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[InviteResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/responses/{jsonable_encoder(response_id)}",
            method="PUT",
            json={
                "status": status,
                "data": data,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InviteResponse,
                    parse_obj_as(
                        type_=InviteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_call_metadata_by_invite_id_and_response_id(
        self, id: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[CallMetadata]:
        """
        Parameters
        ----------
        id : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CallMetadata]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/responses/{jsonable_encoder(response_id)}/callMetadata",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CallMetadata,
                    parse_obj_as(
                        type_=CallMetadata,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_participant_invites(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetParticipantInvitesResponse]:
        """
        Get all participant invites for an invite using invite ID

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetParticipantInvitesResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/participantInvites",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetParticipantInvitesResponse,
                    parse_obj_as(
                        type_=GetParticipantInvitesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_participant_invite(
        self,
        id: str,
        *,
        participant: PostApiInvitesIdParticipantInvitesRequestParticipant,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ParticipantInvite]:
        """
        Create a participant invite using invite ID

        Parameters
        ----------
        id : str

        participant : PostApiInvitesIdParticipantInvitesRequestParticipant

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ParticipantInvite]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/participantInvites",
            method="POST",
            json={
                "participant": convert_and_respect_annotation_metadata(
                    object_=participant,
                    annotation=PostApiInvitesIdParticipantInvitesRequestParticipant,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ParticipantInvite,
                    parse_obj_as(
                        type_=ParticipantInvite,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_participant_invite(
        self, id: str, participant_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ParticipantInvite]:
        """
        Get a participant invite using invite ID and participant ID

        Parameters
        ----------
        id : str

        participant_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ParticipantInvite]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/participantInvites/{jsonable_encoder(participant_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ParticipantInvite,
                    parse_obj_as(
                        type_=ParticipantInvite,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_participant_invite(
        self,
        id: str,
        participant_id: str,
        *,
        code: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ParticipantInvite]:
        """
        Update a participant invite using invite ID and participant ID

        Parameters
        ----------
        id : str

        participant_id : str

        code : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ParticipantInvite]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/participantInvites/{jsonable_encoder(participant_id)}",
            method="PUT",
            json={
                "code": code,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ParticipantInvite,
                    parse_obj_as(
                        type_=ParticipantInvite,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_call_metadata_by_invite_id_and_participant_id(
        self, id: str, participant_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[CallMetadata]:
        """
        Parameters
        ----------
        id : str

        participant_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CallMetadata]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/participants/{jsonable_encoder(participant_id)}/callMetadata",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CallMetadata,
                    parse_obj_as(
                        type_=CallMetadata,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_chat_sessions_for_user(
        self, *, project_id: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[GetApiChatsResponseItem]]:
        """
        Get all chat sessions for authenticated user

        Parameters
        ----------
        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[GetApiChatsResponseItem]]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/chats/",
            method="GET",
            params={
                "projectId": project_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[GetApiChatsResponseItem],
                    parse_obj_as(
                        type_=typing.List[GetApiChatsResponseItem],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_a_new_chat_session(
        self,
        *,
        message: typing.Optional[str] = OMIT,
        project_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CreateChatSessionResponse]:
        """
        Create a new chat session, optionally with an initial message

        Parameters
        ----------
        message : typing.Optional[str]

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CreateChatSessionResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/chats/",
            method="POST",
            json={
                "message": message,
                "projectId": project_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateChatSessionResponse,
                    parse_obj_as(
                        type_=CreateChatSessionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_chat_history_for_a_specific_session(
        self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetChatSessionResponse]:
        """
        Get chat message history and citations for a specific chat session

        Parameters
        ----------
        session_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetChatSessionResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/chats/{jsonable_encoder(session_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetChatSessionResponse,
                    parse_obj_as(
                        type_=GetChatSessionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_a_chat_session(
        self,
        session_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PutApiChatsSessionIdResponse]:
        """
        Update the name and description of a chat session

        Parameters
        ----------
        session_id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PutApiChatsSessionIdResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/chats/{jsonable_encoder(session_id)}",
            method="PUT",
            json={
                "name": name,
                "description": description,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PutApiChatsSessionIdResponse,
                    parse_obj_as(
                        type_=PutApiChatsSessionIdResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_a_chat_session(
        self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DeleteChatSessionResponse]:
        """
        Delete a chat session and all its messages

        Parameters
        ----------
        session_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DeleteChatSessionResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/chats/{jsonable_encoder(session_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeleteChatSessionResponse,
                    parse_obj_as(
                        type_=DeleteChatSessionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_chat_message(
        self,
        session_id: str,
        *,
        message: str,
        project_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SendChatMessageResponse]:
        """
        Send a message to analyze transcripts and get AI response

        Parameters
        ----------
        session_id : str

        message : str

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SendChatMessageResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/chats/{jsonable_encoder(session_id)}/messages",
            method="POST",
            json={
                "message": message,
                "projectId": project_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SendChatMessageResponse,
                    parse_obj_as(
                        type_=SendChatMessageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def post_api_copilotkit(self, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[None]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/copilotkit",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def upload_a_file(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PostApiFilesResponse]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PostApiFilesResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/files/",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostApiFilesResponse,
                    parse_obj_as(
                        type_=PostApiFilesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_file_metadata(
        self, file_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[File]:
        """
        Parameters
        ----------
        file_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[File]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/files/{jsonable_encoder(file_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    File,
                    parse_obj_as(
                        type_=File,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_a_file(
        self, file_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Parameters
        ----------
        file_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/files/{jsonable_encoder(file_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_a_signed_url_for_file_access(
        self,
        file_id: str,
        *,
        action: typing.Optional[PostApiFilesFileIdSignedUrlRequestAction] = OMIT,
        expires_in: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PostApiFilesFileIdSignedUrlResponse]:
        """
        Parameters
        ----------
        file_id : str

        action : typing.Optional[PostApiFilesFileIdSignedUrlRequestAction]

        expires_in : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PostApiFilesFileIdSignedUrlResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/files/{jsonable_encoder(file_id)}/signed-url",
            method="POST",
            json={
                "action": action,
                "expiresIn": expires_in,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostApiFilesFileIdSignedUrlResponse,
                    parse_obj_as(
                        type_=PostApiFilesFileIdSignedUrlResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_threads(
        self,
        *,
        project_id: typing.Optional[str] = None,
        kind: typing.Optional[ThreadKind] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetApiThreadsResponse]:
        """
        Parameters
        ----------
        project_id : typing.Optional[str]

        kind : typing.Optional[ThreadKind]

        limit : typing.Optional[int]

        offset : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetApiThreadsResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/threads/",
            method="GET",
            params={
                "projectId": project_id,
                "kind": kind,
                "limit": limit,
                "offset": offset,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetApiThreadsResponse,
                    parse_obj_as(
                        type_=GetApiThreadsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def upsert_thread(
        self,
        thread_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        kind: typing.Optional[ThreadKind] = OMIT,
        project_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Thread]:
        """
        Parameters
        ----------
        thread_id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        kind : typing.Optional[ThreadKind]

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Thread]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/threads/{jsonable_encoder(thread_id)}",
            method="POST",
            json={
                "name": name,
                "description": description,
                "metadata": metadata,
                "kind": kind,
                "projectId": project_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Thread,
                    parse_obj_as(
                        type_=Thread,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_thread_files(
        self,
        thread_id: str,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        file_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetApiThreadsThreadIdFilesResponse]:
        """
        Parameters
        ----------
        thread_id : str

        limit : typing.Optional[int]

        offset : typing.Optional[int]

        file_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetApiThreadsThreadIdFilesResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/threads/{jsonable_encoder(thread_id)}/files",
            method="GET",
            params={
                "limit": limit,
                "offset": offset,
                "fileNames": file_names,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetApiThreadsThreadIdFilesResponse,
                    parse_obj_as(
                        type_=GetApiThreadsThreadIdFilesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawKeplarApi:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_api_auth_google_redirect(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/auth/google/redirect",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_api_auth_google(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/auth/google",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_invite_by_code(
        self,
        code: str,
        *,
        participant_code: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CodeInvite]:
        """
        Get an invite using invite code

        Parameters
        ----------
        code : str

        participant_code : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CodeInvite]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/",
            method="GET",
            params={
                "participantCode": participant_code,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CodeInvite,
                    parse_obj_as(
                        type_=CodeInvite,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_participant_invite_by_code_and_participant_code(
        self, code: str, participant_code: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ParticipantInvite]:
        """
        Get a participant invite using invite code and participant code

        Parameters
        ----------
        code : str

        participant_code : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ParticipantInvite]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/participantCode/{jsonable_encoder(participant_code)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ParticipantInvite,
                    parse_obj_as(
                        type_=ParticipantInvite,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_remaining_responses_count_by_invite_code(
        self, code: str, *, participant_code: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[RemainingResponsesResponse]:
        """
        Get the number of remaining responses for an invite using invite code

        Parameters
        ----------
        code : str

        participant_code : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[RemainingResponsesResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/remainingResponses",
            method="GET",
            params={
                "participantCode": participant_code,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    RemainingResponsesResponse,
                    parse_obj_as(
                        type_=RemainingResponsesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_invite_response_by_invite_code_and_participant_code(
        self, code: str, *, participant_code: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[CodeInviteResponse]:
        """
        Get the invite response for an invite using invite code and participant code

        Parameters
        ----------
        code : str

        participant_code : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CodeInviteResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/participantResponse",
            method="GET",
            params={
                "participantCode": participant_code,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CodeInviteResponse,
                    parse_obj_as(
                        type_=CodeInviteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_invite_response_by_invite_code(
        self,
        code: str,
        *,
        participant_code: typing.Optional[str] = None,
        kind: typing.Optional[InviteResponseKind] = OMIT,
        data: typing.Optional[PostApiInviteCodeCodeResponsesRequestData] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CodeInviteResponse]:
        """
        Create a response for an invite using invite code

        Parameters
        ----------
        code : str

        participant_code : typing.Optional[str]

        kind : typing.Optional[InviteResponseKind]

        data : typing.Optional[PostApiInviteCodeCodeResponsesRequestData]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CodeInviteResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/responses",
            method="POST",
            params={
                "participantCode": participant_code,
            },
            json={
                "kind": kind,
                "data": convert_and_respect_annotation_metadata(
                    object_=data, annotation=PostApiInviteCodeCodeResponsesRequestData, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CodeInviteResponse,
                    parse_obj_as(
                        type_=CodeInviteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_invite_response_by_invite_code(
        self, code: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[CodeInviteResponse]:
        """
        Get a response of an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CodeInviteResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/responses/{jsonable_encoder(response_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CodeInviteResponse,
                    parse_obj_as(
                        type_=CodeInviteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_invite_response_by_invite_code(
        self,
        code: str,
        response_id: str,
        *,
        status: InviteResponseStatus,
        data: typing.Optional[PutApiInviteCodeCodeResponsesResponseIdRequestData] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CodeInviteResponse]:
        """
        Update a response of an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        status : InviteResponseStatus

        data : typing.Optional[PutApiInviteCodeCodeResponsesResponseIdRequestData]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CodeInviteResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/responses/{jsonable_encoder(response_id)}",
            method="PUT",
            json={
                "status": status,
                "data": convert_and_respect_annotation_metadata(
                    object_=data, annotation=PutApiInviteCodeCodeResponsesResponseIdRequestData, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CodeInviteResponse,
                    parse_obj_as(
                        type_=CodeInviteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def start_call_by_invite_code(
        self, code: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[InboundCallResponse]:
        """
        Start a call for an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[InboundCallResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/responses/{jsonable_encoder(response_id)}/startCall",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InboundCallResponse,
                    parse_obj_as(
                        type_=InboundCallResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_call_by_invite_code(
        self,
        code: str,
        response_id: str,
        *,
        call_id: str,
        call: PutApiInviteCodeCodeResponsesResponseIdUpdateCallRequestCall,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.Optional[typing.Any]]:
        """
        Update a call for an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        call_id : str

        call : PutApiInviteCodeCodeResponsesResponseIdUpdateCallRequestCall

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[typing.Any]]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/responses/{jsonable_encoder(response_id)}/updateCall",
            method="PUT",
            json={
                "callId": call_id,
                "call": convert_and_respect_annotation_metadata(
                    object_=call,
                    annotation=PutApiInviteCodeCodeResponsesResponseIdUpdateCallRequestCall,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if _response is None or not _response.text.strip():
                return AsyncHttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def start_phone_call_by_invite_code(
        self, code: str, response_id: str, *, phone_number: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PhoneCallStartResponse]:
        """
        Start a phone call for an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        phone_number : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PhoneCallStartResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/responses/{jsonable_encoder(response_id)}/startPhoneCall",
            method="POST",
            json={
                "phoneNumber": phone_number,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PhoneCallStartResponse,
                    parse_obj_as(
                        type_=PhoneCallStartResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_call_metadata_by_invite_code(
        self, code: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[CallMetadata]:
        """
        Get a call metadata of an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CallMetadata]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/responses/{jsonable_encoder(response_id)}/callMetadata",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CallMetadata,
                    parse_obj_as(
                        type_=CallMetadata,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_call_metadata_transcript_insight_by_invite_code(
        self, code: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[CallMetadata]:
        """
        Create a call metadata transcript insight for an invite using invite code and response ID

        Parameters
        ----------
        code : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CallMetadata]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/inviteCode/{jsonable_encoder(code)}/responses/{jsonable_encoder(response_id)}/transcriptInsight",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CallMetadata,
                    parse_obj_as(
                        type_=CallMetadata,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def post_api_vapi_webhook(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/vapi/webhook",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_demo_invite(
        self,
        *,
        name: str,
        company: str,
        email: str,
        invite_code: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        name : str

        company : str

        email : str

        invite_code : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/demos/createDemoInvite",
            method="POST",
            json={
                "name": name,
                "company": company,
                "email": email,
                "inviteCode": invite_code,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_user(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[User]:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[User]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/users/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    User,
                    parse_obj_as(
                        type_=User,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_projects(
        self,
        *,
        search: typing.Optional[str] = None,
        page: typing.Optional[float] = None,
        limit: typing.Optional[float] = None,
        statuses: typing.Optional[typing.Union[ProjectStatus, typing.Sequence[ProjectStatus]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetApiProjectsResponse]:
        """
        Parameters
        ----------
        search : typing.Optional[str]

        page : typing.Optional[float]

        limit : typing.Optional[float]

        statuses : typing.Optional[typing.Union[ProjectStatus, typing.Sequence[ProjectStatus]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetApiProjectsResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/projects/",
            method="GET",
            params={
                "search": search,
                "page": page,
                "limit": limit,
                "statuses": statuses,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetApiProjectsResponse,
                    parse_obj_as(
                        type_=GetApiProjectsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_project(
        self,
        *,
        name: str,
        config: ProjectConfig,
        conversation_config: ProjectConversationConfig,
        description: typing.Optional[str] = OMIT,
        status: typing.Optional[ProjectStatus] = OMIT,
        thread_assets: typing.Optional[typing.Sequence[PostApiProjectsRequestThreadAssetsItem]] = OMIT,
        thread_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ProjectWithAnalytics]:
        """
        Parameters
        ----------
        name : str

        config : ProjectConfig

        conversation_config : ProjectConversationConfig

        description : typing.Optional[str]

        status : typing.Optional[ProjectStatus]

        thread_assets : typing.Optional[typing.Sequence[PostApiProjectsRequestThreadAssetsItem]]

        thread_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProjectWithAnalytics]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/projects/",
            method="POST",
            json={
                "name": name,
                "description": description,
                "status": status,
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=ProjectConfig, direction="write"
                ),
                "conversationConfig": convert_and_respect_annotation_metadata(
                    object_=conversation_config, annotation=ProjectConversationConfig, direction="write"
                ),
                "threadAssets": convert_and_respect_annotation_metadata(
                    object_=thread_assets,
                    annotation=typing.Sequence[PostApiProjectsRequestThreadAssetsItem],
                    direction="write",
                ),
                "threadId": thread_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProjectWithAnalytics,
                    parse_obj_as(
                        type_=ProjectWithAnalytics,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_project(
        self, project_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ProjectWithAnalytics]:
        """
        Parameters
        ----------
        project_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProjectWithAnalytics]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/projects/{jsonable_encoder(project_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProjectWithAnalytics,
                    parse_obj_as(
                        type_=ProjectWithAnalytics,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_project(
        self,
        project_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        status: typing.Optional[ProjectStatus] = OMIT,
        config: typing.Optional[ProjectConfig] = OMIT,
        conversation_config: typing.Optional[ProjectConversationConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ProjectWithAnalytics]:
        """
        Parameters
        ----------
        project_id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        status : typing.Optional[ProjectStatus]

        config : typing.Optional[ProjectConfig]

        conversation_config : typing.Optional[ProjectConversationConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProjectWithAnalytics]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/projects/{jsonable_encoder(project_id)}",
            method="PUT",
            json={
                "name": name,
                "description": description,
                "status": status,
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=ProjectConfig, direction="write"
                ),
                "conversationConfig": convert_and_respect_annotation_metadata(
                    object_=conversation_config, annotation=ProjectConversationConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProjectWithAnalytics,
                    parse_obj_as(
                        type_=ProjectWithAnalytics,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_project_test_call(
        self, project_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ProjectTestCallResponse]:
        """
        Parameters
        ----------
        project_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProjectTestCallResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/projects/{jsonable_encoder(project_id)}/test-call",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProjectTestCallResponse,
                    parse_obj_as(
                        type_=ProjectTestCallResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_project_responses(
        self,
        project_id: str,
        *,
        page: typing.Optional[float] = None,
        limit: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetProjectResponsesResponse]:
        """
        Parameters
        ----------
        project_id : str

        page : typing.Optional[float]

        limit : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetProjectResponsesResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/projects/{jsonable_encoder(project_id)}/responses",
            method="GET",
            params={
                "page": page,
                "limit": limit,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetProjectResponsesResponse,
                    parse_obj_as(
                        type_=GetProjectResponsesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def search_project_transcripts(
        self,
        project_id: str,
        *,
        page: typing.Optional[float] = OMIT,
        limit: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SearchProjectTranscriptsResponse]:
        """
        Parameters
        ----------
        project_id : str

        page : typing.Optional[float]

        limit : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SearchProjectTranscriptsResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/projects/{jsonable_encoder(project_id)}/searchTranscripts",
            method="POST",
            json={
                "page": page,
                "limit": limit,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SearchProjectTranscriptsResponse,
                    parse_obj_as(
                        type_=SearchProjectTranscriptsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_project_analysis(
        self, project_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        project_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[typing.Any]]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/projects/{jsonable_encoder(project_id)}/analysis",
            method="POST",
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return AsyncHttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_project_file_metadata(
        self,
        project_id: str,
        file_id: str,
        *,
        description: typing.Optional[str] = OMIT,
        metadata: typing.Optional[ProjectFileMetadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ProjectFileWithUrl]:
        """
        Parameters
        ----------
        project_id : str

        file_id : str

        description : typing.Optional[str]

        metadata : typing.Optional[ProjectFileMetadata]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProjectFileWithUrl]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/projects/{jsonable_encoder(project_id)}/files/{jsonable_encoder(file_id)}",
            method="PUT",
            json={
                "description": description,
                "metadata": convert_and_respect_annotation_metadata(
                    object_=metadata, annotation=ProjectFileMetadata, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProjectFileWithUrl,
                    parse_obj_as(
                        type_=ProjectFileWithUrl,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def remove_a_file_from_a_project(
        self, project_id: str, file_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        project_id : str

        file_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/projects/{jsonable_encoder(project_id)}/files/{jsonable_encoder(file_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_files_for_a_project(
        self,
        project_id: str,
        *,
        category: typing.Optional[str] = None,
        page: typing.Optional[float] = None,
        limit: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetApiProjectsProjectIdFilesResponse]:
        """
        Parameters
        ----------
        project_id : str

        category : typing.Optional[str]

        page : typing.Optional[float]

        limit : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetApiProjectsProjectIdFilesResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/projects/{jsonable_encoder(project_id)}/files",
            method="GET",
            params={
                "category": category,
                "page": page,
                "limit": limit,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetApiProjectsProjectIdFilesResponse,
                    parse_obj_as(
                        type_=GetApiProjectsProjectIdFilesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def add_an_existing_file_to_a_project(
        self,
        project_id: str,
        *,
        file_id: str,
        category: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        metadata: typing.Optional[ProjectFileMetadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ProjectFileWithUrl]:
        """
        Parameters
        ----------
        project_id : str

        file_id : str

        category : typing.Optional[str]

        description : typing.Optional[str]

        metadata : typing.Optional[ProjectFileMetadata]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProjectFileWithUrl]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/projects/{jsonable_encoder(project_id)}/files",
            method="POST",
            json={
                "fileId": file_id,
                "category": category,
                "description": description,
                "metadata": convert_and_respect_annotation_metadata(
                    object_=metadata, annotation=ProjectFileMetadata, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProjectFileWithUrl,
                    parse_obj_as(
                        type_=ProjectFileWithUrl,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_call(
        self, call_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Call]:
        """
        Get detailed information about a specific call including participant and project data

        Parameters
        ----------
        call_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Call]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/calls/{jsonable_encoder(call_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Call,
                    parse_obj_as(
                        type_=Call,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_conversation_message(
        self, call_id: str, index: float, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ConversationMessage]:
        """
        Parameters
        ----------
        call_id : str

        index : float

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ConversationMessage]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/calls/{jsonable_encoder(call_id)}/messages/{jsonable_encoder(index)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ConversationMessage,
                    parse_obj_as(
                        type_=ConversationMessage,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def search_conversation_messages(
        self,
        *,
        request: typing.Dict[str, typing.Sequence[float]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[PostApiCallMessagesSearchResponseItem]]:
        """
        Parameters
        ----------
        request : typing.Dict[str, typing.Sequence[float]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[PostApiCallMessagesSearchResponseItem]]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/callMessages/search",
            method="POST",
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[PostApiCallMessagesSearchResponseItem],
                    parse_obj_as(
                        type_=typing.List[PostApiCallMessagesSearchResponseItem],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_invite(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Invite]:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Invite]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Invite,
                    parse_obj_as(
                        type_=Invite,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_invite(
        self,
        id: str,
        *,
        config: InviteConfig,
        status: InviteStatus,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        live_at: typing.Optional[dt.datetime] = OMIT,
        expires_at: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Invite]:
        """
        Parameters
        ----------
        id : str

        config : InviteConfig

        status : InviteStatus

        name : typing.Optional[str]

        description : typing.Optional[str]

        live_at : typing.Optional[dt.datetime]

        expires_at : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Invite]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/",
            method="PUT",
            json={
                "name": name,
                "description": description,
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=InviteConfig, direction="write"
                ),
                "liveAt": live_at,
                "expiresAt": expires_at,
                "status": status,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Invite,
                    parse_obj_as(
                        type_=Invite,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_invite(
        self,
        *,
        name: str,
        config: InviteConfig,
        project_id: str,
        description: typing.Optional[str] = OMIT,
        expires_at: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Invite]:
        """
        Parameters
        ----------
        name : str

        config : InviteConfig

        project_id : str

        description : typing.Optional[str]

        expires_at : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Invite]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/invites/",
            method="POST",
            json={
                "name": name,
                "description": description,
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=InviteConfig, direction="write"
                ),
                "projectId": project_id,
                "expiresAt": expires_at,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Invite,
                    parse_obj_as(
                        type_=Invite,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_invite_responses(
        self,
        id: str,
        *,
        page: typing.Optional[float] = None,
        limit: typing.Optional[float] = None,
        statuses: typing.Optional[typing.Union[InviteResponseStatus, typing.Sequence[InviteResponseStatus]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetApiInvitesIdResponsesResponse]:
        """
        Get all invite responses for an invite using invite ID

        Parameters
        ----------
        id : str

        page : typing.Optional[float]

        limit : typing.Optional[float]

        statuses : typing.Optional[typing.Union[InviteResponseStatus, typing.Sequence[InviteResponseStatus]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetApiInvitesIdResponsesResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/responses",
            method="GET",
            params={
                "page": page,
                "limit": limit,
                "statuses": statuses,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetApiInvitesIdResponsesResponse,
                    parse_obj_as(
                        type_=GetApiInvitesIdResponsesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_invite_response(
        self,
        id: str,
        *,
        kind: typing.Optional[InviteResponseKind] = OMIT,
        participant_invite_code: typing.Optional[str] = OMIT,
        data: typing.Optional[InviteResponseData] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[InviteResponse]:
        """
        Create an invite response using invite ID

        Parameters
        ----------
        id : str

        kind : typing.Optional[InviteResponseKind]

        participant_invite_code : typing.Optional[str]

        data : typing.Optional[InviteResponseData]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[InviteResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/responses",
            method="POST",
            json={
                "kind": kind,
                "participantInviteCode": participant_invite_code,
                "data": convert_and_respect_annotation_metadata(
                    object_=data, annotation=InviteResponseData, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InviteResponse,
                    parse_obj_as(
                        type_=InviteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_invite_response(
        self, id: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[InviteResponse]:
        """
        Get an invite response using invite ID and response ID

        Parameters
        ----------
        id : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[InviteResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/responses/{jsonable_encoder(response_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InviteResponse,
                    parse_obj_as(
                        type_=InviteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_invite_response(
        self,
        id: str,
        response_id: str,
        *,
        status: InviteResponseStatus,
        data: typing.Optional[typing.Optional[typing.Any]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[InviteResponse]:
        """
        Update an invite response using invite ID and response ID

        Parameters
        ----------
        id : str

        response_id : str

        status : InviteResponseStatus

        data : typing.Optional[typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[InviteResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/responses/{jsonable_encoder(response_id)}",
            method="PUT",
            json={
                "status": status,
                "data": data,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InviteResponse,
                    parse_obj_as(
                        type_=InviteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_call_metadata_by_invite_id_and_response_id(
        self, id: str, response_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[CallMetadata]:
        """
        Parameters
        ----------
        id : str

        response_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CallMetadata]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/responses/{jsonable_encoder(response_id)}/callMetadata",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CallMetadata,
                    parse_obj_as(
                        type_=CallMetadata,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_participant_invites(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetParticipantInvitesResponse]:
        """
        Get all participant invites for an invite using invite ID

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetParticipantInvitesResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/participantInvites",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetParticipantInvitesResponse,
                    parse_obj_as(
                        type_=GetParticipantInvitesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_participant_invite(
        self,
        id: str,
        *,
        participant: PostApiInvitesIdParticipantInvitesRequestParticipant,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ParticipantInvite]:
        """
        Create a participant invite using invite ID

        Parameters
        ----------
        id : str

        participant : PostApiInvitesIdParticipantInvitesRequestParticipant

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ParticipantInvite]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/participantInvites",
            method="POST",
            json={
                "participant": convert_and_respect_annotation_metadata(
                    object_=participant,
                    annotation=PostApiInvitesIdParticipantInvitesRequestParticipant,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ParticipantInvite,
                    parse_obj_as(
                        type_=ParticipantInvite,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_participant_invite(
        self, id: str, participant_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ParticipantInvite]:
        """
        Get a participant invite using invite ID and participant ID

        Parameters
        ----------
        id : str

        participant_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ParticipantInvite]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/participantInvites/{jsonable_encoder(participant_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ParticipantInvite,
                    parse_obj_as(
                        type_=ParticipantInvite,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_participant_invite(
        self,
        id: str,
        participant_id: str,
        *,
        code: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ParticipantInvite]:
        """
        Update a participant invite using invite ID and participant ID

        Parameters
        ----------
        id : str

        participant_id : str

        code : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ParticipantInvite]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/participantInvites/{jsonable_encoder(participant_id)}",
            method="PUT",
            json={
                "code": code,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ParticipantInvite,
                    parse_obj_as(
                        type_=ParticipantInvite,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_call_metadata_by_invite_id_and_participant_id(
        self, id: str, participant_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[CallMetadata]:
        """
        Parameters
        ----------
        id : str

        participant_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CallMetadata]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/invites/{jsonable_encoder(id)}/participants/{jsonable_encoder(participant_id)}/callMetadata",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CallMetadata,
                    parse_obj_as(
                        type_=CallMetadata,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_chat_sessions_for_user(
        self, *, project_id: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[GetApiChatsResponseItem]]:
        """
        Get all chat sessions for authenticated user

        Parameters
        ----------
        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[GetApiChatsResponseItem]]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/chats/",
            method="GET",
            params={
                "projectId": project_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[GetApiChatsResponseItem],
                    parse_obj_as(
                        type_=typing.List[GetApiChatsResponseItem],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_a_new_chat_session(
        self,
        *,
        message: typing.Optional[str] = OMIT,
        project_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CreateChatSessionResponse]:
        """
        Create a new chat session, optionally with an initial message

        Parameters
        ----------
        message : typing.Optional[str]

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CreateChatSessionResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/chats/",
            method="POST",
            json={
                "message": message,
                "projectId": project_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateChatSessionResponse,
                    parse_obj_as(
                        type_=CreateChatSessionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_chat_history_for_a_specific_session(
        self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetChatSessionResponse]:
        """
        Get chat message history and citations for a specific chat session

        Parameters
        ----------
        session_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetChatSessionResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/chats/{jsonable_encoder(session_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetChatSessionResponse,
                    parse_obj_as(
                        type_=GetChatSessionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_a_chat_session(
        self,
        session_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PutApiChatsSessionIdResponse]:
        """
        Update the name and description of a chat session

        Parameters
        ----------
        session_id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PutApiChatsSessionIdResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/chats/{jsonable_encoder(session_id)}",
            method="PUT",
            json={
                "name": name,
                "description": description,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PutApiChatsSessionIdResponse,
                    parse_obj_as(
                        type_=PutApiChatsSessionIdResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_a_chat_session(
        self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DeleteChatSessionResponse]:
        """
        Delete a chat session and all its messages

        Parameters
        ----------
        session_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DeleteChatSessionResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/chats/{jsonable_encoder(session_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeleteChatSessionResponse,
                    parse_obj_as(
                        type_=DeleteChatSessionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_chat_message(
        self,
        session_id: str,
        *,
        message: str,
        project_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SendChatMessageResponse]:
        """
        Send a message to analyze transcripts and get AI response

        Parameters
        ----------
        session_id : str

        message : str

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SendChatMessageResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/chats/{jsonable_encoder(session_id)}/messages",
            method="POST",
            json={
                "message": message,
                "projectId": project_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SendChatMessageResponse,
                    parse_obj_as(
                        type_=SendChatMessageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def post_api_copilotkit(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/copilotkit",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def upload_a_file(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PostApiFilesResponse]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PostApiFilesResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/files/",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostApiFilesResponse,
                    parse_obj_as(
                        type_=PostApiFilesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_file_metadata(
        self, file_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[File]:
        """
        Parameters
        ----------
        file_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[File]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/files/{jsonable_encoder(file_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    File,
                    parse_obj_as(
                        type_=File,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_a_file(
        self, file_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        file_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/files/{jsonable_encoder(file_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_a_signed_url_for_file_access(
        self,
        file_id: str,
        *,
        action: typing.Optional[PostApiFilesFileIdSignedUrlRequestAction] = OMIT,
        expires_in: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PostApiFilesFileIdSignedUrlResponse]:
        """
        Parameters
        ----------
        file_id : str

        action : typing.Optional[PostApiFilesFileIdSignedUrlRequestAction]

        expires_in : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PostApiFilesFileIdSignedUrlResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/files/{jsonable_encoder(file_id)}/signed-url",
            method="POST",
            json={
                "action": action,
                "expiresIn": expires_in,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostApiFilesFileIdSignedUrlResponse,
                    parse_obj_as(
                        type_=PostApiFilesFileIdSignedUrlResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_threads(
        self,
        *,
        project_id: typing.Optional[str] = None,
        kind: typing.Optional[ThreadKind] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetApiThreadsResponse]:
        """
        Parameters
        ----------
        project_id : typing.Optional[str]

        kind : typing.Optional[ThreadKind]

        limit : typing.Optional[int]

        offset : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetApiThreadsResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/threads/",
            method="GET",
            params={
                "projectId": project_id,
                "kind": kind,
                "limit": limit,
                "offset": offset,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetApiThreadsResponse,
                    parse_obj_as(
                        type_=GetApiThreadsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def upsert_thread(
        self,
        thread_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        kind: typing.Optional[ThreadKind] = OMIT,
        project_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Thread]:
        """
        Parameters
        ----------
        thread_id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        kind : typing.Optional[ThreadKind]

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Thread]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/threads/{jsonable_encoder(thread_id)}",
            method="POST",
            json={
                "name": name,
                "description": description,
                "metadata": metadata,
                "kind": kind,
                "projectId": project_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Thread,
                    parse_obj_as(
                        type_=Thread,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_thread_files(
        self,
        thread_id: str,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        file_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetApiThreadsThreadIdFilesResponse]:
        """
        Parameters
        ----------
        thread_id : str

        limit : typing.Optional[int]

        offset : typing.Optional[int]

        file_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetApiThreadsThreadIdFilesResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/threads/{jsonable_encoder(thread_id)}/files",
            method="GET",
            params={
                "limit": limit,
                "offset": offset,
                "fileNames": file_names,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetApiThreadsThreadIdFilesResponse,
                    parse_obj_as(
                        type_=GetApiThreadsThreadIdFilesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
