# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .project_audience import ProjectAudience
from .project_participant_makeup import ProjectParticipantMakeup
from .project_screener_question import ProjectScreenerQuestion
from .project_template_settings import ProjectTemplateSettings
from .prompt_variables import PromptVariables


class ProjectConfig(UniversalBaseModel):
    prompt_variables: typing_extensions.Annotated[PromptVariables, FieldMetadata(alias="promptVariables")]
    learning_plan: typing_extensions.Annotated[str, FieldMetadata(alias="learningPlan")]
    participant_makeup: typing_extensions.Annotated[
        typing.Optional[ProjectParticipantMakeup], FieldMetadata(alias="participantMakeup")
    ] = None
    screener_questions: typing_extensions.Annotated[
        typing.Optional[typing.List[ProjectScreenerQuestion]], FieldMetadata(alias="screenerQuestions")
    ] = None
    template_settings: typing_extensions.Annotated[
        typing.Optional[ProjectTemplateSettings], FieldMetadata(alias="templateSettings")
    ] = None
    audience_settings: typing_extensions.Annotated[
        typing.Optional[ProjectAudience], FieldMetadata(alias="audienceSettings")
    ] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
