# coding: utf-8

"""
    Kernel API

    Access Kernel insights programmatically

    OpenAPI spec version: 0.2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class GeographiesApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def geographies_get(self, country_iso, geo_level, metric_code, start_date, **kwargs):
        """
        Available geographies
        The Geographies endpoint returns information about the available geographies for a given country, geography level, metric, & date combination.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.geographies_get(country_iso, geo_level, metric_code, start_date, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str country_iso: 3-letter country code (required)
        :param str geo_level: Geographic level of granularity (required)
        :param list[str] metric_code: Comma-delimited list of metric codes (required)
        :param date start_date: First date for which metrics are returned (required)
        :param date end_date: Last date included in the timeseries
        :param str crop: Filter response by crop
        :return: list[Geography]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.geographies_get_with_http_info(country_iso, geo_level, metric_code, start_date, **kwargs)
        else:
            (data) = self.geographies_get_with_http_info(country_iso, geo_level, metric_code, start_date, **kwargs)
            return data

    def geographies_get_with_http_info(self, country_iso, geo_level, metric_code, start_date, **kwargs):
        """
        Available geographies
        The Geographies endpoint returns information about the available geographies for a given country, geography level, metric, & date combination.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.geographies_get_with_http_info(country_iso, geo_level, metric_code, start_date, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str country_iso: 3-letter country code (required)
        :param str geo_level: Geographic level of granularity (required)
        :param list[str] metric_code: Comma-delimited list of metric codes (required)
        :param date start_date: First date for which metrics are returned (required)
        :param date end_date: Last date included in the timeseries
        :param str crop: Filter response by crop
        :return: list[Geography]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['country_iso', 'geo_level', 'metric_code', 'start_date', 'end_date', 'crop']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method geographies_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'country_iso' is set
        if ('country_iso' not in params) or (params['country_iso'] is None):
            raise ValueError("Missing the required parameter `country_iso` when calling `geographies_get`")
        # verify the required parameter 'geo_level' is set
        if ('geo_level' not in params) or (params['geo_level'] is None):
            raise ValueError("Missing the required parameter `geo_level` when calling `geographies_get`")
        # verify the required parameter 'metric_code' is set
        if ('metric_code' not in params) or (params['metric_code'] is None):
            raise ValueError("Missing the required parameter `metric_code` when calling `geographies_get`")
        # verify the required parameter 'start_date' is set
        if ('start_date' not in params) or (params['start_date'] is None):
            raise ValueError("Missing the required parameter `start_date` when calling `geographies_get`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'country_iso' in params:
            query_params.append(('country_iso', params['country_iso']))
        if 'geo_level' in params:
            query_params.append(('geo_level', params['geo_level']))
        if 'metric_code' in params:
            query_params.append(('metric_code', params['metric_code']))
            collection_formats['metric_code'] = 'csv'
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))
        if 'crop' in params:
            query_params.append(('crop', params['crop']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/geographies', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[Geography]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def geographies_levels_get(self, country_iso, metric_code, start_date, **kwargs):
        """
        Available geography levels
        The Geography Levels endpoint returns information about the available geography levels for a given country, metric, & date combination.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.geographies_levels_get(country_iso, metric_code, start_date, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str country_iso: 3-letter country code (required)
        :param list[str] metric_code: Comma-delimited list of metric codes (required)
        :param date start_date: First date for which metrics are returned (required)
        :param date end_date: Last date included in the timeseries
        :param str crop: Filter response by crop
        :return: list[GeographyLevel]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.geographies_levels_get_with_http_info(country_iso, metric_code, start_date, **kwargs)
        else:
            (data) = self.geographies_levels_get_with_http_info(country_iso, metric_code, start_date, **kwargs)
            return data

    def geographies_levels_get_with_http_info(self, country_iso, metric_code, start_date, **kwargs):
        """
        Available geography levels
        The Geography Levels endpoint returns information about the available geography levels for a given country, metric, & date combination.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.geographies_levels_get_with_http_info(country_iso, metric_code, start_date, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str country_iso: 3-letter country code (required)
        :param list[str] metric_code: Comma-delimited list of metric codes (required)
        :param date start_date: First date for which metrics are returned (required)
        :param date end_date: Last date included in the timeseries
        :param str crop: Filter response by crop
        :return: list[GeographyLevel]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['country_iso', 'metric_code', 'start_date', 'end_date', 'crop']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method geographies_levels_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'country_iso' is set
        if ('country_iso' not in params) or (params['country_iso'] is None):
            raise ValueError("Missing the required parameter `country_iso` when calling `geographies_levels_get`")
        # verify the required parameter 'metric_code' is set
        if ('metric_code' not in params) or (params['metric_code'] is None):
            raise ValueError("Missing the required parameter `metric_code` when calling `geographies_levels_get`")
        # verify the required parameter 'start_date' is set
        if ('start_date' not in params) or (params['start_date'] is None):
            raise ValueError("Missing the required parameter `start_date` when calling `geographies_levels_get`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'country_iso' in params:
            query_params.append(('country_iso', params['country_iso']))
        if 'metric_code' in params:
            query_params.append(('metric_code', params['metric_code']))
            collection_formats['metric_code'] = 'csv'
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))
        if 'crop' in params:
            query_params.append(('crop', params['crop']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/geographies/levels', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[GeographyLevel]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
