# coding: utf-8

"""
    Kernel API

    Access Kernel insights programmatically

    OpenAPI spec version: 0.2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class MetricsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def forecasts_metadata_get(self, **kwargs):
        """
        Forecast model metadata
        The Forecasts Metadata endpoint returns supporting contextual information about a given forecast model.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.forecasts_metadata_get(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool active: Flag designating whether or not the model is active.
        :param bool primary: Flag designating the primary forecast model
        :param bool secondary: Flag designating the secondary forecast model
        :param str crop: Filter models by a particular crop
        :param list[str] metric_code: Comma-delimited list of metric codes
        :param list[str] model_type: Comma-delimited list of model types
        :return: ForecastMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.forecasts_metadata_get_with_http_info(**kwargs)
        else:
            (data) = self.forecasts_metadata_get_with_http_info(**kwargs)
            return data

    def forecasts_metadata_get_with_http_info(self, **kwargs):
        """
        Forecast model metadata
        The Forecasts Metadata endpoint returns supporting contextual information about a given forecast model.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.forecasts_metadata_get_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool active: Flag designating whether or not the model is active.
        :param bool primary: Flag designating the primary forecast model
        :param bool secondary: Flag designating the secondary forecast model
        :param str crop: Filter models by a particular crop
        :param list[str] metric_code: Comma-delimited list of metric codes
        :param list[str] model_type: Comma-delimited list of model types
        :return: ForecastMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['active', 'primary', 'secondary', 'crop', 'metric_code', 'model_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method forecasts_metadata_get" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'active' in params:
            query_params.append(('active', params['active']))
        if 'primary' in params:
            query_params.append(('primary', params['primary']))
        if 'secondary' in params:
            query_params.append(('secondary', params['secondary']))
        if 'crop' in params:
            query_params.append(('crop', params['crop']))
        if 'metric_code' in params:
            query_params.append(('metric_code', params['metric_code']))
            collection_formats['metric_code'] = 'csv'
        if 'model_type' in params:
            query_params.append(('model_type', params['model_type']))
            collection_formats['model_type'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/forecasts/metadata', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ForecastMetadata',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def metrics_metadata_get(self, **kwargs):
        """
        All available metric names and descriptions
        The Metrics metadata endpoint returns all available metrics, descriptions, UOMs, and other supporting information for a given geography level and crop
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.metrics_metadata_get(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool dropdown_visible: Metric used for dropdowns
        :param str crop: Filter response by crop
        :param str metric_category: Metric category
        :param list[str] metric_type: Comma-delimited list of metric types
        :param list[str] metric_source: Comma-delimited list of metric sources
        :param list[str] metric_code: Comma-delimited list of metric codes
        :return: list[Metric]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.metrics_metadata_get_with_http_info(**kwargs)
        else:
            (data) = self.metrics_metadata_get_with_http_info(**kwargs)
            return data

    def metrics_metadata_get_with_http_info(self, **kwargs):
        """
        All available metric names and descriptions
        The Metrics metadata endpoint returns all available metrics, descriptions, UOMs, and other supporting information for a given geography level and crop
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.metrics_metadata_get_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool dropdown_visible: Metric used for dropdowns
        :param str crop: Filter response by crop
        :param str metric_category: Metric category
        :param list[str] metric_type: Comma-delimited list of metric types
        :param list[str] metric_source: Comma-delimited list of metric sources
        :param list[str] metric_code: Comma-delimited list of metric codes
        :return: list[Metric]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dropdown_visible', 'crop', 'metric_category', 'metric_type', 'metric_source', 'metric_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method metrics_metadata_get" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dropdown_visible' in params:
            query_params.append(('dropdown_visible', params['dropdown_visible']))
        if 'crop' in params:
            query_params.append(('crop', params['crop']))
        if 'metric_category' in params:
            query_params.append(('metric_category', params['metric_category']))
        if 'metric_type' in params:
            query_params.append(('metric_type', params['metric_type']))
            collection_formats['metric_type'] = 'csv'
        if 'metric_source' in params:
            query_params.append(('metric_source', params['metric_source']))
            collection_formats['metric_source'] = 'csv'
        if 'metric_code' in params:
            query_params.append(('metric_code', params['metric_code']))
            collection_formats['metric_code'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/metrics/metadata', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[Metric]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def metrics_table_get(self, metric_code, crop, country_iso, geo_level, start_date, **kwargs):
        """
        Get values for a metric (or group of metrics) for a specific geography, crop, and date (or date range).
        This endpoint returns a table of values, where the rows describe metrics for a specific geography on a specific date for a specific crop.  The list of columns to be included should be specified as a comma delimited list of metric identifiers.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.metrics_table_get(metric_code, crop, country_iso, geo_level, start_date, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] metric_code: Comma-delimited list of metric codes (required)
        :param str crop: Filter response by crop (required)
        :param list[str] country_iso: 3-letter country code (required)
        :param str geo_level: Geographic level of granularity (required)
        :param date start_date: First date for which metrics are returned (required)
        :param date end_date: Last date included in the timeseries
        :param list[str] geo_id: Comma-delimited list of country-specific geography IDs
        :return: Table
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.metrics_table_get_with_http_info(metric_code, crop, country_iso, geo_level, start_date, **kwargs)
        else:
            (data) = self.metrics_table_get_with_http_info(metric_code, crop, country_iso, geo_level, start_date, **kwargs)
            return data

    def metrics_table_get_with_http_info(self, metric_code, crop, country_iso, geo_level, start_date, **kwargs):
        """
        Get values for a metric (or group of metrics) for a specific geography, crop, and date (or date range).
        This endpoint returns a table of values, where the rows describe metrics for a specific geography on a specific date for a specific crop.  The list of columns to be included should be specified as a comma delimited list of metric identifiers.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.metrics_table_get_with_http_info(metric_code, crop, country_iso, geo_level, start_date, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] metric_code: Comma-delimited list of metric codes (required)
        :param str crop: Filter response by crop (required)
        :param list[str] country_iso: 3-letter country code (required)
        :param str geo_level: Geographic level of granularity (required)
        :param date start_date: First date for which metrics are returned (required)
        :param date end_date: Last date included in the timeseries
        :param list[str] geo_id: Comma-delimited list of country-specific geography IDs
        :return: Table
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['metric_code', 'crop', 'country_iso', 'geo_level', 'start_date', 'end_date', 'geo_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method metrics_table_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'metric_code' is set
        if ('metric_code' not in params) or (params['metric_code'] is None):
            raise ValueError("Missing the required parameter `metric_code` when calling `metrics_table_get`")
        # verify the required parameter 'crop' is set
        if ('crop' not in params) or (params['crop'] is None):
            raise ValueError("Missing the required parameter `crop` when calling `metrics_table_get`")
        # verify the required parameter 'country_iso' is set
        if ('country_iso' not in params) or (params['country_iso'] is None):
            raise ValueError("Missing the required parameter `country_iso` when calling `metrics_table_get`")
        # verify the required parameter 'geo_level' is set
        if ('geo_level' not in params) or (params['geo_level'] is None):
            raise ValueError("Missing the required parameter `geo_level` when calling `metrics_table_get`")
        # verify the required parameter 'start_date' is set
        if ('start_date' not in params) or (params['start_date'] is None):
            raise ValueError("Missing the required parameter `start_date` when calling `metrics_table_get`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'metric_code' in params:
            query_params.append(('metric_code', params['metric_code']))
            collection_formats['metric_code'] = 'csv'
        if 'crop' in params:
            query_params.append(('crop', params['crop']))
        if 'country_iso' in params:
            query_params.append(('country_iso', params['country_iso']))
            collection_formats['country_iso'] = 'csv'
        if 'geo_level' in params:
            query_params.append(('geo_level', params['geo_level']))
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))
        if 'geo_id' in params:
            query_params.append(('geo_id', params['geo_id']))
            collection_formats['geo_id'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/metrics/table', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Table',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
