"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

This program source code file is part of KiCad, a free EDA CAD application.

Copyright (C) 2024 Jon Evans <jon@craftyjon.com>
Copyright (C) 2024 KiCad Developers, see AUTHORS.txt for contributors.

This program is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, either version 3 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see <http://www.gnu.org/licenses/>.
"""
from .. import board
import builtins
import collections.abc
from .. import common
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing
DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetBoardStackup(google.protobuf.message.Message):
    """
    Board stackup and properties
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['board', b'board']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['board', b'board']) -> None:
        ...
global___GetBoardStackup = GetBoardStackup

@typing.final
class BoardStackupResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    STACKUP_FIELD_NUMBER: builtins.int

    @property
    def stackup(self) -> board.board_pb2.BoardStackup:
        ...

    def __init__(self, *, stackup: board.board_pb2.BoardStackup | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['stackup', b'stackup']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['stackup', b'stackup']) -> None:
        ...
global___BoardStackupResponse = BoardStackupResponse

@typing.final
class UpdateBoardStackup(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int
    STACKUP_FIELD_NUMBER: builtins.int

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    @property
    def stackup(self) -> board.board_pb2.BoardStackup:
        ...

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=..., stackup: board.board_pb2.BoardStackup | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['board', b'board', 'stackup', b'stackup']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['board', b'board', 'stackup', b'stackup']) -> None:
        ...
global___UpdateBoardStackup = UpdateBoardStackup

@typing.final
class GetGraphicsDefaults(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['board', b'board']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['board', b'board']) -> None:
        ...
global___GetGraphicsDefaults = GetGraphicsDefaults

@typing.final
class GraphicsDefaultsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    DEFAULTS_FIELD_NUMBER: builtins.int

    @property
    def defaults(self) -> board.board_pb2.GraphicsDefaults:
        ...

    def __init__(self, *, defaults: board.board_pb2.GraphicsDefaults | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['defaults', b'defaults']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['defaults', b'defaults']) -> None:
        ...
global___GraphicsDefaultsResponse = GraphicsDefaultsResponse

@typing.final
class GetNets(google.protobuf.message.Message):
    """
    Net management
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int
    NETCLASS_FILTER_FIELD_NUMBER: builtins.int

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    @property
    def netclass_filter(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """If provided, will only return nets that belong to the given netclass.
        If more than one netclass_filter is given, nets belonging to any of the given classes will
        be returned.
        """

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=..., netclass_filter: collections.abc.Iterable[builtins.str] | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['board', b'board']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['board', b'board', 'netclass_filter', b'netclass_filter']) -> None:
        ...
global___GetNets = GetNets

@typing.final
class NetsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NETS_FIELD_NUMBER: builtins.int

    @property
    def nets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[board.board_types_pb2.Net]:
        ...

    def __init__(self, *, nets: collections.abc.Iterable[board.board_types_pb2.Net] | None=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['nets', b'nets']) -> None:
        ...
global___NetsResponse = NetsResponse

@typing.final
class GetItemsByNet(google.protobuf.message.Message):
    """Retrieve all the copper items belonging to a certain net or set of nets
    returns kiapi.common.commands.GetItemsResponse
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    HEADER_FIELD_NUMBER: builtins.int
    TYPES_FIELD_NUMBER: builtins.int
    NET_CODES_FIELD_NUMBER: builtins.int

    @property
    def header(self) -> common.types.base_types_pb2.ItemHeader:
        """Specifies which document to query, which fields to return, etc."""

    @property
    def types(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[common.types.enums_pb2.KiCadObjectType.ValueType]:
        """List of one or more types of items to retreive"""

    @property
    def net_codes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[board.board_types_pb2.NetCode]:
        """A list of net codes to filter items by"""

    def __init__(self, *, header: common.types.base_types_pb2.ItemHeader | None=..., types: collections.abc.Iterable[common.types.enums_pb2.KiCadObjectType.ValueType] | None=..., net_codes: collections.abc.Iterable[board.board_types_pb2.NetCode] | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['header', b'header']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['header', b'header', 'net_codes', b'net_codes', 'types', b'types']) -> None:
        ...
global___GetItemsByNet = GetItemsByNet

@typing.final
class GetItemsByNetClass(google.protobuf.message.Message):
    """Retrieve all the copper items belonging to a certain net class or set of net classes
    returns kiapi.common.commands.GetItemsResponse
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    HEADER_FIELD_NUMBER: builtins.int
    TYPES_FIELD_NUMBER: builtins.int
    NET_CLASSES_FIELD_NUMBER: builtins.int

    @property
    def header(self) -> common.types.base_types_pb2.ItemHeader:
        """Specifies which document to query, which fields to return, etc."""

    @property
    def types(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[common.types.enums_pb2.KiCadObjectType.ValueType]:
        """List of one or more types of items to retreive"""

    @property
    def net_classes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of net class names to filter items by"""

    def __init__(self, *, header: common.types.base_types_pb2.ItemHeader | None=..., types: collections.abc.Iterable[common.types.enums_pb2.KiCadObjectType.ValueType] | None=..., net_classes: collections.abc.Iterable[builtins.str] | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['header', b'header']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['header', b'header', 'net_classes', b'net_classes', 'types', b'types']) -> None:
        ...
global___GetItemsByNetClass = GetItemsByNetClass

@typing.final
class RefillZones(google.protobuf.message.Message):
    """
    Blocking operations

    Refills some or all zones on the board.
    This is a blocking operation; it will return Empty immediately, but KiCad will return
    ApiStatusCode.AS_BUSY to all future API requests until the zone fill has completed.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int
    ZONES_FIELD_NUMBER: builtins.int

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    @property
    def zones(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[common.types.base_types_pb2.KIID]:
        """A list of zones to refill.  If empty, all zones are refilled."""

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=..., zones: collections.abc.Iterable[common.types.base_types_pb2.KIID] | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['board', b'board']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['board', b'board', 'zones', b'zones']) -> None:
        ...
global___RefillZones = RefillZones

@typing.final
class GetPadShapeAsPolygon(google.protobuf.message.Message):
    """
    Utilities

    Computes the polygon representation of a pad, merging any custom shapes together.
    This representation will approximate curves as a series of segments.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int
    PADS_FIELD_NUMBER: builtins.int
    LAYER_FIELD_NUMBER: builtins.int
    layer: board.board_types_pb2.BoardLayer.ValueType
    'The layer to process'

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        """The board to process"""

    @property
    def pads(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[common.types.base_types_pb2.KIID]:
        """A list of one or more pads to process"""

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=..., pads: collections.abc.Iterable[common.types.base_types_pb2.KIID] | None=..., layer: board.board_types_pb2.BoardLayer.ValueType=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['board', b'board']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['board', b'board', 'layer', b'layer', 'pads', b'pads']) -> None:
        ...
global___GetPadShapeAsPolygon = GetPadShapeAsPolygon

@typing.final
class PadShapeAsPolygonResponse(google.protobuf.message.Message):
    """Returned from GetPadShapeAsPolygon.  The pads and polygons repeated fields will have the same length
    and can be treated as a list of tuples.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PADS_FIELD_NUMBER: builtins.int
    POLYGONS_FIELD_NUMBER: builtins.int

    @property
    def pads(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[common.types.base_types_pb2.KIID]:
        """The pads that were processed"""

    @property
    def polygons(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[common.types.base_types_pb2.PolygonWithHoles]:
        """The polygon representation of each pad"""

    def __init__(self, *, pads: collections.abc.Iterable[common.types.base_types_pb2.KIID] | None=..., polygons: collections.abc.Iterable[common.types.base_types_pb2.PolygonWithHoles] | None=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['pads', b'pads', 'polygons', b'polygons']) -> None:
        ...
global___PadShapeAsPolygonResponse = PadShapeAsPolygonResponse

@typing.final
class GetVisibleLayers(google.protobuf.message.Message):
    """PCB editor commands

    returns BoardLayers
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['board', b'board']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['board', b'board']) -> None:
        ...
global___GetVisibleLayers = GetVisibleLayers

@typing.final
class BoardLayerResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    LAYER_FIELD_NUMBER: builtins.int
    layer: board.board_types_pb2.BoardLayer.ValueType

    def __init__(self, *, layer: board.board_types_pb2.BoardLayer.ValueType=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['layer', b'layer']) -> None:
        ...
global___BoardLayerResponse = BoardLayerResponse

@typing.final
class BoardLayers(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    LAYERS_FIELD_NUMBER: builtins.int

    @property
    def layers(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[board.board_types_pb2.BoardLayer.ValueType]:
        ...

    def __init__(self, *, layers: collections.abc.Iterable[board.board_types_pb2.BoardLayer.ValueType] | None=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['layers', b'layers']) -> None:
        ...
global___BoardLayers = BoardLayers

@typing.final
class SetVisibleLayers(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int
    LAYERS_FIELD_NUMBER: builtins.int

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    @property
    def layers(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[board.board_types_pb2.BoardLayer.ValueType]:
        ...

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=..., layers: collections.abc.Iterable[board.board_types_pb2.BoardLayer.ValueType] | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['board', b'board']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['board', b'board', 'layers', b'layers']) -> None:
        ...
global___SetVisibleLayers = SetVisibleLayers

@typing.final
class GetActiveLayer(google.protobuf.message.Message):
    """returns BoardLayerResponse"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['board', b'board']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['board', b'board']) -> None:
        ...
global___GetActiveLayer = GetActiveLayer

@typing.final
class SetActiveLayer(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int
    LAYER_FIELD_NUMBER: builtins.int
    layer: board.board_types_pb2.BoardLayer.ValueType

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=..., layer: board.board_types_pb2.BoardLayer.ValueType=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['board', b'board']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['board', b'board', 'layer', b'layer']) -> None:
        ...
global___SetActiveLayer = SetActiveLayer

@typing.final
class InteractiveMoveItems(google.protobuf.message.Message):
    """// Interactive commands ////
    These commands begin an interactive operation in the editor.
    They return a response immediately, but the editor will become busy
    and will not reply to further API commands until the user has finished
    the operation.
    These commands will return an error if received in a non-interactive context.

    Selects and begins an interactive move of the given item(s).
    NOTE: Takes ownership of the active commit, if one exists:
          the move tool will push the commit when the user confirms the move,
          or roll back the commit if the user cancels the move.  Keep this in
          mind if using this command in combination with commands that create
          or modify items using an explicit commit.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int
    ITEMS_FIELD_NUMBER: builtins.int

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    @property
    def items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[common.types.base_types_pb2.KIID]:
        ...

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=..., items: collections.abc.Iterable[common.types.base_types_pb2.KIID] | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['board', b'board']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['board', b'board', 'items', b'items']) -> None:
        ...
global___InteractiveMoveItems = InteractiveMoveItems