"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Commands and responses related to manipulating editor windows
"""
import builtins
import collections.abc
from ... import common
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing
if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions
DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _RunActionStatus:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _RunActionStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_RunActionStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    RAS_UNKNOWN: _RunActionStatus.ValueType
    RAS_OK: _RunActionStatus.ValueType
    'The action was submitted successfully.'
    RAS_INVALID: _RunActionStatus.ValueType
    'The action was unknown for the targeted frame.'
    RAS_FRAME_NOT_OPEN: _RunActionStatus.ValueType
    'The targeted frame was not open when the call was submitted.'

class RunActionStatus(_RunActionStatus, metaclass=_RunActionStatusEnumTypeWrapper):
    ...
RAS_UNKNOWN: RunActionStatus.ValueType
RAS_OK: RunActionStatus.ValueType
'The action was submitted successfully.'
RAS_INVALID: RunActionStatus.ValueType
'The action was unknown for the targeted frame.'
RAS_FRAME_NOT_OPEN: RunActionStatus.ValueType
'The targeted frame was not open when the call was submitted.'
global___RunActionStatus = RunActionStatus

class _CommitAction:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CommitActionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_CommitAction.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CMA_UNKNOWN: _CommitAction.ValueType
    CMA_COMMIT: _CommitAction.ValueType
    'Commit the changes to the design'
    CMA_DROP: _CommitAction.ValueType
    'Cancel this commit'

class CommitAction(_CommitAction, metaclass=_CommitActionEnumTypeWrapper):
    ...
CMA_UNKNOWN: CommitAction.ValueType
CMA_COMMIT: CommitAction.ValueType
'Commit the changes to the design'
CMA_DROP: CommitAction.ValueType
'Cancel this commit'
global___CommitAction = CommitAction

class _ItemStatusCode:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ItemStatusCodeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ItemStatusCode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ISC_UNKNOWN: _ItemStatusCode.ValueType
    ISC_OK: _ItemStatusCode.ValueType
    'The item was created or updated'
    ISC_INVALID_TYPE: _ItemStatusCode.ValueType
    "The item's type is not valid for the given document"
    ISC_EXISTING: _ItemStatusCode.ValueType
    'The item to be created had a specified KIID and that KIID was already in use'
    ISC_NONEXISTENT: _ItemStatusCode.ValueType
    'The item to be updated did not exist in the given document'
    ISC_IMMUTABLE: _ItemStatusCode.ValueType
    'The item to be updated is not allowed to be modified by the API'
    ISC_INVALID_DATA: _ItemStatusCode.ValueType
    'The item to be created does not have valid data for the given document'

class ItemStatusCode(_ItemStatusCode, metaclass=_ItemStatusCodeEnumTypeWrapper):
    ...
ISC_UNKNOWN: ItemStatusCode.ValueType
ISC_OK: ItemStatusCode.ValueType
'The item was created or updated'
ISC_INVALID_TYPE: ItemStatusCode.ValueType
"The item's type is not valid for the given document"
ISC_EXISTING: ItemStatusCode.ValueType
'The item to be created had a specified KIID and that KIID was already in use'
ISC_NONEXISTENT: ItemStatusCode.ValueType
'The item to be updated did not exist in the given document'
ISC_IMMUTABLE: ItemStatusCode.ValueType
'The item to be updated is not allowed to be modified by the API'
ISC_INVALID_DATA: ItemStatusCode.ValueType
'The item to be created does not have valid data for the given document'
global___ItemStatusCode = ItemStatusCode

class _ItemDeletionStatus:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ItemDeletionStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ItemDeletionStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    IDS_UNKNOWN: _ItemDeletionStatus.ValueType
    IDS_OK: _ItemDeletionStatus.ValueType
    IDS_NONEXISTENT: _ItemDeletionStatus.ValueType
    'The item did not exist in the given document'
    IDS_IMMUTABLE: _ItemDeletionStatus.ValueType
    'The item is not allowed to be modified by the API'

class ItemDeletionStatus(_ItemDeletionStatus, metaclass=_ItemDeletionStatusEnumTypeWrapper):
    ...
IDS_UNKNOWN: ItemDeletionStatus.ValueType
IDS_OK: ItemDeletionStatus.ValueType
IDS_NONEXISTENT: ItemDeletionStatus.ValueType
'The item did not exist in the given document'
IDS_IMMUTABLE: ItemDeletionStatus.ValueType
'The item is not allowed to be modified by the API'
global___ItemDeletionStatus = ItemDeletionStatus

class _BoundingBoxMode:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _BoundingBoxModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_BoundingBoxMode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    BBM_UNKNOWN: _BoundingBoxMode.ValueType
    BBM_ITEM_ONLY: _BoundingBoxMode.ValueType
    BBM_ITEM_AND_CHILD_TEXT: _BoundingBoxMode.ValueType

class BoundingBoxMode(_BoundingBoxMode, metaclass=_BoundingBoxModeEnumTypeWrapper):
    ...
BBM_UNKNOWN: BoundingBoxMode.ValueType
BBM_ITEM_ONLY: BoundingBoxMode.ValueType
BBM_ITEM_AND_CHILD_TEXT: BoundingBoxMode.ValueType
global___BoundingBoxMode = BoundingBoxMode

class _HitTestResult:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _HitTestResultEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_HitTestResult.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    HTR_UNKNOWN: _HitTestResult.ValueType
    HTR_NO_HIT: _HitTestResult.ValueType
    HTR_HIT: _HitTestResult.ValueType

class HitTestResult(_HitTestResult, metaclass=_HitTestResultEnumTypeWrapper):
    ...
HTR_UNKNOWN: HitTestResult.ValueType
HTR_NO_HIT: HitTestResult.ValueType
HTR_HIT: HitTestResult.ValueType
global___HitTestResult = HitTestResult

@typing.final
class RefreshEditor(google.protobuf.message.Message):
    """Refreshes the given frame, if that frame is open"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    FRAME_FIELD_NUMBER: builtins.int
    frame: common.types.base_types_pb2.FrameType.ValueType

    def __init__(self, *, frame: common.types.base_types_pb2.FrameType.ValueType=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['frame', b'frame']) -> None:
        ...
global___RefreshEditor = RefreshEditor

@typing.final
class GetOpenDocuments(google.protobuf.message.Message):
    """Retrieves a list of open documents of the given type"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TYPE_FIELD_NUMBER: builtins.int
    type: common.types.base_types_pb2.DocumentType.ValueType
    'Which type of documents to query'

    def __init__(self, *, type: common.types.base_types_pb2.DocumentType.ValueType=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['type', b'type']) -> None:
        ...
global___GetOpenDocuments = GetOpenDocuments

@typing.final
class GetOpenDocumentsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    DOCUMENTS_FIELD_NUMBER: builtins.int

    @property
    def documents(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[common.types.base_types_pb2.DocumentSpecifier]:
        ...

    def __init__(self, *, documents: collections.abc.Iterable[common.types.base_types_pb2.DocumentSpecifier] | None=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['documents', b'documents']) -> None:
        ...
global___GetOpenDocumentsResponse = GetOpenDocumentsResponse

@typing.final
class RunAction(google.protobuf.message.Message):
    """
    Runs a TOOL_ACTION using the TOOL_MANAGER of a given frame.
    WARNING: The TOOL_ACTIONs are specifically *not* an API.
    Command names may change as code is refactored, and commands may disappear.
    This API method is provided for low-level prototyping purposes only.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ACTION_FIELD_NUMBER: builtins.int
    action: builtins.str
    'Action name, like "eeschema.InteractiveSelection.ClearSelection" '

    def __init__(self, *, action: builtins.str=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['action', b'action']) -> None:
        ...
global___RunAction = RunAction

@typing.final
class RunActionResponse(google.protobuf.message.Message):
    """
    NOTE: At the moment, RAS_FRAME_NOT_OPEN won't be returned as the handler is inside the frame.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    STATUS_FIELD_NUMBER: builtins.int
    status: global___RunActionStatus.ValueType

    def __init__(self, *, status: global___RunActionStatus.ValueType=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['status', b'status']) -> None:
        ...
global___RunActionResponse = RunActionResponse

@typing.final
class BeginCommit(google.protobuf.message.Message):
    """
    Begins a staged set of changes.  Any modifications made to a document through the API after this
    call will be saved to a pending commit, and will not appear in KiCad until a matching call to
    END_COMMIT.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(self) -> None:
        ...
global___BeginCommit = BeginCommit

@typing.final
class BeginCommitResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int

    @property
    def id(self) -> common.types.base_types_pb2.KIID:
        """Opaque identifier tracking a commit"""

    def __init__(self, *, id: common.types.base_types_pb2.KIID | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['id', b'id']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['id', b'id']) -> None:
        ...
global___BeginCommitResponse = BeginCommitResponse

@typing.final
class EndCommit(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    action: global___CommitAction.ValueType
    'What to do with this commit'
    message: builtins.str
    'Optional message describing this changeset'

    @property
    def id(self) -> common.types.base_types_pb2.KIID:
        """The ID that was given by BeginCommit"""

    def __init__(self, *, id: common.types.base_types_pb2.KIID | None=..., action: global___CommitAction.ValueType=..., message: builtins.str=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['id', b'id']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['action', b'action', 'id', b'id', 'message', b'message']) -> None:
        ...
global___EndCommit = EndCommit

@typing.final
class EndCommitResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(self) -> None:
        ...
global___EndCommitResponse = EndCommitResponse

@typing.final
class CreateItems(google.protobuf.message.Message):
    """Creates new items on a given document"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    HEADER_FIELD_NUMBER: builtins.int
    ITEMS_FIELD_NUMBER: builtins.int
    CONTAINER_FIELD_NUMBER: builtins.int

    @property
    def header(self) -> common.types.base_types_pb2.ItemHeader:
        """Specifies which document to create on, which fields are included, etc."""

    @property
    def items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.any_pb2.Any]:
        """List of items to create"""

    @property
    def container(self) -> common.types.base_types_pb2.KIID:
        """Items may be created on a top-level document (sheet, board, etc) or inside a container
        (symbol, footprint).  If this field is not empty, it holds the ID of a symbol or footprint
        that the items should be added to.  This ID must be an existing symbol (for schematic
        documents) or footprint (for board documents).  If the given container does not exist or is
        not the correct item type, the CreateItems call will fail.
        """

    def __init__(self, *, header: common.types.base_types_pb2.ItemHeader | None=..., items: collections.abc.Iterable[google.protobuf.any_pb2.Any] | None=..., container: common.types.base_types_pb2.KIID | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['container', b'container', 'header', b'header']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['container', b'container', 'header', b'header', 'items', b'items']) -> None:
        ...
global___CreateItems = CreateItems

@typing.final
class ItemStatus(google.protobuf.message.Message):
    """Per-item status feedback for creation and update calls"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CODE_FIELD_NUMBER: builtins.int
    ERROR_MESSAGE_FIELD_NUMBER: builtins.int
    code: global___ItemStatusCode.ValueType
    error_message: builtins.str

    def __init__(self, *, code: global___ItemStatusCode.ValueType=..., error_message: builtins.str=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['code', b'code', 'error_message', b'error_message']) -> None:
        ...
global___ItemStatus = ItemStatus

@typing.final
class ItemCreationResult(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    STATUS_FIELD_NUMBER: builtins.int
    ITEM_FIELD_NUMBER: builtins.int

    @property
    def status(self) -> global___ItemStatus:
        ...

    @property
    def item(self) -> google.protobuf.any_pb2.Any:
        """The created version of the item, including an updated KIID as applicable"""

    def __init__(self, *, status: global___ItemStatus | None=..., item: google.protobuf.any_pb2.Any | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['item', b'item', 'status', b'status']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['item', b'item', 'status', b'status']) -> None:
        ...
global___ItemCreationResult = ItemCreationResult

@typing.final
class CreateItemsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    HEADER_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CREATED_ITEMS_FIELD_NUMBER: builtins.int
    status: common.types.base_types_pb2.ItemRequestStatus.ValueType
    'Status of the overall request; may return IRS_OK even if no items were created'

    @property
    def header(self) -> common.types.base_types_pb2.ItemHeader:
        """Specifies which document was modified, which fields are included in created_items, etc."""

    @property
    def created_items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ItemCreationResult]:
        """Status of each item to be created"""

    def __init__(self, *, header: common.types.base_types_pb2.ItemHeader | None=..., status: common.types.base_types_pb2.ItemRequestStatus.ValueType=..., created_items: collections.abc.Iterable[global___ItemCreationResult] | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['header', b'header']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['created_items', b'created_items', 'header', b'header', 'status', b'status']) -> None:
        ...
global___CreateItemsResponse = CreateItemsResponse

@typing.final
class GetItems(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    HEADER_FIELD_NUMBER: builtins.int
    TYPES_FIELD_NUMBER: builtins.int

    @property
    def header(self) -> common.types.base_types_pb2.ItemHeader:
        """Specifies which document to query, which fields to return, etc."""

    @property
    def types(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[common.types.enums_pb2.KiCadObjectType.ValueType]:
        """List of one or more types of items to retreive"""

    def __init__(self, *, header: common.types.base_types_pb2.ItemHeader | None=..., types: collections.abc.Iterable[common.types.enums_pb2.KiCadObjectType.ValueType] | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['header', b'header']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['header', b'header', 'types', b'types']) -> None:
        ...
global___GetItems = GetItems

@typing.final
class GetItemsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    HEADER_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    ITEMS_FIELD_NUMBER: builtins.int
    status: common.types.base_types_pb2.ItemRequestStatus.ValueType
    'Status of the overall request; may return IRS_OK even if no items were retrieved'

    @property
    def header(self) -> common.types.base_types_pb2.ItemHeader:
        """Specifies which document was modified, which fields are included in items, etc."""

    @property
    def items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.any_pb2.Any]:
        ...

    def __init__(self, *, header: common.types.base_types_pb2.ItemHeader | None=..., status: common.types.base_types_pb2.ItemRequestStatus.ValueType=..., items: collections.abc.Iterable[google.protobuf.any_pb2.Any] | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['header', b'header']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['header', b'header', 'items', b'items', 'status', b'status']) -> None:
        ...
global___GetItemsResponse = GetItemsResponse

@typing.final
class UpdateItems(google.protobuf.message.Message):
    """Updates items in a given document"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    HEADER_FIELD_NUMBER: builtins.int
    ITEMS_FIELD_NUMBER: builtins.int

    @property
    def header(self) -> common.types.base_types_pb2.ItemHeader:
        """Specifies which document to modify, which fields are included, etc."""

    @property
    def items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.any_pb2.Any]:
        """List of items to modify"""

    def __init__(self, *, header: common.types.base_types_pb2.ItemHeader | None=..., items: collections.abc.Iterable[google.protobuf.any_pb2.Any] | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['header', b'header']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['header', b'header', 'items', b'items']) -> None:
        ...
global___UpdateItems = UpdateItems

@typing.final
class ItemUpdateResult(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    STATUS_FIELD_NUMBER: builtins.int
    ITEM_FIELD_NUMBER: builtins.int

    @property
    def status(self) -> global___ItemStatus:
        ...

    @property
    def item(self) -> google.protobuf.any_pb2.Any:
        """The update version of the item"""

    def __init__(self, *, status: global___ItemStatus | None=..., item: google.protobuf.any_pb2.Any | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['item', b'item', 'status', b'status']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['item', b'item', 'status', b'status']) -> None:
        ...
global___ItemUpdateResult = ItemUpdateResult

@typing.final
class UpdateItemsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    HEADER_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    UPDATED_ITEMS_FIELD_NUMBER: builtins.int
    status: common.types.base_types_pb2.ItemRequestStatus.ValueType
    'Status of the overall request; may return IRS_OK even if no items were modified'

    @property
    def header(self) -> common.types.base_types_pb2.ItemHeader:
        """Specifies which document was modified, which fields are included in updated_items, etc."""

    @property
    def updated_items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ItemUpdateResult]:
        """Status of each item to be created"""

    def __init__(self, *, header: common.types.base_types_pb2.ItemHeader | None=..., status: common.types.base_types_pb2.ItemRequestStatus.ValueType=..., updated_items: collections.abc.Iterable[global___ItemUpdateResult] | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['header', b'header']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['header', b'header', 'status', b'status', 'updated_items', b'updated_items']) -> None:
        ...
global___UpdateItemsResponse = UpdateItemsResponse

@typing.final
class DeleteItems(google.protobuf.message.Message):
    """Deletes items in a given document"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    HEADER_FIELD_NUMBER: builtins.int
    ITEM_IDS_FIELD_NUMBER: builtins.int

    @property
    def header(self) -> common.types.base_types_pb2.ItemHeader:
        """Specifies which document to modify"""

    @property
    def item_ids(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[common.types.base_types_pb2.KIID]:
        """List of item KIIDs to delete"""

    def __init__(self, *, header: common.types.base_types_pb2.ItemHeader | None=..., item_ids: collections.abc.Iterable[common.types.base_types_pb2.KIID] | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['header', b'header']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['header', b'header', 'item_ids', b'item_ids']) -> None:
        ...
global___DeleteItems = DeleteItems

@typing.final
class ItemDeletionResult(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    status: global___ItemDeletionStatus.ValueType

    @property
    def id(self) -> common.types.base_types_pb2.KIID:
        ...

    def __init__(self, *, id: common.types.base_types_pb2.KIID | None=..., status: global___ItemDeletionStatus.ValueType=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['id', b'id']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['id', b'id', 'status', b'status']) -> None:
        ...
global___ItemDeletionResult = ItemDeletionResult

@typing.final
class DeleteItemsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    HEADER_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    DELETED_ITEMS_FIELD_NUMBER: builtins.int
    status: common.types.base_types_pb2.ItemRequestStatus.ValueType
    'Status of the overall request; may return IRS_OK even if no items were deleted'

    @property
    def header(self) -> common.types.base_types_pb2.ItemHeader:
        """Specifies which document was modified, etc."""

    @property
    def deleted_items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ItemDeletionResult]:
        """Status of each item requested to be deleted"""

    def __init__(self, *, header: common.types.base_types_pb2.ItemHeader | None=..., status: common.types.base_types_pb2.ItemRequestStatus.ValueType=..., deleted_items: collections.abc.Iterable[global___ItemDeletionResult] | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['header', b'header']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['deleted_items', b'deleted_items', 'header', b'header', 'status', b'status']) -> None:
        ...
global___DeleteItemsResponse = DeleteItemsResponse

@typing.final
class GetBoundingBox(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    HEADER_FIELD_NUMBER: builtins.int
    ITEMS_FIELD_NUMBER: builtins.int
    MODE_FIELD_NUMBER: builtins.int
    mode: global___BoundingBoxMode.ValueType
    'Some item types can have independently-movable text as children (e.g. footprints)\n    This mode controls whether or not these are included in the box\n    '

    @property
    def header(self) -> common.types.base_types_pb2.ItemHeader:
        ...

    @property
    def items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[common.types.base_types_pb2.KIID]:
        ...

    def __init__(self, *, header: common.types.base_types_pb2.ItemHeader | None=..., items: collections.abc.Iterable[common.types.base_types_pb2.KIID] | None=..., mode: global___BoundingBoxMode.ValueType=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['header', b'header']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['header', b'header', 'items', b'items', 'mode', b'mode']) -> None:
        ...
global___GetBoundingBox = GetBoundingBox

@typing.final
class GetBoundingBoxResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ITEMS_FIELD_NUMBER: builtins.int
    BOXES_FIELD_NUMBER: builtins.int

    @property
    def items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[common.types.base_types_pb2.KIID]:
        ...

    @property
    def boxes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[common.types.base_types_pb2.Box2]:
        ...

    def __init__(self, *, items: collections.abc.Iterable[common.types.base_types_pb2.KIID] | None=..., boxes: collections.abc.Iterable[common.types.base_types_pb2.Box2] | None=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['boxes', b'boxes', 'items', b'items']) -> None:
        ...
global___GetBoundingBoxResponse = GetBoundingBoxResponse

@typing.final
class HitTest(google.protobuf.message.Message):
    """Tests if a certain point falls within tolerance of an item's geometry"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    HEADER_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    POSITION_FIELD_NUMBER: builtins.int
    TOLERANCE_FIELD_NUMBER: builtins.int
    tolerance: builtins.int

    @property
    def header(self) -> common.types.base_types_pb2.ItemHeader:
        ...

    @property
    def id(self) -> common.types.base_types_pb2.KIID:
        ...

    @property
    def position(self) -> common.types.base_types_pb2.Vector2:
        ...

    def __init__(self, *, header: common.types.base_types_pb2.ItemHeader | None=..., id: common.types.base_types_pb2.KIID | None=..., position: common.types.base_types_pb2.Vector2 | None=..., tolerance: builtins.int=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['header', b'header', 'id', b'id', 'position', b'position']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['header', b'header', 'id', b'id', 'position', b'position', 'tolerance', b'tolerance']) -> None:
        ...
global___HitTest = HitTest

@typing.final
class HitTestResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    RESULT_FIELD_NUMBER: builtins.int
    result: global___HitTestResult.ValueType

    def __init__(self, *, result: global___HitTestResult.ValueType=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['result', b'result']) -> None:
        ...
global___HitTestResponse = HitTestResponse

@typing.final
class GetTitleBlockInfo(google.protobuf.message.Message):
    """returns common.types.TitleBlockInfo"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    DOCUMENT_FIELD_NUMBER: builtins.int

    @property
    def document(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    def __init__(self, *, document: common.types.base_types_pb2.DocumentSpecifier | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['document', b'document']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['document', b'document']) -> None:
        ...
global___GetTitleBlockInfo = GetTitleBlockInfo

@typing.final
class SaveDocumentToString(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    DOCUMENT_FIELD_NUMBER: builtins.int

    @property
    def document(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    def __init__(self, *, document: common.types.base_types_pb2.DocumentSpecifier | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['document', b'document']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['document', b'document']) -> None:
        ...
global___SaveDocumentToString = SaveDocumentToString

@typing.final
class SavedDocumentResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    DOCUMENT_FIELD_NUMBER: builtins.int
    CONTENTS_FIELD_NUMBER: builtins.int
    contents: builtins.str

    @property
    def document(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    def __init__(self, *, document: common.types.base_types_pb2.DocumentSpecifier | None=..., contents: builtins.str=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['document', b'document']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['contents', b'contents', 'document', b'document']) -> None:
        ...
global___SavedDocumentResponse = SavedDocumentResponse

@typing.final
class SaveSelectionToString(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(self) -> None:
        ...
global___SaveSelectionToString = SaveSelectionToString

@typing.final
class SavedSelectionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    IDS_FIELD_NUMBER: builtins.int
    CONTENTS_FIELD_NUMBER: builtins.int
    contents: builtins.str

    @property
    def ids(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[common.types.base_types_pb2.KIID]:
        ...

    def __init__(self, *, ids: collections.abc.Iterable[common.types.base_types_pb2.KIID] | None=..., contents: builtins.str=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['contents', b'contents', 'ids', b'ids']) -> None:
        ...
global___SavedSelectionResponse = SavedSelectionResponse

@typing.final
class ParseAndCreateItemsFromString(google.protobuf.message.Message):
    """Attempts to parse the given string as a s-expression formatted container with items,
    similar to how the Paste action inside the KiCad editor works.  If the parse is successful,
    the items will be created and inserted into the editor.
    Returns CreateItemsResponse
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    DOCUMENT_FIELD_NUMBER: builtins.int
    CONTENTS_FIELD_NUMBER: builtins.int
    contents: builtins.str

    @property
    def document(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    def __init__(self, *, document: common.types.base_types_pb2.DocumentSpecifier | None=..., contents: builtins.str=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['document', b'document']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['contents', b'contents', 'document', b'document']) -> None:
        ...
global___ParseAndCreateItemsFromString = ParseAndCreateItemsFromString