"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

base_types.proto
Includes types used in many parts of the API
"""
import builtins
import collections.abc
from ... import common
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing
if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions
DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _CommandStatus:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CommandStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_CommandStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CS_UNKNOWN: _CommandStatus.ValueType
    CS_OK: _CommandStatus.ValueType
    'Command succeeded'
    CS_FAILED: _CommandStatus.ValueType
    'Command failed'

class CommandStatus(_CommandStatus, metaclass=_CommandStatusEnumTypeWrapper):
    ...
CS_UNKNOWN: CommandStatus.ValueType
CS_OK: CommandStatus.ValueType
'Command succeeded'
CS_FAILED: CommandStatus.ValueType
'Command failed'
global___CommandStatus = CommandStatus

class _FrameType:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _FrameTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_FrameType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    FT_UNKNOWN: _FrameType.ValueType
    FT_PROJECT_MANAGER: _FrameType.ValueType
    FT_SCHEMATIC_EDITOR: _FrameType.ValueType
    FT_PCB_EDITOR: _FrameType.ValueType
    FT_SPICE_SIMULATOR: _FrameType.ValueType
    FT_SYMBOL_EDITOR: _FrameType.ValueType
    FT_FOOTPRINT_EDITOR: _FrameType.ValueType
    FT_DRAWING_SHEET_EDITOR: _FrameType.ValueType

class FrameType(_FrameType, metaclass=_FrameTypeEnumTypeWrapper):
    """*
    Some commands are specific to a KiCad window (frame).  This list contains all addressable frames.
    """
FT_UNKNOWN: FrameType.ValueType
FT_PROJECT_MANAGER: FrameType.ValueType
FT_SCHEMATIC_EDITOR: FrameType.ValueType
FT_PCB_EDITOR: FrameType.ValueType
FT_SPICE_SIMULATOR: FrameType.ValueType
FT_SYMBOL_EDITOR: FrameType.ValueType
FT_FOOTPRINT_EDITOR: FrameType.ValueType
FT_DRAWING_SHEET_EDITOR: FrameType.ValueType
global___FrameType = FrameType

class _DocumentType:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DocumentTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DocumentType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DOCTYPE_UNKNOWN: _DocumentType.ValueType
    DOCTYPE_SCHEMATIC: _DocumentType.ValueType
    DOCTYPE_SYMBOL: _DocumentType.ValueType
    DOCTYPE_PCB: _DocumentType.ValueType
    DOCTYPE_FOOTPRINT: _DocumentType.ValueType
    DOCTYPE_DRAWING_SHEET: _DocumentType.ValueType
    DOCTYPE_PROJECT: _DocumentType.ValueType

class DocumentType(_DocumentType, metaclass=_DocumentTypeEnumTypeWrapper):
    """*
    Identifier for the type of document being targeted by a request
    """
DOCTYPE_UNKNOWN: DocumentType.ValueType
DOCTYPE_SCHEMATIC: DocumentType.ValueType
DOCTYPE_SYMBOL: DocumentType.ValueType
DOCTYPE_PCB: DocumentType.ValueType
DOCTYPE_FOOTPRINT: DocumentType.ValueType
DOCTYPE_DRAWING_SHEET: DocumentType.ValueType
DOCTYPE_PROJECT: DocumentType.ValueType
global___DocumentType = DocumentType

class _ItemRequestStatus:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ItemRequestStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ItemRequestStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    IRS_UNKNOWN: _ItemRequestStatus.ValueType
    IRS_OK: _ItemRequestStatus.ValueType
    IRS_DOCUMENT_NOT_FOUND: _ItemRequestStatus.ValueType
    'The given document is not open in KiCad'
    IRS_FIELD_MASK_INVALID: _ItemRequestStatus.ValueType
    'The given field_mask contains invalid specifiers'

class ItemRequestStatus(_ItemRequestStatus, metaclass=_ItemRequestStatusEnumTypeWrapper):
    """*
    Status of a request that included an ItemHeader
    """
IRS_UNKNOWN: ItemRequestStatus.ValueType
IRS_OK: ItemRequestStatus.ValueType
IRS_DOCUMENT_NOT_FOUND: ItemRequestStatus.ValueType
'The given document is not open in KiCad'
IRS_FIELD_MASK_INVALID: ItemRequestStatus.ValueType
'The given field_mask contains invalid specifiers'
global___ItemRequestStatus = ItemRequestStatus

class _LockedState:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _LockedStateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_LockedState.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    LS_UNKNOWN: _LockedState.ValueType
    LS_UNLOCKED: _LockedState.ValueType
    LS_LOCKED: _LockedState.ValueType

class LockedState(_LockedState, metaclass=_LockedStateEnumTypeWrapper):
    """Describes whether or not an item is locked for editing or movement"""
LS_UNKNOWN: LockedState.ValueType
LS_UNLOCKED: LockedState.ValueType
LS_LOCKED: LockedState.ValueType
global___LockedState = LockedState

class _GraphicFillType:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _GraphicFillTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_GraphicFillType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    GFT_UNKNOWN: _GraphicFillType.ValueType
    GFT_UNFILLED: _GraphicFillType.ValueType
    GFT_FILLED: _GraphicFillType.ValueType

class GraphicFillType(_GraphicFillType, metaclass=_GraphicFillTypeEnumTypeWrapper):
    ...
GFT_UNKNOWN: GraphicFillType.ValueType
GFT_UNFILLED: GraphicFillType.ValueType
GFT_FILLED: GraphicFillType.ValueType
global___GraphicFillType = GraphicFillType

class _AxisAlignment:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _AxisAlignmentEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AxisAlignment.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    AA_UNKNOWN: _AxisAlignment.ValueType
    AA_X_AXIS: _AxisAlignment.ValueType
    AA_Y_AXIS: _AxisAlignment.ValueType

class AxisAlignment(_AxisAlignment, metaclass=_AxisAlignmentEnumTypeWrapper):
    ...
AA_UNKNOWN: AxisAlignment.ValueType
AA_X_AXIS: AxisAlignment.ValueType
AA_Y_AXIS: AxisAlignment.ValueType
global___AxisAlignment = AxisAlignment

class _MapMergeMode:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _MapMergeModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_MapMergeMode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    MMM_UNKNOWN: _MapMergeMode.ValueType
    MMM_MERGE: _MapMergeMode.ValueType
    'The existing map will be merged with the incoming map; keys that are not present in the\n    incoming map will be preserved with their original values\n    '
    MMM_REPLACE: _MapMergeMode.ValueType
    'The existing map will be cleared and replaced with the incoming map'

class MapMergeMode(_MapMergeMode, metaclass=_MapMergeModeEnumTypeWrapper):
    ...
MMM_UNKNOWN: MapMergeMode.ValueType
MMM_MERGE: MapMergeMode.ValueType
'The existing map will be merged with the incoming map; keys that are not present in the\nincoming map will be preserved with their original values\n'
MMM_REPLACE: MapMergeMode.ValueType
'The existing map will be cleared and replaced with the incoming map'
global___MapMergeMode = MapMergeMode

@typing_extensions.final
class CommandStatusResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    STATUS_FIELD_NUMBER: builtins.int
    status: global___CommandStatus.ValueType

    def __init__(self, *, status: global___CommandStatus.ValueType=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['status', b'status']) -> None:
        ...
global___CommandStatusResponse = CommandStatusResponse

@typing_extensions.final
class KiCadVersion(google.protobuf.message.Message):
    """*
    Describes a particular version of KiCad
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    MAJOR_FIELD_NUMBER: builtins.int
    MINOR_FIELD_NUMBER: builtins.int
    PATCH_FIELD_NUMBER: builtins.int
    FULL_VERSION_FIELD_NUMBER: builtins.int
    major: builtins.int
    minor: builtins.int
    patch: builtins.int
    full_version: builtins.str
    'Full identifier string, potentially containing git hashes, packager-added info, etc.'

    def __init__(self, *, major: builtins.int=..., minor: builtins.int=..., patch: builtins.int=..., full_version: builtins.str=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['full_version', b'full_version', 'major', b'major', 'minor', b'minor', 'patch', b'patch']) -> None:
        ...
global___KiCadVersion = KiCadVersion

@typing_extensions.final
class KIID(google.protobuf.message.Message):
    """*
    Describes a KIID, or UUID of an object in a KiCad editor model.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    VALUE_FIELD_NUMBER: builtins.int
    value: builtins.str
    "The KIID's value in standard UUID format, stored as a string for easy portability"

    def __init__(self, *, value: builtins.str=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['value', b'value']) -> None:
        ...
global___KIID = KIID

@typing_extensions.final
class LibraryIdentifier(google.protobuf.message.Message):
    """*
    Describes a KiCad LIB_ID; a unique identifier for a loaded symbol or footprint
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    LIBRARY_NICKNAME_FIELD_NUMBER: builtins.int
    ENTRY_NAME_FIELD_NUMBER: builtins.int
    library_nickname: builtins.str
    'The library portion of the LIB_ID'
    entry_name: builtins.str
    'The symbol or footprint name'

    def __init__(self, *, library_nickname: builtins.str=..., entry_name: builtins.str=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['entry_name', b'entry_name', 'library_nickname', b'library_nickname']) -> None:
        ...
global___LibraryIdentifier = LibraryIdentifier

@typing_extensions.final
class SheetPath(google.protobuf.message.Message):
    """*
    Describes a unique sheet in a schematic
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PATH_FIELD_NUMBER: builtins.int
    PATH_HUMAN_READABLE_FIELD_NUMBER: builtins.int

    @property
    def path(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___KIID]:
        """The canonical path to the sheet.  The first KIID will be the root sheet, etc."""
    path_human_readable: builtins.str
    'The path converted to a human readable form such as "/", "/child", or "/child/grandchild" '

    def __init__(self, *, path: collections.abc.Iterable[global___KIID] | None=..., path_human_readable: builtins.str=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['path', b'path', 'path_human_readable', b'path_human_readable']) -> None:
        ...
global___SheetPath = SheetPath

@typing_extensions.final
class ProjectSpecifier(google.protobuf.message.Message):
    """*
    Describes a KiCad project
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NAME_FIELD_NUMBER: builtins.int
    PATH_FIELD_NUMBER: builtins.int
    name: builtins.str
    'The name of the project (without the kicad_pro extension)'
    path: builtins.str
    'The path to the project directory'

    def __init__(self, *, name: builtins.str=..., path: builtins.str=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['name', b'name', 'path', b'path']) -> None:
        ...
global___ProjectSpecifier = ProjectSpecifier

@typing_extensions.final
class DocumentSpecifier(google.protobuf.message.Message):
    """*
    Describes a document that will be the target of a request
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TYPE_FIELD_NUMBER: builtins.int
    LIB_ID_FIELD_NUMBER: builtins.int
    SHEET_PATH_FIELD_NUMBER: builtins.int
    BOARD_FILENAME_FIELD_NUMBER: builtins.int
    PROJECT_FIELD_NUMBER: builtins.int
    type: global___DocumentType.ValueType

    @property
    def lib_id(self) -> global___LibraryIdentifier:
        """If type == DT_SYMBOL or DT_FOOTPRINT, identifies a certain library entry"""

    @property
    def sheet_path(self) -> global___SheetPath:
        """If type == DT_SCHEMATIC, identifies a sheet with a given path"""
    board_filename: builtins.str
    'If type == DT_PCB, identifies a PCB with a given filename, e.g. "board.kicad_pcb" '

    @property
    def project(self) -> global___ProjectSpecifier:
        ...

    def __init__(self, *, type: global___DocumentType.ValueType=..., lib_id: global___LibraryIdentifier | None=..., sheet_path: global___SheetPath | None=..., board_filename: builtins.str=..., project: global___ProjectSpecifier | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['board_filename', b'board_filename', 'identifier', b'identifier', 'lib_id', b'lib_id', 'project', b'project', 'sheet_path', b'sheet_path']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['board_filename', b'board_filename', 'identifier', b'identifier', 'lib_id', b'lib_id', 'project', b'project', 'sheet_path', b'sheet_path', 'type', b'type']) -> None:
        ...

    def WhichOneof(self, oneof_group: typing_extensions.Literal['identifier', b'identifier']) -> typing_extensions.Literal['lib_id', 'sheet_path', 'board_filename'] | None:
        ...
global___DocumentSpecifier = DocumentSpecifier

@typing_extensions.final
class ItemHeader(google.protobuf.message.Message):
    """*
    This header is included in requests and responses about item(s) in a document
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    DOCUMENT_FIELD_NUMBER: builtins.int
    CONTAINER_FIELD_NUMBER: builtins.int
    FIELD_MASK_FIELD_NUMBER: builtins.int

    @property
    def document(self) -> global___DocumentSpecifier:
        """Which document is this request targeting?"""

    @property
    def container(self) -> global___KIID:
        """Which container within the document is this request targeting?
        If container is omitted or empty, the document is used as the container.
        """

    @property
    def field_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Which fields on the item(s) are included with this request or response"""

    def __init__(self, *, document: global___DocumentSpecifier | None=..., container: global___KIID | None=..., field_mask: google.protobuf.field_mask_pb2.FieldMask | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['container', b'container', 'document', b'document', 'field_mask', b'field_mask']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['container', b'container', 'document', b'document', 'field_mask', b'field_mask']) -> None:
        ...
global___ItemHeader = ItemHeader

@typing_extensions.final
class Vector2(google.protobuf.message.Message):
    """Describes a point or distance in 2D space.  All coordinates are in nanometers."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    X_NM_FIELD_NUMBER: builtins.int
    Y_NM_FIELD_NUMBER: builtins.int
    x_nm: builtins.int
    y_nm: builtins.int

    def __init__(self, *, x_nm: builtins.int=..., y_nm: builtins.int=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['x_nm', b'x_nm', 'y_nm', b'y_nm']) -> None:
        ...
global___Vector2 = Vector2

@typing_extensions.final
class Vector3(google.protobuf.message.Message):
    """Describes a point or distance in 3D space.  All coordinates are in nanometers."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    X_NM_FIELD_NUMBER: builtins.int
    Y_NM_FIELD_NUMBER: builtins.int
    Z_NM_FIELD_NUMBER: builtins.int
    x_nm: builtins.int
    y_nm: builtins.int
    z_nm: builtins.int

    def __init__(self, *, x_nm: builtins.int=..., y_nm: builtins.int=..., z_nm: builtins.int=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['x_nm', b'x_nm', 'y_nm', b'y_nm', 'z_nm', b'z_nm']) -> None:
        ...
global___Vector3 = Vector3

@typing_extensions.final
class Vector3D(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    X_NM_FIELD_NUMBER: builtins.int
    Y_NM_FIELD_NUMBER: builtins.int
    Z_NM_FIELD_NUMBER: builtins.int
    x_nm: builtins.float
    y_nm: builtins.float
    z_nm: builtins.float

    def __init__(self, *, x_nm: builtins.float=..., y_nm: builtins.float=..., z_nm: builtins.float=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['x_nm', b'x_nm', 'y_nm', b'y_nm', 'z_nm', b'z_nm']) -> None:
        ...
global___Vector3D = Vector3D

@typing_extensions.final
class Box2(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    POSITION_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int

    @property
    def position(self) -> global___Vector2:
        ...

    @property
    def size(self) -> global___Vector2:
        ...

    def __init__(self, *, position: global___Vector2 | None=..., size: global___Vector2 | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['position', b'position', 'size', b'size']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['position', b'position', 'size', b'size']) -> None:
        ...
global___Box2 = Box2

@typing_extensions.final
class Distance(google.protobuf.message.Message):
    """Describes a quantity of distance (size, length, etc).  All coordinates are in nanometers."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    VALUE_NM_FIELD_NUMBER: builtins.int
    value_nm: builtins.int

    def __init__(self, *, value_nm: builtins.int=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['value_nm', b'value_nm']) -> None:
        ...
global___Distance = Distance

@typing_extensions.final
class Angle(google.protobuf.message.Message):
    """Corresponds to EDA_ANGLE, where the underlying storage is degrees"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    VALUE_DEGREES_FIELD_NUMBER: builtins.int
    value_degrees: builtins.float

    def __init__(self, *, value_degrees: builtins.float=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['value_degrees', b'value_degrees']) -> None:
        ...
global___Angle = Angle

@typing_extensions.final
class Ratio(google.protobuf.message.Message):
    """Represents a value from 0.0 to 1.0"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    VALUE_FIELD_NUMBER: builtins.int
    value: builtins.float

    def __init__(self, *, value: builtins.float=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['value', b'value']) -> None:
        ...
global___Ratio = Ratio

@typing_extensions.final
class Color(google.protobuf.message.Message):
    """Corresponds to COLOR4D.  Each color channel is a double from 0.0 to 1.0."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    R_FIELD_NUMBER: builtins.int
    G_FIELD_NUMBER: builtins.int
    B_FIELD_NUMBER: builtins.int
    A_FIELD_NUMBER: builtins.int
    r: builtins.float
    g: builtins.float
    b: builtins.float
    a: builtins.float

    def __init__(self, *, r: builtins.float=..., g: builtins.float=..., b: builtins.float=..., a: builtins.float=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['a', b'a', 'b', b'b', 'g', b'g', 'r', b'r']) -> None:
        ...
global___Color = Color

@typing_extensions.final
class ArcStartMidEnd(google.protobuf.message.Message):
    """The formulation of arc that is used in KiCad core geometry code.
    Start, midpoint (on the arc) and end are stored.  Angle, center point, etc are calculated.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    START_FIELD_NUMBER: builtins.int
    MID_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int

    @property
    def start(self) -> global___Vector2:
        ...

    @property
    def mid(self) -> global___Vector2:
        ...

    @property
    def end(self) -> global___Vector2:
        ...

    def __init__(self, *, start: global___Vector2 | None=..., mid: global___Vector2 | None=..., end: global___Vector2 | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['end', b'end', 'mid', b'mid', 'start', b'start']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['end', b'end', 'mid', b'mid', 'start', b'start']) -> None:
        ...
global___ArcStartMidEnd = ArcStartMidEnd

@typing_extensions.final
class PolyLineNode(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    POINT_FIELD_NUMBER: builtins.int
    ARC_FIELD_NUMBER: builtins.int

    @property
    def point(self) -> global___Vector2:
        ...

    @property
    def arc(self) -> global___ArcStartMidEnd:
        ...

    def __init__(self, *, point: global___Vector2 | None=..., arc: global___ArcStartMidEnd | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['arc', b'arc', 'geometry', b'geometry', 'point', b'point']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['arc', b'arc', 'geometry', b'geometry', 'point', b'point']) -> None:
        ...

    def WhichOneof(self, oneof_group: typing_extensions.Literal['geometry', b'geometry']) -> typing_extensions.Literal['point', 'arc'] | None:
        ...
global___PolyLineNode = PolyLineNode

@typing_extensions.final
class PolyLine(google.protobuf.message.Message):
    """Corresponds to class SHAPE_LINE_CHAIN: A closed or open polyline that can include arcs.
    For non-arc cases, each node is a point along the line.  An implicit line segment exists
    between the last and first node if closed is true.  When arcs are present, the arc start and
    end points are not duplicated by point nodes (meaning, for example, a rectangle with rounded
    corners could be represented with four arc nodes and no point nodes).
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NODES_FIELD_NUMBER: builtins.int
    CLOSED_FIELD_NUMBER: builtins.int

    @property
    def nodes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PolyLineNode]:
        ...
    closed: builtins.bool

    def __init__(self, *, nodes: collections.abc.Iterable[global___PolyLineNode] | None=..., closed: builtins.bool=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['closed', b'closed', 'nodes', b'nodes']) -> None:
        ...
global___PolyLine = PolyLine

@typing_extensions.final
class PolygonWithHoles(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    OUTLINE_FIELD_NUMBER: builtins.int
    HOLES_FIELD_NUMBER: builtins.int

    @property
    def outline(self) -> global___PolyLine:
        ...

    @property
    def holes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PolyLine]:
        ...

    def __init__(self, *, outline: global___PolyLine | None=..., holes: collections.abc.Iterable[global___PolyLine] | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['outline', b'outline']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['holes', b'holes', 'outline', b'outline']) -> None:
        ...
global___PolygonWithHoles = PolygonWithHoles

@typing_extensions.final
class PolySet(google.protobuf.message.Message):
    """Corresponds to SHAPE_POLY_SET: a set of polygons or polylines"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    POLYGONS_FIELD_NUMBER: builtins.int

    @property
    def polygons(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PolygonWithHoles]:
        ...

    def __init__(self, *, polygons: collections.abc.Iterable[global___PolygonWithHoles] | None=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['polygons', b'polygons']) -> None:
        ...
global___PolySet = PolySet

@typing_extensions.final
class TextAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    FONT_NAME_FIELD_NUMBER: builtins.int
    HORIZONTAL_ALIGNMENT_FIELD_NUMBER: builtins.int
    VERTICAL_ALIGNMENT_FIELD_NUMBER: builtins.int
    ANGLE_FIELD_NUMBER: builtins.int
    LINE_SPACING_FIELD_NUMBER: builtins.int
    STROKE_WIDTH_FIELD_NUMBER: builtins.int
    ITALIC_FIELD_NUMBER: builtins.int
    BOLD_FIELD_NUMBER: builtins.int
    UNDERLINED_FIELD_NUMBER: builtins.int
    VISIBLE_FIELD_NUMBER: builtins.int
    MIRRORED_FIELD_NUMBER: builtins.int
    MULTILINE_FIELD_NUMBER: builtins.int
    KEEP_UPRIGHT_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    font_name: builtins.str
    horizontal_alignment: common.types.enums_pb2.HorizontalAlignment.ValueType
    vertical_alignment: common.types.enums_pb2.VerticalAlignment.ValueType

    @property
    def angle(self) -> global___Angle:
        ...
    line_spacing: builtins.float

    @property
    def stroke_width(self) -> global___Distance:
        ...
    italic: builtins.bool
    bold: builtins.bool
    underlined: builtins.bool
    visible: builtins.bool
    mirrored: builtins.bool
    multiline: builtins.bool
    keep_upright: builtins.bool

    @property
    def size(self) -> global___Vector2:
        ...

    def __init__(self, *, font_name: builtins.str=..., horizontal_alignment: common.types.enums_pb2.HorizontalAlignment.ValueType=..., vertical_alignment: common.types.enums_pb2.VerticalAlignment.ValueType=..., angle: global___Angle | None=..., line_spacing: builtins.float=..., stroke_width: global___Distance | None=..., italic: builtins.bool=..., bold: builtins.bool=..., underlined: builtins.bool=..., visible: builtins.bool=..., mirrored: builtins.bool=..., multiline: builtins.bool=..., keep_upright: builtins.bool=..., size: global___Vector2 | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['angle', b'angle', 'size', b'size', 'stroke_width', b'stroke_width']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['angle', b'angle', 'bold', b'bold', 'font_name', b'font_name', 'horizontal_alignment', b'horizontal_alignment', 'italic', b'italic', 'keep_upright', b'keep_upright', 'line_spacing', b'line_spacing', 'mirrored', b'mirrored', 'multiline', b'multiline', 'size', b'size', 'stroke_width', b'stroke_width', 'underlined', b'underlined', 'vertical_alignment', b'vertical_alignment', 'visible', b'visible']) -> None:
        ...
global___TextAttributes = TextAttributes

@typing_extensions.final
class Text(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    POSITION_FIELD_NUMBER: builtins.int
    ATTRIBUTES_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    HYPERLINK_FIELD_NUMBER: builtins.int

    @property
    def position(self) -> global___Vector2:
        """Reserved for future use; base text objects don't have IDs right now
        kiapi.common.types.KIID           id         = 1;
        """

    @property
    def attributes(self) -> global___TextAttributes:
        ...
    text: builtins.str
    "Reserved for future use; base objects don't support locking right nos\n    kiapi.common.types.LockedState    locked     = 4;\n    "
    hyperlink: builtins.str

    def __init__(self, *, position: global___Vector2 | None=..., attributes: global___TextAttributes | None=..., text: builtins.str=..., hyperlink: builtins.str=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['attributes', b'attributes', 'position', b'position']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['attributes', b'attributes', 'hyperlink', b'hyperlink', 'position', b'position', 'text', b'text']) -> None:
        ...
global___Text = Text

@typing_extensions.final
class TextBox(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TOP_LEFT_FIELD_NUMBER: builtins.int
    BOTTOM_RIGHT_FIELD_NUMBER: builtins.int
    ATTRIBUTES_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int

    @property
    def top_left(self) -> global___Vector2:
        ...

    @property
    def bottom_right(self) -> global___Vector2:
        ...

    @property
    def attributes(self) -> global___TextAttributes:
        ...
    text: builtins.str
    "Reserved for future use; base objects don't support locking right nos\n    kiapi.common.types.LockedState    locked       = 5;\n    "

    def __init__(self, *, top_left: global___Vector2 | None=..., bottom_right: global___Vector2 | None=..., attributes: global___TextAttributes | None=..., text: builtins.str=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['attributes', b'attributes', 'bottom_right', b'bottom_right', 'top_left', b'top_left']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['attributes', b'attributes', 'bottom_right', b'bottom_right', 'text', b'text', 'top_left', b'top_left']) -> None:
        ...
global___TextBox = TextBox

@typing_extensions.final
class StrokeAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    WIDTH_FIELD_NUMBER: builtins.int
    STYLE_FIELD_NUMBER: builtins.int
    COLOR_FIELD_NUMBER: builtins.int

    @property
    def width(self) -> global___Distance:
        ...
    style: common.types.enums_pb2.StrokeLineStyle.ValueType

    @property
    def color(self) -> global___Color:
        ...

    def __init__(self, *, width: global___Distance | None=..., style: common.types.enums_pb2.StrokeLineStyle.ValueType=..., color: global___Color | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['color', b'color', 'width', b'width']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['color', b'color', 'style', b'style', 'width', b'width']) -> None:
        ...
global___StrokeAttributes = StrokeAttributes

@typing_extensions.final
class GraphicFillAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    FILL_TYPE_FIELD_NUMBER: builtins.int
    COLOR_FIELD_NUMBER: builtins.int
    fill_type: global___GraphicFillType.ValueType

    @property
    def color(self) -> global___Color:
        """Color of the fill (not used in board and footprints)"""

    def __init__(self, *, fill_type: global___GraphicFillType.ValueType=..., color: global___Color | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['color', b'color']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['color', b'color', 'fill_type', b'fill_type']) -> None:
        ...
global___GraphicFillAttributes = GraphicFillAttributes

@typing_extensions.final
class GraphicAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    STROKE_FIELD_NUMBER: builtins.int
    FILL_FIELD_NUMBER: builtins.int

    @property
    def stroke(self) -> global___StrokeAttributes:
        ...

    @property
    def fill(self) -> global___GraphicFillAttributes:
        ...

    def __init__(self, *, stroke: global___StrokeAttributes | None=..., fill: global___GraphicFillAttributes | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['fill', b'fill', 'stroke', b'stroke']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['fill', b'fill', 'stroke', b'stroke']) -> None:
        ...
global___GraphicAttributes = GraphicAttributes

@typing_extensions.final
class GraphicSegmentAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    START_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int

    @property
    def start(self) -> global___Vector2:
        ...

    @property
    def end(self) -> global___Vector2:
        ...

    def __init__(self, *, start: global___Vector2 | None=..., end: global___Vector2 | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['end', b'end', 'start', b'start']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['end', b'end', 'start', b'start']) -> None:
        ...
global___GraphicSegmentAttributes = GraphicSegmentAttributes

@typing_extensions.final
class GraphicRectangleAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TOP_LEFT_FIELD_NUMBER: builtins.int
    BOTTOM_RIGHT_FIELD_NUMBER: builtins.int

    @property
    def top_left(self) -> global___Vector2:
        ...

    @property
    def bottom_right(self) -> global___Vector2:
        ...

    def __init__(self, *, top_left: global___Vector2 | None=..., bottom_right: global___Vector2 | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['bottom_right', b'bottom_right', 'top_left', b'top_left']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['bottom_right', b'bottom_right', 'top_left', b'top_left']) -> None:
        ...
global___GraphicRectangleAttributes = GraphicRectangleAttributes

@typing_extensions.final
class GraphicArcAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    START_FIELD_NUMBER: builtins.int
    MID_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int

    @property
    def start(self) -> global___Vector2:
        ...

    @property
    def mid(self) -> global___Vector2:
        ...

    @property
    def end(self) -> global___Vector2:
        ...

    def __init__(self, *, start: global___Vector2 | None=..., mid: global___Vector2 | None=..., end: global___Vector2 | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['end', b'end', 'mid', b'mid', 'start', b'start']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['end', b'end', 'mid', b'mid', 'start', b'start']) -> None:
        ...
global___GraphicArcAttributes = GraphicArcAttributes

@typing_extensions.final
class GraphicCircleAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CENTER_FIELD_NUMBER: builtins.int
    RADIUS_POINT_FIELD_NUMBER: builtins.int

    @property
    def center(self) -> global___Vector2:
        ...

    @property
    def radius_point(self) -> global___Vector2:
        """A point on the radius of the circle.  This is stored instead of just a radius so that the point
        by which the user can adjust the circle radius is persisted.
        """

    def __init__(self, *, center: global___Vector2 | None=..., radius_point: global___Vector2 | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['center', b'center', 'radius_point', b'radius_point']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['center', b'center', 'radius_point', b'radius_point']) -> None:
        ...
global___GraphicCircleAttributes = GraphicCircleAttributes

@typing_extensions.final
class GraphicBezierAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    START_FIELD_NUMBER: builtins.int
    CONTROL1_FIELD_NUMBER: builtins.int
    CONTROL2_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int

    @property
    def start(self) -> global___Vector2:
        ...

    @property
    def control1(self) -> global___Vector2:
        ...

    @property
    def control2(self) -> global___Vector2:
        ...

    @property
    def end(self) -> global___Vector2:
        ...

    def __init__(self, *, start: global___Vector2 | None=..., control1: global___Vector2 | None=..., control2: global___Vector2 | None=..., end: global___Vector2 | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['control1', b'control1', 'control2', b'control2', 'end', b'end', 'start', b'start']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['control1', b'control1', 'control2', b'control2', 'end', b'end', 'start', b'start']) -> None:
        ...
global___GraphicBezierAttributes = GraphicBezierAttributes

@typing_extensions.final
class GraphicShape(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ATTRIBUTES_FIELD_NUMBER: builtins.int
    SEGMENT_FIELD_NUMBER: builtins.int
    RECTANGLE_FIELD_NUMBER: builtins.int
    ARC_FIELD_NUMBER: builtins.int
    CIRCLE_FIELD_NUMBER: builtins.int
    POLYGON_FIELD_NUMBER: builtins.int
    BEZIER_FIELD_NUMBER: builtins.int

    @property
    def attributes(self) -> global___GraphicAttributes:
        """Reserved for future use; base EDA_SHAPE doesn't have an ID or locked state right now
        KIID              id         = 1;
        LockedState       locked     = 2;
        """

    @property
    def segment(self) -> global___GraphicSegmentAttributes:
        ...

    @property
    def rectangle(self) -> global___GraphicRectangleAttributes:
        ...

    @property
    def arc(self) -> global___GraphicArcAttributes:
        ...

    @property
    def circle(self) -> global___GraphicCircleAttributes:
        ...

    @property
    def polygon(self) -> global___PolySet:
        ...

    @property
    def bezier(self) -> global___GraphicBezierAttributes:
        ...

    def __init__(self, *, attributes: global___GraphicAttributes | None=..., segment: global___GraphicSegmentAttributes | None=..., rectangle: global___GraphicRectangleAttributes | None=..., arc: global___GraphicArcAttributes | None=..., circle: global___GraphicCircleAttributes | None=..., polygon: global___PolySet | None=..., bezier: global___GraphicBezierAttributes | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['arc', b'arc', 'attributes', b'attributes', 'bezier', b'bezier', 'circle', b'circle', 'geometry', b'geometry', 'polygon', b'polygon', 'rectangle', b'rectangle', 'segment', b'segment']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['arc', b'arc', 'attributes', b'attributes', 'bezier', b'bezier', 'circle', b'circle', 'geometry', b'geometry', 'polygon', b'polygon', 'rectangle', b'rectangle', 'segment', b'segment']) -> None:
        ...

    def WhichOneof(self, oneof_group: typing_extensions.Literal['geometry', b'geometry']) -> typing_extensions.Literal['segment', 'rectangle', 'arc', 'circle', 'polygon', 'bezier'] | None:
        ...
global___GraphicShape = GraphicShape

@typing_extensions.final
class CompoundShape(google.protobuf.message.Message):
    """A SHAPE_COMPOUND in KiCad"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SHAPES_FIELD_NUMBER: builtins.int

    @property
    def shapes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GraphicShape]:
        ...

    def __init__(self, *, shapes: collections.abc.Iterable[global___GraphicShape] | None=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['shapes', b'shapes']) -> None:
        ...
global___CompoundShape = CompoundShape

@typing_extensions.final
class TitleBlockInfo(google.protobuf.message.Message):
    """The text strings that can be set in a drawing sheet for the title block"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TITLE_FIELD_NUMBER: builtins.int
    DATE_FIELD_NUMBER: builtins.int
    REVISION_FIELD_NUMBER: builtins.int
    COMPANY_FIELD_NUMBER: builtins.int
    COMMENT1_FIELD_NUMBER: builtins.int
    COMMENT2_FIELD_NUMBER: builtins.int
    COMMENT3_FIELD_NUMBER: builtins.int
    COMMENT4_FIELD_NUMBER: builtins.int
    COMMENT5_FIELD_NUMBER: builtins.int
    COMMENT6_FIELD_NUMBER: builtins.int
    COMMENT7_FIELD_NUMBER: builtins.int
    COMMENT8_FIELD_NUMBER: builtins.int
    COMMENT9_FIELD_NUMBER: builtins.int
    title: builtins.str
    date: builtins.str
    revision: builtins.str
    company: builtins.str
    comment1: builtins.str
    'Note: not a repeated string; there can be gaps and the UI limits the count to 9'
    comment2: builtins.str
    comment3: builtins.str
    comment4: builtins.str
    comment5: builtins.str
    comment6: builtins.str
    comment7: builtins.str
    comment8: builtins.str
    comment9: builtins.str

    def __init__(self, *, title: builtins.str=..., date: builtins.str=..., revision: builtins.str=..., company: builtins.str=..., comment1: builtins.str=..., comment2: builtins.str=..., comment3: builtins.str=..., comment4: builtins.str=..., comment5: builtins.str=..., comment6: builtins.str=..., comment7: builtins.str=..., comment8: builtins.str=..., comment9: builtins.str=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['comment1', b'comment1', 'comment2', b'comment2', 'comment3', b'comment3', 'comment4', b'comment4', 'comment5', b'comment5', 'comment6', b'comment6', 'comment7', b'comment7', 'comment8', b'comment8', 'comment9', b'comment9', 'company', b'company', 'date', b'date', 'revision', b'revision', 'title', b'title']) -> None:
        ...
global___TitleBlockInfo = TitleBlockInfo