"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

This program source code file is part of KiCad, a free EDA CAD application.

Copyright (C) 2024 KiCad Developers, see AUTHORS.txt for contributors.

This program is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, either version 3 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see <http://www.gnu.org/licenses/>.
"""
import builtins
import collections.abc
from ... import common
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys
if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions
DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class GetVersion(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(self) -> None:
        ...
global___GetVersion = GetVersion

@typing_extensions.final
class GetVersionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    VERSION_FIELD_NUMBER: builtins.int

    @property
    def version(self) -> common.types.base_types_pb2.KiCadVersion:
        ...

    def __init__(self, *, version: common.types.base_types_pb2.KiCadVersion | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['version', b'version']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['version', b'version']) -> None:
        ...
global___GetVersionResponse = GetVersionResponse

@typing_extensions.final
class Ping(google.protobuf.message.Message):
    """A command to check if the connection to KiCad is OK"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(self) -> None:
        ...
global___Ping = Ping

@typing_extensions.final
class GetKiCadBinaryPath(google.protobuf.message.Message):
    """Returns the full path to the given KiCad binary"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BINARY_NAME_FIELD_NUMBER: builtins.int
    binary_name: builtins.str
    'The short name of the binary, such as `kicad-cli` or `kicad-cli.exe`.  If on Windows, an `.exe`\n    extension will be assumed if not present.\n    '

    def __init__(self, *, binary_name: builtins.str=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['binary_name', b'binary_name']) -> None:
        ...
global___GetKiCadBinaryPath = GetKiCadBinaryPath

@typing_extensions.final
class PathResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PATH_FIELD_NUMBER: builtins.int
    path: builtins.str

    def __init__(self, *, path: builtins.str=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['path', b'path']) -> None:
        ...
global___PathResponse = PathResponse

@typing_extensions.final
class GetTextExtents(google.protobuf.message.Message):
    """returns kiapi.common.types.Box2"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TEXT_FIELD_NUMBER: builtins.int

    @property
    def text(self) -> common.types.base_types_pb2.Text:
        """A temporary text item to calculate the bounding box for"""

    def __init__(self, *, text: common.types.base_types_pb2.Text | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['text', b'text']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['text', b'text']) -> None:
        ...
global___GetTextExtents = GetTextExtents

@typing_extensions.final
class TextOrTextBox(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TEXT_FIELD_NUMBER: builtins.int
    TEXTBOX_FIELD_NUMBER: builtins.int

    @property
    def text(self) -> common.types.base_types_pb2.Text:
        ...

    @property
    def textbox(self) -> common.types.base_types_pb2.TextBox:
        ...

    def __init__(self, *, text: common.types.base_types_pb2.Text | None=..., textbox: common.types.base_types_pb2.TextBox | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['inner', b'inner', 'text', b'text', 'textbox', b'textbox']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['inner', b'inner', 'text', b'text', 'textbox', b'textbox']) -> None:
        ...

    def WhichOneof(self, oneof_group: typing_extensions.Literal['inner', b'inner']) -> typing_extensions.Literal['text', 'textbox'] | None:
        ...
global___TextOrTextBox = TextOrTextBox

@typing_extensions.final
class GetTextAsShapes(google.protobuf.message.Message):
    """Render the given text object(s) as shapes.  Depending on whether the text is using
    the KiCad stroke font or a custom font, the response will be a compound shape containing
    a set of polygons or a set of segments.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TEXT_FIELD_NUMBER: builtins.int

    @property
    def text(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TextOrTextBox]:
        ...

    def __init__(self, *, text: collections.abc.Iterable[global___TextOrTextBox] | None=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['text', b'text']) -> None:
        ...
global___GetTextAsShapes = GetTextAsShapes

@typing_extensions.final
class TextWithShapes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TEXT_FIELD_NUMBER: builtins.int
    SHAPES_FIELD_NUMBER: builtins.int

    @property
    def text(self) -> global___TextOrTextBox:
        ...

    @property
    def shapes(self) -> common.types.base_types_pb2.CompoundShape:
        ...

    def __init__(self, *, text: global___TextOrTextBox | None=..., shapes: common.types.base_types_pb2.CompoundShape | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['shapes', b'shapes', 'text', b'text']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['shapes', b'shapes', 'text', b'text']) -> None:
        ...
global___TextWithShapes = TextWithShapes

@typing_extensions.final
class GetTextAsShapesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TEXT_WITH_SHAPES_FIELD_NUMBER: builtins.int

    @property
    def text_with_shapes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TextWithShapes]:
        ...

    def __init__(self, *, text_with_shapes: collections.abc.Iterable[global___TextWithShapes] | None=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['text_with_shapes', b'text_with_shapes']) -> None:
        ...
global___GetTextAsShapesResponse = GetTextAsShapesResponse

@typing_extensions.final
class GetPluginSettingsPath(google.protobuf.message.Message):
    """Return a writeable path that a plugin can use for storing persistent data such as configuration
    files, etc.  This path may not yet exist; actual creation of the directory for a given plugin is
    up to the plugin itself.  Files in this path will not be modified if the plugin is uninstalled or
    upgraded.

    Returns StringResponse
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    IDENTIFIER_FIELD_NUMBER: builtins.int
    identifier: builtins.str
    'The identifier of the plugin'

    def __init__(self, *, identifier: builtins.str=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['identifier', b'identifier']) -> None:
        ...
global___GetPluginSettingsPath = GetPluginSettingsPath

@typing_extensions.final
class StringResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    RESPONSE_FIELD_NUMBER: builtins.int
    response: builtins.str

    def __init__(self, *, response: builtins.str=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['response', b'response']) -> None:
        ...
global___StringResponse = StringResponse