# Copyright The KiCad Developers
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the “Software”), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

import os
import setuptools

from tools.generate_protos import generate_protos


def pre_build():
    print("Generating protobuf wrappers...")
    proto_in = os.path.join(os.getcwd(), "kicad/api/proto")
    proto_out = os.path.join(os.getcwd(), "kipy/proto")
    generate_protos(proto_in, proto_out)

    os.chdir(os.path.join(os.getcwd(), "kicad"))
    stream = os.popen('git describe')
    git_description = stream.read().strip()
    version_file_path = os.path.join(os.getcwd(), "../kipy/kicad_api_version.py")
    with open(version_file_path, 'w') as version_file:
        version_file.write("# This file is automatically generated, do not modify it\n")
        version_file.write(f'KICAD_API_VERSION = "{git_description}"\n')

    # Change back to the original directory
    os.chdir(os.path.dirname(os.path.abspath(__file__)))


def build(setup_kwargs):
    pre_build()

    # Poetry assumes we want a targeted build since we have a build script,
    # but there is no way to specify that we actually want to build for any
    # in the pyproject.toml file :/
    try:
        setuptools.setup(
            **setup_kwargs,
            script_args = ['bdist_wheel'],
            options = {
                'bdist_wheel': { 'plat_name': 'any' },
                ##'egg_info': { 'egg_base': './dist/' }
            }
        )
    except Exception as e:
        print(f"Failed to build wheel: {e}")

if __name__ == "__main__":
    pre_build()
