"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

This program source code file is part of KiCad, a free EDA CAD application.

Copyright (C) 2024 Jon Evans <jon@craftyjon.com>
Copyright (C) 2024 KiCad Developers, see AUTHORS.txt for contributors.

This program is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, either version 3 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see <http://www.gnu.org/licenses/>.
"""
from .. import board
import builtins
import collections.abc
from .. import common
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing
if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions
DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _InactiveLayerDisplayMode:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _InactiveLayerDisplayModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_InactiveLayerDisplayMode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ILDM_UNKNOWN: _InactiveLayerDisplayMode.ValueType
    ILDM_NORMAL: _InactiveLayerDisplayMode.ValueType
    'Inactive layers are shown'
    ILDM_DIMMED: _InactiveLayerDisplayMode.ValueType
    'Inactive layers are shown with dimmed colors'
    ILDM_HIDDEN: _InactiveLayerDisplayMode.ValueType
    'Inactive layers are hidden'

class InactiveLayerDisplayMode(_InactiveLayerDisplayMode, metaclass=_InactiveLayerDisplayModeEnumTypeWrapper):
    ...
ILDM_UNKNOWN: InactiveLayerDisplayMode.ValueType
ILDM_NORMAL: InactiveLayerDisplayMode.ValueType
'Inactive layers are shown'
ILDM_DIMMED: InactiveLayerDisplayMode.ValueType
'Inactive layers are shown with dimmed colors'
ILDM_HIDDEN: InactiveLayerDisplayMode.ValueType
'Inactive layers are hidden'
global___InactiveLayerDisplayMode = InactiveLayerDisplayMode

class _NetColorDisplayMode:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _NetColorDisplayModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_NetColorDisplayMode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    NCDM_UNKNOWN: _NetColorDisplayMode.ValueType
    NCDM_ALL: _NetColorDisplayMode.ValueType
    'Net and netclass colors are shown in the ratsnest and on all copper items'
    NCDM_RATSNEST: _NetColorDisplayMode.ValueType
    'Net and netclass colors are shown in the ratsnest only'
    NCDM_OFF: _NetColorDisplayMode.ValueType
    'Net and netclass colors are not shown'

class NetColorDisplayMode(_NetColorDisplayMode, metaclass=_NetColorDisplayModeEnumTypeWrapper):
    ...
NCDM_UNKNOWN: NetColorDisplayMode.ValueType
NCDM_ALL: NetColorDisplayMode.ValueType
'Net and netclass colors are shown in the ratsnest and on all copper items'
NCDM_RATSNEST: NetColorDisplayMode.ValueType
'Net and netclass colors are shown in the ratsnest only'
NCDM_OFF: NetColorDisplayMode.ValueType
'Net and netclass colors are not shown'
global___NetColorDisplayMode = NetColorDisplayMode

class _BoardFlipMode:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _BoardFlipModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_BoardFlipMode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    BFM_UNKNOWN: _BoardFlipMode.ValueType
    BFM_NORMAL: _BoardFlipMode.ValueType
    'Normal ("non-flipped") mode'
    BFM_FLIPPED_X: _BoardFlipMode.ValueType
    '"Flipped" mode, viewed from the back and mirrored around the X axis'

class BoardFlipMode(_BoardFlipMode, metaclass=_BoardFlipModeEnumTypeWrapper):
    ...
BFM_UNKNOWN: BoardFlipMode.ValueType
BFM_NORMAL: BoardFlipMode.ValueType
'Normal ("non-flipped") mode'
BFM_FLIPPED_X: BoardFlipMode.ValueType
'"Flipped" mode, viewed from the back and mirrored around the X axis'
global___BoardFlipMode = BoardFlipMode

class _RatsnestDisplayMode:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _RatsnestDisplayModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_RatsnestDisplayMode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    RDM_UNKNOWN: _RatsnestDisplayMode.ValueType
    RDM_ALL_LAYERS: _RatsnestDisplayMode.ValueType
    'Ratsnest lines are drawn to objects even if they are on hidden layers'
    RDM_VISIBLE_LAYERS: _RatsnestDisplayMode.ValueType
    'Ratsnest lines are hidden when at least one endpoint is an item on a hidden layer'

class RatsnestDisplayMode(_RatsnestDisplayMode, metaclass=_RatsnestDisplayModeEnumTypeWrapper):
    ...
RDM_UNKNOWN: RatsnestDisplayMode.ValueType
RDM_ALL_LAYERS: RatsnestDisplayMode.ValueType
'Ratsnest lines are drawn to objects even if they are on hidden layers'
RDM_VISIBLE_LAYERS: RatsnestDisplayMode.ValueType
'Ratsnest lines are hidden when at least one endpoint is an item on a hidden layer'
global___RatsnestDisplayMode = RatsnestDisplayMode

@typing_extensions.final
class GetBoardStackup(google.protobuf.message.Message):
    """
    Board stackup and properties
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['board', b'board']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['board', b'board']) -> None:
        ...
global___GetBoardStackup = GetBoardStackup

@typing_extensions.final
class BoardStackupResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    STACKUP_FIELD_NUMBER: builtins.int

    @property
    def stackup(self) -> board.board_pb2.BoardStackup:
        ...

    def __init__(self, *, stackup: board.board_pb2.BoardStackup | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['stackup', b'stackup']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['stackup', b'stackup']) -> None:
        ...
global___BoardStackupResponse = BoardStackupResponse

@typing_extensions.final
class UpdateBoardStackup(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int
    STACKUP_FIELD_NUMBER: builtins.int

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    @property
    def stackup(self) -> board.board_pb2.BoardStackup:
        ...

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=..., stackup: board.board_pb2.BoardStackup | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['board', b'board', 'stackup', b'stackup']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['board', b'board', 'stackup', b'stackup']) -> None:
        ...
global___UpdateBoardStackup = UpdateBoardStackup

@typing_extensions.final
class GetGraphicsDefaults(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['board', b'board']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['board', b'board']) -> None:
        ...
global___GetGraphicsDefaults = GetGraphicsDefaults

@typing_extensions.final
class GraphicsDefaultsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    DEFAULTS_FIELD_NUMBER: builtins.int

    @property
    def defaults(self) -> board.board_pb2.GraphicsDefaults:
        ...

    def __init__(self, *, defaults: board.board_pb2.GraphicsDefaults | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['defaults', b'defaults']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['defaults', b'defaults']) -> None:
        ...
global___GraphicsDefaultsResponse = GraphicsDefaultsResponse

@typing_extensions.final
class GetNets(google.protobuf.message.Message):
    """
    Net management
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int
    NETCLASS_FILTER_FIELD_NUMBER: builtins.int

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    @property
    def netclass_filter(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """If provided, will only return nets that belong to the given netclass.
        If more than one netclass_filter is given, nets belonging to any of the given classes will
        be returned.
        """

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=..., netclass_filter: collections.abc.Iterable[builtins.str] | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['board', b'board']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['board', b'board', 'netclass_filter', b'netclass_filter']) -> None:
        ...
global___GetNets = GetNets

@typing_extensions.final
class NetsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NETS_FIELD_NUMBER: builtins.int

    @property
    def nets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[board.board_types_pb2.Net]:
        ...

    def __init__(self, *, nets: collections.abc.Iterable[board.board_types_pb2.Net] | None=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['nets', b'nets']) -> None:
        ...
global___NetsResponse = NetsResponse

@typing_extensions.final
class GetItemsByNet(google.protobuf.message.Message):
    """Retrieve all the copper items belonging to a certain net or set of nets
    returns kiapi.common.commands.GetItemsResponse
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    HEADER_FIELD_NUMBER: builtins.int
    TYPES_FIELD_NUMBER: builtins.int
    NET_CODES_FIELD_NUMBER: builtins.int

    @property
    def header(self) -> common.types.base_types_pb2.ItemHeader:
        """Specifies which document to query, which fields to return, etc."""

    @property
    def types(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[common.types.enums_pb2.KiCadObjectType.ValueType]:
        """List of one or more types of items to retreive"""

    @property
    def net_codes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[board.board_types_pb2.NetCode]:
        """A list of net codes to filter items by"""

    def __init__(self, *, header: common.types.base_types_pb2.ItemHeader | None=..., types: collections.abc.Iterable[common.types.enums_pb2.KiCadObjectType.ValueType] | None=..., net_codes: collections.abc.Iterable[board.board_types_pb2.NetCode] | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['header', b'header']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['header', b'header', 'net_codes', b'net_codes', 'types', b'types']) -> None:
        ...
global___GetItemsByNet = GetItemsByNet

@typing_extensions.final
class GetItemsByNetClass(google.protobuf.message.Message):
    """Retrieve all the copper items belonging to a certain net class or set of net classes
    returns kiapi.common.commands.GetItemsResponse
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    HEADER_FIELD_NUMBER: builtins.int
    TYPES_FIELD_NUMBER: builtins.int
    NET_CLASSES_FIELD_NUMBER: builtins.int

    @property
    def header(self) -> common.types.base_types_pb2.ItemHeader:
        """Specifies which document to query, which fields to return, etc."""

    @property
    def types(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[common.types.enums_pb2.KiCadObjectType.ValueType]:
        """List of one or more types of items to retreive"""

    @property
    def net_classes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of net class names to filter items by"""

    def __init__(self, *, header: common.types.base_types_pb2.ItemHeader | None=..., types: collections.abc.Iterable[common.types.enums_pb2.KiCadObjectType.ValueType] | None=..., net_classes: collections.abc.Iterable[builtins.str] | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['header', b'header']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['header', b'header', 'net_classes', b'net_classes', 'types', b'types']) -> None:
        ...
global___GetItemsByNetClass = GetItemsByNetClass

@typing_extensions.final
class GetNetClassForNets(google.protobuf.message.Message):
    """A net may be part of multiple classes that have a priority ordering, which will result in a
    composite "effective" netclass containing the merged/overridden properties of all the constituent
    netclasses it contains.  This message retrieves this effective netclass for a net or list of
    nets.
    Returns NetClassForNetsResponse
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NET_FIELD_NUMBER: builtins.int

    @property
    def net(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[board.board_types_pb2.Net]:
        ...

    def __init__(self, *, net: collections.abc.Iterable[board.board_types_pb2.Net] | None=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['net', b'net']) -> None:
        ...
global___GetNetClassForNets = GetNetClassForNets

@typing_extensions.final
class NetClassForNetsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ClassesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str

        @property
        def value(self) -> common.types.project_settings_pb2.NetClass:
            ...

        def __init__(self, *, key: builtins.str=..., value: common.types.project_settings_pb2.NetClass | None=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['value', b'value']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['key', b'key', 'value', b'value']) -> None:
            ...
    CLASSES_FIELD_NUMBER: builtins.int

    @property
    def classes(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, common.types.project_settings_pb2.NetClass]:
        """Map of net name to netclass info"""

    def __init__(self, *, classes: collections.abc.Mapping[builtins.str, common.types.project_settings_pb2.NetClass] | None=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['classes', b'classes']) -> None:
        ...
global___NetClassForNetsResponse = NetClassForNetsResponse

@typing_extensions.final
class RefillZones(google.protobuf.message.Message):
    """
    Blocking operations

    Refills some or all zones on the board.
    This is a blocking operation; it will return Empty immediately, but KiCad will return
    ApiStatusCode.AS_BUSY to all future API requests until the zone fill has completed.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int
    ZONES_FIELD_NUMBER: builtins.int

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    @property
    def zones(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[common.types.base_types_pb2.KIID]:
        """A list of zones to refill.  If empty, all zones are refilled."""

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=..., zones: collections.abc.Iterable[common.types.base_types_pb2.KIID] | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['board', b'board']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['board', b'board', 'zones', b'zones']) -> None:
        ...
global___RefillZones = RefillZones

@typing_extensions.final
class GetPadShapeAsPolygon(google.protobuf.message.Message):
    """
    Utilities

    Computes the polygon representation of a pad, merging any custom shapes together.
    This representation will approximate curves as a series of segments.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int
    PADS_FIELD_NUMBER: builtins.int
    LAYER_FIELD_NUMBER: builtins.int

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        """The board to process"""

    @property
    def pads(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[common.types.base_types_pb2.KIID]:
        """A list of one or more pads to process"""
    layer: board.board_types_pb2.BoardLayer.ValueType
    'The layer to process'

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=..., pads: collections.abc.Iterable[common.types.base_types_pb2.KIID] | None=..., layer: board.board_types_pb2.BoardLayer.ValueType=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['board', b'board']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['board', b'board', 'layer', b'layer', 'pads', b'pads']) -> None:
        ...
global___GetPadShapeAsPolygon = GetPadShapeAsPolygon

@typing_extensions.final
class PadShapeAsPolygonResponse(google.protobuf.message.Message):
    """Returned from GetPadShapeAsPolygon.  The pads and polygons repeated fields will have the same length
    and can be treated as a list of tuples.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PADS_FIELD_NUMBER: builtins.int
    POLYGONS_FIELD_NUMBER: builtins.int

    @property
    def pads(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[common.types.base_types_pb2.KIID]:
        """The pads that were processed"""

    @property
    def polygons(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[common.types.base_types_pb2.PolygonWithHoles]:
        """The polygon representation of each pad"""

    def __init__(self, *, pads: collections.abc.Iterable[common.types.base_types_pb2.KIID] | None=..., polygons: collections.abc.Iterable[common.types.base_types_pb2.PolygonWithHoles] | None=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['pads', b'pads', 'polygons', b'polygons']) -> None:
        ...
global___PadShapeAsPolygonResponse = PadShapeAsPolygonResponse

@typing_extensions.final
class GetVisibleLayers(google.protobuf.message.Message):
    """PCB editor commands

    returns BoardLayers
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['board', b'board']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['board', b'board']) -> None:
        ...
global___GetVisibleLayers = GetVisibleLayers

@typing_extensions.final
class BoardLayerResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    LAYER_FIELD_NUMBER: builtins.int
    layer: board.board_types_pb2.BoardLayer.ValueType

    def __init__(self, *, layer: board.board_types_pb2.BoardLayer.ValueType=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['layer', b'layer']) -> None:
        ...
global___BoardLayerResponse = BoardLayerResponse

@typing_extensions.final
class BoardLayers(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    LAYERS_FIELD_NUMBER: builtins.int

    @property
    def layers(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[board.board_types_pb2.BoardLayer.ValueType]:
        ...

    def __init__(self, *, layers: collections.abc.Iterable[board.board_types_pb2.BoardLayer.ValueType] | None=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['layers', b'layers']) -> None:
        ...
global___BoardLayers = BoardLayers

@typing_extensions.final
class SetVisibleLayers(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int
    LAYERS_FIELD_NUMBER: builtins.int

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    @property
    def layers(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[board.board_types_pb2.BoardLayer.ValueType]:
        ...

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=..., layers: collections.abc.Iterable[board.board_types_pb2.BoardLayer.ValueType] | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['board', b'board']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['board', b'board', 'layers', b'layers']) -> None:
        ...
global___SetVisibleLayers = SetVisibleLayers

@typing_extensions.final
class GetActiveLayer(google.protobuf.message.Message):
    """returns BoardLayerResponse"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['board', b'board']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['board', b'board']) -> None:
        ...
global___GetActiveLayer = GetActiveLayer

@typing_extensions.final
class SetActiveLayer(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int
    LAYER_FIELD_NUMBER: builtins.int

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...
    layer: board.board_types_pb2.BoardLayer.ValueType

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=..., layer: board.board_types_pb2.BoardLayer.ValueType=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['board', b'board']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['board', b'board', 'layer', b'layer']) -> None:
        ...
global___SetActiveLayer = SetActiveLayer

@typing_extensions.final
class BoardEditorAppearanceSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    INACTIVE_LAYER_DISPLAY_FIELD_NUMBER: builtins.int
    NET_COLOR_DISPLAY_FIELD_NUMBER: builtins.int
    BOARD_FLIP_FIELD_NUMBER: builtins.int
    RATSNEST_DISPLAY_FIELD_NUMBER: builtins.int
    inactive_layer_display: global___InactiveLayerDisplayMode.ValueType
    net_color_display: global___NetColorDisplayMode.ValueType
    board_flip: global___BoardFlipMode.ValueType
    ratsnest_display: global___RatsnestDisplayMode.ValueType

    def __init__(self, *, inactive_layer_display: global___InactiveLayerDisplayMode.ValueType=..., net_color_display: global___NetColorDisplayMode.ValueType=..., board_flip: global___BoardFlipMode.ValueType=..., ratsnest_display: global___RatsnestDisplayMode.ValueType=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['board_flip', b'board_flip', 'inactive_layer_display', b'inactive_layer_display', 'net_color_display', b'net_color_display', 'ratsnest_display', b'ratsnest_display']) -> None:
        ...
global___BoardEditorAppearanceSettings = BoardEditorAppearanceSettings

@typing_extensions.final
class GetBoardEditorAppearanceSettings(google.protobuf.message.Message):
    """Returns BoardEditorAppearanceSettings"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(self) -> None:
        ...
global___GetBoardEditorAppearanceSettings = GetBoardEditorAppearanceSettings

@typing_extensions.final
class SetBoardEditorAppearanceSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SETTINGS_FIELD_NUMBER: builtins.int

    @property
    def settings(self) -> global___BoardEditorAppearanceSettings:
        ...

    def __init__(self, *, settings: global___BoardEditorAppearanceSettings | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['settings', b'settings']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['settings', b'settings']) -> None:
        ...
global___SetBoardEditorAppearanceSettings = SetBoardEditorAppearanceSettings

@typing_extensions.final
class InteractiveMoveItems(google.protobuf.message.Message):
    """// Interactive commands ////
    These commands begin an interactive operation in the editor.
    They return a response immediately, but the editor will become busy
    and will not reply to further API commands until the user has finished
    the operation.
    These commands will return an error if received in a non-interactive context.

    Selects and begins an interactive move of the given item(s).
    NOTE: Takes ownership of the active commit, if one exists:
          the move tool will push the commit when the user confirms the move,
          or roll back the commit if the user cancels the move.  Keep this in
          mind if using this command in combination with commands that create
          or modify items using an explicit commit.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    BOARD_FIELD_NUMBER: builtins.int
    ITEMS_FIELD_NUMBER: builtins.int

    @property
    def board(self) -> common.types.base_types_pb2.DocumentSpecifier:
        ...

    @property
    def items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[common.types.base_types_pb2.KIID]:
        ...

    def __init__(self, *, board: common.types.base_types_pb2.DocumentSpecifier | None=..., items: collections.abc.Iterable[common.types.base_types_pb2.KIID] | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['board', b'board']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['board', b'board', 'items', b'items']) -> None:
        ...
global___InteractiveMoveItems = InteractiveMoveItems