"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

project_settings.proto
Messages that describes project settings shared between schematics and boards
"""
from ... import board
import builtins
import collections.abc
from ... import common
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing
if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions
DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _NetClassType:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _NetClassTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_NetClassType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    NCT_UNKNOWN: _NetClassType.ValueType
    NCT_EXPLICIT: _NetClassType.ValueType
    'An explicitly-defined netclass, created by the user and saved in the project file'
    NCT_IMPLICIT: _NetClassType.ValueType
    'An implicit (effective) netclass, made up of multiple explicit netclasses'

class NetClassType(_NetClassType, metaclass=_NetClassTypeEnumTypeWrapper):
    ...
NCT_UNKNOWN: NetClassType.ValueType
NCT_EXPLICIT: NetClassType.ValueType
'An explicitly-defined netclass, created by the user and saved in the project file'
NCT_IMPLICIT: NetClassType.ValueType
'An implicit (effective) netclass, made up of multiple explicit netclasses'
global___NetClassType = NetClassType

@typing_extensions.final
class NetClassBoardSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CLEARANCE_FIELD_NUMBER: builtins.int
    TRACK_WIDTH_FIELD_NUMBER: builtins.int
    DIFF_PAIR_TRACK_WIDTH_FIELD_NUMBER: builtins.int
    DIFF_PAIR_GAP_FIELD_NUMBER: builtins.int
    DIFF_PAIR_VIA_GAP_FIELD_NUMBER: builtins.int
    VIA_STACK_FIELD_NUMBER: builtins.int
    MICROVIA_STACK_FIELD_NUMBER: builtins.int
    COLOR_FIELD_NUMBER: builtins.int

    @property
    def clearance(self) -> common.types.base_types_pb2.Distance:
        ...

    @property
    def track_width(self) -> common.types.base_types_pb2.Distance:
        ...

    @property
    def diff_pair_track_width(self) -> common.types.base_types_pb2.Distance:
        ...

    @property
    def diff_pair_gap(self) -> common.types.base_types_pb2.Distance:
        ...

    @property
    def diff_pair_via_gap(self) -> common.types.base_types_pb2.Distance:
        ...

    @property
    def via_stack(self) -> board.board_types_pb2.PadStack:
        """The default padstack to use for vias belonging to this netclass
        Currently KiCad only supports specifying the drill diameter and annular size on all layers for
        netclass via stacks.  Complex padstacks and other via features cannot be specified here.
        """

    @property
    def microvia_stack(self) -> board.board_types_pb2.PadStack:
        """The default padstack to use for microvias belonging to this netclass
        Currently KiCad only supports specifying the drill diameter and annular size on all layers for
        netclass via stacks.  Complex padstacks and other via features cannot be specified here.
        """

    @property
    def color(self) -> common.types.base_types_pb2.Color:
        ...

    def __init__(self, *, clearance: common.types.base_types_pb2.Distance | None=..., track_width: common.types.base_types_pb2.Distance | None=..., diff_pair_track_width: common.types.base_types_pb2.Distance | None=..., diff_pair_gap: common.types.base_types_pb2.Distance | None=..., diff_pair_via_gap: common.types.base_types_pb2.Distance | None=..., via_stack: board.board_types_pb2.PadStack | None=..., microvia_stack: board.board_types_pb2.PadStack | None=..., color: common.types.base_types_pb2.Color | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['_clearance', b'_clearance', '_color', b'_color', '_diff_pair_gap', b'_diff_pair_gap', '_diff_pair_track_width', b'_diff_pair_track_width', '_diff_pair_via_gap', b'_diff_pair_via_gap', '_microvia_stack', b'_microvia_stack', '_track_width', b'_track_width', '_via_stack', b'_via_stack', 'clearance', b'clearance', 'color', b'color', 'diff_pair_gap', b'diff_pair_gap', 'diff_pair_track_width', b'diff_pair_track_width', 'diff_pair_via_gap', b'diff_pair_via_gap', 'microvia_stack', b'microvia_stack', 'track_width', b'track_width', 'via_stack', b'via_stack']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['_clearance', b'_clearance', '_color', b'_color', '_diff_pair_gap', b'_diff_pair_gap', '_diff_pair_track_width', b'_diff_pair_track_width', '_diff_pair_via_gap', b'_diff_pair_via_gap', '_microvia_stack', b'_microvia_stack', '_track_width', b'_track_width', '_via_stack', b'_via_stack', 'clearance', b'clearance', 'color', b'color', 'diff_pair_gap', b'diff_pair_gap', 'diff_pair_track_width', b'diff_pair_track_width', 'diff_pair_via_gap', b'diff_pair_via_gap', 'microvia_stack', b'microvia_stack', 'track_width', b'track_width', 'via_stack', b'via_stack']) -> None:
        ...

    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal['_clearance', b'_clearance']) -> typing_extensions.Literal['clearance'] | None:
        ...

    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal['_color', b'_color']) -> typing_extensions.Literal['color'] | None:
        ...

    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal['_diff_pair_gap', b'_diff_pair_gap']) -> typing_extensions.Literal['diff_pair_gap'] | None:
        ...

    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal['_diff_pair_track_width', b'_diff_pair_track_width']) -> typing_extensions.Literal['diff_pair_track_width'] | None:
        ...

    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal['_diff_pair_via_gap', b'_diff_pair_via_gap']) -> typing_extensions.Literal['diff_pair_via_gap'] | None:
        ...

    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal['_microvia_stack', b'_microvia_stack']) -> typing_extensions.Literal['microvia_stack'] | None:
        ...

    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal['_track_width', b'_track_width']) -> typing_extensions.Literal['track_width'] | None:
        ...

    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal['_via_stack', b'_via_stack']) -> typing_extensions.Literal['via_stack'] | None:
        ...
global___NetClassBoardSettings = NetClassBoardSettings

@typing_extensions.final
class NetClassSchematicSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    WIRE_WIDTH_FIELD_NUMBER: builtins.int
    BUS_WIDTH_FIELD_NUMBER: builtins.int
    COLOR_FIELD_NUMBER: builtins.int
    LINE_STYLE_FIELD_NUMBER: builtins.int

    @property
    def wire_width(self) -> common.types.base_types_pb2.Distance:
        ...

    @property
    def bus_width(self) -> common.types.base_types_pb2.Distance:
        ...

    @property
    def color(self) -> common.types.base_types_pb2.Color:
        ...
    line_style: common.types.enums_pb2.StrokeLineStyle.ValueType

    def __init__(self, *, wire_width: common.types.base_types_pb2.Distance | None=..., bus_width: common.types.base_types_pb2.Distance | None=..., color: common.types.base_types_pb2.Color | None=..., line_style: common.types.enums_pb2.StrokeLineStyle.ValueType | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['_bus_width', b'_bus_width', '_color', b'_color', '_line_style', b'_line_style', '_wire_width', b'_wire_width', 'bus_width', b'bus_width', 'color', b'color', 'line_style', b'line_style', 'wire_width', b'wire_width']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['_bus_width', b'_bus_width', '_color', b'_color', '_line_style', b'_line_style', '_wire_width', b'_wire_width', 'bus_width', b'bus_width', 'color', b'color', 'line_style', b'line_style', 'wire_width', b'wire_width']) -> None:
        ...

    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal['_bus_width', b'_bus_width']) -> typing_extensions.Literal['bus_width'] | None:
        ...

    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal['_color', b'_color']) -> typing_extensions.Literal['color'] | None:
        ...

    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal['_line_style', b'_line_style']) -> typing_extensions.Literal['line_style'] | None:
        ...

    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal['_wire_width', b'_wire_width']) -> typing_extensions.Literal['wire_width'] | None:
        ...
global___NetClassSchematicSettings = NetClassSchematicSettings

@typing_extensions.final
class NetClass(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NAME_FIELD_NUMBER: builtins.int
    PRIORITY_FIELD_NUMBER: builtins.int
    BOARD_FIELD_NUMBER: builtins.int
    SCHEMATIC_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    CONSTITUENTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    'The name of the netclass (the literal string "Default" for the default netclass)\n    May be empty for composite netclasses\n    '
    priority: builtins.int

    @property
    def board(self) -> global___NetClassBoardSettings:
        ...

    @property
    def schematic(self) -> global___NetClassSchematicSettings:
        ...
    type: global___NetClassType.ValueType

    @property
    def constituents(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """If this is a composite netclass, a list of the names of the "real" netclasses that make it up"""

    def __init__(self, *, name: builtins.str=..., priority: builtins.int | None=..., board: global___NetClassBoardSettings | None=..., schematic: global___NetClassSchematicSettings | None=..., type: global___NetClassType.ValueType=..., constituents: collections.abc.Iterable[builtins.str] | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['_board', b'_board', '_priority', b'_priority', '_schematic', b'_schematic', 'board', b'board', 'priority', b'priority', 'schematic', b'schematic']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['_board', b'_board', '_priority', b'_priority', '_schematic', b'_schematic', 'board', b'board', 'constituents', b'constituents', 'name', b'name', 'priority', b'priority', 'schematic', b'schematic', 'type', b'type']) -> None:
        ...

    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal['_board', b'_board']) -> typing_extensions.Literal['board'] | None:
        ...

    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal['_priority', b'_priority']) -> typing_extensions.Literal['priority'] | None:
        ...

    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal['_schematic', b'_schematic']) -> typing_extensions.Literal['schematic'] | None:
        ...
global___NetClass = NetClass

@typing_extensions.final
class TextVariables(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class VariablesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str

        def __init__(self, *, key: builtins.str=..., value: builtins.str=...) -> None:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['key', b'key', 'value', b'value']) -> None:
            ...
    VARIABLES_FIELD_NUMBER: builtins.int

    @property
    def variables(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        ...

    def __init__(self, *, variables: collections.abc.Mapping[builtins.str, builtins.str] | None=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['variables', b'variables']) -> None:
        ...
global___TextVariables = TextVariables