# KiCad API Python Bindings

`kicad-python` is the official Python bindings for the [KiCad](https://kicad.org) IPC API.  This
library makes it possible to develop scripts and tools that interact with a running KiCad session.

The KiCad IPC API can be considered in "public beta" state with the release of KiCad 9 (currently
planned for on or around February 1, 2025).  The existing SWIG-based Python bindings for KiCad's
PCB editor still exist in KiCad 9, but are in maintenance mode and will not be expanded.

For more information about the IPC API, please see the
[KiCad developer documentation](https://dev-docs.kicad.org/en/apis-and-binding/ipc-api/index.html).
Specific documentation for developing add-ons is
[also available](https://dev-docs.kicad.org/en/apis-and-binding/ipc-api/for-addon-developers/index.html).

> Note: Version 0.0.2 and prior of this package are an obsolete earlier effort and are unrelated to
> this codebase.

## Requirements

Using the IPC API requires a suitable version of KiCad (9.0 or higher) and requires that KiCad be
running with the API server enabled in Preferences > Plugins.  This package also depends on the
`protobuf` and `pynng` packages for communication with KiCad.

> Note: Unlike the SWIG-based Python bindings, the IPC API requires communication with a running
> instance of KiCad.  It is not possible to use `kicad-python` to manipulate KiCad design files
> without KiCad running.

## Contributing

Please file bug reports and feature requests in this Gitlab project.  The team may move them to the
main KiCad repository depending on the nature of the request.

Merge requests are welcome for minor fixes and improvements.  More significant changes should be
discussed with the development team (via email, or in an issue) first.

## Building from Source

Most users should use `kicad-python` by installing the latest version from PyPI.  You can also
build and install the library from this repository, to test unreleased changes or contribute to
the development.  For instructions on how to do so, please see `COMPILING.md`.

Note that this library builds against the API definitions (`.proto` files) in the `kicad` submodule.
Official releases of the library to PyPI should use a tagged release of KiCad, but the development
branch of `kicad-python` may sometimes move the submodule pointer to non-tagged commits during the
course of development.  If you are using this library from source rather than from PyPI, remember
to keep the submodule updated and to test against a suitable build of KiCad, which may need to be
a nightly or testing build in some situations.  You can use the method `KiCad.check_version` to
make sure you are using a compatible version of `kicad-python` for your installed version of KiCad.

## Getting Started

To check that everything is working, install `kicad-python` (either follow the directions in
COMPILING.md or else install the latest version from PyPI using `pip install kicad-python`).
Launch KiCad, make sure the API server is enabled in Preferences > Plugins, and then you should be
able to run:

```sh
$ python3 ./examples/hello.py
```

This should print out the version of KiCad you have connected to.

## Documentation

The documentation created from this repository (via the `docs` directory and the docstrings in the
source code) is hosted at https://docs.kicad.org/kicad-python-main

Many things are still not documented or underdocumented -- contributions that expand the
documentation or add docstrings are welcomed.

## Examples

Check out the repository for some example scripts that may serve as a starting point.  Some of the
examples are snippets that can be run directly from a terminal or your Python development
environment, and some are KiCad action plugins that can be loaded into the PCB editor.  For the
plugins, copy or symlink them into the appropriate plugins path in order for KiCad to find them.

## Release History

### 0.4.0 (July 8, 2025)

- Fix ability to move and rotate footprints
- Fix ArcTrack length calculation (Quentin Freimanis, !13)
- Make it possible to add new `BoardPolygon`s in a more ergonomic way
- Add `FootprintInstance.sheet_path` property (#37)
- Add `board.check_padstack_presence_on_layers`, replacing FlashLayer in SWIG
- Allow setting `Net.name` so that new nets can be created
- Deprecate `Net.code` (net codes are an internal KiCad detail and API clients should ignore them)
- Add `py.typed` type hinting indicator file (John Hagen, !16)
- Fix `Vector2.from_xy_mm` type annotations (John Hagen, !17)
- Add `Arc.angle` and `ArcTrack.angle`; some arc angle utilities (Quentin Freimanis, !14)
- Add `remove_items_by_id` (Anthonypark, !20)
- Allow assigning nets to `Zone` (#62)
- Allow changing `Pad.pad_type` (#63)
- Allow changing `Field.layer` (#64)

### 0.3.0 (March 29, 2025)

- Add support for footprint mounting style attribute (#19) (Thanh Duong, !10)
- Added `visible` property to `Field` and deprecate it from `TextAttributes` to match KiCad changes
- Improve version checking functions(Lucas Gerads, !11)
- Add missing board layers User.10 through User.45 (#23)
- Improve padstack-related APIs for creating new vias and pads (#21)
- Change arc angle methods to return normalized angles; add degrees versions (#22)
- Add `board.get_origin` and `board.set_origin` (#20)
- Add `ArcTrack.length` (Thanh Duong, !12)
- Add `Footprint.models` (#31)
- Fix ability to create new graphic shapes on boards
- Fix the return value of `Board.update_items` and document it (#35)

### 0.2.0 (February 19, 2025)

- Updates for KiCad 9.0.0 release
- Fix `util.board_layer.canonical_name` names for technical layers
- Add board item selection management APIs
- Fix `requirements.txt` files in sample plugins
- Fix RecursionError when calling `BoardCircle.__repr__` (#13)
- Relicense as MIT

### 0.1.2 (January 17, 2025)

- Updates for KiCad 9.0.0-rc2 release
- Fixes to plugin examples
- Add support for various project settings, board stackup, board file management
- Add helpers for board layer name conversions
- Change thermal spoke settings to match updated KiCad API
- Documentation improvements

### 0.1.1 (December 24, 2024)

- Bump dependency versions to fix compilation with newer protoc

### 0.1.0 (December 21, 2024)

*Corresponding KiCad version: 9.0.0-rc1*

First formal release of the new IPC-API version of this package.  Contains support for most of the
KiCad API functionality that is currently exposed, which is focused around the PCB editor to enable
a transition path from existing SWIG-based plugins.
