"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

This program source code file is part of KiCad, a free EDA CAD application.

Copyright (C) 2024 KiCad Developers, see AUTHORS.txt for contributors.

This program is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, either version 3 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see <http://www.gnu.org/licenses/>.
"""
import builtins
import collections.abc
from .. import common
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing
if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions
DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _BoardLayer:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _BoardLayerEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_BoardLayer.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    BL_UNKNOWN: _BoardLayer.ValueType
    BL_UNDEFINED: _BoardLayer.ValueType
    BL_UNSELECTED: _BoardLayer.ValueType
    BL_F_Cu: _BoardLayer.ValueType
    BL_In1_Cu: _BoardLayer.ValueType
    BL_In2_Cu: _BoardLayer.ValueType
    BL_In3_Cu: _BoardLayer.ValueType
    BL_In4_Cu: _BoardLayer.ValueType
    BL_In5_Cu: _BoardLayer.ValueType
    BL_In6_Cu: _BoardLayer.ValueType
    BL_In7_Cu: _BoardLayer.ValueType
    BL_In8_Cu: _BoardLayer.ValueType
    BL_In9_Cu: _BoardLayer.ValueType
    BL_In10_Cu: _BoardLayer.ValueType
    BL_In11_Cu: _BoardLayer.ValueType
    BL_In12_Cu: _BoardLayer.ValueType
    BL_In13_Cu: _BoardLayer.ValueType
    BL_In14_Cu: _BoardLayer.ValueType
    BL_In15_Cu: _BoardLayer.ValueType
    BL_In16_Cu: _BoardLayer.ValueType
    BL_In17_Cu: _BoardLayer.ValueType
    BL_In18_Cu: _BoardLayer.ValueType
    BL_In19_Cu: _BoardLayer.ValueType
    BL_In20_Cu: _BoardLayer.ValueType
    BL_In21_Cu: _BoardLayer.ValueType
    BL_In22_Cu: _BoardLayer.ValueType
    BL_In23_Cu: _BoardLayer.ValueType
    BL_In24_Cu: _BoardLayer.ValueType
    BL_In25_Cu: _BoardLayer.ValueType
    BL_In26_Cu: _BoardLayer.ValueType
    BL_In27_Cu: _BoardLayer.ValueType
    BL_In28_Cu: _BoardLayer.ValueType
    BL_In29_Cu: _BoardLayer.ValueType
    BL_In30_Cu: _BoardLayer.ValueType
    BL_B_Cu: _BoardLayer.ValueType
    BL_B_Adhes: _BoardLayer.ValueType
    BL_F_Adhes: _BoardLayer.ValueType
    BL_B_Paste: _BoardLayer.ValueType
    BL_F_Paste: _BoardLayer.ValueType
    BL_B_SilkS: _BoardLayer.ValueType
    BL_F_SilkS: _BoardLayer.ValueType
    BL_B_Mask: _BoardLayer.ValueType
    BL_F_Mask: _BoardLayer.ValueType
    BL_Dwgs_User: _BoardLayer.ValueType
    BL_Cmts_User: _BoardLayer.ValueType
    BL_Eco1_User: _BoardLayer.ValueType
    BL_Eco2_User: _BoardLayer.ValueType
    BL_Edge_Cuts: _BoardLayer.ValueType
    BL_Margin: _BoardLayer.ValueType
    BL_B_CrtYd: _BoardLayer.ValueType
    BL_F_CrtYd: _BoardLayer.ValueType
    BL_B_Fab: _BoardLayer.ValueType
    BL_F_Fab: _BoardLayer.ValueType
    BL_User_1: _BoardLayer.ValueType
    BL_User_2: _BoardLayer.ValueType
    BL_User_3: _BoardLayer.ValueType
    BL_User_4: _BoardLayer.ValueType
    BL_User_5: _BoardLayer.ValueType
    BL_User_6: _BoardLayer.ValueType
    BL_User_7: _BoardLayer.ValueType
    BL_User_8: _BoardLayer.ValueType
    BL_User_9: _BoardLayer.ValueType
    BL_Rescue: _BoardLayer.ValueType
    BL_User_10: _BoardLayer.ValueType
    BL_User_11: _BoardLayer.ValueType
    BL_User_12: _BoardLayer.ValueType
    BL_User_13: _BoardLayer.ValueType
    BL_User_14: _BoardLayer.ValueType
    BL_User_15: _BoardLayer.ValueType
    BL_User_16: _BoardLayer.ValueType
    BL_User_17: _BoardLayer.ValueType
    BL_User_18: _BoardLayer.ValueType
    BL_User_19: _BoardLayer.ValueType
    BL_User_20: _BoardLayer.ValueType
    BL_User_21: _BoardLayer.ValueType
    BL_User_22: _BoardLayer.ValueType
    BL_User_23: _BoardLayer.ValueType
    BL_User_24: _BoardLayer.ValueType
    BL_User_25: _BoardLayer.ValueType
    BL_User_26: _BoardLayer.ValueType
    BL_User_27: _BoardLayer.ValueType
    BL_User_28: _BoardLayer.ValueType
    BL_User_29: _BoardLayer.ValueType
    BL_User_30: _BoardLayer.ValueType
    BL_User_31: _BoardLayer.ValueType
    BL_User_32: _BoardLayer.ValueType
    BL_User_33: _BoardLayer.ValueType
    BL_User_34: _BoardLayer.ValueType
    BL_User_35: _BoardLayer.ValueType
    BL_User_36: _BoardLayer.ValueType
    BL_User_37: _BoardLayer.ValueType
    BL_User_38: _BoardLayer.ValueType
    BL_User_39: _BoardLayer.ValueType
    BL_User_40: _BoardLayer.ValueType
    BL_User_41: _BoardLayer.ValueType
    BL_User_42: _BoardLayer.ValueType
    BL_User_43: _BoardLayer.ValueType
    BL_User_44: _BoardLayer.ValueType
    BL_User_45: _BoardLayer.ValueType

class BoardLayer(_BoardLayer, metaclass=_BoardLayerEnumTypeWrapper):
    ...
BL_UNKNOWN: BoardLayer.ValueType
BL_UNDEFINED: BoardLayer.ValueType
BL_UNSELECTED: BoardLayer.ValueType
BL_F_Cu: BoardLayer.ValueType
BL_In1_Cu: BoardLayer.ValueType
BL_In2_Cu: BoardLayer.ValueType
BL_In3_Cu: BoardLayer.ValueType
BL_In4_Cu: BoardLayer.ValueType
BL_In5_Cu: BoardLayer.ValueType
BL_In6_Cu: BoardLayer.ValueType
BL_In7_Cu: BoardLayer.ValueType
BL_In8_Cu: BoardLayer.ValueType
BL_In9_Cu: BoardLayer.ValueType
BL_In10_Cu: BoardLayer.ValueType
BL_In11_Cu: BoardLayer.ValueType
BL_In12_Cu: BoardLayer.ValueType
BL_In13_Cu: BoardLayer.ValueType
BL_In14_Cu: BoardLayer.ValueType
BL_In15_Cu: BoardLayer.ValueType
BL_In16_Cu: BoardLayer.ValueType
BL_In17_Cu: BoardLayer.ValueType
BL_In18_Cu: BoardLayer.ValueType
BL_In19_Cu: BoardLayer.ValueType
BL_In20_Cu: BoardLayer.ValueType
BL_In21_Cu: BoardLayer.ValueType
BL_In22_Cu: BoardLayer.ValueType
BL_In23_Cu: BoardLayer.ValueType
BL_In24_Cu: BoardLayer.ValueType
BL_In25_Cu: BoardLayer.ValueType
BL_In26_Cu: BoardLayer.ValueType
BL_In27_Cu: BoardLayer.ValueType
BL_In28_Cu: BoardLayer.ValueType
BL_In29_Cu: BoardLayer.ValueType
BL_In30_Cu: BoardLayer.ValueType
BL_B_Cu: BoardLayer.ValueType
BL_B_Adhes: BoardLayer.ValueType
BL_F_Adhes: BoardLayer.ValueType
BL_B_Paste: BoardLayer.ValueType
BL_F_Paste: BoardLayer.ValueType
BL_B_SilkS: BoardLayer.ValueType
BL_F_SilkS: BoardLayer.ValueType
BL_B_Mask: BoardLayer.ValueType
BL_F_Mask: BoardLayer.ValueType
BL_Dwgs_User: BoardLayer.ValueType
BL_Cmts_User: BoardLayer.ValueType
BL_Eco1_User: BoardLayer.ValueType
BL_Eco2_User: BoardLayer.ValueType
BL_Edge_Cuts: BoardLayer.ValueType
BL_Margin: BoardLayer.ValueType
BL_B_CrtYd: BoardLayer.ValueType
BL_F_CrtYd: BoardLayer.ValueType
BL_B_Fab: BoardLayer.ValueType
BL_F_Fab: BoardLayer.ValueType
BL_User_1: BoardLayer.ValueType
BL_User_2: BoardLayer.ValueType
BL_User_3: BoardLayer.ValueType
BL_User_4: BoardLayer.ValueType
BL_User_5: BoardLayer.ValueType
BL_User_6: BoardLayer.ValueType
BL_User_7: BoardLayer.ValueType
BL_User_8: BoardLayer.ValueType
BL_User_9: BoardLayer.ValueType
BL_Rescue: BoardLayer.ValueType
BL_User_10: BoardLayer.ValueType
BL_User_11: BoardLayer.ValueType
BL_User_12: BoardLayer.ValueType
BL_User_13: BoardLayer.ValueType
BL_User_14: BoardLayer.ValueType
BL_User_15: BoardLayer.ValueType
BL_User_16: BoardLayer.ValueType
BL_User_17: BoardLayer.ValueType
BL_User_18: BoardLayer.ValueType
BL_User_19: BoardLayer.ValueType
BL_User_20: BoardLayer.ValueType
BL_User_21: BoardLayer.ValueType
BL_User_22: BoardLayer.ValueType
BL_User_23: BoardLayer.ValueType
BL_User_24: BoardLayer.ValueType
BL_User_25: BoardLayer.ValueType
BL_User_26: BoardLayer.ValueType
BL_User_27: BoardLayer.ValueType
BL_User_28: BoardLayer.ValueType
BL_User_29: BoardLayer.ValueType
BL_User_30: BoardLayer.ValueType
BL_User_31: BoardLayer.ValueType
BL_User_32: BoardLayer.ValueType
BL_User_33: BoardLayer.ValueType
BL_User_34: BoardLayer.ValueType
BL_User_35: BoardLayer.ValueType
BL_User_36: BoardLayer.ValueType
BL_User_37: BoardLayer.ValueType
BL_User_38: BoardLayer.ValueType
BL_User_39: BoardLayer.ValueType
BL_User_40: BoardLayer.ValueType
BL_User_41: BoardLayer.ValueType
BL_User_42: BoardLayer.ValueType
BL_User_43: BoardLayer.ValueType
BL_User_44: BoardLayer.ValueType
BL_User_45: BoardLayer.ValueType
global___BoardLayer = BoardLayer

class _PadStackType:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PadStackTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_PadStackType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    PST_UNKNOWN: _PadStackType.ValueType
    PST_NORMAL: _PadStackType.ValueType
    'The same shape is used on all copper layers'
    PST_FRONT_INNER_BACK: _PadStackType.ValueType
    'The padstack uses up to three different shapes (F_Cu, inner layers, B_Cu)'
    PST_CUSTOM: _PadStackType.ValueType
    "The padstack's shape may differ on arbitrary copper layers"

class PadStackType(_PadStackType, metaclass=_PadStackTypeEnumTypeWrapper):
    """What copper layer shape mode the padstack uses"""
PST_UNKNOWN: PadStackType.ValueType
PST_NORMAL: PadStackType.ValueType
'The same shape is used on all copper layers'
PST_FRONT_INNER_BACK: PadStackType.ValueType
'The padstack uses up to three different shapes (F_Cu, inner layers, B_Cu)'
PST_CUSTOM: PadStackType.ValueType
"The padstack's shape may differ on arbitrary copper layers"
global___PadStackType = PadStackType

class _UnconnectedLayerRemoval:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _UnconnectedLayerRemovalEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_UnconnectedLayerRemoval.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ULR_UNKNOWN: _UnconnectedLayerRemoval.ValueType
    ULR_KEEP: _UnconnectedLayerRemoval.ValueType
    'Keep annular rings on all layers'
    ULR_REMOVE: _UnconnectedLayerRemoval.ValueType
    'Remove annular rings on unconnected layers, including start and end layers.'
    ULR_REMOVE_EXCEPT_START_AND_END: _UnconnectedLayerRemoval.ValueType
    'Remove annular rings on unconnected layers, but preserve start and end layers even if unconnected.'

class UnconnectedLayerRemoval(_UnconnectedLayerRemoval, metaclass=_UnconnectedLayerRemovalEnumTypeWrapper):
    ...
ULR_UNKNOWN: UnconnectedLayerRemoval.ValueType
ULR_KEEP: UnconnectedLayerRemoval.ValueType
'Keep annular rings on all layers'
ULR_REMOVE: UnconnectedLayerRemoval.ValueType
'Remove annular rings on unconnected layers, including start and end layers.'
ULR_REMOVE_EXCEPT_START_AND_END: UnconnectedLayerRemoval.ValueType
'Remove annular rings on unconnected layers, but preserve start and end layers even if unconnected.'
global___UnconnectedLayerRemoval = UnconnectedLayerRemoval

class _PadStackShape:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PadStackShapeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_PadStackShape.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    PSS_UNKNOWN: _PadStackShape.ValueType
    PSS_CIRCLE: _PadStackShape.ValueType
    PSS_RECTANGLE: _PadStackShape.ValueType
    PSS_OVAL: _PadStackShape.ValueType
    PSS_TRAPEZOID: _PadStackShape.ValueType
    PSS_ROUNDRECT: _PadStackShape.ValueType
    PSS_CHAMFEREDRECT: _PadStackShape.ValueType
    PSS_CUSTOM: _PadStackShape.ValueType

class PadStackShape(_PadStackShape, metaclass=_PadStackShapeEnumTypeWrapper):
    """The shape of a pad on a given layer"""
PSS_UNKNOWN: PadStackShape.ValueType
PSS_CIRCLE: PadStackShape.ValueType
PSS_RECTANGLE: PadStackShape.ValueType
PSS_OVAL: PadStackShape.ValueType
PSS_TRAPEZOID: PadStackShape.ValueType
PSS_ROUNDRECT: PadStackShape.ValueType
PSS_CHAMFEREDRECT: PadStackShape.ValueType
PSS_CUSTOM: PadStackShape.ValueType
global___PadStackShape = PadStackShape

class _ZoneConnectionStyle:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ZoneConnectionStyleEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ZoneConnectionStyle.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ZCS_UNKNOWN: _ZoneConnectionStyle.ValueType
    ZCS_INHERITED: _ZoneConnectionStyle.ValueType
    ZCS_NONE: _ZoneConnectionStyle.ValueType
    ZCS_THERMAL: _ZoneConnectionStyle.ValueType
    ZCS_FULL: _ZoneConnectionStyle.ValueType
    ZCS_PTH_THERMAL: _ZoneConnectionStyle.ValueType
    'Thermal reliefs for plated through holes, solid for SMD pads'

class ZoneConnectionStyle(_ZoneConnectionStyle, metaclass=_ZoneConnectionStyleEnumTypeWrapper):
    """enum class ZONE_CONNECTION"""
ZCS_UNKNOWN: ZoneConnectionStyle.ValueType
ZCS_INHERITED: ZoneConnectionStyle.ValueType
ZCS_NONE: ZoneConnectionStyle.ValueType
ZCS_THERMAL: ZoneConnectionStyle.ValueType
ZCS_FULL: ZoneConnectionStyle.ValueType
ZCS_PTH_THERMAL: ZoneConnectionStyle.ValueType
'Thermal reliefs for plated through holes, solid for SMD pads'
global___ZoneConnectionStyle = ZoneConnectionStyle

class _SolderMaskMode:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SolderMaskModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SolderMaskMode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SMM_UNKOWN: _SolderMaskMode.ValueType
    SMM_MASKED: _SolderMaskMode.ValueType
    SMM_UNMASKED: _SolderMaskMode.ValueType
    SMM_FROM_DESIGN_RULES: _SolderMaskMode.ValueType

class SolderMaskMode(_SolderMaskMode, metaclass=_SolderMaskModeEnumTypeWrapper):
    ...
SMM_UNKOWN: SolderMaskMode.ValueType
SMM_MASKED: SolderMaskMode.ValueType
SMM_UNMASKED: SolderMaskMode.ValueType
SMM_FROM_DESIGN_RULES: SolderMaskMode.ValueType
global___SolderMaskMode = SolderMaskMode

class _SolderPasteMode:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SolderPasteModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SolderPasteMode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SPM_UNKOWN: _SolderPasteMode.ValueType
    SPM_PASTE: _SolderPasteMode.ValueType
    SPM_NO_PASTE: _SolderPasteMode.ValueType
    SPM_FROM_DESIGN_RULES: _SolderPasteMode.ValueType

class SolderPasteMode(_SolderPasteMode, metaclass=_SolderPasteModeEnumTypeWrapper):
    ...
SPM_UNKOWN: SolderPasteMode.ValueType
SPM_PASTE: SolderPasteMode.ValueType
SPM_NO_PASTE: SolderPasteMode.ValueType
SPM_FROM_DESIGN_RULES: SolderPasteMode.ValueType
global___SolderPasteMode = SolderPasteMode

class _DrillShape:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DrillShapeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DrillShape.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DS_UNKNOWN: _DrillShape.ValueType
    DS_CIRCLE: _DrillShape.ValueType
    DS_OBLONG: _DrillShape.ValueType
    DS_UNDEFINED: _DrillShape.ValueType

class DrillShape(_DrillShape, metaclass=_DrillShapeEnumTypeWrapper):
    ...
DS_UNKNOWN: DrillShape.ValueType
DS_CIRCLE: DrillShape.ValueType
DS_OBLONG: DrillShape.ValueType
DS_UNDEFINED: DrillShape.ValueType
global___DrillShape = DrillShape

class _ViaType:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ViaTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ViaType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    VT_UNKNOWN: _ViaType.ValueType
    VT_THROUGH: _ViaType.ValueType
    'Through vias always start on F_Cu and end on B_Cu'
    VT_BLIND_BURIED: _ViaType.ValueType
    'Blind/buried vias can have arbitrary start and end layers'
    VT_MICRO: _ViaType.ValueType
    'Microvias, blind/buried vias, can have arbitrary start and end layers, but also have different\n    size defaults and design rules\n    '

class ViaType(_ViaType, metaclass=_ViaTypeEnumTypeWrapper):
    ...
VT_UNKNOWN: ViaType.ValueType
VT_THROUGH: ViaType.ValueType
'Through vias always start on F_Cu and end on B_Cu'
VT_BLIND_BURIED: ViaType.ValueType
'Blind/buried vias can have arbitrary start and end layers'
VT_MICRO: ViaType.ValueType
'Microvias, blind/buried vias, can have arbitrary start and end layers, but also have different\nsize defaults and design rules\n'
global___ViaType = ViaType

class _PadType:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PadTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_PadType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    PT_UNKNOWN: _PadType.ValueType
    PT_PTH: _PadType.ValueType
    PT_SMD: _PadType.ValueType
    PT_EDGE_CONNECTOR: _PadType.ValueType
    PT_NPTH: _PadType.ValueType

class PadType(_PadType, metaclass=_PadTypeEnumTypeWrapper):
    """NOTE: There has been some discussion about what to do with pad attributes and properties.
    This may be considered somewhat unstable until we decide what to do with the KiCad side.
    It is not clear what the set of mutually-exclusive pad types will be at the end of the day,
    versus what will be non-exclusive attributes/properties.
    For now, this maps to PAD_ATTRIB in KiCad.
    """
PT_UNKNOWN: PadType.ValueType
PT_PTH: PadType.ValueType
PT_SMD: PadType.ValueType
PT_EDGE_CONNECTOR: PadType.ValueType
PT_NPTH: PadType.ValueType
global___PadType = PadType

class _CustomPadShapeZoneFillStrategy:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CustomPadShapeZoneFillStrategyEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_CustomPadShapeZoneFillStrategy.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CPSZ_UNKNOWN: _CustomPadShapeZoneFillStrategy.ValueType
    CPSZ_OUTLINE: _CustomPadShapeZoneFillStrategy.ValueType
    CPSZ_CONVEXHULL: _CustomPadShapeZoneFillStrategy.ValueType

class CustomPadShapeZoneFillStrategy(_CustomPadShapeZoneFillStrategy, metaclass=_CustomPadShapeZoneFillStrategyEnumTypeWrapper):
    ...
CPSZ_UNKNOWN: CustomPadShapeZoneFillStrategy.ValueType
CPSZ_OUTLINE: CustomPadShapeZoneFillStrategy.ValueType
CPSZ_CONVEXHULL: CustomPadShapeZoneFillStrategy.ValueType
global___CustomPadShapeZoneFillStrategy = CustomPadShapeZoneFillStrategy

class _ZoneType:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ZoneTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ZoneType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ZT_UNKNOWN: _ZoneType.ValueType
    ZT_COPPER: _ZoneType.ValueType
    ZT_GRAPHICAL: _ZoneType.ValueType
    ZT_RULE_AREA: _ZoneType.ValueType
    ZT_TEARDROP: _ZoneType.ValueType

class ZoneType(_ZoneType, metaclass=_ZoneTypeEnumTypeWrapper):
    ...
ZT_UNKNOWN: ZoneType.ValueType
ZT_COPPER: ZoneType.ValueType
ZT_GRAPHICAL: ZoneType.ValueType
ZT_RULE_AREA: ZoneType.ValueType
ZT_TEARDROP: ZoneType.ValueType
global___ZoneType = ZoneType

class _TeardropType:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _TeardropTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_TeardropType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TDT_UNKNOWN: _TeardropType.ValueType
    TDT_NONE: _TeardropType.ValueType
    TDT_UNSPECIFIED: _TeardropType.ValueType
    TDT_VIA_PAD: _TeardropType.ValueType
    TDT_TRACK_END: _TeardropType.ValueType

class TeardropType(_TeardropType, metaclass=_TeardropTypeEnumTypeWrapper):
    ...
TDT_UNKNOWN: TeardropType.ValueType
TDT_NONE: TeardropType.ValueType
TDT_UNSPECIFIED: TeardropType.ValueType
TDT_VIA_PAD: TeardropType.ValueType
TDT_TRACK_END: TeardropType.ValueType
global___TeardropType = TeardropType

class _IslandRemovalMode:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _IslandRemovalModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_IslandRemovalMode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    IRM_UNKNOWN: _IslandRemovalMode.ValueType
    IRM_ALWAYS: _IslandRemovalMode.ValueType
    IRM_NEVER: _IslandRemovalMode.ValueType
    IRM_AREA: _IslandRemovalMode.ValueType

class IslandRemovalMode(_IslandRemovalMode, metaclass=_IslandRemovalModeEnumTypeWrapper):
    ...
IRM_UNKNOWN: IslandRemovalMode.ValueType
IRM_ALWAYS: IslandRemovalMode.ValueType
IRM_NEVER: IslandRemovalMode.ValueType
IRM_AREA: IslandRemovalMode.ValueType
global___IslandRemovalMode = IslandRemovalMode

class _ZoneFillMode:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ZoneFillModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ZoneFillMode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ZFM_UNKNOWN: _ZoneFillMode.ValueType
    ZFM_SOLID: _ZoneFillMode.ValueType
    ZFM_HATCHED: _ZoneFillMode.ValueType

class ZoneFillMode(_ZoneFillMode, metaclass=_ZoneFillModeEnumTypeWrapper):
    ...
ZFM_UNKNOWN: ZoneFillMode.ValueType
ZFM_SOLID: ZoneFillMode.ValueType
ZFM_HATCHED: ZoneFillMode.ValueType
global___ZoneFillMode = ZoneFillMode

class _ZoneHatchSmoothing:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ZoneHatchSmoothingEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ZoneHatchSmoothing.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ZHS_UNKNOWN: _ZoneHatchSmoothing.ValueType
    ZHS_NONE: _ZoneHatchSmoothing.ValueType
    ZHS_FILLET: _ZoneHatchSmoothing.ValueType
    ZHS_ARC_LOW_DEF: _ZoneHatchSmoothing.ValueType
    ZHS_ARC_HIGH_DEF: _ZoneHatchSmoothing.ValueType

class ZoneHatchSmoothing(_ZoneHatchSmoothing, metaclass=_ZoneHatchSmoothingEnumTypeWrapper):
    ...
ZHS_UNKNOWN: ZoneHatchSmoothing.ValueType
ZHS_NONE: ZoneHatchSmoothing.ValueType
ZHS_FILLET: ZoneHatchSmoothing.ValueType
ZHS_ARC_LOW_DEF: ZoneHatchSmoothing.ValueType
ZHS_ARC_HIGH_DEF: ZoneHatchSmoothing.ValueType
global___ZoneHatchSmoothing = ZoneHatchSmoothing

class _ZoneHatchFillBorderMode:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ZoneHatchFillBorderModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ZoneHatchFillBorderMode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ZHFBM_UNKNOWN: _ZoneHatchFillBorderMode.ValueType
    ZHFBM_USE_MIN_ZONE_THICKNESS: _ZoneHatchFillBorderMode.ValueType
    ZHFBM_USE_HATCH_THICKNESS: _ZoneHatchFillBorderMode.ValueType

class ZoneHatchFillBorderMode(_ZoneHatchFillBorderMode, metaclass=_ZoneHatchFillBorderModeEnumTypeWrapper):
    ...
ZHFBM_UNKNOWN: ZoneHatchFillBorderMode.ValueType
ZHFBM_USE_MIN_ZONE_THICKNESS: ZoneHatchFillBorderMode.ValueType
ZHFBM_USE_HATCH_THICKNESS: ZoneHatchFillBorderMode.ValueType
global___ZoneHatchFillBorderMode = ZoneHatchFillBorderMode

class _PlacementRuleSourceType:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PlacementRuleSourceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_PlacementRuleSourceType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    PRST_UNKNOWN: _PlacementRuleSourceType.ValueType
    PRST_SHEET_NAME: _PlacementRuleSourceType.ValueType
    PRST_COMPONENT_CLASS: _PlacementRuleSourceType.ValueType

class PlacementRuleSourceType(_PlacementRuleSourceType, metaclass=_PlacementRuleSourceTypeEnumTypeWrapper):
    ...
PRST_UNKNOWN: PlacementRuleSourceType.ValueType
PRST_SHEET_NAME: PlacementRuleSourceType.ValueType
PRST_COMPONENT_CLASS: PlacementRuleSourceType.ValueType
global___PlacementRuleSourceType = PlacementRuleSourceType

class _ZoneBorderStyle:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ZoneBorderStyleEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ZoneBorderStyle.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ZBS_UNKNOWN: _ZoneBorderStyle.ValueType
    ZBS_SOLID: _ZoneBorderStyle.ValueType
    ZBS_DIAGONAL_FULL: _ZoneBorderStyle.ValueType
    ZBS_DIAGONAL_EDGE: _ZoneBorderStyle.ValueType
    ZBS_INVISIBLE: _ZoneBorderStyle.ValueType

class ZoneBorderStyle(_ZoneBorderStyle, metaclass=_ZoneBorderStyleEnumTypeWrapper):
    ...
ZBS_UNKNOWN: ZoneBorderStyle.ValueType
ZBS_SOLID: ZoneBorderStyle.ValueType
ZBS_DIAGONAL_FULL: ZoneBorderStyle.ValueType
ZBS_DIAGONAL_EDGE: ZoneBorderStyle.ValueType
ZBS_INVISIBLE: ZoneBorderStyle.ValueType
global___ZoneBorderStyle = ZoneBorderStyle

class _DimensionTextBorderStyle:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DimensionTextBorderStyleEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DimensionTextBorderStyle.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DTBS_UNKNOWN: _DimensionTextBorderStyle.ValueType
    DTBS_NONE: _DimensionTextBorderStyle.ValueType
    DTBS_RECTANGLE: _DimensionTextBorderStyle.ValueType
    DTBS_CIRCLE: _DimensionTextBorderStyle.ValueType
    DTBS_ROUNDRECT: _DimensionTextBorderStyle.ValueType

class DimensionTextBorderStyle(_DimensionTextBorderStyle, metaclass=_DimensionTextBorderStyleEnumTypeWrapper):
    """The style of the optional frame applied to dimension text"""
DTBS_UNKNOWN: DimensionTextBorderStyle.ValueType
DTBS_NONE: DimensionTextBorderStyle.ValueType
DTBS_RECTANGLE: DimensionTextBorderStyle.ValueType
DTBS_CIRCLE: DimensionTextBorderStyle.ValueType
DTBS_ROUNDRECT: DimensionTextBorderStyle.ValueType
global___DimensionTextBorderStyle = DimensionTextBorderStyle

class _DimensionUnitFormat:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DimensionUnitFormatEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DimensionUnitFormat.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DUF_UNKNOWN: _DimensionUnitFormat.ValueType
    DUF_NO_SUFFIX: _DimensionUnitFormat.ValueType
    DUF_BARE_SUFFIX: _DimensionUnitFormat.ValueType
    DUF_PAREN_SUFFIX: _DimensionUnitFormat.ValueType

class DimensionUnitFormat(_DimensionUnitFormat, metaclass=_DimensionUnitFormatEnumTypeWrapper):
    ...
DUF_UNKNOWN: DimensionUnitFormat.ValueType
DUF_NO_SUFFIX: DimensionUnitFormat.ValueType
DUF_BARE_SUFFIX: DimensionUnitFormat.ValueType
DUF_PAREN_SUFFIX: DimensionUnitFormat.ValueType
global___DimensionUnitFormat = DimensionUnitFormat

class _DimensionArrowDirection:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DimensionArrowDirectionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DimensionArrowDirection.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DAD_UNKNOWN: _DimensionArrowDirection.ValueType
    DAD_INWARD: _DimensionArrowDirection.ValueType
    DAD_OUTWARD: _DimensionArrowDirection.ValueType

class DimensionArrowDirection(_DimensionArrowDirection, metaclass=_DimensionArrowDirectionEnumTypeWrapper):
    ...
DAD_UNKNOWN: DimensionArrowDirection.ValueType
DAD_INWARD: DimensionArrowDirection.ValueType
DAD_OUTWARD: DimensionArrowDirection.ValueType
global___DimensionArrowDirection = DimensionArrowDirection

class _DimensionPrecision:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DimensionPrecisionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DimensionPrecision.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DP_UNKNOWN: _DimensionPrecision.ValueType
    DP_FIXED_0: _DimensionPrecision.ValueType
    'No digits after decimal point'
    DP_FIXED_1: _DimensionPrecision.ValueType
    '1 digit after decimal point'
    DP_FIXED_2: _DimensionPrecision.ValueType
    '2 digits after decimal point'
    DP_FIXED_3: _DimensionPrecision.ValueType
    '3 digits after decimal point'
    DP_FIXED_4: _DimensionPrecision.ValueType
    '4 digits after decimal point'
    DP_FIXED_5: _DimensionPrecision.ValueType
    '5 digits after decimal point'
    DP_SCALED_IN_2: _DimensionPrecision.ValueType
    'Precision depends on unit selection; 2 digits for inches, 0 for mils, 1 for mm'
    DP_SCALED_IN_3: _DimensionPrecision.ValueType
    'Precision depends on unit selection; 3 digits for inches, 0 for mils, 2 for mm'
    DP_SCALED_IN_4: _DimensionPrecision.ValueType
    'Precision depends on unit selection; 4 digits for inches, 1 for mils, 3 for mm'
    DP_SCALED_IN_5: _DimensionPrecision.ValueType
    'Precision depends on unit selection; 5 digits for inches, 2 for mils, 4 for mm'

class DimensionPrecision(_DimensionPrecision, metaclass=_DimensionPrecisionEnumTypeWrapper):
    ...
DP_UNKNOWN: DimensionPrecision.ValueType
DP_FIXED_0: DimensionPrecision.ValueType
'No digits after decimal point'
DP_FIXED_1: DimensionPrecision.ValueType
'1 digit after decimal point'
DP_FIXED_2: DimensionPrecision.ValueType
'2 digits after decimal point'
DP_FIXED_3: DimensionPrecision.ValueType
'3 digits after decimal point'
DP_FIXED_4: DimensionPrecision.ValueType
'4 digits after decimal point'
DP_FIXED_5: DimensionPrecision.ValueType
'5 digits after decimal point'
DP_SCALED_IN_2: DimensionPrecision.ValueType
'Precision depends on unit selection; 2 digits for inches, 0 for mils, 1 for mm'
DP_SCALED_IN_3: DimensionPrecision.ValueType
'Precision depends on unit selection; 3 digits for inches, 0 for mils, 2 for mm'
DP_SCALED_IN_4: DimensionPrecision.ValueType
'Precision depends on unit selection; 4 digits for inches, 1 for mils, 3 for mm'
DP_SCALED_IN_5: DimensionPrecision.ValueType
'Precision depends on unit selection; 5 digits for inches, 2 for mils, 4 for mm'
global___DimensionPrecision = DimensionPrecision

class _DimensionTextPosition:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DimensionTextPositionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DimensionTextPosition.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DTP_UNKNOWN: _DimensionTextPosition.ValueType
    DTP_OUTSIDE: _DimensionTextPosition.ValueType
    DTP_INLINE: _DimensionTextPosition.ValueType
    DTP_MANUAL: _DimensionTextPosition.ValueType

class DimensionTextPosition(_DimensionTextPosition, metaclass=_DimensionTextPositionEnumTypeWrapper):
    ...
DTP_UNKNOWN: DimensionTextPosition.ValueType
DTP_OUTSIDE: DimensionTextPosition.ValueType
DTP_INLINE: DimensionTextPosition.ValueType
DTP_MANUAL: DimensionTextPosition.ValueType
global___DimensionTextPosition = DimensionTextPosition

class _DimensionUnit:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DimensionUnitEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DimensionUnit.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DU_UNKNOWN: _DimensionUnit.ValueType
    DU_INCHES: _DimensionUnit.ValueType
    DU_MILS: _DimensionUnit.ValueType
    DU_MILLIMETERS: _DimensionUnit.ValueType
    DU_AUTOMATIC: _DimensionUnit.ValueType

class DimensionUnit(_DimensionUnit, metaclass=_DimensionUnitEnumTypeWrapper):
    ...
DU_UNKNOWN: DimensionUnit.ValueType
DU_INCHES: DimensionUnit.ValueType
DU_MILS: DimensionUnit.ValueType
DU_MILLIMETERS: DimensionUnit.ValueType
DU_AUTOMATIC: DimensionUnit.ValueType
global___DimensionUnit = DimensionUnit

class _FootprintMountingStyle:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _FootprintMountingStyleEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_FootprintMountingStyle.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    FMS_UNKNOWN: _FootprintMountingStyle.ValueType
    FMS_THROUGH_HOLE: _FootprintMountingStyle.ValueType
    FMS_SMD: _FootprintMountingStyle.ValueType
    FMS_UNSPECIFIED: _FootprintMountingStyle.ValueType

class FootprintMountingStyle(_FootprintMountingStyle, metaclass=_FootprintMountingStyleEnumTypeWrapper):
    ...
FMS_UNKNOWN: FootprintMountingStyle.ValueType
FMS_THROUGH_HOLE: FootprintMountingStyle.ValueType
FMS_SMD: FootprintMountingStyle.ValueType
FMS_UNSPECIFIED: FootprintMountingStyle.ValueType
global___FootprintMountingStyle = FootprintMountingStyle

@typing.final
class NetCode(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    VALUE_FIELD_NUMBER: builtins.int
    value: builtins.int

    def __init__(self, *, value: builtins.int=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['value', b'value']) -> None:
        ...
global___NetCode = NetCode

@typing.final
class Net(google.protobuf.message.Message):
    """Describes a copper item's net"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CODE_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    'Human-readable net name'

    @property
    def code(self) -> global___NetCode:
        """A unique code representing this net"""

    def __init__(self, *, code: global___NetCode | None=..., name: builtins.str=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['code', b'code']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['code', b'code', 'name', b'name']) -> None:
        ...
global___Net = Net

@typing.final
class Track(google.protobuf.message.Message):
    """Represents a track segment on a board"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    START_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int
    WIDTH_FIELD_NUMBER: builtins.int
    LOCKED_FIELD_NUMBER: builtins.int
    LAYER_FIELD_NUMBER: builtins.int
    NET_FIELD_NUMBER: builtins.int
    locked: common.types.base_types_pb2.LockedState.ValueType
    layer: global___BoardLayer.ValueType

    @property
    def id(self) -> common.types.base_types_pb2.KIID:
        ...

    @property
    def start(self) -> common.types.base_types_pb2.Vector2:
        ...

    @property
    def end(self) -> common.types.base_types_pb2.Vector2:
        ...

    @property
    def width(self) -> common.types.base_types_pb2.Distance:
        ...

    @property
    def net(self) -> global___Net:
        ...

    def __init__(self, *, id: common.types.base_types_pb2.KIID | None=..., start: common.types.base_types_pb2.Vector2 | None=..., end: common.types.base_types_pb2.Vector2 | None=..., width: common.types.base_types_pb2.Distance | None=..., locked: common.types.base_types_pb2.LockedState.ValueType=..., layer: global___BoardLayer.ValueType=..., net: global___Net | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['end', b'end', 'id', b'id', 'net', b'net', 'start', b'start', 'width', b'width']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['end', b'end', 'id', b'id', 'layer', b'layer', 'locked', b'locked', 'net', b'net', 'start', b'start', 'width', b'width']) -> None:
        ...
global___Track = Track

@typing.final
class Arc(google.protobuf.message.Message):
    """Represents an arc track (not a PCB_SHAPE in arc shape)
    Arc tracks in KiCad store start, midpoint, and end.
    All other values (center point, angles, etc) are inferred.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    START_FIELD_NUMBER: builtins.int
    MID_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int
    WIDTH_FIELD_NUMBER: builtins.int
    LOCKED_FIELD_NUMBER: builtins.int
    LAYER_FIELD_NUMBER: builtins.int
    NET_FIELD_NUMBER: builtins.int
    locked: common.types.base_types_pb2.LockedState.ValueType
    layer: global___BoardLayer.ValueType

    @property
    def id(self) -> common.types.base_types_pb2.KIID:
        ...

    @property
    def start(self) -> common.types.base_types_pb2.Vector2:
        ...

    @property
    def mid(self) -> common.types.base_types_pb2.Vector2:
        """Arc midpoint"""

    @property
    def end(self) -> common.types.base_types_pb2.Vector2:
        ...

    @property
    def width(self) -> common.types.base_types_pb2.Distance:
        ...

    @property
    def net(self) -> global___Net:
        ...

    def __init__(self, *, id: common.types.base_types_pb2.KIID | None=..., start: common.types.base_types_pb2.Vector2 | None=..., mid: common.types.base_types_pb2.Vector2 | None=..., end: common.types.base_types_pb2.Vector2 | None=..., width: common.types.base_types_pb2.Distance | None=..., locked: common.types.base_types_pb2.LockedState.ValueType=..., layer: global___BoardLayer.ValueType=..., net: global___Net | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['end', b'end', 'id', b'id', 'mid', b'mid', 'net', b'net', 'start', b'start', 'width', b'width']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['end', b'end', 'id', b'id', 'layer', b'layer', 'locked', b'locked', 'mid', b'mid', 'net', b'net', 'start', b'start', 'width', b'width']) -> None:
        ...
global___Arc = Arc

@typing.final
class ChamferedRectCorners(google.protobuf.message.Message):
    """Which corners are chamfered in a PSS_CHAMFEREDRECT"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TOP_LEFT_FIELD_NUMBER: builtins.int
    TOP_RIGHT_FIELD_NUMBER: builtins.int
    BOTTOM_LEFT_FIELD_NUMBER: builtins.int
    BOTTOM_RIGHT_FIELD_NUMBER: builtins.int
    top_left: builtins.bool
    top_right: builtins.bool
    bottom_left: builtins.bool
    bottom_right: builtins.bool

    def __init__(self, *, top_left: builtins.bool=..., top_right: builtins.bool=..., bottom_left: builtins.bool=..., bottom_right: builtins.bool=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['bottom_left', b'bottom_left', 'bottom_right', b'bottom_right', 'top_left', b'top_left', 'top_right', b'top_right']) -> None:
        ...
global___ChamferedRectCorners = ChamferedRectCorners

@typing.final
class ZoneConnectionSettings(google.protobuf.message.Message):
    """Controls for how copper zones connect to a pad"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ZONE_CONNECTION_FIELD_NUMBER: builtins.int
    THERMAL_SPOKES_FIELD_NUMBER: builtins.int
    zone_connection: global___ZoneConnectionStyle.ValueType

    @property
    def thermal_spokes(self) -> global___ThermalSpokeSettings:
        ...

    def __init__(self, *, zone_connection: global___ZoneConnectionStyle.ValueType=..., thermal_spokes: global___ThermalSpokeSettings | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['thermal_spokes', b'thermal_spokes']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['thermal_spokes', b'thermal_spokes', 'zone_connection', b'zone_connection']) -> None:
        ...
global___ZoneConnectionSettings = ZoneConnectionSettings

@typing.final
class SolderMaskOverrides(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SOLDER_MASK_MARGIN_FIELD_NUMBER: builtins.int

    @property
    def solder_mask_margin(self) -> common.types.base_types_pb2.Distance:
        """Solder mask expansion/contraction"""

    def __init__(self, *, solder_mask_margin: common.types.base_types_pb2.Distance | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['solder_mask_margin', b'solder_mask_margin']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['solder_mask_margin', b'solder_mask_margin']) -> None:
        ...
global___SolderMaskOverrides = SolderMaskOverrides

@typing.final
class SolderPasteOverrides(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SOLDER_PASTE_MARGIN_FIELD_NUMBER: builtins.int
    SOLDER_PASTE_MARGIN_RATIO_FIELD_NUMBER: builtins.int

    @property
    def solder_paste_margin(self) -> common.types.base_types_pb2.Distance:
        """Solder paste expansion/contraction"""

    @property
    def solder_paste_margin_ratio(self) -> common.types.base_types_pb2.Ratio:
        """Solder paste expansion/contraction ratio"""

    def __init__(self, *, solder_paste_margin: common.types.base_types_pb2.Distance | None=..., solder_paste_margin_ratio: common.types.base_types_pb2.Ratio | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['solder_paste_margin', b'solder_paste_margin', 'solder_paste_margin_ratio', b'solder_paste_margin_ratio']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['solder_paste_margin', b'solder_paste_margin', 'solder_paste_margin_ratio', b'solder_paste_margin_ratio']) -> None:
        ...
global___SolderPasteOverrides = SolderPasteOverrides

@typing.final
class PadStackLayer(google.protobuf.message.Message):
    """The defintion of a padstack on a single layer"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    LAYER_FIELD_NUMBER: builtins.int
    SHAPE_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    CORNER_ROUNDING_RATIO_FIELD_NUMBER: builtins.int
    CHAMFER_RATIO_FIELD_NUMBER: builtins.int
    CHAMFERED_CORNERS_FIELD_NUMBER: builtins.int
    CUSTOM_SHAPES_FIELD_NUMBER: builtins.int
    CUSTOM_ANCHOR_SHAPE_FIELD_NUMBER: builtins.int
    ZONE_SETTINGS_FIELD_NUMBER: builtins.int
    TRAPEZOID_DELTA_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    layer: global___BoardLayer.ValueType
    'The board layer of this padstack entry.  For Front/Inner/Back padstacks, In1_Cu is used to represent inner layers.'
    shape: global___PadStackShape.ValueType
    'The shape of the pad on this layer'
    corner_rounding_ratio: builtins.float
    'How much to round the corners of the shape by, as a fraction of min(size.x, size.y)\n    Only used for PSS_ROUNDRECT or PSS_CHAMFEREDRECT\n    '
    chamfer_ratio: builtins.float
    'How much to round the corners of the shape by, as a fraction of min(size.x, size.y)\n    Only used for PSS_CHAMFEREDRECT\n    '
    custom_anchor_shape: global___PadStackShape.ValueType
    'If shape == PSS_CUSTOM, defines the shape of the anchor (only PSS_CIRCLE and PSS_RECTANGLE supported at present)'

    @property
    def size(self) -> common.types.base_types_pb2.Vector2:
        """The size (x and y) of the shape on this layer"""

    @property
    def chamfered_corners(self) -> global___ChamferedRectCorners:
        ...

    @property
    def custom_shapes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BoardGraphicShape]:
        ...

    @property
    def zone_settings(self) -> global___ZoneConnectionSettings:
        """Reserved for future use -- at the moment, zone connection settings are not per-layer"""

    @property
    def trapezoid_delta(self) -> common.types.base_types_pb2.Vector2:
        """The difference in side length between the short and long pads in a trapezoid.  Only one of x or y may be nonzero.
        Only used for PSS_TRAPEZOID
        """

    @property
    def offset(self) -> common.types.base_types_pb2.Vector2:
        """The offset of the center of this shape from the center of the pad (which is defined as the hole center)"""

    def __init__(self, *, layer: global___BoardLayer.ValueType=..., shape: global___PadStackShape.ValueType=..., size: common.types.base_types_pb2.Vector2 | None=..., corner_rounding_ratio: builtins.float=..., chamfer_ratio: builtins.float=..., chamfered_corners: global___ChamferedRectCorners | None=..., custom_shapes: collections.abc.Iterable[global___BoardGraphicShape] | None=..., custom_anchor_shape: global___PadStackShape.ValueType=..., zone_settings: global___ZoneConnectionSettings | None=..., trapezoid_delta: common.types.base_types_pb2.Vector2 | None=..., offset: common.types.base_types_pb2.Vector2 | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['chamfered_corners', b'chamfered_corners', 'offset', b'offset', 'size', b'size', 'trapezoid_delta', b'trapezoid_delta', 'zone_settings', b'zone_settings']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['chamfer_ratio', b'chamfer_ratio', 'chamfered_corners', b'chamfered_corners', 'corner_rounding_ratio', b'corner_rounding_ratio', 'custom_anchor_shape', b'custom_anchor_shape', 'custom_shapes', b'custom_shapes', 'layer', b'layer', 'offset', b'offset', 'shape', b'shape', 'size', b'size', 'trapezoid_delta', b'trapezoid_delta', 'zone_settings', b'zone_settings']) -> None:
        ...
global___PadStackLayer = PadStackLayer

@typing.final
class PadStackOuterLayer(google.protobuf.message.Message):
    """Properties for the outer technical layers of a padstack on the top or bottom of the stack"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SOLDER_MASK_MODE_FIELD_NUMBER: builtins.int
    SOLDER_PASTE_MODE_FIELD_NUMBER: builtins.int
    SOLDER_MASK_SETTINGS_FIELD_NUMBER: builtins.int
    SOLDER_PASTE_SETTINGS_FIELD_NUMBER: builtins.int
    solder_mask_mode: global___SolderMaskMode.ValueType
    solder_paste_mode: global___SolderPasteMode.ValueType

    @property
    def solder_mask_settings(self) -> global___SolderMaskOverrides:
        """NOTE: At present, KiCad does not support different solder mask expansion settings for the top and bottom layers"""

    @property
    def solder_paste_settings(self) -> global___SolderPasteOverrides:
        """NOTE: At present, KiCad does not support different solder paste expansion settings for the top and bottom layers"""

    def __init__(self, *, solder_mask_mode: global___SolderMaskMode.ValueType=..., solder_paste_mode: global___SolderPasteMode.ValueType=..., solder_mask_settings: global___SolderMaskOverrides | None=..., solder_paste_settings: global___SolderPasteOverrides | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['solder_mask_settings', b'solder_mask_settings', 'solder_paste_settings', b'solder_paste_settings']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['solder_mask_mode', b'solder_mask_mode', 'solder_mask_settings', b'solder_mask_settings', 'solder_paste_mode', b'solder_paste_mode', 'solder_paste_settings', b'solder_paste_settings']) -> None:
        ...
global___PadStackOuterLayer = PadStackOuterLayer

@typing.final
class DrillProperties(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    START_LAYER_FIELD_NUMBER: builtins.int
    END_LAYER_FIELD_NUMBER: builtins.int
    DIAMETER_FIELD_NUMBER: builtins.int
    SHAPE_FIELD_NUMBER: builtins.int
    start_layer: global___BoardLayer.ValueType
    'Lowest (closest to F_Cu) layer this drill exists on.'
    end_layer: global___BoardLayer.ValueType
    'Highest (closest to B_Cu) layer this drill exists on.'
    shape: global___DrillShape.ValueType

    @property
    def diameter(self) -> common.types.base_types_pb2.Vector2:
        """The diameter, in x and y, of the pad's drilled hole, if this pad has a hole.
        x and y will be the same value if the hole is round.
        """

    def __init__(self, *, start_layer: global___BoardLayer.ValueType=..., end_layer: global___BoardLayer.ValueType=..., diameter: common.types.base_types_pb2.Vector2 | None=..., shape: global___DrillShape.ValueType=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['diameter', b'diameter']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['diameter', b'diameter', 'end_layer', b'end_layer', 'shape', b'shape', 'start_layer', b'start_layer']) -> None:
        ...
global___DrillProperties = DrillProperties

@typing.final
class PadStack(google.protobuf.message.Message):
    """A pad stack definition for a multilayer pad or via."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TYPE_FIELD_NUMBER: builtins.int
    LAYERS_FIELD_NUMBER: builtins.int
    DRILL_FIELD_NUMBER: builtins.int
    UNCONNECTED_LAYER_REMOVAL_FIELD_NUMBER: builtins.int
    COPPER_LAYERS_FIELD_NUMBER: builtins.int
    ANGLE_FIELD_NUMBER: builtins.int
    FRONT_OUTER_LAYERS_FIELD_NUMBER: builtins.int
    BACK_OUTER_LAYERS_FIELD_NUMBER: builtins.int
    ZONE_SETTINGS_FIELD_NUMBER: builtins.int
    type: global___PadStackType.ValueType
    'What type of pad stack this represents.'
    unconnected_layer_removal: global___UnconnectedLayerRemoval.ValueType
    'How to treat pad shapes on unconnected layers.'

    @property
    def layers(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___BoardLayer.ValueType]:
        """The set of board layers this padstack has a definition for"""

    @property
    def drill(self) -> global___DrillProperties:
        """Properties of the drilled hole in this padstack, if it has one"""

    @property
    def copper_layers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PadStackLayer]:
        ...

    @property
    def angle(self) -> common.types.base_types_pb2.Angle:
        """The overall rotation of this padstack (affects all layers)"""

    @property
    def front_outer_layers(self) -> global___PadStackOuterLayer:
        """Solder mask and paste settings for the front"""

    @property
    def back_outer_layers(self) -> global___PadStackOuterLayer:
        """Solder mask and paste settings for the back"""

    @property
    def zone_settings(self) -> global___ZoneConnectionSettings:
        """Controls for how copper zones connect to the padstack"""

    def __init__(self, *, type: global___PadStackType.ValueType=..., layers: collections.abc.Iterable[global___BoardLayer.ValueType] | None=..., drill: global___DrillProperties | None=..., unconnected_layer_removal: global___UnconnectedLayerRemoval.ValueType=..., copper_layers: collections.abc.Iterable[global___PadStackLayer] | None=..., angle: common.types.base_types_pb2.Angle | None=..., front_outer_layers: global___PadStackOuterLayer | None=..., back_outer_layers: global___PadStackOuterLayer | None=..., zone_settings: global___ZoneConnectionSettings | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['angle', b'angle', 'back_outer_layers', b'back_outer_layers', 'drill', b'drill', 'front_outer_layers', b'front_outer_layers', 'zone_settings', b'zone_settings']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['angle', b'angle', 'back_outer_layers', b'back_outer_layers', 'copper_layers', b'copper_layers', 'drill', b'drill', 'front_outer_layers', b'front_outer_layers', 'layers', b'layers', 'type', b'type', 'unconnected_layer_removal', b'unconnected_layer_removal', 'zone_settings', b'zone_settings']) -> None:
        ...
global___PadStack = PadStack

@typing.final
class Via(google.protobuf.message.Message):
    """Represents a via"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    POSITION_FIELD_NUMBER: builtins.int
    PAD_STACK_FIELD_NUMBER: builtins.int
    LOCKED_FIELD_NUMBER: builtins.int
    NET_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    locked: common.types.base_types_pb2.LockedState.ValueType
    type: global___ViaType.ValueType

    @property
    def id(self) -> common.types.base_types_pb2.KIID:
        """The unique identifier of the via"""

    @property
    def position(self) -> common.types.base_types_pb2.Vector2:
        """The location of the via's center point"""

    @property
    def pad_stack(self) -> global___PadStack:
        """The pad stack definition for this via."""

    @property
    def net(self) -> global___Net:
        ...

    def __init__(self, *, id: common.types.base_types_pb2.KIID | None=..., position: common.types.base_types_pb2.Vector2 | None=..., pad_stack: global___PadStack | None=..., locked: common.types.base_types_pb2.LockedState.ValueType=..., net: global___Net | None=..., type: global___ViaType.ValueType=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['id', b'id', 'net', b'net', 'pad_stack', b'pad_stack', 'position', b'position']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['id', b'id', 'locked', b'locked', 'net', b'net', 'pad_stack', b'pad_stack', 'position', b'position', 'type', b'type']) -> None:
        ...
global___Via = Via

@typing.final
class BoardGraphicShape(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SHAPE_FIELD_NUMBER: builtins.int
    LAYER_FIELD_NUMBER: builtins.int
    NET_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    LOCKED_FIELD_NUMBER: builtins.int
    layer: global___BoardLayer.ValueType
    locked: common.types.base_types_pb2.LockedState.ValueType

    @property
    def shape(self) -> common.types.base_types_pb2.GraphicShape:
        ...

    @property
    def net(self) -> global___Net:
        ...

    @property
    def id(self) -> common.types.base_types_pb2.KIID:
        ...

    def __init__(self, *, shape: common.types.base_types_pb2.GraphicShape | None=..., layer: global___BoardLayer.ValueType=..., net: global___Net | None=..., id: common.types.base_types_pb2.KIID | None=..., locked: common.types.base_types_pb2.LockedState.ValueType=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['id', b'id', 'net', b'net', 'shape', b'shape']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['id', b'id', 'layer', b'layer', 'locked', b'locked', 'net', b'net', 'shape', b'shape']) -> None:
        ...
global___BoardGraphicShape = BoardGraphicShape

@typing.final
class BoardText(google.protobuf.message.Message):
    """A board-specific text object, existing on a board layer"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    LAYER_FIELD_NUMBER: builtins.int
    KNOCKOUT_FIELD_NUMBER: builtins.int
    LOCKED_FIELD_NUMBER: builtins.int
    layer: global___BoardLayer.ValueType
    knockout: builtins.bool
    locked: common.types.base_types_pb2.LockedState.ValueType

    @property
    def id(self) -> common.types.base_types_pb2.KIID:
        ...

    @property
    def text(self) -> common.types.base_types_pb2.Text:
        ...

    def __init__(self, *, id: common.types.base_types_pb2.KIID | None=..., text: common.types.base_types_pb2.Text | None=..., layer: global___BoardLayer.ValueType=..., knockout: builtins.bool=..., locked: common.types.base_types_pb2.LockedState.ValueType=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['id', b'id', 'text', b'text']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['id', b'id', 'knockout', b'knockout', 'layer', b'layer', 'locked', b'locked', 'text', b'text']) -> None:
        ...
global___BoardText = BoardText

@typing.final
class BoardTextBox(google.protobuf.message.Message):
    """A board-specific textbox, existing on a board layer"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    TEXTBOX_FIELD_NUMBER: builtins.int
    LAYER_FIELD_NUMBER: builtins.int
    LOCKED_FIELD_NUMBER: builtins.int
    layer: global___BoardLayer.ValueType
    locked: common.types.base_types_pb2.LockedState.ValueType

    @property
    def id(self) -> common.types.base_types_pb2.KIID:
        ...

    @property
    def textbox(self) -> common.types.base_types_pb2.TextBox:
        ...

    def __init__(self, *, id: common.types.base_types_pb2.KIID | None=..., textbox: common.types.base_types_pb2.TextBox | None=..., layer: global___BoardLayer.ValueType=..., locked: common.types.base_types_pb2.LockedState.ValueType=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['id', b'id', 'textbox', b'textbox']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['id', b'id', 'layer', b'layer', 'locked', b'locked', 'textbox', b'textbox']) -> None:
        ...
global___BoardTextBox = BoardTextBox

@typing.final
class ThermalSpokeSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    WIDTH_FIELD_NUMBER: builtins.int
    ANGLE_FIELD_NUMBER: builtins.int
    GAP_FIELD_NUMBER: builtins.int

    @property
    def width(self) -> common.types.base_types_pb2.Distance:
        ...

    @property
    def angle(self) -> common.types.base_types_pb2.Angle:
        ...

    @property
    def gap(self) -> common.types.base_types_pb2.Distance:
        ...

    def __init__(self, *, width: common.types.base_types_pb2.Distance | None=..., angle: common.types.base_types_pb2.Angle | None=..., gap: common.types.base_types_pb2.Distance | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['angle', b'angle', 'gap', b'gap', 'width', b'width']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['angle', b'angle', 'gap', b'gap', 'width', b'width']) -> None:
        ...
global___ThermalSpokeSettings = ThermalSpokeSettings

@typing.final
class Pad(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    LOCKED_FIELD_NUMBER: builtins.int
    NUMBER_FIELD_NUMBER: builtins.int
    NET_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    PAD_STACK_FIELD_NUMBER: builtins.int
    POSITION_FIELD_NUMBER: builtins.int
    COPPER_CLEARANCE_OVERRIDE_FIELD_NUMBER: builtins.int
    locked: common.types.base_types_pb2.LockedState.ValueType
    number: builtins.str
    type: global___PadType.ValueType

    @property
    def id(self) -> common.types.base_types_pb2.KIID:
        ...

    @property
    def net(self) -> global___Net:
        ...

    @property
    def pad_stack(self) -> global___PadStack:
        ...

    @property
    def position(self) -> common.types.base_types_pb2.Vector2:
        """A pad's position is always relative to the parent footprint's origin"""

    @property
    def copper_clearance_override(self) -> common.types.base_types_pb2.Distance:
        """Copper-to-copper clearance override"""

    def __init__(self, *, id: common.types.base_types_pb2.KIID | None=..., locked: common.types.base_types_pb2.LockedState.ValueType=..., number: builtins.str=..., net: global___Net | None=..., type: global___PadType.ValueType=..., pad_stack: global___PadStack | None=..., position: common.types.base_types_pb2.Vector2 | None=..., copper_clearance_override: common.types.base_types_pb2.Distance | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['copper_clearance_override', b'copper_clearance_override', 'id', b'id', 'net', b'net', 'pad_stack', b'pad_stack', 'position', b'position']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['copper_clearance_override', b'copper_clearance_override', 'id', b'id', 'locked', b'locked', 'net', b'net', 'number', b'number', 'pad_stack', b'pad_stack', 'position', b'position', 'type', b'type']) -> None:
        ...
global___Pad = Pad

@typing.final
class HatchFillSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    THICKNESS_FIELD_NUMBER: builtins.int
    GAP_FIELD_NUMBER: builtins.int
    ORIENTATION_FIELD_NUMBER: builtins.int
    HATCH_SMOOTHING_RATIO_FIELD_NUMBER: builtins.int
    HATCH_HOLE_MIN_AREA_RATIO_FIELD_NUMBER: builtins.int
    BORDER_MODE_FIELD_NUMBER: builtins.int
    hatch_smoothing_ratio: builtins.float
    hatch_hole_min_area_ratio: builtins.float
    border_mode: global___ZoneHatchFillBorderMode.ValueType

    @property
    def thickness(self) -> common.types.base_types_pb2.Distance:
        ...

    @property
    def gap(self) -> common.types.base_types_pb2.Distance:
        ...

    @property
    def orientation(self) -> common.types.base_types_pb2.Angle:
        ...

    def __init__(self, *, thickness: common.types.base_types_pb2.Distance | None=..., gap: common.types.base_types_pb2.Distance | None=..., orientation: common.types.base_types_pb2.Angle | None=..., hatch_smoothing_ratio: builtins.float=..., hatch_hole_min_area_ratio: builtins.float=..., border_mode: global___ZoneHatchFillBorderMode.ValueType=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['gap', b'gap', 'orientation', b'orientation', 'thickness', b'thickness']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['border_mode', b'border_mode', 'gap', b'gap', 'hatch_hole_min_area_ratio', b'hatch_hole_min_area_ratio', 'hatch_smoothing_ratio', b'hatch_smoothing_ratio', 'orientation', b'orientation', 'thickness', b'thickness']) -> None:
        ...
global___HatchFillSettings = HatchFillSettings

@typing.final
class TeardropSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TYPE_FIELD_NUMBER: builtins.int
    type: global___TeardropType.ValueType

    def __init__(self, *, type: global___TeardropType.ValueType=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['type', b'type']) -> None:
        ...
global___TeardropSettings = TeardropSettings

@typing.final
class CopperZoneSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CONNECTION_FIELD_NUMBER: builtins.int
    CLEARANCE_FIELD_NUMBER: builtins.int
    MIN_THICKNESS_FIELD_NUMBER: builtins.int
    ISLAND_MODE_FIELD_NUMBER: builtins.int
    MIN_ISLAND_AREA_FIELD_NUMBER: builtins.int
    FILL_MODE_FIELD_NUMBER: builtins.int
    HATCH_SETTINGS_FIELD_NUMBER: builtins.int
    NET_FIELD_NUMBER: builtins.int
    TEARDROP_FIELD_NUMBER: builtins.int
    island_mode: global___IslandRemovalMode.ValueType
    min_island_area: builtins.int
    fill_mode: global___ZoneFillMode.ValueType

    @property
    def connection(self) -> global___ZoneConnectionSettings:
        ...

    @property
    def clearance(self) -> common.types.base_types_pb2.Distance:
        ...

    @property
    def min_thickness(self) -> common.types.base_types_pb2.Distance:
        ...

    @property
    def hatch_settings(self) -> global___HatchFillSettings:
        ...

    @property
    def net(self) -> global___Net:
        ...

    @property
    def teardrop(self) -> global___TeardropSettings:
        ...

    def __init__(self, *, connection: global___ZoneConnectionSettings | None=..., clearance: common.types.base_types_pb2.Distance | None=..., min_thickness: common.types.base_types_pb2.Distance | None=..., island_mode: global___IslandRemovalMode.ValueType=..., min_island_area: builtins.int=..., fill_mode: global___ZoneFillMode.ValueType=..., hatch_settings: global___HatchFillSettings | None=..., net: global___Net | None=..., teardrop: global___TeardropSettings | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['clearance', b'clearance', 'connection', b'connection', 'hatch_settings', b'hatch_settings', 'min_thickness', b'min_thickness', 'net', b'net', 'teardrop', b'teardrop']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['clearance', b'clearance', 'connection', b'connection', 'fill_mode', b'fill_mode', 'hatch_settings', b'hatch_settings', 'island_mode', b'island_mode', 'min_island_area', b'min_island_area', 'min_thickness', b'min_thickness', 'net', b'net', 'teardrop', b'teardrop']) -> None:
        ...
global___CopperZoneSettings = CopperZoneSettings

@typing.final
class RuleAreaSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    KEEPOUT_COPPER_FIELD_NUMBER: builtins.int
    KEEPOUT_VIAS_FIELD_NUMBER: builtins.int
    KEEPOUT_TRACKS_FIELD_NUMBER: builtins.int
    KEEPOUT_PADS_FIELD_NUMBER: builtins.int
    KEEPOUT_FOOTPRINTS_FIELD_NUMBER: builtins.int
    PLACEMENT_ENABLED_FIELD_NUMBER: builtins.int
    PLACEMENT_SOURCE_TYPE_FIELD_NUMBER: builtins.int
    PLACEMENT_SOURCE_FIELD_NUMBER: builtins.int
    keepout_copper: builtins.bool
    keepout_vias: builtins.bool
    keepout_tracks: builtins.bool
    keepout_pads: builtins.bool
    keepout_footprints: builtins.bool
    placement_enabled: builtins.bool
    placement_source_type: global___PlacementRuleSourceType.ValueType
    placement_source: builtins.str

    def __init__(self, *, keepout_copper: builtins.bool=..., keepout_vias: builtins.bool=..., keepout_tracks: builtins.bool=..., keepout_pads: builtins.bool=..., keepout_footprints: builtins.bool=..., placement_enabled: builtins.bool=..., placement_source_type: global___PlacementRuleSourceType.ValueType=..., placement_source: builtins.str=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['keepout_copper', b'keepout_copper', 'keepout_footprints', b'keepout_footprints', 'keepout_pads', b'keepout_pads', 'keepout_tracks', b'keepout_tracks', 'keepout_vias', b'keepout_vias', 'placement_enabled', b'placement_enabled', 'placement_source', b'placement_source', 'placement_source_type', b'placement_source_type']) -> None:
        ...
global___RuleAreaSettings = RuleAreaSettings

@typing.final
class ZoneBorderSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    STYLE_FIELD_NUMBER: builtins.int
    PITCH_FIELD_NUMBER: builtins.int
    style: global___ZoneBorderStyle.ValueType

    @property
    def pitch(self) -> common.types.base_types_pb2.Distance:
        ...

    def __init__(self, *, style: global___ZoneBorderStyle.ValueType=..., pitch: common.types.base_types_pb2.Distance | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['pitch', b'pitch']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['pitch', b'pitch', 'style', b'style']) -> None:
        ...
global___ZoneBorderSettings = ZoneBorderSettings

@typing.final
class ZoneFilledPolygons(google.protobuf.message.Message):
    """The set of filled polygons of a zone on a single board layer"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    LAYER_FIELD_NUMBER: builtins.int
    SHAPES_FIELD_NUMBER: builtins.int
    layer: global___BoardLayer.ValueType

    @property
    def shapes(self) -> common.types.base_types_pb2.PolySet:
        ...

    def __init__(self, *, layer: global___BoardLayer.ValueType=..., shapes: common.types.base_types_pb2.PolySet | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['shapes', b'shapes']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['layer', b'layer', 'shapes', b'shapes']) -> None:
        ...
global___ZoneFilledPolygons = ZoneFilledPolygons

@typing.final
class Zone(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    LAYERS_FIELD_NUMBER: builtins.int
    OUTLINE_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    COPPER_SETTINGS_FIELD_NUMBER: builtins.int
    RULE_AREA_SETTINGS_FIELD_NUMBER: builtins.int
    PRIORITY_FIELD_NUMBER: builtins.int
    FILLED_FIELD_NUMBER: builtins.int
    FILLED_POLYGONS_FIELD_NUMBER: builtins.int
    BORDER_FIELD_NUMBER: builtins.int
    LOCKED_FIELD_NUMBER: builtins.int
    type: global___ZoneType.ValueType
    name: builtins.str
    priority: builtins.int
    filled: builtins.bool
    locked: common.types.base_types_pb2.LockedState.ValueType

    @property
    def id(self) -> common.types.base_types_pb2.KIID:
        ...

    @property
    def layers(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___BoardLayer.ValueType]:
        ...

    @property
    def outline(self) -> common.types.base_types_pb2.PolySet:
        ...

    @property
    def copper_settings(self) -> global___CopperZoneSettings:
        ...

    @property
    def rule_area_settings(self) -> global___RuleAreaSettings:
        ...

    @property
    def filled_polygons(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ZoneFilledPolygons]:
        ...

    @property
    def border(self) -> global___ZoneBorderSettings:
        ...

    def __init__(self, *, id: common.types.base_types_pb2.KIID | None=..., type: global___ZoneType.ValueType=..., layers: collections.abc.Iterable[global___BoardLayer.ValueType] | None=..., outline: common.types.base_types_pb2.PolySet | None=..., name: builtins.str=..., copper_settings: global___CopperZoneSettings | None=..., rule_area_settings: global___RuleAreaSettings | None=..., priority: builtins.int=..., filled: builtins.bool=..., filled_polygons: collections.abc.Iterable[global___ZoneFilledPolygons] | None=..., border: global___ZoneBorderSettings | None=..., locked: common.types.base_types_pb2.LockedState.ValueType=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['border', b'border', 'copper_settings', b'copper_settings', 'id', b'id', 'outline', b'outline', 'rule_area_settings', b'rule_area_settings', 'settings', b'settings']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['border', b'border', 'copper_settings', b'copper_settings', 'filled', b'filled', 'filled_polygons', b'filled_polygons', 'id', b'id', 'layers', b'layers', 'locked', b'locked', 'name', b'name', 'outline', b'outline', 'priority', b'priority', 'rule_area_settings', b'rule_area_settings', 'settings', b'settings', 'type', b'type']) -> None:
        ...

    def WhichOneof(self, oneof_group: typing.Literal['settings', b'settings']) -> typing.Literal['copper_settings', 'rule_area_settings'] | None:
        ...
global___Zone = Zone

@typing.final
class AlignedDimensionAttributes(google.protobuf.message.Message):
    """An aligned dimension is drawn parallel to the line segment between the start and end points"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    START_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int
    HEIGHT_FIELD_NUMBER: builtins.int
    EXTENSION_HEIGHT_FIELD_NUMBER: builtins.int

    @property
    def start(self) -> common.types.base_types_pb2.Vector2:
        ...

    @property
    def end(self) -> common.types.base_types_pb2.Vector2:
        ...

    @property
    def height(self) -> common.types.base_types_pb2.Distance:
        """Perpendicular distance from dimension endpoints to crossbar"""

    @property
    def extension_height(self) -> common.types.base_types_pb2.Distance:
        """Length of extension lines past the crossbar"""

    def __init__(self, *, start: common.types.base_types_pb2.Vector2 | None=..., end: common.types.base_types_pb2.Vector2 | None=..., height: common.types.base_types_pb2.Distance | None=..., extension_height: common.types.base_types_pb2.Distance | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['end', b'end', 'extension_height', b'extension_height', 'height', b'height', 'start', b'start']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['end', b'end', 'extension_height', b'extension_height', 'height', b'height', 'start', b'start']) -> None:
        ...
global___AlignedDimensionAttributes = AlignedDimensionAttributes

@typing.final
class OrthogonalDimensionAttributes(google.protobuf.message.Message):
    """An orthogonal dimension is drawn parallel to the X or Y axis of the coordinate system"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    START_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int
    HEIGHT_FIELD_NUMBER: builtins.int
    EXTENSION_HEIGHT_FIELD_NUMBER: builtins.int
    ALIGNMENT_FIELD_NUMBER: builtins.int
    alignment: common.types.base_types_pb2.AxisAlignment.ValueType
    'Which axis the dimension is parallel to'

    @property
    def start(self) -> common.types.base_types_pb2.Vector2:
        ...

    @property
    def end(self) -> common.types.base_types_pb2.Vector2:
        ...

    @property
    def height(self) -> common.types.base_types_pb2.Distance:
        """Perpendicular distance from dimension endpoints to crossbar"""

    @property
    def extension_height(self) -> common.types.base_types_pb2.Distance:
        """Length of extension lines past the crossbar"""

    def __init__(self, *, start: common.types.base_types_pb2.Vector2 | None=..., end: common.types.base_types_pb2.Vector2 | None=..., height: common.types.base_types_pb2.Distance | None=..., extension_height: common.types.base_types_pb2.Distance | None=..., alignment: common.types.base_types_pb2.AxisAlignment.ValueType=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['end', b'end', 'extension_height', b'extension_height', 'height', b'height', 'start', b'start']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['alignment', b'alignment', 'end', b'end', 'extension_height', b'extension_height', 'height', b'height', 'start', b'start']) -> None:
        ...
global___OrthogonalDimensionAttributes = OrthogonalDimensionAttributes

@typing.final
class RadialDimensionAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CENTER_FIELD_NUMBER: builtins.int
    RADIUS_POINT_FIELD_NUMBER: builtins.int
    LEADER_LENGTH_FIELD_NUMBER: builtins.int

    @property
    def center(self) -> common.types.base_types_pb2.Vector2:
        """The center of the dimensioned circle or arc"""

    @property
    def radius_point(self) -> common.types.base_types_pb2.Vector2:
        """A point on the radius of the circle or arc"""

    @property
    def leader_length(self) -> common.types.base_types_pb2.Distance:
        """The distance from radius_point to draw the first segment of the leader line.
        The second segment is drawn from the end of the first segment to the text position.
        """

    def __init__(self, *, center: common.types.base_types_pb2.Vector2 | None=..., radius_point: common.types.base_types_pb2.Vector2 | None=..., leader_length: common.types.base_types_pb2.Distance | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['center', b'center', 'leader_length', b'leader_length', 'radius_point', b'radius_point']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['center', b'center', 'leader_length', b'leader_length', 'radius_point', b'radius_point']) -> None:
        ...
global___RadialDimensionAttributes = RadialDimensionAttributes

@typing.final
class LeaderDimensionAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    START_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int
    BORDER_STYLE_FIELD_NUMBER: builtins.int
    border_style: global___DimensionTextBorderStyle.ValueType

    @property
    def start(self) -> common.types.base_types_pb2.Vector2:
        ...

    @property
    def end(self) -> common.types.base_types_pb2.Vector2:
        ...

    def __init__(self, *, start: common.types.base_types_pb2.Vector2 | None=..., end: common.types.base_types_pb2.Vector2 | None=..., border_style: global___DimensionTextBorderStyle.ValueType=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['end', b'end', 'start', b'start']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['border_style', b'border_style', 'end', b'end', 'start', b'start']) -> None:
        ...
global___LeaderDimensionAttributes = LeaderDimensionAttributes

@typing.final
class CenterDimensionAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CENTER_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int

    @property
    def center(self) -> common.types.base_types_pb2.Vector2:
        ...

    @property
    def end(self) -> common.types.base_types_pb2.Vector2:
        """A point on the end of one of the four radial spokes drawn from the center point"""

    def __init__(self, *, center: common.types.base_types_pb2.Vector2 | None=..., end: common.types.base_types_pb2.Vector2 | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['center', b'center', 'end', b'end']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['center', b'center', 'end', b'end']) -> None:
        ...
global___CenterDimensionAttributes = CenterDimensionAttributes

@typing.final
class Dimension(google.protobuf.message.Message):
    """A dimension in KiCad is a special type of text object.
    To know the visual appearance of the dimension as rendered by KiCad, use GetTextAsShapes
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    LOCKED_FIELD_NUMBER: builtins.int
    LAYER_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    ALIGNED_FIELD_NUMBER: builtins.int
    ORTHOGONAL_FIELD_NUMBER: builtins.int
    RADIAL_FIELD_NUMBER: builtins.int
    LEADER_FIELD_NUMBER: builtins.int
    CENTER_FIELD_NUMBER: builtins.int
    OVERRIDE_TEXT_ENABLED_FIELD_NUMBER: builtins.int
    OVERRIDE_TEXT_FIELD_NUMBER: builtins.int
    PREFIX_FIELD_NUMBER: builtins.int
    SUFFIX_FIELD_NUMBER: builtins.int
    UNIT_FIELD_NUMBER: builtins.int
    UNIT_FORMAT_FIELD_NUMBER: builtins.int
    ARROW_DIRECTION_FIELD_NUMBER: builtins.int
    PRECISION_FIELD_NUMBER: builtins.int
    SUPPRESS_TRAILING_ZEROES_FIELD_NUMBER: builtins.int
    LINE_THICKNESS_FIELD_NUMBER: builtins.int
    ARROW_LENGTH_FIELD_NUMBER: builtins.int
    EXTENSION_OFFSET_FIELD_NUMBER: builtins.int
    TEXT_POSITION_FIELD_NUMBER: builtins.int
    KEEP_TEXT_ALIGNED_FIELD_NUMBER: builtins.int
    locked: common.types.base_types_pb2.LockedState.ValueType
    layer: global___BoardLayer.ValueType
    override_text_enabled: builtins.bool
    override_text: builtins.str
    prefix: builtins.str
    suffix: builtins.str
    unit: global___DimensionUnit.ValueType
    unit_format: global___DimensionUnitFormat.ValueType
    arrow_direction: global___DimensionArrowDirection.ValueType
    precision: global___DimensionPrecision.ValueType
    suppress_trailing_zeroes: builtins.bool
    text_position: global___DimensionTextPosition.ValueType
    keep_text_aligned: builtins.bool

    @property
    def id(self) -> common.types.base_types_pb2.KIID:
        ...

    @property
    def text(self) -> common.types.base_types_pb2.Text:
        ...

    @property
    def aligned(self) -> global___AlignedDimensionAttributes:
        ...

    @property
    def orthogonal(self) -> global___OrthogonalDimensionAttributes:
        ...

    @property
    def radial(self) -> global___RadialDimensionAttributes:
        ...

    @property
    def leader(self) -> global___LeaderDimensionAttributes:
        ...

    @property
    def center(self) -> global___CenterDimensionAttributes:
        ...

    @property
    def line_thickness(self) -> common.types.base_types_pb2.Distance:
        ...

    @property
    def arrow_length(self) -> common.types.base_types_pb2.Distance:
        ...

    @property
    def extension_offset(self) -> common.types.base_types_pb2.Distance:
        ...

    def __init__(self, *, id: common.types.base_types_pb2.KIID | None=..., locked: common.types.base_types_pb2.LockedState.ValueType=..., layer: global___BoardLayer.ValueType=..., text: common.types.base_types_pb2.Text | None=..., aligned: global___AlignedDimensionAttributes | None=..., orthogonal: global___OrthogonalDimensionAttributes | None=..., radial: global___RadialDimensionAttributes | None=..., leader: global___LeaderDimensionAttributes | None=..., center: global___CenterDimensionAttributes | None=..., override_text_enabled: builtins.bool=..., override_text: builtins.str=..., prefix: builtins.str=..., suffix: builtins.str=..., unit: global___DimensionUnit.ValueType=..., unit_format: global___DimensionUnitFormat.ValueType=..., arrow_direction: global___DimensionArrowDirection.ValueType=..., precision: global___DimensionPrecision.ValueType=..., suppress_trailing_zeroes: builtins.bool=..., line_thickness: common.types.base_types_pb2.Distance | None=..., arrow_length: common.types.base_types_pb2.Distance | None=..., extension_offset: common.types.base_types_pb2.Distance | None=..., text_position: global___DimensionTextPosition.ValueType=..., keep_text_aligned: builtins.bool=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['aligned', b'aligned', 'arrow_length', b'arrow_length', 'center', b'center', 'dimension_style', b'dimension_style', 'extension_offset', b'extension_offset', 'id', b'id', 'leader', b'leader', 'line_thickness', b'line_thickness', 'orthogonal', b'orthogonal', 'radial', b'radial', 'text', b'text']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['aligned', b'aligned', 'arrow_direction', b'arrow_direction', 'arrow_length', b'arrow_length', 'center', b'center', 'dimension_style', b'dimension_style', 'extension_offset', b'extension_offset', 'id', b'id', 'keep_text_aligned', b'keep_text_aligned', 'layer', b'layer', 'leader', b'leader', 'line_thickness', b'line_thickness', 'locked', b'locked', 'orthogonal', b'orthogonal', 'override_text', b'override_text', 'override_text_enabled', b'override_text_enabled', 'precision', b'precision', 'prefix', b'prefix', 'radial', b'radial', 'suffix', b'suffix', 'suppress_trailing_zeroes', b'suppress_trailing_zeroes', 'text', b'text', 'text_position', b'text_position', 'unit', b'unit', 'unit_format', b'unit_format']) -> None:
        ...

    def WhichOneof(self, oneof_group: typing.Literal['dimension_style', b'dimension_style']) -> typing.Literal['aligned', 'orthogonal', 'radial', 'leader', 'center'] | None:
        ...
global___Dimension = Dimension

@typing.final
class ReferenceImage(google.protobuf.message.Message):
    """TODO"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(self) -> None:
        ...
global___ReferenceImage = ReferenceImage

@typing.final
class Group(google.protobuf.message.Message):
    """TODO"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(self) -> None:
        ...
global___Group = Group

@typing.final
class FieldId(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    id: builtins.int

    def __init__(self, *, id: builtins.int=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['id', b'id']) -> None:
        ...
global___FieldId = FieldId

@typing.final
class Field(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    VISIBLE_FIELD_NUMBER: builtins.int
    name: builtins.str
    visible: builtins.bool
    'Since 9.0.1'

    @property
    def id(self) -> global___FieldId:
        ...

    @property
    def text(self) -> global___BoardText:
        ...

    def __init__(self, *, id: global___FieldId | None=..., name: builtins.str=..., text: global___BoardText | None=..., visible: builtins.bool=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['id', b'id', 'text', b'text']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['id', b'id', 'name', b'name', 'text', b'text', 'visible', b'visible']) -> None:
        ...
global___Field = Field

@typing.final
class FootprintAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    DESCRIPTION_FIELD_NUMBER: builtins.int
    KEYWORDS_FIELD_NUMBER: builtins.int
    NOT_IN_SCHEMATIC_FIELD_NUMBER: builtins.int
    EXCLUDE_FROM_POSITION_FILES_FIELD_NUMBER: builtins.int
    EXCLUDE_FROM_BILL_OF_MATERIALS_FIELD_NUMBER: builtins.int
    EXEMPT_FROM_COURTYARD_REQUIREMENT_FIELD_NUMBER: builtins.int
    DO_NOT_POPULATE_FIELD_NUMBER: builtins.int
    MOUNTING_STYLE_FIELD_NUMBER: builtins.int
    description: builtins.str
    keywords: builtins.str
    not_in_schematic: builtins.bool
    exclude_from_position_files: builtins.bool
    exclude_from_bill_of_materials: builtins.bool
    exempt_from_courtyard_requirement: builtins.bool
    do_not_populate: builtins.bool
    mounting_style: global___FootprintMountingStyle.ValueType

    def __init__(self, *, description: builtins.str=..., keywords: builtins.str=..., not_in_schematic: builtins.bool=..., exclude_from_position_files: builtins.bool=..., exclude_from_bill_of_materials: builtins.bool=..., exempt_from_courtyard_requirement: builtins.bool=..., do_not_populate: builtins.bool=..., mounting_style: global___FootprintMountingStyle.ValueType=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['description', b'description', 'do_not_populate', b'do_not_populate', 'exclude_from_bill_of_materials', b'exclude_from_bill_of_materials', 'exclude_from_position_files', b'exclude_from_position_files', 'exempt_from_courtyard_requirement', b'exempt_from_courtyard_requirement', 'keywords', b'keywords', 'mounting_style', b'mounting_style', 'not_in_schematic', b'not_in_schematic']) -> None:
        ...
global___FootprintAttributes = FootprintAttributes

@typing.final
class NetTieDefinition(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PAD_NUMBER_FIELD_NUMBER: builtins.int

    @property
    def pad_number(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        ...

    def __init__(self, *, pad_number: collections.abc.Iterable[builtins.str] | None=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['pad_number', b'pad_number']) -> None:
        ...
global___NetTieDefinition = NetTieDefinition

@typing.final
class FootprintDesignRuleOverrides(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SOLDER_MASK_FIELD_NUMBER: builtins.int
    SOLDER_PASTE_FIELD_NUMBER: builtins.int
    COPPER_CLEARANCE_FIELD_NUMBER: builtins.int
    ZONE_CONNECTION_FIELD_NUMBER: builtins.int
    zone_connection: global___ZoneConnectionStyle.ValueType

    @property
    def solder_mask(self) -> global___SolderMaskOverrides:
        ...

    @property
    def solder_paste(self) -> global___SolderPasteOverrides:
        ...

    @property
    def copper_clearance(self) -> common.types.base_types_pb2.Distance:
        ...

    def __init__(self, *, solder_mask: global___SolderMaskOverrides | None=..., solder_paste: global___SolderPasteOverrides | None=..., copper_clearance: common.types.base_types_pb2.Distance | None=..., zone_connection: global___ZoneConnectionStyle.ValueType=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['copper_clearance', b'copper_clearance', 'solder_mask', b'solder_mask', 'solder_paste', b'solder_paste']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['copper_clearance', b'copper_clearance', 'solder_mask', b'solder_mask', 'solder_paste', b'solder_paste', 'zone_connection', b'zone_connection']) -> None:
        ...
global___FootprintDesignRuleOverrides = FootprintDesignRuleOverrides

@typing.final
class Footprint3DModel(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    FILENAME_FIELD_NUMBER: builtins.int
    SCALE_FIELD_NUMBER: builtins.int
    ROTATION_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    VISIBLE_FIELD_NUMBER: builtins.int
    OPACITY_FIELD_NUMBER: builtins.int
    filename: builtins.str
    visible: builtins.bool
    opacity: builtins.float

    @property
    def scale(self) -> common.types.base_types_pb2.Vector3D:
        """Scaling factor along each axis"""

    @property
    def rotation(self) -> common.types.base_types_pb2.Vector3D:
        """Rotation around each axis, in degrees"""

    @property
    def offset(self) -> common.types.base_types_pb2.Vector3D:
        """Offset from footprint center"""

    def __init__(self, *, filename: builtins.str=..., scale: common.types.base_types_pb2.Vector3D | None=..., rotation: common.types.base_types_pb2.Vector3D | None=..., offset: common.types.base_types_pb2.Vector3D | None=..., visible: builtins.bool=..., opacity: builtins.float=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['offset', b'offset', 'rotation', b'rotation', 'scale', b'scale']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['filename', b'filename', 'offset', b'offset', 'opacity', b'opacity', 'rotation', b'rotation', 'scale', b'scale', 'visible', b'visible']) -> None:
        ...
global___Footprint3DModel = Footprint3DModel

@typing.final
class Footprint(google.protobuf.message.Message):
    """A footprint definition (i.e. what would be in a library)"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    ANCHOR_FIELD_NUMBER: builtins.int
    ATTRIBUTES_FIELD_NUMBER: builtins.int
    OVERRIDES_FIELD_NUMBER: builtins.int
    NET_TIES_FIELD_NUMBER: builtins.int
    PRIVATE_LAYERS_FIELD_NUMBER: builtins.int
    REFERENCE_FIELD_FIELD_NUMBER: builtins.int
    VALUE_FIELD_FIELD_NUMBER: builtins.int
    DATASHEET_FIELD_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_FIELD_NUMBER: builtins.int
    ITEMS_FIELD_NUMBER: builtins.int

    @property
    def id(self) -> common.types.base_types_pb2.LibraryIdentifier:
        ...

    @property
    def anchor(self) -> common.types.base_types_pb2.Vector2:
        ...

    @property
    def attributes(self) -> global___FootprintAttributes:
        ...

    @property
    def overrides(self) -> global___FootprintDesignRuleOverrides:
        ...

    @property
    def net_ties(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___NetTieDefinition]:
        ...

    @property
    def private_layers(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___BoardLayer.ValueType]:
        ...

    @property
    def reference_field(self) -> global___Field:
        ...

    @property
    def value_field(self) -> global___Field:
        ...

    @property
    def datasheet_field(self) -> global___Field:
        ...

    @property
    def description_field(self) -> global___Field:
        ...

    @property
    def items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.any_pb2.Any]:
        """All footprint items except for mandatory fields"""

    def __init__(self, *, id: common.types.base_types_pb2.LibraryIdentifier | None=..., anchor: common.types.base_types_pb2.Vector2 | None=..., attributes: global___FootprintAttributes | None=..., overrides: global___FootprintDesignRuleOverrides | None=..., net_ties: collections.abc.Iterable[global___NetTieDefinition] | None=..., private_layers: collections.abc.Iterable[global___BoardLayer.ValueType] | None=..., reference_field: global___Field | None=..., value_field: global___Field | None=..., datasheet_field: global___Field | None=..., description_field: global___Field | None=..., items: collections.abc.Iterable[google.protobuf.any_pb2.Any] | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['anchor', b'anchor', 'attributes', b'attributes', 'datasheet_field', b'datasheet_field', 'description_field', b'description_field', 'id', b'id', 'overrides', b'overrides', 'reference_field', b'reference_field', 'value_field', b'value_field']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['anchor', b'anchor', 'attributes', b'attributes', 'datasheet_field', b'datasheet_field', 'description_field', b'description_field', 'id', b'id', 'items', b'items', 'net_ties', b'net_ties', 'overrides', b'overrides', 'private_layers', b'private_layers', 'reference_field', b'reference_field', 'value_field', b'value_field']) -> None:
        ...
global___Footprint = Footprint

@typing.final
class FootprintInstance(google.protobuf.message.Message):
    """An instance of a footprint on a board"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    POSITION_FIELD_NUMBER: builtins.int
    ORIENTATION_FIELD_NUMBER: builtins.int
    LAYER_FIELD_NUMBER: builtins.int
    LOCKED_FIELD_NUMBER: builtins.int
    DEFINITION_FIELD_NUMBER: builtins.int
    REFERENCE_FIELD_FIELD_NUMBER: builtins.int
    VALUE_FIELD_FIELD_NUMBER: builtins.int
    DATASHEET_FIELD_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_FIELD_NUMBER: builtins.int
    ATTRIBUTES_FIELD_NUMBER: builtins.int
    OVERRIDES_FIELD_NUMBER: builtins.int
    SYMBOL_PATH_FIELD_NUMBER: builtins.int
    layer: global___BoardLayer.ValueType
    locked: common.types.base_types_pb2.LockedState.ValueType

    @property
    def id(self) -> common.types.base_types_pb2.KIID:
        ...

    @property
    def position(self) -> common.types.base_types_pb2.Vector2:
        ...

    @property
    def orientation(self) -> common.types.base_types_pb2.Angle:
        ...

    @property
    def definition(self) -> global___Footprint:
        ...

    @property
    def reference_field(self) -> global___Field:
        ...

    @property
    def value_field(self) -> global___Field:
        ...

    @property
    def datasheet_field(self) -> global___Field:
        ...

    @property
    def description_field(self) -> global___Field:
        ...

    @property
    def attributes(self) -> global___FootprintAttributes:
        ...

    @property
    def overrides(self) -> global___FootprintDesignRuleOverrides:
        ...

    @property
    def symbol_path(self) -> common.types.base_types_pb2.SheetPath:
        """The sheet path to the associated symbol for this footprint instance, if one exists"""

    def __init__(self, *, id: common.types.base_types_pb2.KIID | None=..., position: common.types.base_types_pb2.Vector2 | None=..., orientation: common.types.base_types_pb2.Angle | None=..., layer: global___BoardLayer.ValueType=..., locked: common.types.base_types_pb2.LockedState.ValueType=..., definition: global___Footprint | None=..., reference_field: global___Field | None=..., value_field: global___Field | None=..., datasheet_field: global___Field | None=..., description_field: global___Field | None=..., attributes: global___FootprintAttributes | None=..., overrides: global___FootprintDesignRuleOverrides | None=..., symbol_path: common.types.base_types_pb2.SheetPath | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['attributes', b'attributes', 'datasheet_field', b'datasheet_field', 'definition', b'definition', 'description_field', b'description_field', 'id', b'id', 'orientation', b'orientation', 'overrides', b'overrides', 'position', b'position', 'reference_field', b'reference_field', 'symbol_path', b'symbol_path', 'value_field', b'value_field']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['attributes', b'attributes', 'datasheet_field', b'datasheet_field', 'definition', b'definition', 'description_field', b'description_field', 'id', b'id', 'layer', b'layer', 'locked', b'locked', 'orientation', b'orientation', 'overrides', b'overrides', 'position', b'position', 'reference_field', b'reference_field', 'symbol_path', b'symbol_path', 'value_field', b'value_field']) -> None:
        ...
global___FootprintInstance = FootprintInstance