# coding: utf-8

"""
    Kinde Management API

     Provides endpoints to manage your Kinde Businesses.  ## Intro  ## How to use  1. [Set up and authorize a machine-to-machine (M2M) application](https://docs.kinde.com/developer-tools/kinde-api/connect-to-kinde-api/).  2. [Generate a test access token](https://docs.kinde.com/developer-tools/kinde-api/access-token-for-api/)  3. Test request any endpoint using the test token 

    The version of the OpenAPI document: 1
    Contact: support@kinde.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from kinde_sdk.management.models.user_identities_inner import UserIdentitiesInner
from typing import Optional, Set
from typing_extensions import Self

class UsersResponseUsersInner(BaseModel):
    """
    UsersResponseUsersInner
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique ID of the user in Kinde.")
    provided_id: Optional[StrictStr] = Field(default=None, description="External ID for user.")
    email: Optional[StrictStr] = Field(default=None, description="Default email address of the user in Kinde.")
    phone: Optional[StrictStr] = Field(default=None, description="User's primary phone number.")
    username: Optional[StrictStr] = Field(default=None, description="Primary username of the user in Kinde.")
    last_name: Optional[StrictStr] = Field(default=None, description="User's last name.")
    first_name: Optional[StrictStr] = Field(default=None, description="User's first name.")
    is_suspended: Optional[StrictBool] = Field(default=None, description="Whether the user is currently suspended or not.")
    picture: Optional[StrictStr] = Field(default=None, description="User's profile picture URL.")
    total_sign_ins: Optional[StrictInt] = Field(default=None, description="Total number of user sign ins.")
    failed_sign_ins: Optional[StrictInt] = Field(default=None, description="Number of consecutive failed user sign ins.")
    last_signed_in: Optional[StrictStr] = Field(default=None, description="Last sign in date in ISO 8601 format.")
    created_on: Optional[StrictStr] = Field(default=None, description="Date of user creation in ISO 8601 format.")
    organizations: Optional[List[StrictStr]] = Field(default=None, description="Array of organizations a user belongs to.")
    identities: Optional[List[UserIdentitiesInner]] = Field(default=None, description="Array of identities belonging to the user.")
    __properties: ClassVar[List[str]] = ["id", "provided_id", "email", "phone", "username", "last_name", "first_name", "is_suspended", "picture", "total_sign_ins", "failed_sign_ins", "last_signed_in", "created_on", "organizations", "identities"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UsersResponseUsersInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in identities (list)
        _items = []
        if self.identities:
            for _item_identities in self.identities:
                if _item_identities:
                    _items.append(_item_identities.to_dict())
            _dict['identities'] = _items
        # set to None if total_sign_ins (nullable) is None
        # and model_fields_set contains the field
        if self.total_sign_ins is None and "total_sign_ins" in self.model_fields_set:
            _dict['total_sign_ins'] = None

        # set to None if failed_sign_ins (nullable) is None
        # and model_fields_set contains the field
        if self.failed_sign_ins is None and "failed_sign_ins" in self.model_fields_set:
            _dict['failed_sign_ins'] = None

        # set to None if last_signed_in (nullable) is None
        # and model_fields_set contains the field
        if self.last_signed_in is None and "last_signed_in" in self.model_fields_set:
            _dict['last_signed_in'] = None

        # set to None if created_on (nullable) is None
        # and model_fields_set contains the field
        if self.created_on is None and "created_on" in self.model_fields_set:
            _dict['created_on'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UsersResponseUsersInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "provided_id": obj.get("provided_id"),
            "email": obj.get("email"),
            "phone": obj.get("phone"),
            "username": obj.get("username"),
            "last_name": obj.get("last_name"),
            "first_name": obj.get("first_name"),
            "is_suspended": obj.get("is_suspended"),
            "picture": obj.get("picture"),
            "total_sign_ins": obj.get("total_sign_ins"),
            "failed_sign_ins": obj.get("failed_sign_ins"),
            "last_signed_in": obj.get("last_signed_in"),
            "created_on": obj.get("created_on"),
            "organizations": obj.get("organizations"),
            "identities": [UserIdentitiesInner.from_dict(_item) for _item in obj["identities"]] if obj.get("identities") is not None else None
        })
        return _obj


