# coding: utf-8

"""
    Kinde Management API

     Provides endpoints to manage your Kinde Businesses.  ## Intro  ## How to use  1. [Set up and authorize a machine-to-machine (M2M) application](https://docs.kinde.com/developer-tools/kinde-api/connect-to-kinde-api/).  2. [Generate a test access token](https://docs.kinde.com/developer-tools/kinde-api/access-token-for-api/)  3. Test request any endpoint using the test token 

    The version of the OpenAPI document: 1
    Contact: support@kinde.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from kinde_sdk.management.models.get_environment_response_environment_background_color import GetEnvironmentResponseEnvironmentBackgroundColor
from kinde_sdk.management.models.get_environment_response_environment_link_color import GetEnvironmentResponseEnvironmentLinkColor
from kinde_sdk.management.models.get_organization_response_billing import GetOrganizationResponseBilling
from typing import Optional, Set
from typing_extensions import Self

class GetOrganizationResponse(BaseModel):
    """
    GetOrganizationResponse
    """ # noqa: E501
    code: Optional[StrictStr] = Field(default=None, description="The unique identifier for the organization.")
    name: Optional[StrictStr] = Field(default=None, description="The organization's name.")
    handle: Optional[StrictStr] = Field(default=None, description="A unique handle for the organization - can be used for dynamic callback urls.")
    is_default: Optional[StrictBool] = Field(default=None, description="Whether the organization is the default organization.")
    external_id: Optional[StrictStr] = Field(default=None, description="The organization's external identifier - commonly used when migrating from or mapping to other systems.")
    is_auto_membership_enabled: Optional[StrictBool] = Field(default=None, description="If users become members of this organization when the org code is supplied during authentication.")
    logo: Optional[StrictStr] = Field(default=None, description="The organization's logo URL.")
    logo_dark: Optional[StrictStr] = Field(default=None, description="The organization's logo URL to be used for dark themes.")
    favicon_svg: Optional[StrictStr] = Field(default=None, description="The organization's SVG favicon URL. Optimal format for most browsers")
    favicon_fallback: Optional[StrictStr] = Field(default=None, description="The favicon URL to be used as a fallback in browsers that don’t support SVG, add a PNG")
    link_color: Optional[GetEnvironmentResponseEnvironmentLinkColor] = None
    background_color: Optional[GetEnvironmentResponseEnvironmentBackgroundColor] = None
    button_color: Optional[GetEnvironmentResponseEnvironmentLinkColor] = None
    button_text_color: Optional[GetEnvironmentResponseEnvironmentBackgroundColor] = None
    link_color_dark: Optional[GetEnvironmentResponseEnvironmentLinkColor] = None
    background_color_dark: Optional[GetEnvironmentResponseEnvironmentLinkColor] = None
    button_text_color_dark: Optional[GetEnvironmentResponseEnvironmentLinkColor] = None
    button_color_dark: Optional[GetEnvironmentResponseEnvironmentLinkColor] = None
    button_border_radius: Optional[StrictInt] = Field(default=None, description="The border radius for buttons. Value is px, Kinde transforms to rem for rendering")
    card_border_radius: Optional[StrictInt] = Field(default=None, description="The border radius for cards. Value is px, Kinde transforms to rem for rendering")
    input_border_radius: Optional[StrictInt] = Field(default=None, description="The border radius for inputs. Value is px, Kinde transforms to rem for rendering")
    theme_code: Optional[StrictStr] = Field(default=None, description="Whether the environment is forced into light mode, dark mode or user preference")
    color_scheme: Optional[StrictStr] = Field(default=None, description="The color scheme for the environment used for meta tags based on the theme code")
    created_on: Optional[StrictStr] = Field(default=None, description="Date of organization creation in ISO 8601 format.")
    is_allow_registrations: Optional[StrictBool] = Field(default=None, description="Deprecated - Use 'is_auto_membership_enabled' instead")
    sender_name: Optional[StrictStr] = Field(default=None, description="The name of the organization that will be used in emails")
    sender_email: Optional[StrictStr] = Field(default=None, description="The email address that will be used in emails. Requires custom SMTP to be set up.")
    billing: Optional[GetOrganizationResponseBilling] = None
    __properties: ClassVar[List[str]] = ["code", "name", "handle", "is_default", "external_id", "is_auto_membership_enabled", "logo", "logo_dark", "favicon_svg", "favicon_fallback", "link_color", "background_color", "button_color", "button_text_color", "link_color_dark", "background_color_dark", "button_text_color_dark", "button_color_dark", "button_border_radius", "card_border_radius", "input_border_radius", "theme_code", "color_scheme", "created_on", "is_allow_registrations", "sender_name", "sender_email", "billing"]

    @field_validator('theme_code')
    def theme_code_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['light', 'dark', 'user_preference']):
            raise ValueError("must be one of enum values ('light', 'dark', 'user_preference')")
        return value

    @field_validator('color_scheme')
    def color_scheme_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['light', 'dark', 'light dark']):
            raise ValueError("must be one of enum values ('light', 'dark', 'light dark')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetOrganizationResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of link_color
        if self.link_color:
            _dict['link_color'] = self.link_color.to_dict()
        # override the default output from pydantic by calling `to_dict()` of background_color
        if self.background_color:
            _dict['background_color'] = self.background_color.to_dict()
        # override the default output from pydantic by calling `to_dict()` of button_color
        if self.button_color:
            _dict['button_color'] = self.button_color.to_dict()
        # override the default output from pydantic by calling `to_dict()` of button_text_color
        if self.button_text_color:
            _dict['button_text_color'] = self.button_text_color.to_dict()
        # override the default output from pydantic by calling `to_dict()` of link_color_dark
        if self.link_color_dark:
            _dict['link_color_dark'] = self.link_color_dark.to_dict()
        # override the default output from pydantic by calling `to_dict()` of background_color_dark
        if self.background_color_dark:
            _dict['background_color_dark'] = self.background_color_dark.to_dict()
        # override the default output from pydantic by calling `to_dict()` of button_text_color_dark
        if self.button_text_color_dark:
            _dict['button_text_color_dark'] = self.button_text_color_dark.to_dict()
        # override the default output from pydantic by calling `to_dict()` of button_color_dark
        if self.button_color_dark:
            _dict['button_color_dark'] = self.button_color_dark.to_dict()
        # override the default output from pydantic by calling `to_dict()` of billing
        if self.billing:
            _dict['billing'] = self.billing.to_dict()
        # set to None if handle (nullable) is None
        # and model_fields_set contains the field
        if self.handle is None and "handle" in self.model_fields_set:
            _dict['handle'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['external_id'] = None

        # set to None if logo (nullable) is None
        # and model_fields_set contains the field
        if self.logo is None and "logo" in self.model_fields_set:
            _dict['logo'] = None

        # set to None if logo_dark (nullable) is None
        # and model_fields_set contains the field
        if self.logo_dark is None and "logo_dark" in self.model_fields_set:
            _dict['logo_dark'] = None

        # set to None if favicon_svg (nullable) is None
        # and model_fields_set contains the field
        if self.favicon_svg is None and "favicon_svg" in self.model_fields_set:
            _dict['favicon_svg'] = None

        # set to None if favicon_fallback (nullable) is None
        # and model_fields_set contains the field
        if self.favicon_fallback is None and "favicon_fallback" in self.model_fields_set:
            _dict['favicon_fallback'] = None

        # set to None if link_color (nullable) is None
        # and model_fields_set contains the field
        if self.link_color is None and "link_color" in self.model_fields_set:
            _dict['link_color'] = None

        # set to None if background_color (nullable) is None
        # and model_fields_set contains the field
        if self.background_color is None and "background_color" in self.model_fields_set:
            _dict['background_color'] = None

        # set to None if button_color (nullable) is None
        # and model_fields_set contains the field
        if self.button_color is None and "button_color" in self.model_fields_set:
            _dict['button_color'] = None

        # set to None if button_text_color (nullable) is None
        # and model_fields_set contains the field
        if self.button_text_color is None and "button_text_color" in self.model_fields_set:
            _dict['button_text_color'] = None

        # set to None if link_color_dark (nullable) is None
        # and model_fields_set contains the field
        if self.link_color_dark is None and "link_color_dark" in self.model_fields_set:
            _dict['link_color_dark'] = None

        # set to None if background_color_dark (nullable) is None
        # and model_fields_set contains the field
        if self.background_color_dark is None and "background_color_dark" in self.model_fields_set:
            _dict['background_color_dark'] = None

        # set to None if button_text_color_dark (nullable) is None
        # and model_fields_set contains the field
        if self.button_text_color_dark is None and "button_text_color_dark" in self.model_fields_set:
            _dict['button_text_color_dark'] = None

        # set to None if button_color_dark (nullable) is None
        # and model_fields_set contains the field
        if self.button_color_dark is None and "button_color_dark" in self.model_fields_set:
            _dict['button_color_dark'] = None

        # set to None if button_border_radius (nullable) is None
        # and model_fields_set contains the field
        if self.button_border_radius is None and "button_border_radius" in self.model_fields_set:
            _dict['button_border_radius'] = None

        # set to None if card_border_radius (nullable) is None
        # and model_fields_set contains the field
        if self.card_border_radius is None and "card_border_radius" in self.model_fields_set:
            _dict['card_border_radius'] = None

        # set to None if input_border_radius (nullable) is None
        # and model_fields_set contains the field
        if self.input_border_radius is None and "input_border_radius" in self.model_fields_set:
            _dict['input_border_radius'] = None

        # set to None if is_allow_registrations (nullable) is None
        # and model_fields_set contains the field
        if self.is_allow_registrations is None and "is_allow_registrations" in self.model_fields_set:
            _dict['is_allow_registrations'] = None

        # set to None if sender_name (nullable) is None
        # and model_fields_set contains the field
        if self.sender_name is None and "sender_name" in self.model_fields_set:
            _dict['sender_name'] = None

        # set to None if sender_email (nullable) is None
        # and model_fields_set contains the field
        if self.sender_email is None and "sender_email" in self.model_fields_set:
            _dict['sender_email'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetOrganizationResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "code": obj.get("code"),
            "name": obj.get("name"),
            "handle": obj.get("handle"),
            "is_default": obj.get("is_default"),
            "external_id": obj.get("external_id"),
            "is_auto_membership_enabled": obj.get("is_auto_membership_enabled"),
            "logo": obj.get("logo"),
            "logo_dark": obj.get("logo_dark"),
            "favicon_svg": obj.get("favicon_svg"),
            "favicon_fallback": obj.get("favicon_fallback"),
            "link_color": GetEnvironmentResponseEnvironmentLinkColor.from_dict(obj["link_color"]) if obj.get("link_color") is not None else None,
            "background_color": GetEnvironmentResponseEnvironmentBackgroundColor.from_dict(obj["background_color"]) if obj.get("background_color") is not None else None,
            "button_color": GetEnvironmentResponseEnvironmentLinkColor.from_dict(obj["button_color"]) if obj.get("button_color") is not None else None,
            "button_text_color": GetEnvironmentResponseEnvironmentBackgroundColor.from_dict(obj["button_text_color"]) if obj.get("button_text_color") is not None else None,
            "link_color_dark": GetEnvironmentResponseEnvironmentLinkColor.from_dict(obj["link_color_dark"]) if obj.get("link_color_dark") is not None else None,
            "background_color_dark": GetEnvironmentResponseEnvironmentLinkColor.from_dict(obj["background_color_dark"]) if obj.get("background_color_dark") is not None else None,
            "button_text_color_dark": GetEnvironmentResponseEnvironmentLinkColor.from_dict(obj["button_text_color_dark"]) if obj.get("button_text_color_dark") is not None else None,
            "button_color_dark": GetEnvironmentResponseEnvironmentLinkColor.from_dict(obj["button_color_dark"]) if obj.get("button_color_dark") is not None else None,
            "button_border_radius": obj.get("button_border_radius"),
            "card_border_radius": obj.get("card_border_radius"),
            "input_border_radius": obj.get("input_border_radius"),
            "theme_code": obj.get("theme_code"),
            "color_scheme": obj.get("color_scheme"),
            "created_on": obj.get("created_on"),
            "is_allow_registrations": obj.get("is_allow_registrations"),
            "sender_name": obj.get("sender_name"),
            "sender_email": obj.get("sender_email"),
            "billing": GetOrganizationResponseBilling.from_dict(obj["billing"]) if obj.get("billing") is not None else None
        })
        return _obj


