# coding: utf-8

"""
    Kinde Management API

     Provides endpoints to manage your Kinde Businesses.  ## Intro  ## How to use  1. [Set up and authorize a machine-to-machine (M2M) application](https://docs.kinde.com/developer-tools/kinde-api/connect-to-kinde-api/).  2. [Generate a test access token](https://docs.kinde.com/developer-tools/kinde-api/access-token-for-api/)  3. Test request any endpoint using the test token 

    The version of the OpenAPI document: 1
    Contact: support@kinde.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Identity(BaseModel):
    """
    Identity
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The unique ID for the identity")
    type: Optional[StrictStr] = Field(default=None, description="The type of identity")
    is_confirmed: Optional[StrictBool] = Field(default=None, description="Whether the identity is confirmed")
    created_on: Optional[StrictStr] = Field(default=None, description="Date of user creation in ISO 8601 format")
    last_login_on: Optional[StrictStr] = Field(default=None, description="Date of last login in ISO 8601 format")
    total_logins: Optional[StrictInt] = None
    name: Optional[StrictStr] = Field(default=None, description="The value of the identity")
    email: Optional[StrictStr] = Field(default=None, description="The associated email of the identity")
    is_primary: Optional[StrictBool] = Field(default=None, description="Whether the identity is the primary identity for the user")
    __properties: ClassVar[List[str]] = ["id", "type", "is_confirmed", "created_on", "last_login_on", "total_logins", "name", "email", "is_primary"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Identity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if is_primary (nullable) is None
        # and model_fields_set contains the field
        if self.is_primary is None and "is_primary" in self.model_fields_set:
            _dict['is_primary'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Identity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "is_confirmed": obj.get("is_confirmed"),
            "created_on": obj.get("created_on"),
            "last_login_on": obj.get("last_login_on"),
            "total_logins": obj.get("total_logins"),
            "name": obj.get("name"),
            "email": obj.get("email"),
            "is_primary": obj.get("is_primary")
        })
        return _obj


