# coding: utf-8

"""
    Kinde Management API

     Provides endpoints to manage your Kinde Businesses.  ## Intro  ## How to use  1. [Set up and authorize a machine-to-machine (M2M) application](https://docs.kinde.com/developer-tools/kinde-api/connect-to-kinde-api/).  2. [Generate a test access token](https://docs.kinde.com/developer-tools/kinde-api/access-token-for-api/)  3. Test request any endpoint using the test token 

    The version of the OpenAPI document: 1
    Contact: support@kinde.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UpdateBusinessRequest(BaseModel):
    """
    UpdateBusinessRequest
    """ # noqa: E501
    business_name: Optional[StrictStr] = Field(default=None, description="The name of the business.")
    email: Optional[StrictStr] = Field(default=None, description="The email address of the business.")
    industry_key: Optional[StrictStr] = Field(default=None, description="The key of the industry of your business. Can be retrieved from the /industries endpoint.")
    is_click_wrap: Optional[StrictBool] = Field(default=None, description="Whether the business is using clickwrap agreements.")
    is_show_kinde_branding: Optional[StrictBool] = Field(default=None, description="Whether the business is showing Kinde branding. Requires a paid plan.")
    kinde_perk_code: Optional[StrictStr] = Field(default=None, description="The Kinde perk code for the business.")
    phone: Optional[StrictStr] = Field(default=None, description="The phone number of the business.")
    privacy_url: Optional[StrictStr] = Field(default=None, description="The URL to the business's privacy policy.")
    terms_url: Optional[StrictStr] = Field(default=None, description="The URL to the business's terms of service.")
    timezone_key: Optional[StrictStr] = Field(default=None, description="The key of the timezone of your business. Can be retrieved from the /timezones endpoint.")
    __properties: ClassVar[List[str]] = ["business_name", "email", "industry_key", "is_click_wrap", "is_show_kinde_branding", "kinde_perk_code", "phone", "privacy_url", "terms_url", "timezone_key"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateBusinessRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if business_name (nullable) is None
        # and model_fields_set contains the field
        if self.business_name is None and "business_name" in self.model_fields_set:
            _dict['business_name'] = None

        # set to None if email (nullable) is None
        # and model_fields_set contains the field
        if self.email is None and "email" in self.model_fields_set:
            _dict['email'] = None

        # set to None if industry_key (nullable) is None
        # and model_fields_set contains the field
        if self.industry_key is None and "industry_key" in self.model_fields_set:
            _dict['industry_key'] = None

        # set to None if is_click_wrap (nullable) is None
        # and model_fields_set contains the field
        if self.is_click_wrap is None and "is_click_wrap" in self.model_fields_set:
            _dict['is_click_wrap'] = None

        # set to None if is_show_kinde_branding (nullable) is None
        # and model_fields_set contains the field
        if self.is_show_kinde_branding is None and "is_show_kinde_branding" in self.model_fields_set:
            _dict['is_show_kinde_branding'] = None

        # set to None if kinde_perk_code (nullable) is None
        # and model_fields_set contains the field
        if self.kinde_perk_code is None and "kinde_perk_code" in self.model_fields_set:
            _dict['kinde_perk_code'] = None

        # set to None if phone (nullable) is None
        # and model_fields_set contains the field
        if self.phone is None and "phone" in self.model_fields_set:
            _dict['phone'] = None

        # set to None if privacy_url (nullable) is None
        # and model_fields_set contains the field
        if self.privacy_url is None and "privacy_url" in self.model_fields_set:
            _dict['privacy_url'] = None

        # set to None if terms_url (nullable) is None
        # and model_fields_set contains the field
        if self.terms_url is None and "terms_url" in self.model_fields_set:
            _dict['terms_url'] = None

        # set to None if timezone_key (nullable) is None
        # and model_fields_set contains the field
        if self.timezone_key is None and "timezone_key" in self.model_fields_set:
            _dict['timezone_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateBusinessRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "business_name": obj.get("business_name"),
            "email": obj.get("email"),
            "industry_key": obj.get("industry_key"),
            "is_click_wrap": obj.get("is_click_wrap"),
            "is_show_kinde_branding": obj.get("is_show_kinde_branding"),
            "kinde_perk_code": obj.get("kinde_perk_code"),
            "phone": obj.get("phone"),
            "privacy_url": obj.get("privacy_url"),
            "terms_url": obj.get("terms_url"),
            "timezone_key": obj.get("timezone_key")
        })
        return _obj


