# coding: utf-8

"""
    Kinde Management API

     Provides endpoints to manage your Kinde Businesses.  ## Intro  ## How to use  1. [Set up and authorize a machine-to-machine (M2M) application](https://docs.kinde.com/developer-tools/kinde-api/connect-to-kinde-api/).  2. [Generate a test access token](https://docs.kinde.com/developer-tools/kinde-api/access-token-for-api/)  3. Test request any endpoint using the test token 

    The version of the OpenAPI document: 1
    Contact: support@kinde.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CreateConnectionRequestOptionsOneOf1(BaseModel):
    """
    Azure AD connection options.
    """ # noqa: E501
    client_id: Optional[StrictStr] = Field(default=None, description="Client ID.")
    client_secret: Optional[StrictStr] = Field(default=None, description="Client secret.")
    home_realm_domains: Optional[List[StrictStr]] = Field(default=None, description="List of domains to limit authentication.")
    entra_id_domain: Optional[StrictStr] = Field(default=None, description="Domain for Entra ID.")
    is_use_common_endpoint: Optional[StrictBool] = Field(default=None, description="Use https://login.windows.net/common instead of a default endpoint.")
    is_sync_user_profile_on_login: Optional[StrictBool] = Field(default=None, description="Sync user profile data with IDP.")
    is_retrieve_provider_user_groups: Optional[StrictBool] = Field(default=None, description="Include user group info from MS Entra ID.")
    is_extended_attributes_required: Optional[StrictBool] = Field(default=None, description="Include additional user profile information.")
    is_auto_join_organization_enabled: Optional[StrictBool] = Field(default=None, description="Users automatically join organization when using this connection.")
    __properties: ClassVar[List[str]] = ["client_id", "client_secret", "home_realm_domains", "entra_id_domain", "is_use_common_endpoint", "is_sync_user_profile_on_login", "is_retrieve_provider_user_groups", "is_extended_attributes_required", "is_auto_join_organization_enabled"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateConnectionRequestOptionsOneOf1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateConnectionRequestOptionsOneOf1 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "client_id": obj.get("client_id"),
            "client_secret": obj.get("client_secret"),
            "home_realm_domains": obj.get("home_realm_domains"),
            "entra_id_domain": obj.get("entra_id_domain"),
            "is_use_common_endpoint": obj.get("is_use_common_endpoint"),
            "is_sync_user_profile_on_login": obj.get("is_sync_user_profile_on_login"),
            "is_retrieve_provider_user_groups": obj.get("is_retrieve_provider_user_groups"),
            "is_extended_attributes_required": obj.get("is_extended_attributes_required"),
            "is_auto_join_organization_enabled": obj.get("is_auto_join_organization_enabled")
        })
        return _obj


