# coding: utf-8

"""
    Kinde Management API

     Provides endpoints to manage your Kinde Businesses.  ## Intro  ## How to use  1. [Set up and authorize a machine-to-machine (M2M) application](https://docs.kinde.com/developer-tools/kinde-api/connect-to-kinde-api/).  2. [Generate a test access token](https://docs.kinde.com/developer-tools/kinde-api/access-token-for-api/)  3. Test request any endpoint using the test token 

    The version of the OpenAPI document: 1
    Contact: support@kinde.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class GetEntitlementsResponseDataEntitlementsInner(BaseModel):
    """
    GetEntitlementsResponseDataEntitlementsInner
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The friendly id of an entitlement")
    fixed_charge: Optional[StrictInt] = Field(default=None, description="The price charged if this is an entitlement for a fixed charged")
    price_name: Optional[StrictStr] = Field(default=None, description="The name of the price associated with the entitlement")
    unit_amount: Optional[StrictInt] = Field(default=None, description="The price charged for this entitlement in cents")
    feature_code: Optional[StrictStr] = Field(default=None, description="The feature code of the feature corresponding to this entitlement")
    feature_name: Optional[StrictStr] = Field(default=None, description="The feature name of the feature corresponding to this entitlement")
    entitlement_limit_max: Optional[StrictInt] = Field(default=None, description="The maximum number of units of the feature the customer is entitled to")
    entitlement_limit_min: Optional[StrictInt] = Field(default=None, description="The minimum number of units of the feature the customer is entitled to")
    __properties: ClassVar[List[str]] = ["id", "fixed_charge", "price_name", "unit_amount", "feature_code", "feature_name", "entitlement_limit_max", "entitlement_limit_min"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetEntitlementsResponseDataEntitlementsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if unit_amount (nullable) is None
        # and model_fields_set contains the field
        if self.unit_amount is None and "unit_amount" in self.model_fields_set:
            _dict['unit_amount'] = None

        # set to None if entitlement_limit_max (nullable) is None
        # and model_fields_set contains the field
        if self.entitlement_limit_max is None and "entitlement_limit_max" in self.model_fields_set:
            _dict['entitlement_limit_max'] = None

        # set to None if entitlement_limit_min (nullable) is None
        # and model_fields_set contains the field
        if self.entitlement_limit_min is None and "entitlement_limit_min" in self.model_fields_set:
            _dict['entitlement_limit_min'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetEntitlementsResponseDataEntitlementsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "fixed_charge": obj.get("fixed_charge"),
            "price_name": obj.get("price_name"),
            "unit_amount": obj.get("unit_amount"),
            "feature_code": obj.get("feature_code"),
            "feature_name": obj.get("feature_name"),
            "entitlement_limit_max": obj.get("entitlement_limit_max"),
            "entitlement_limit_min": obj.get("entitlement_limit_min")
        })
        return _obj


