# coding: utf-8

"""
    Kinde Management API

     Provides endpoints to manage your Kinde Businesses.  ## Intro  ## How to use  1. [Set up and authorize a machine-to-machine (M2M) application](https://docs.kinde.com/developer-tools/kinde-api/connect-to-kinde-api/).  2. [Generate a test access token](https://docs.kinde.com/developer-tools/kinde-api/access-token-for-api/)  3. Test request any endpoint using the test token 

    The version of the OpenAPI document: 1
    Contact: support@kinde.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class OrganizationUser(BaseModel):
    """
    OrganizationUser
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The unique ID for the user.")
    email: Optional[StrictStr] = Field(default=None, description="The user's email address.")
    full_name: Optional[StrictStr] = Field(default=None, description="The user's full name.")
    last_name: Optional[StrictStr] = Field(default=None, description="The user's last name.")
    first_name: Optional[StrictStr] = Field(default=None, description="The user's first name.")
    picture: Optional[StrictStr] = Field(default=None, description="The user's profile picture URL.")
    joined_on: Optional[StrictStr] = Field(default=None, description="The date the user joined the organization.")
    last_accessed_on: Optional[StrictStr] = Field(default=None, description="The date the user last accessed the organization.")
    roles: Optional[List[StrictStr]] = Field(default=None, description="The roles the user has in the organization.")
    __properties: ClassVar[List[str]] = ["id", "email", "full_name", "last_name", "first_name", "picture", "joined_on", "last_accessed_on", "roles"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrganizationUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if email (nullable) is None
        # and model_fields_set contains the field
        if self.email is None and "email" in self.model_fields_set:
            _dict['email'] = None

        # set to None if last_name (nullable) is None
        # and model_fields_set contains the field
        if self.last_name is None and "last_name" in self.model_fields_set:
            _dict['last_name'] = None

        # set to None if first_name (nullable) is None
        # and model_fields_set contains the field
        if self.first_name is None and "first_name" in self.model_fields_set:
            _dict['first_name'] = None

        # set to None if picture (nullable) is None
        # and model_fields_set contains the field
        if self.picture is None and "picture" in self.model_fields_set:
            _dict['picture'] = None

        # set to None if last_accessed_on (nullable) is None
        # and model_fields_set contains the field
        if self.last_accessed_on is None and "last_accessed_on" in self.model_fields_set:
            _dict['last_accessed_on'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrganizationUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "email": obj.get("email"),
            "full_name": obj.get("full_name"),
            "last_name": obj.get("last_name"),
            "first_name": obj.get("first_name"),
            "picture": obj.get("picture"),
            "joined_on": obj.get("joined_on"),
            "last_accessed_on": obj.get("last_accessed_on"),
            "roles": obj.get("roles")
        })
        return _obj


