# coding: utf-8

"""
    Kinde Management API

     Provides endpoints to manage your Kinde Businesses.  ## Intro  ## How to use  1. [Set up and authorize a machine-to-machine (M2M) application](https://docs.kinde.com/developer-tools/kinde-api/connect-to-kinde-api/).  2. [Generate a test access token](https://docs.kinde.com/developer-tools/kinde-api/access-token-for-api/)  3. Test request any endpoint using the test token 

    The version of the OpenAPI document: 1
    Contact: support@kinde.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from kinde_sdk.management.models.get_billing_agreements_response_agreements_inner_entitlements_inner import GetBillingAgreementsResponseAgreementsInnerEntitlementsInner
from typing import Optional, Set
from typing_extensions import Self

class GetBillingAgreementsResponseAgreementsInner(BaseModel):
    """
    GetBillingAgreementsResponseAgreementsInner
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The friendly id of an agreement")
    plan_code: Optional[StrictStr] = Field(default=None, description="The plan code the billing customer is subscribed to")
    expires_on: Optional[datetime] = Field(default=None, description="The date the agreement expired (and was no longer active)")
    billing_group_id: Optional[StrictStr] = Field(default=None, description="The friendly id of the billing group this agreement's plan is part of")
    entitlements: Optional[List[GetBillingAgreementsResponseAgreementsInnerEntitlementsInner]] = Field(default=None, description="A list of billing entitlements that is part of this agreement")
    __properties: ClassVar[List[str]] = ["id", "plan_code", "expires_on", "billing_group_id", "entitlements"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetBillingAgreementsResponseAgreementsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in entitlements (list)
        _items = []
        if self.entitlements:
            for _item_entitlements in self.entitlements:
                if _item_entitlements:
                    _items.append(_item_entitlements.to_dict())
            _dict['entitlements'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetBillingAgreementsResponseAgreementsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "plan_code": obj.get("plan_code"),
            "expires_on": obj.get("expires_on"),
            "billing_group_id": obj.get("billing_group_id"),
            "entitlements": [GetBillingAgreementsResponseAgreementsInnerEntitlementsInner.from_dict(_item) for _item in obj["entitlements"]] if obj.get("entitlements") is not None else None
        })
        return _obj


