# coding: utf-8

"""
    Kinde Management API

     Provides endpoints to manage your Kinde Businesses.  ## Intro  ## How to use  1. [Set up and authorize a machine-to-machine (M2M) application](https://docs.kinde.com/developer-tools/kinde-api/connect-to-kinde-api/).  2. [Generate a test access token](https://docs.kinde.com/developer-tools/kinde-api/access-token-for-api/)  3. Test request any endpoint using the test token 

    The version of the OpenAPI document: 1
    Contact: support@kinde.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UpdateOrganizationRequest(BaseModel):
    """
    UpdateOrganizationRequest
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="The organization's name.")
    external_id: Optional[StrictStr] = Field(default=None, description="The organization's ID.")
    background_color: Optional[StrictStr] = Field(default=None, description="The organization's brand settings - background color.")
    button_color: Optional[StrictStr] = Field(default=None, description="The organization's brand settings - button color.")
    button_text_color: Optional[StrictStr] = Field(default=None, description="The organization's brand settings - button text color.")
    link_color: Optional[StrictStr] = Field(default=None, description="The organization's brand settings - link color.")
    background_color_dark: Optional[StrictStr] = Field(default=None, description="The organization's brand settings - dark mode background color.")
    button_color_dark: Optional[StrictStr] = Field(default=None, description="The organization's brand settings - dark mode button color.")
    button_text_color_dark: Optional[StrictStr] = Field(default=None, description="The organization's brand settings - dark mode button text color.")
    link_color_dark: Optional[StrictStr] = Field(default=None, description="The organization's brand settings - dark mode link color.")
    theme_code: Optional[StrictStr] = Field(default=None, description="The organization's brand settings - theme/mode.")
    handle: Optional[StrictStr] = Field(default=None, description="The organization's handle.")
    is_allow_registrations: Optional[StrictBool] = Field(default=None, description="Deprecated - Use 'is_auto_membership_enabled' instead.")
    is_auto_join_domain_list: Optional[StrictBool] = Field(default=None, description="Users can sign up to this organization.")
    allowed_domains: Optional[List[StrictStr]] = Field(default=None, description="Domains allowed for self-sign up to this environment.")
    is_enable_advanced_orgs: Optional[StrictBool] = Field(default=None, description="Activate advanced organization features.")
    is_enforce_mfa: Optional[StrictBool] = Field(default=None, description="Enforce MFA for all users in this organization.")
    sender_name: Optional[StrictStr] = Field(default=None, description="The name of the organization that will be used in emails")
    sender_email: Optional[StrictStr] = Field(default=None, description="The email address that will be used in emails. Requires custom SMTP to be set up.")
    __properties: ClassVar[List[str]] = ["name", "external_id", "background_color", "button_color", "button_text_color", "link_color", "background_color_dark", "button_color_dark", "button_text_color_dark", "link_color_dark", "theme_code", "handle", "is_allow_registrations", "is_auto_join_domain_list", "allowed_domains", "is_enable_advanced_orgs", "is_enforce_mfa", "sender_name", "sender_email"]

    @field_validator('theme_code')
    def theme_code_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['light', 'dark', 'user_preference']):
            raise ValueError("must be one of enum values ('light', 'dark', 'user_preference')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateOrganizationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if sender_name (nullable) is None
        # and model_fields_set contains the field
        if self.sender_name is None and "sender_name" in self.model_fields_set:
            _dict['sender_name'] = None

        # set to None if sender_email (nullable) is None
        # and model_fields_set contains the field
        if self.sender_email is None and "sender_email" in self.model_fields_set:
            _dict['sender_email'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateOrganizationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "external_id": obj.get("external_id"),
            "background_color": obj.get("background_color"),
            "button_color": obj.get("button_color"),
            "button_text_color": obj.get("button_text_color"),
            "link_color": obj.get("link_color"),
            "background_color_dark": obj.get("background_color_dark"),
            "button_color_dark": obj.get("button_color_dark"),
            "button_text_color_dark": obj.get("button_text_color_dark"),
            "link_color_dark": obj.get("link_color_dark"),
            "theme_code": obj.get("theme_code"),
            "handle": obj.get("handle"),
            "is_allow_registrations": obj.get("is_allow_registrations"),
            "is_auto_join_domain_list": obj.get("is_auto_join_domain_list"),
            "allowed_domains": obj.get("allowed_domains"),
            "is_enable_advanced_orgs": obj.get("is_enable_advanced_orgs"),
            "is_enforce_mfa": obj.get("is_enforce_mfa"),
            "sender_name": obj.get("sender_name"),
            "sender_email": obj.get("sender_email")
        })
        return _obj


