# coding: utf-8

"""
    Kinde Management API

     Provides endpoints to manage your Kinde Businesses.  ## Intro  ## How to use  1. [Set up and authorize a machine-to-machine (M2M) application](https://docs.kinde.com/developer-tools/kinde-api/connect-to-kinde-api/).  2. [Generate a test access token](https://docs.kinde.com/developer-tools/kinde-api/access-token-for-api/)  3. Test request any endpoint using the test token 

    The version of the OpenAPI document: 1
    Contact: support@kinde.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class GetUserSessionsResponseSessionsInner(BaseModel):
    """
    GetUserSessionsResponseSessionsInner
    """ # noqa: E501
    user_id: Optional[StrictStr] = Field(default=None, description="The unique identifier of the user associated with the session.")
    org_code: Optional[StrictStr] = Field(default=None, description="The organization code associated with the session, if applicable.")
    client_id: Optional[StrictStr] = Field(default=None, description="The client ID used to initiate the session.")
    expires_on: Optional[datetime] = Field(default=None, description="The timestamp indicating when the session will expire.")
    session_id: Optional[StrictStr] = Field(default=None, description="The unique identifier of the session.")
    started_on: Optional[datetime] = Field(default=None, description="The timestamp when the session was initiated.")
    updated_on: Optional[datetime] = Field(default=None, description="The timestamp of the last update to the session.")
    connection_id: Optional[StrictStr] = Field(default=None, description="The identifier of the connection through which the session was established.")
    last_ip_address: Optional[StrictStr] = Field(default=None, description="The last known IP address of the user during this session.")
    last_user_agent: Optional[StrictStr] = Field(default=None, description="The last known user agent (browser or app) used during this session.")
    initial_ip_address: Optional[StrictStr] = Field(default=None, description="The IP address from which the session was initially started.")
    initial_user_agent: Optional[StrictStr] = Field(default=None, description="The user agent (browser or app) used when the session was first created.")
    __properties: ClassVar[List[str]] = ["user_id", "org_code", "client_id", "expires_on", "session_id", "started_on", "updated_on", "connection_id", "last_ip_address", "last_user_agent", "initial_ip_address", "initial_user_agent"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetUserSessionsResponseSessionsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if org_code (nullable) is None
        # and model_fields_set contains the field
        if self.org_code is None and "org_code" in self.model_fields_set:
            _dict['org_code'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetUserSessionsResponseSessionsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "user_id": obj.get("user_id"),
            "org_code": obj.get("org_code"),
            "client_id": obj.get("client_id"),
            "expires_on": obj.get("expires_on"),
            "session_id": obj.get("session_id"),
            "started_on": obj.get("started_on"),
            "updated_on": obj.get("updated_on"),
            "connection_id": obj.get("connection_id"),
            "last_ip_address": obj.get("last_ip_address"),
            "last_user_agent": obj.get("last_user_agent"),
            "initial_ip_address": obj.get("initial_ip_address"),
            "initial_user_agent": obj.get("initial_user_agent")
        })
        return _obj


