# do not import all endpoints into this module because that uses a lot of memory and stack frames
# if you need the ability to import all endpoints from this module, import them with
# from kinde_sdk.apis.path_to_api import path_to_api

import enum


class PathValues(str, enum.Enum):
    OAUTH2_USER_PROFILE = "/oauth2/user_profile"
    OAUTH2_INTROSPECT = "/oauth2/introspect"
    OAUTH2_REVOKE = "/oauth2/revoke"
    OAUTH2_V2_USER_PROFILE = "/oauth2/v2/user_profile"
    API_V1_APIS = "/api/v1/apis"
    API_V1_APIS_API_ID = "/api/v1/apis/{api_id}"
    API_V1_APIS_API_ID_APPLICATIONS = "/api/v1/apis/{api_id}/applications"
    API_V1_APPLICATIONS = "/api/v1/applications"
    API_V1_APPLICATIONS_APPLICATION_ID = "/api/v1/applications/{application_id}"
    API_V1_APPLICATIONS_APPLICATION_ID_CONNECTIONS = "/api/v1/applications/{application_id}/connections"
    API_V1_APPLICATIONS_APPLICATION_ID_CONNECTIONS_CONNECTION_ID = "/api/v1/applications/{application_id}/connections/{connection_id}"
    API_V1_BUSINESS = "/api/v1/business"
    API_V1_INDUSTRIES = "/api/v1/industries"
    API_V1_TIMEZONES = "/api/v1/timezones"
    API_V1_APPLICATIONS_APP_ID_AUTH_REDIRECT_URLS = "/api/v1/applications/{app_id}/auth_redirect_urls"
    API_V1_APPLICATIONS_APP_ID_AUTH_LOGOUT_URLS = "/api/v1/applications/{app_id}/auth_logout_urls"
    API_V1_CONNECTED_APPS_AUTH_URL = "/api/v1/connected_apps/auth_url"
    API_V1_CONNECTED_APPS_TOKEN = "/api/v1/connected_apps/token"
    API_V1_CONNECTED_APPS_REVOKE = "/api/v1/connected_apps/revoke"
    API_V1_CONNECTIONS = "/api/v1/connections"
    API_V1_CONNECTIONS_CONNECTION_ID = "/api/v1/connections/{connection_id}"
    API_V1_ENVIRONMENT_FEATURE_FLAGS = "/api/v1/environment/feature_flags"
    API_V1_ENVIRONMENT_FEATURE_FLAGS_FEATURE_FLAG_KEY = "/api/v1/environment/feature_flags/{feature_flag_key}"
    API_V1_FEATURE_FLAGS = "/api/v1/feature_flags"
    API_V1_FEATURE_FLAGS_FEATURE_FLAG_KEY = "/api/v1/feature_flags/{feature_flag_key}"
    API_V1_ORGANIZATION = "/api/v1/organization"
    API_V1_ORGANIZATION_ORG_CODE = "/api/v1/organization/{org_code}"
    API_V1_ORGANIZATIONS = "/api/v1/organizations"
    API_V1_ORGANIZATIONS_ORG_CODE_USERS = "/api/v1/organizations/{org_code}/users"
    API_V1_ORGANIZATIONS_ORG_CODE_USERS_USER_ID_ROLES = "/api/v1/organizations/{org_code}/users/{user_id}/roles"
    API_V1_ORGANIZATIONS_ORG_CODE_USERS_USER_ID_ROLES_ROLE_ID = "/api/v1/organizations/{org_code}/users/{user_id}/roles/{role_id}"
    API_V1_ORGANIZATIONS_ORG_CODE_USERS_USER_ID_PERMISSIONS = "/api/v1/organizations/{org_code}/users/{user_id}/permissions"
    API_V1_ORGANIZATIONS_ORG_CODE_USERS_USER_ID_PERMISSIONS_PERMISSION_ID = "/api/v1/organizations/{org_code}/users/{user_id}/permissions/{permission_id}"
    API_V1_ORGANIZATIONS_ORG_CODE_USERS_USER_ID = "/api/v1/organizations/{org_code}/users/{user_id}"
    API_V1_ORGANIZATIONS_ORG_CODE_FEATURE_FLAGS = "/api/v1/organizations/{org_code}/feature_flags"
    API_V1_ORGANIZATIONS_ORG_CODE_FEATURE_FLAGS_FEATURE_FLAG_KEY = "/api/v1/organizations/{org_code}/feature_flags/{feature_flag_key}"
    API_V1_ORGANIZATIONS_ORG_CODE_PROPERTIES_PROPERTY_KEY = "/api/v1/organizations/{org_code}/properties/{property_key}"
    API_V1_ORGANIZATIONS_ORG_CODE_PROPERTIES = "/api/v1/organizations/{org_code}/properties"
    API_V1_ORGANIZATION_ORG_CODE_HANDLE = "/api/v1/organization/{org_code}/handle"
    API_V1_PERMISSIONS = "/api/v1/permissions"
    API_V1_PERMISSIONS_PERMISSION_ID = "/api/v1/permissions/{permission_id}"
    API_V1_PROPERTIES = "/api/v1/properties"
    API_V1_PROPERTIES_PROPERTY_ID = "/api/v1/properties/{property_id}"
    API_V1_PROPERTY_CATEGORIES = "/api/v1/property_categories"
    API_V1_PROPERTY_CATEGORIES_CATEGORY_ID = "/api/v1/property_categories/{category_id}"
    API_V1_ROLES = "/api/v1/roles"
    API_V1_ROLES_ROLE_ID_PERMISSIONS = "/api/v1/roles/{role_id}/permissions"
    API_V1_ROLES_ROLE_ID_PERMISSIONS_PERMISSION_ID = "/api/v1/roles/{role_id}/permissions/{permission_id}"
    API_V1_ROLES_ROLE_ID = "/api/v1/roles/{role_id}"
    API_V1_SUBSCRIBERS = "/api/v1/subscribers"
    API_V1_SUBSCRIBERS_SUBSCRIBER_ID = "/api/v1/subscribers/{subscriber_id}"
    API_V1_USERS = "/api/v1/users"
    API_V1_USERS_USER_ID_REFRESH_CLAIMS = "/api/v1/users/{user_id}/refresh_claims"
    API_V1_USER = "/api/v1/user"
    API_V1_USERS_USER_ID_FEATURE_FLAGS_FEATURE_FLAG_KEY = "/api/v1/users/{user_id}/feature_flags/{feature_flag_key}"
    API_V1_USERS_USER_ID_PROPERTIES_PROPERTY_KEY = "/api/v1/users/{user_id}/properties/{property_key}"
    API_V1_USERS_USER_ID_PROPERTIES = "/api/v1/users/{user_id}/properties"
    API_V1_USERS_USER_ID_PASSWORD = "/api/v1/users/{user_id}/password"
    API_V1_EVENTS_EVENT_ID = "/api/v1/events/{event_id}"
    API_V1_EVENT_TYPES = "/api/v1/event_types"
    API_V1_WEBHOOKS_WEBHOOK_ID = "/api/v1/webhooks/{webhook_id}"
    API_V1_WEBHOOKS = "/api/v1/webhooks"
