# coding: utf-8

"""
    Kinde Management API

     Provides endpoints to manage your Kinde Businesses.  ## Intro  ## How to use  1. [Set up and authorize a machine-to-machine (M2M) application](https://docs.kinde.com/developer-tools/kinde-api/connect-to-kinde-api/).  2. [Generate a test access token](https://docs.kinde.com/developer-tools/kinde-api/access-token-for-api/)  3. Test request any endpoint using the test token 

    The version of the OpenAPI document: 1
    Contact: support@kinde.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class GetApplicationResponseApplication(BaseModel):
    """
    GetApplicationResponseApplication
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The application's identifier.")
    name: Optional[StrictStr] = Field(default=None, description="The application's name.")
    type: Optional[StrictStr] = Field(default=None, description="The application's type.")
    client_id: Optional[StrictStr] = Field(default=None, description="The application's client ID.")
    client_secret: Optional[StrictStr] = Field(default=None, description="The application's client secret.")
    login_uri: Optional[StrictStr] = Field(default=None, description="The default login route for resolving session issues.")
    homepage_uri: Optional[StrictStr] = Field(default=None, description="The homepage link to your application.")
    has_cancel_button: Optional[StrictBool] = Field(default=None, description="Whether the application has a cancel button to allow users to exit the auth flow [Beta].")
    __properties: ClassVar[List[str]] = ["id", "name", "type", "client_id", "client_secret", "login_uri", "homepage_uri", "has_cancel_button"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['m2m', 'reg', 'spa']):
            raise ValueError("must be one of enum values ('m2m', 'reg', 'spa')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetApplicationResponseApplication from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetApplicationResponseApplication from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "type": obj.get("type"),
            "client_id": obj.get("client_id"),
            "client_secret": obj.get("client_secret"),
            "login_uri": obj.get("login_uri"),
            "homepage_uri": obj.get("homepage_uri"),
            "has_cancel_button": obj.get("has_cancel_button")
        })
        return _obj


