# coding: utf-8

"""
    Kinde Management API

     Provides endpoints to manage your Kinde Businesses.  ## Intro  ## How to use  1. [Set up and authorize a machine-to-machine (M2M) application](https://docs.kinde.com/developer-tools/kinde-api/connect-to-kinde-api/).  2. [Generate a test access token](https://docs.kinde.com/developer-tools/kinde-api/access-token-for-api/)  3. Test request any endpoint using the test token 

    The version of the OpenAPI document: 1
    Contact: support@kinde.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CreateConnectionRequestOptionsOneOf2(BaseModel):
    """
    SAML connection options (e.g., Cloudflare SAML).
    """ # noqa: E501
    home_realm_domains: Optional[List[StrictStr]] = Field(default=None, description="List of domains to restrict authentication.")
    saml_entity_id: Optional[StrictStr] = Field(default=None, description="SAML Entity ID.")
    saml_acs_url: Optional[StrictStr] = Field(default=None, description="Assertion Consumer Service URL.")
    saml_idp_metadata_url: Optional[StrictStr] = Field(default=None, description="URL for the IdP metadata.")
    saml_sign_in_url: Optional[StrictStr] = Field(default=None, description="Override the default SSO endpoint with a URL your IdP recognizes.")
    saml_email_key_attr: Optional[StrictStr] = Field(default=None, description="Attribute key for the user’s email.")
    saml_first_name_key_attr: Optional[StrictStr] = Field(default=None, description="Attribute key for the user’s first name.")
    saml_last_name_key_attr: Optional[StrictStr] = Field(default=None, description="Attribute key for the user’s last name.")
    is_create_missing_user: Optional[StrictBool] = Field(default=None, description="Create user if they don’t exist.")
    saml_signing_certificate: Optional[StrictStr] = Field(default=None, description="Certificate for signing SAML requests.")
    saml_signing_private_key: Optional[StrictStr] = Field(default=None, description="Private key associated with the signing certificate.")
    is_auto_join_organization_enabled: Optional[StrictBool] = Field(default=None, description="Users automatically join organization when using this connection.")
    __properties: ClassVar[List[str]] = ["home_realm_domains", "saml_entity_id", "saml_acs_url", "saml_idp_metadata_url", "saml_sign_in_url", "saml_email_key_attr", "saml_first_name_key_attr", "saml_last_name_key_attr", "is_create_missing_user", "saml_signing_certificate", "saml_signing_private_key", "is_auto_join_organization_enabled"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateConnectionRequestOptionsOneOf2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateConnectionRequestOptionsOneOf2 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "home_realm_domains": obj.get("home_realm_domains"),
            "saml_entity_id": obj.get("saml_entity_id"),
            "saml_acs_url": obj.get("saml_acs_url"),
            "saml_idp_metadata_url": obj.get("saml_idp_metadata_url"),
            "saml_sign_in_url": obj.get("saml_sign_in_url"),
            "saml_email_key_attr": obj.get("saml_email_key_attr"),
            "saml_first_name_key_attr": obj.get("saml_first_name_key_attr"),
            "saml_last_name_key_attr": obj.get("saml_last_name_key_attr"),
            "is_create_missing_user": obj.get("is_create_missing_user"),
            "saml_signing_certificate": obj.get("saml_signing_certificate"),
            "saml_signing_private_key": obj.get("saml_signing_private_key"),
            "is_auto_join_organization_enabled": obj.get("is_auto_join_organization_enabled")
        })
        return _obj


