# coding: utf-8

"""
    Kinde Management API

     Provides endpoints to manage your Kinde Businesses.  ## Intro  ## How to use  1. [Set up and authorize a machine-to-machine (M2M) application](https://docs.kinde.com/developer-tools/kinde-api/connect-to-kinde-api/).  2. [Generate a test access token](https://docs.kinde.com/developer-tools/kinde-api/access-token-for-api/)  3. Test request any endpoint using the test token 

    The version of the OpenAPI document: 1
    Contact: support@kinde.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from kinde_sdk.management.models.get_billing_entitlements_response_entitlements_inner import GetBillingEntitlementsResponseEntitlementsInner
from kinde_sdk.management.models.get_billing_entitlements_response_plans_inner import GetBillingEntitlementsResponsePlansInner
from typing import Optional, Set
from typing_extensions import Self

class GetBillingEntitlementsResponse(BaseModel):
    """
    GetBillingEntitlementsResponse
    """ # noqa: E501
    code: Optional[StrictStr] = Field(default=None, description="Response code.")
    message: Optional[StrictStr] = Field(default=None, description="Response message.")
    has_more: Optional[StrictBool] = Field(default=None, description="Whether more records exist.")
    entitlements: Optional[List[GetBillingEntitlementsResponseEntitlementsInner]] = Field(default=None, description="A list of entitlements")
    plans: Optional[List[GetBillingEntitlementsResponsePlansInner]] = Field(default=None, description="A list of plans.")
    __properties: ClassVar[List[str]] = ["code", "message", "has_more", "entitlements", "plans"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetBillingEntitlementsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in entitlements (list)
        _items = []
        if self.entitlements:
            for _item_entitlements in self.entitlements:
                if _item_entitlements:
                    _items.append(_item_entitlements.to_dict())
            _dict['entitlements'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in plans (list)
        _items = []
        if self.plans:
            for _item_plans in self.plans:
                if _item_plans:
                    _items.append(_item_plans.to_dict())
            _dict['plans'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetBillingEntitlementsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "code": obj.get("code"),
            "message": obj.get("message"),
            "has_more": obj.get("has_more"),
            "entitlements": [GetBillingEntitlementsResponseEntitlementsInner.from_dict(_item) for _item in obj["entitlements"]] if obj.get("entitlements") is not None else None,
            "plans": [GetBillingEntitlementsResponsePlansInner.from_dict(_item) for _item in obj["plans"]] if obj.get("plans") is not None else None
        })
        return _obj


